/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Serialized;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.util.LinkedIdentityHashMap;

public class BimImporter {
    private static final int PT_GROUPS = 0;
    private static final int PT_MATERIALS = 1;
    private static final int PT_WALLS = 2;
    private static final int PT_SLABS = 3;
    private static final int PT_FURNISHINGS = 4;
    private static final int PT_HOLES = 5;

    public static void open(Serialized ser, String filename) throws IOException {
        Surface defSurf = ser.surfmgr.get(PredefSurf.INERT);
        int parseType = -1;
        LinkedIdentityHashMap<ModelComposite, Integer> groupParentMap = new LinkedIdentityHashMap<ModelComposite, Integer>();
        ArrayList<ModelComposite> groups = new ArrayList<ModelComposite>();
        ArrayList<Surface> surfaces = new ArrayList<Surface>();
        ArrayList<FDSObject> walls = new ArrayList<FDSObject>();
        ArrayList<FDSObject> holes = new ArrayList<FDSObject>();
        ArrayList<FDSObject> furnishings = new ArrayList<FDSObject>();
        ArrayList<FDSObject> slabs = new ArrayList<FDSObject>();
        int lineno = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineno;
                if ((line = line.trim()).equals("[groups]")) {
                    parseType = 0;
                    continue;
                }
                if (line.equals("[materials]")) {
                    parseType = 1;
                    continue;
                }
                if (line.equals("[walls]")) {
                    parseType = 2;
                    continue;
                }
                if (line.equals("[slabs]")) {
                    parseType = 3;
                    continue;
                }
                if (line.equals("[furnishings]")) {
                    parseType = 4;
                    continue;
                }
                if (line.equals("[holes]")) {
                    parseType = 5;
                    continue;
                }
                if (line.length() <= 0) continue;
                switch (parseType) {
                    case 0: {
                        ModelComposite group = BimImporter.parseGroup(line, groupParentMap);
                        if (group == null) break;
                        groups.add(group);
                        break;
                    }
                    case 1: {
                        Surface surf = BimImporter.parseMaterial(line);
                        if (surf == null) break;
                        surfaces.add(surf);
                        break;
                    }
                    case 2: {
                        FDSObject obj = BimImporter.parseSolid(line, groups, defSurf, surfaces);
                        if (obj == null) break;
                        walls.add(obj);
                        break;
                    }
                    case 3: {
                        FDSObject obj = BimImporter.parseSolid(line, groups, defSurf, surfaces);
                        if (obj == null) break;
                        slabs.add(obj);
                        break;
                    }
                    case 4: {
                        FDSObject obj = BimImporter.parseSolid(line, groups, defSurf, surfaces);
                        if (obj == null) break;
                        furnishings.add(obj);
                        break;
                    }
                    case 5: {
                        FDSObject obj = BimImporter.parseHole(line, groups);
                        if (obj == null) break;
                        holes.add(obj);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IOException(String.format(Intl.intl("Error on line %d: %s"), lineno, e.getMessage()));
        }
        ArrayList<ModelComposite> rootGroups = new ArrayList<ModelComposite>();
        for (Map.Entry entry : groupParentMap.entrySet()) {
            if ((Integer)entry.getValue() == -1) {
                rootGroups.add((ModelComposite)entry.getKey());
                continue;
            }
            ((ModelComposite)groups.get((Integer)entry.getValue())).add((IPyroObject)entry.getKey());
        }
        ser.surfmgr.addAll(surfaces);
        ser.obstructions.addAll(rootGroups);
    }

    private static StreamTokenizer newTokenizer(String line) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
        tokenizer.eolIsSignificant(false);
        tokenizer.lowerCaseMode(false);
        tokenizer.parseNumbers();
        tokenizer.quoteChar(34);
        return tokenizer;
    }

    private static void checkToken(StreamTokenizer tok, int expectedType) throws IOException {
        int type = tok.nextToken();
        if (type != expectedType) {
            throw new IOException(Intl.intl("Could not read file"));
        }
    }

    private static String readString(StreamTokenizer tok) throws IOException {
        BimImporter.checkToken(tok, 34);
        return tok.sval;
    }

    private static double readDouble(StreamTokenizer tok) throws IOException {
        BimImporter.checkToken(tok, -2);
        return tok.nval;
    }

    private static int readInt(StreamTokenizer tok) throws IOException {
        BimImporter.checkToken(tok, -2);
        return (int)tok.nval;
    }

    private static void skipChar(StreamTokenizer tok, char c) throws IOException {
        BimImporter.checkToken(tok, c);
    }

    private static ModelComposite parseGroup(String line, Map<ModelComposite, Integer> groupParentMap) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        int parentid = BimImporter.readInt(tok);
        String name = BimImporter.readString(tok);
        ModelComposite group = new ModelComposite(name);
        groupParentMap.put(group, parentid);
        return group;
    }

    private static Surface parseMaterial(String line) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        String name = BimImporter.readString(tok);
        Surface surf = new Surface(name);
        return surf;
    }

    private static AABoxGeom readGeom(StreamTokenizer tok) throws IOException {
        double minx = BimImporter.readDouble(tok);
        double maxx = BimImporter.readDouble(tok);
        double miny = BimImporter.readDouble(tok);
        double maxy = BimImporter.readDouble(tok);
        double minz = BimImporter.readDouble(tok);
        double maxz = BimImporter.readDouble(tok);
        return new AABoxGeom(new Point3d(minx, miny, minz), new Point3d(maxx, maxy, maxz));
    }

    private static FDSObject parseSolid(String line, List<ModelComposite> groups, Surface defSurf, List<Surface> surfaces) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        int parentid = BimImporter.readInt(tok);
        String name = BimImporter.readString(tok);
        int matlid = BimImporter.readInt(tok);
        AABoxGeom geom = BimImporter.readGeom(tok);
        Surface surf = matlid != -1 ? surfaces.get(matlid) : defSurf;
        Obstruction obj = new Obstruction(name, GeomNodeUtil.newNode(geom), new Surface[]{surf});
        if (parentid != -1) {
            groups.get(parentid).add(obj);
            return obj;
        }
        return null;
    }

    private static FDSObject parseHole(String line, List<ModelComposite> groups) throws IOException {
        StreamTokenizer tok = BimImporter.newTokenizer(line);
        BimImporter.readInt(tok);
        BimImporter.skipChar(tok, ':');
        int parentid = BimImporter.readInt(tok);
        String name = BimImporter.readString(tok);
        AABoxGeom geom = BimImporter.readGeom(tok);
        Hole obj = new Hole(name, GeomNodeUtil.newNode(geom));
        if (parentid != -1) {
            groups.get(parentid).add(obj);
            return obj;
        }
        return null;
    }
}

