/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.output.QuantityClipboard;
import pyrosim.gui.output.guiOutputUtil;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ComboBoxTableCell;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;

public class SlcfDialog
extends guiDialog {
    private static final long serialVersionUID = -281526882433842190L;
    private PyroMod d_pyroMod = ((PyroSim)Application.getApp()).getMediator();
    private guiTableEditor d_editor;
    private guiTable table;
    private Unit d_lengthUnit;
    private static final String OPT_YES = Intl.intl("YES");
    private static final String OPT_NO = Intl.intl("NO");

    public SlcfDialog(JFrame parent) {
        super((Window)parent, Intl.intl("Animated Planar Slices"), 9);
        UnitSystem system = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lengthUnit = system.getLengthUnit();
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        String[] headers = new String[]{Intl.intl("Name"), Intl.intl("XYZ Plane"), Intl.intl("Plane Value"), Intl.intl("Gas Phase Quantity"), Intl.intl("Use Vector?"), Intl.intl("Cell Centered?")};
        this.d_editor = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{String.class, String.class, UnitDouble.class, IQuantity.class, String.class, String.class}), 30);
        this.table = this.d_editor.getTable();
        this.table.setNullValuesAllowed(false);
        this.table.setColumnOptions(1, "X", "Y", "Z");
        this.table.getColumnModel().getColumn(2).setCellEditor(new guiTable.UnitDoubleEditor(this.d_lengthUnit));
        this.table.getColumnModel().getColumn(2).setCellRenderer(new guiTable.UnitDoubleRenderer());
        QuantityComboBox msrCB = new QuantityComboBox(128L, QuantityType.GAS);
        ComboBoxTableCell<IQuantity> cell = new ComboBoxTableCell<IQuantity>(msrCB);
        QuantityUtil.TypeFilter quantFilter = new QuantityUtil.TypeFilter(128L, QuantityType.GAS);
        this.table.setClipboard(3, (guiTableClipboard)new QuantityClipboard(quantFilter));
        this.table.getColumnModel().getColumn(3).setCellRenderer(cell);
        this.table.getColumnModel().getColumn(3).setCellEditor(cell);
        this.table.setColumnOptions(4, OPT_YES, OPT_NO);
        this.table.setColumnOptions(5, OPT_YES, OPT_NO);
        this.loadData();
        this.table.autoSizeColumns(200);
        GridBagUtil.add(dlgPanel, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 1);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (!this.noTwoPointsSame()) {
            String msg = Intl.intl("Error: Duplicate values of the same quantity are not permitted.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private Collection<PlanarSlice> getAllSlices() {
        return ((APyroObject)this.d_pyroMod.getSlcfList()).flatten(PlanarSlice.class);
    }

    public void setInitialSel(Collection<? extends PlanarSlice> slices) {
        this.table.clearSelection();
        this.table.setColumnSelectionInterval(0, 5);
        for (Slice slice : slices) {
            int ix = Util.indexOf(this.getAllSlices(), slice);
            if (ix < 0) continue;
            this.table.addRowSelectionInterval(ix, ix);
        }
    }

    public void loadData() {
        Collection<PlanarSlice> slices = this.getAllSlices();
        int numRows = slices.size();
        if (numRows > 0) {
            guiDefaultTableModel model = (guiDefaultTableModel)this.table.getModel();
            int i = 0;
            for (PlanarSlice slice : slices) {
                String plane;
                String name = slice.getName();
                boolean flowBool = slice.includeFlowVector();
                String flowStr = flowBool ? OPT_YES : OPT_NO;
                boolean centerBool = slice.isCellCentered();
                String centerStr = centerBool ? OPT_YES : OPT_NO;
                int planeid = slice.getPlane();
                switch (planeid) {
                    case 0: {
                        plane = "X";
                        break;
                    }
                    case 1: {
                        plane = "Y";
                        break;
                    }
                    case 2: {
                        plane = "Z";
                        break;
                    }
                    default: {
                        plane = "";
                    }
                }
                model.setValueAt(name, i, 0);
                model.setValueAt(plane, i, 1);
                model.setValueAt(slice.getLocation().convert(this.d_lengthUnit), i, 2);
                model.setValueAt(slice.getQuantity(), i, 3);
                model.setValueAt(flowStr, i, 4);
                model.setValueAt(centerStr, i, 5);
                ++i;
            }
        }
    }

    public void saveData() {
        List<PlanarSlice> slices = Arrays.asList(this.getSlices());
        Task task = guiOutputUtil.taskReplaceObjs(this.d_pyroMod.getSlcfList(), slices);
        this.d_pyroMod.getTaskManager().exec(task, Intl.intl("Save Slices"));
    }

    private PlanarSlice[] getSlices() {
        TableModel tm = this.d_editor.getTable().getModel();
        int numRows = tm.getRowCount();
        PlanarSlice[] records = new PlanarSlice[numRows];
        for (int i = 0; i < numRows; ++i) {
            String name = (String)tm.getValueAt(i, 0);
            Object flowOpt = tm.getValueAt(i, 4);
            boolean flowBool = flowOpt.equals(OPT_YES);
            Object centerOpt = tm.getValueAt(i, 5);
            boolean centerBool = centerOpt.equals(OPT_YES);
            String strplane = (String)tm.getValueAt(i, 1);
            int plane = strplane.equals("X") ? 0 : (strplane.equals("Y") ? 1 : 2);
            records[i] = new PlanarSlice(plane, (UnitDouble)tm.getValueAt(i, 2), (IQuantity)tm.getValueAt(i, 3), flowBool, centerBool, name);
        }
        return records;
    }

    private boolean noTwoPointsSame() {
        HashSet<PlanarSlice.PlanarSliceHash> hashes = new HashSet<PlanarSlice.PlanarSliceHash>();
        TableModel model = this.d_editor.getTable().getModel();
        for (int m = 0; m < model.getRowCount(); ++m) {
            String name = (String)model.getValueAt(m, 0);
            String strplane = (String)model.getValueAt(m, 1);
            int plane = strplane.equals("X") ? 0 : (strplane.equals("Y") ? 1 : 2);
            PlanarSlice.PlanarSliceHash hash = new PlanarSlice.PlanarSliceHash(plane, (UnitDouble)model.getValueAt(m, 2), (IQuantity)model.getValueAt(m, 3), name);
            if (hashes.add(hash)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
        if (result == 1) {
            this.saveData();
        }
        return result;
    }
}

