/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.grid.GridCreator;
import pyrosim.gui.grid.GridPanel;
import pyrosim.gui.grid.MeshmakerGridCreator;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;

public class RegularGridCreator
implements GridCreator {
    private static final DecimalFormat FMT1 = new DecimalFormat("0.0");
    private static final DecimalFormat FMT2 = new DecimalFormat("0.00");
    private static final DecimalFormat FMT3 = new DecimalFormat("0.000");
    private static final DecimalFormat FMT4 = new DecimalFormat("0.0000");
    private static final Icon ICON_GOOD = PyroGuiUtil.loadPyroSimIcon("good.png");
    private static final Icon ICON_MAYBE = PyroGuiUtil.loadPyroSimIcon("maybe.png");
    private static final Icon ICON_BAD = PyroGuiUtil.loadPyroSimIcon("bad.png");
    private static final Icon ICON_NONE = PyroGuiUtil.loadPyroSimIcon("none.png");
    private PyroMod d_pyMod;
    private guiLabel d_labX;
    private guiLabel d_labY;
    private guiLabel d_labZ;
    private ValueField<Integer> d_fldX;
    private ValueField<Integer> d_fldY;
    private ValueField<Integer> d_fldZ;
    private guiLabel d_labWarnRatioX;
    private guiLabel d_labWarnRatioY;
    private guiLabel d_labWarnRatioZ;
    private MultiLineLabel d_warningLabel;
    private guiLabel d_labCellsForGrid;
    private guiLabel d_labTotalCells;
    private guiLabel d_labCellSz;
    private Grid d_currentGrid;
    private guiPanel d_panel;
    private GridPanel d_gp;
    private static final Color ORANGE_TEXT = Color.ORANGE.darker().darker().darker().darker();

    public RegularGridCreator(GridPanel gp) {
        PyroMod mod;
        this.d_pyMod = mod = PyroSim.getApp().getMediator();
        this.d_gp = gp;
        this.d_panel = this.createPanel();
        this.setValues(null);
        this.updateWarnings();
    }

    @Override
    public guiPanel getPanel() {
        return this.d_panel;
    }

    private guiPanel createPanel() {
        guiPanel panel = new guiPanel();
        panel.setLayout(new MigLayout("insets 0, gapx 12"));
        this.d_fldX = ValueFields.intFld(IntVR.above(3, true));
        this.d_fldY = ValueFields.intFld(IntVR.above(1, true));
        this.d_fldZ = ValueFields.intFld(IntVR.above(1, true));
        this.d_labX = new guiLabel(Intl.intl("X Cells") + ":");
        this.d_labWarnRatioX = this.mkRatioWarningLabel();
        panel.add(this.d_labX);
        panel.add(this.d_fldX);
        panel.add((Component)this.d_labWarnRatioX, "wrap");
        this.d_labY = new guiLabel(Intl.intl("Y Cells") + ":");
        this.d_labWarnRatioY = this.mkRatioWarningLabel();
        panel.add(this.d_labY);
        panel.add(this.d_fldY);
        panel.add((Component)this.d_labWarnRatioY, "wrap");
        this.d_labZ = new guiLabel(Intl.intl("Z Cells") + ":");
        this.d_labWarnRatioZ = this.mkRatioWarningLabel();
        panel.add(this.d_labZ);
        panel.add(this.d_fldZ);
        panel.add((Component)this.d_labWarnRatioZ, "wrap 12");
        this.d_labCellSz = new guiLabel();
        this.d_labCellSz.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CellSizeEditorDlg dlg = new CellSizeEditorDlg(SwingUtilities.getWindowAncestor(RegularGridCreator.this.d_labCellSz));
                if (dlg.doModal() == 1) {
                    try {
                        Unit dispUnit = UnitSystem.getSource(0).getUnit();
                        double newSize = dlg.getSizeValue().get(dispUnit);
                        if (newSize <= 0.0) {
                            return;
                        }
                        double dx = RegularGridCreator.this.d_gp.tryGetMaxX().sub(RegularGridCreator.this.d_gp.tryGetMinX()).get(dispUnit);
                        double dy = RegularGridCreator.this.d_gp.tryGetMaxY().sub(RegularGridCreator.this.d_gp.tryGetMinY()).get(dispUnit);
                        double dz = RegularGridCreator.this.d_gp.tryGetMaxZ().sub(RegularGridCreator.this.d_gp.tryGetMinZ()).get(dispUnit);
                        int numX = (int)Math.round(dx / newSize);
                        int numY = (int)Math.round(dy / newSize);
                        int numZ = (int)Math.round(dz / newSize);
                        RegularGridCreator.this.d_fldX.setValue(numX);
                        RegularGridCreator.this.d_fldY.setValue(numY);
                        RegularGridCreator.this.d_fldZ.setValue(numZ);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.d_labCellsForGrid = new guiLabel(Intl.intl("Number of cells for %s: %d"));
        this.d_labTotalCells = new guiLabel(Intl.intl("Total number of cells: %d"));
        panel.add((Component)this.d_labCellSz, "span, wrap 12");
        panel.add((Component)this.d_labCellsForGrid, "span, wrap 12");
        panel.add((Component)this.d_labTotalCells, "span, wrap 12");
        this.d_warningLabel = new MultiLineLabel(Intl.intl("The number of cells is potentially inefficient. For maximum efficiency, the number should be factorable by 2, 3 and 5."));
        this.d_warningLabel.setColumns(40);
        this.d_warningLabel.setForeground(Color.blue);
        this.d_warningLabel.setVisible(false);
        panel.add((Component)this.d_warningLabel, "span, wrap 12");
        UpdateComponentsListener ucl = new UpdateComponentsListener();
        this.d_fldX.addValueChangeListener(ucl);
        this.d_fldY.addValueChangeListener(ucl);
        this.d_fldZ.addValueChangeListener(ucl);
        this.d_gp.addBoundsValueChangeListener(ucl);
        Dimension minSize = RegularGridCreator.calcMinWarningLblSize(this.d_labWarnRatioX);
        this.d_labWarnRatioX.setPreferredSize(minSize);
        this.d_labWarnRatioY.setPreferredSize(minSize);
        this.d_labWarnRatioZ.setPreferredSize(minSize);
        return panel;
    }

    public void updateWarnings() {
        this.updateRatioWarnings();
        this.updateCellSz();
        this.updateTotalCells();
    }

    private guiLabel mkRatioWarningLabel() {
        guiLabel labWarn = new guiLabel(Intl.intl("Cell Size Ratio: %r"));
        labWarn.setIcon(ICON_NONE);
        String base = Intl.intl("<html>Ratio of this cell dimension to the shortest.<br>For best results, use cubic cells (ratio of 1.0).");
        labWarn.setToolTipText(base);
        return labWarn;
    }

    private static long countCells(Grid g) {
        return (long)g.getXDivisions().length * (long)g.getYDivisions().length * (long)g.getZDivisions().length;
    }

    public void updateTotalCells() {
        long z;
        long y;
        long x;
        long cellsTotal = 0L;
        for (Grid g : this.d_pyMod.getGridManager().flatten()) {
            if (this.d_currentGrid == g) continue;
            cellsTotal += RegularGridCreator.countCells(g);
        }
        try {
            x = Math.max(1, Integer.parseInt(this.d_fldX.getText()));
        }
        catch (Throwable t) {
            x = 1L;
        }
        try {
            y = Math.max(1, Integer.parseInt(this.d_fldY.getText()));
        }
        catch (Throwable t) {
            y = 1L;
        }
        try {
            z = Math.max(1, Integer.parseInt(this.d_fldZ.getText()));
        }
        catch (Throwable t) {
            z = 1L;
        }
        long cellsGrid = x * y * z;
        cellsTotal += cellsGrid;
        String gridText = String.format(Intl.intl("Number of cells for mesh: %s"), NumberFormat.getNumberInstance(Locale.getDefault()).format(cellsGrid));
        this.d_labCellsForGrid.setText(gridText);
        if (this.d_pyMod.getGridManager().flatten().size() > 1) {
            String totText = String.format(Intl.intl("Total number of cells in model: %s"), NumberFormat.getNumberInstance(Locale.getDefault()).format(cellsTotal));
            this.d_labTotalCells.setText(totText);
        } else {
            this.d_labTotalCells.setText("");
        }
    }

    private boolean isSensitiveToNDigits(int n, double tol, double ... values) {
        int mult = 1;
        for (int i = 0; i < n; ++i) {
            mult *= 10;
        }
        for (double value : values) {
            double dval = value * (double)mult;
            int ival = (int)Math.round(value * (double)mult);
            if (!(tol < Math.abs(dval - (double)ival))) continue;
            return true;
        }
        return false;
    }

    public void updateCellSz() {
        double dz;
        double dy;
        double dx;
        int z;
        int y;
        int x;
        try {
            Unit dispUnit = UnitSystem.getSource(0).getUnit();
            x = Integer.parseInt(this.d_fldX.getText());
            y = Integer.parseInt(this.d_fldY.getText());
            z = Integer.parseInt(this.d_fldZ.getText());
            if (x < 1 || y < 1 || z < 1) {
                return;
            }
            dx = this.d_gp.tryGetMaxX().get(dispUnit) - this.d_gp.tryGetMinX().get(dispUnit);
            dy = this.d_gp.tryGetMaxY().get(dispUnit) - this.d_gp.tryGetMinY().get(dispUnit);
            dz = this.d_gp.tryGetMaxZ().get(dispUnit) - this.d_gp.tryGetMinZ().get(dispUnit);
            if (dx <= 0.0 || dy <= 0.0 || dz <= 0.0) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        double szX = dx / (double)x;
        double szY = dy / (double)y;
        double szZ = dz / (double)z;
        double tol = 1.0E-6;
        DecimalFormat fmt = this.isSensitiveToNDigits(3, 1.0E-6, szX, szY, szZ) ? FMT4 : (this.isSensitiveToNDigits(2, 1.0E-6, szX, szY, szZ) ? FMT3 : (this.isSensitiveToNDigits(1, 1.0E-6, szX, szY, szZ) ? FMT2 : FMT1));
        String sz = fmt.format(dx / (double)x) + " x " + fmt.format(dy / (double)y) + " x " + fmt.format(dz / (double)z);
        String text = "<html>" + String.format(Intl.intl("Cell Size (%1$s): "), this.d_gp.getUnit().toString()) + "<a href=\"BLAH\">" + sz + "</a></html>";
        this.d_labCellSz.setText(text);
    }

    public void updateRatioWarnings() {
        double dz;
        double dy;
        double dx;
        int z;
        int y;
        int x;
        this.d_labWarnRatioX.setText("");
        this.d_labWarnRatioY.setText("");
        this.d_labWarnRatioZ.setText("");
        this.d_labWarnRatioX.setIcon(ICON_NONE);
        this.d_labWarnRatioY.setIcon(ICON_NONE);
        this.d_labWarnRatioZ.setIcon(ICON_NONE);
        this.d_labWarnRatioX.setForeground(this.d_labTotalCells.getForeground());
        this.d_labWarnRatioY.setForeground(this.d_labTotalCells.getForeground());
        this.d_labWarnRatioZ.setForeground(this.d_labTotalCells.getForeground());
        try {
            Unit dispUnit = UnitSystem.getSource(0).getUnit();
            x = Integer.parseInt(this.d_fldX.getText());
            y = Integer.parseInt(this.d_fldY.getText());
            z = Integer.parseInt(this.d_fldZ.getText());
            if (x < 1 || y < 1 || z < 1) {
                return;
            }
            dx = this.d_gp.tryGetMaxX().get(dispUnit) - this.d_gp.tryGetMinX().get(dispUnit);
            dy = this.d_gp.tryGetMaxY().get(dispUnit) - this.d_gp.tryGetMinY().get(dispUnit);
            dz = this.d_gp.tryGetMaxZ().get(dispUnit) - this.d_gp.tryGetMinZ().get(dispUnit);
            if (dx <= 0.0 || dy <= 0.0 || dz <= 0.0) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        if (dx <= 0.0 || dy <= 0.0 || dz <= 0.0) {
            return;
        }
        double szX = dx / (double)x;
        double szY = dy / (double)y;
        double szZ = dz / (double)z;
        double smallCell = this.min(szX, szY, szZ);
        RegularGridCreator.updateRatioWarning(this.d_labWarnRatioX, x, szX, smallCell);
        RegularGridCreator.updateRatioWarning(this.d_labWarnRatioY, y, szY, smallCell);
        RegularGridCreator.updateRatioWarning(this.d_labWarnRatioZ, z, szZ, smallCell);
    }

    private static Dimension calcMinWarningLblSize(guiLabel sampleLbl) {
        String txt = sampleLbl.getText();
        String warning = RegularGridCreator.getWarning(10000, 10000.0);
        sampleLbl.setText(warning);
        Dimension size = sampleLbl.getPreferredSize();
        sampleLbl.setText(txt);
        return size;
    }

    private static String getWarning(int cellsWanted, double ratio) {
        Object warnBase = Intl.intl("Cell Size Ratio: %r");
        String strRat = FMT2.format(ratio);
        warnBase = ((String)warnBase).replaceFirst("%r", strRat);
        if (ratio > 1.25) {
            Object subBase = " " + Intl.intl("(suggested cells: %s)");
            subBase = ((String)subBase).replaceFirst("%s", Integer.toString(cellsWanted));
            warnBase = (String)warnBase + (String)subBase;
        }
        return warnBase;
    }

    private static void updateRatioWarning(guiLabel lbl, int count, double sz, double smallCell) {
        double ratio = sz / smallCell;
        int want = (int)(ratio * (double)count);
        String warning = RegularGridCreator.getWarning(want, ratio);
        lbl.setText(warning);
        if (ratio >= 2.0) {
            lbl.setIcon(ICON_BAD);
            lbl.setForeground(ORANGE_TEXT);
        } else if (ratio > 1.25) {
            lbl.setIcon(ICON_MAYBE);
        } else {
            lbl.setIcon(ICON_GOOD);
        }
    }

    private double min(double v1, double ... vals) {
        double min = v1;
        for (double v : vals) {
            min = Math.min(min, v);
        }
        return min;
    }

    @Override
    public String getPanelName() {
        return Intl.intl("Uniform");
    }

    @Override
    public void setValues(Grid g) {
        this.d_currentGrid = g;
        if (g != null) {
            this.d_fldX.setValue(g.getXDivisions().length);
            this.d_fldY.setValue(g.getYDivisions().length);
            this.d_fldZ.setValue(g.getZDivisions().length);
        } else {
            this.d_fldX.setValue(50);
            this.d_fldY.setValue(50);
            this.d_fldZ.setValue(15);
        }
        this.updateWarnings();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if ((Integer)this.d_fldY.getValue() == 2) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this.d_panel, Intl.intl("Invalid Y cells, must use at least 3 cells for 3-D simulations."));
            }
            return false;
        }
        return true;
    }

    public int getNumX() {
        return (Integer)this.d_fldX.getValue();
    }

    public int getNumY() {
        return (Integer)this.d_fldY.getValue();
    }

    public int getNumZ() {
        return (Integer)this.d_fldZ.getValue();
    }

    @Override
    public Grid createGrid(UnitPoint3D minPt, UnitPoint3D maxPt) {
        return new Grid("Mesh", minPt, maxPt, this.getNumX(), this.getNumY(), this.getNumZ());
    }

    public static boolean isGridRegular(Grid g) {
        return RegularGridCreator.isUniform(g.getXDivisions()) && RegularGridCreator.isUniform(g.getYDivisions()) && RegularGridCreator.isUniform(g.getZDivisions());
    }

    public static boolean isUniform(UnitDouble[] sizes) {
        if (sizes.length == 0) {
            return true;
        }
        double v1 = sizes[0].getValue(Geometry.LU);
        for (int m = 1; m < sizes.length; ++m) {
            double v2 = sizes[m].getValue(Geometry.LU);
            if (theUtil.eq(v1, v2, MeshmakerGridCreator.TOL)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void calcCellSizes() {
    }

    private class CellSizeEditorDlg
    extends guiDialog {
        private static final long serialVersionUID = 4953734602941220191L;
        private ValueField<UnitDouble> d_sizeFld;

        public CellSizeEditorDlg(Window owner) {
            super(owner, "Set cell size", 9);
            this.d_sizeFld = ValueFields.udFld(new UnitDouble(0.2, SI.METER), UnitSystem.getSource(0));
            GridBagHelper gbh = new GridBagHelper(this.getDialogPane());
            gbh.add(new guiLabel(Intl.intl("Cell Size:")), this.d_sizeFld);
            gbh.finalizeRows();
        }

        public UnitDouble getSizeValue() {
            return (UnitDouble)this.d_sizeFld.getValue();
        }
    }

    private class UpdateComponentsListener
    implements PropertyChangeListener,
    ItemListener {
        private UpdateComponentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RegularGridCreator.this.updateWarnings();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            RegularGridCreator.this.updateWarnings();
        }
    }
}

