/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.grid.GridCreator;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public abstract class MeshmakerGridCreator
implements GridCreator {
    public static double TOL = 1.0E-4;
    protected guiTable d_table;
    private guiTableEditor d_editor;
    private guiDefaultTableModel d_mod = new guiDefaultTableModel(0, 3, true, 1000, false, 5);
    protected double[] d_XCells;
    protected double[] d_YCells;
    protected double[] d_ZCells;

    public MeshmakerGridCreator() {
        this.d_mod.setColumnClass(0, String.class);
        this.d_mod.setColumnClass(1, Integer.class);
        this.d_mod.setColumnClass(2, Double.class);
        this.d_table = new guiTable((TableModel)this.d_mod, 24);
        this.d_table.setNullValuesAllowed(false);
        TableColumnModel tcm = this.d_table.getColumnModel();
        tcm.getColumn(0).setHeaderValue(Intl.intl("Dir") + " (X, Y, Z)");
        tcm.getColumn(1).setHeaderValue(Intl.intl("Num Cells"));
        tcm.getColumn(2).setHeaderValue(Intl.intl("Size"));
        this.d_table.setColumnOptions(0, "X", "Y", "Z");
        int options = 30;
        this.d_editor = new guiTableEditor(this.d_table, options);
        this.d_editor.setPreferredSize(new Dimension(400, 250));
    }

    @Override
    public guiPanel getPanel() {
        return this.d_editor;
    }

    @Override
    public String getPanelName() {
        return "Meshmaker";
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        int numRows = this.d_mod.getRowCount();
        int xcount = 0;
        int ycount = 0;
        int zcount = 0;
        for (int i = 0; i < numRows; ++i) {
            String msg;
            int ct = (Integer)this.d_mod.getValueAt(i, 1);
            double value = guiTableUtil.getDouble(this.d_mod, i, 2);
            if (ct <= 0) {
                if (showWarn) {
                    msg = Intl.intl("All cell counts must be greater than 0.");
                    this.showMessageBox(msg);
                }
                return false;
            }
            if (value <= 0.0) {
                if (showWarn) {
                    msg = Intl.intl("All cell sizes must be greater than 0.");
                    this.showMessageBox(msg);
                }
                return false;
            }
            String direction = (String)this.d_mod.getValueAt(i, 0);
            if (direction.equalsIgnoreCase("x") || direction.equalsIgnoreCase("nx")) {
                xcount += ct;
                continue;
            }
            if (direction.equalsIgnoreCase("y") || direction.equalsIgnoreCase("ny")) {
                ycount += ct;
                continue;
            }
            if (direction.equalsIgnoreCase("z") || direction.equalsIgnoreCase("nz")) {
                zcount += ct;
                continue;
            }
            if (showWarn) {
                String msg2 = String.format(Intl.intl("In valid entry in direction column (row: %d)."), i + 1);
                this.showMessageBox(msg2);
            }
            return false;
        }
        return this.validateCellCount(xcount, "X", showWarn, allowModify) && this.validateCellCount(ycount, "Y", showWarn, allowModify) && this.validateCellCount(zcount, "Z", showWarn, allowModify);
    }

    private boolean validateCellCount(int totalCellCount, String direction, boolean showWarn, boolean allowModify) {
        if (totalCellCount < 3 && !direction.equals("Y")) {
            if (showWarn) {
                String msg = String.format(Intl.intl("The total cell count in the %s direction must be greater than 2."), direction);
                this.showMessageBox(msg);
            }
            return false;
        }
        if (totalCellCount < 3 && direction.equals("Y") && totalCellCount != 1) {
            if (showWarn) {
                String msg = String.format(Intl.intl("The total cell count in the Y direction must be greater than 2 for 3-D simulations."), new Object[0]);
                this.showMessageBox(msg);
            }
            return false;
        }
        return true;
    }

    @Override
    public void calcCellSizes() {
        int numRows = this.d_mod.getRowCount();
        Vector<Integer> numXDiv = new Vector<Integer>();
        Vector<Integer> numYDiv = new Vector<Integer>();
        Vector<Integer> numZDiv = new Vector<Integer>();
        Vector<Double> XDiv = new Vector<Double>();
        Vector<Double> YDiv = new Vector<Double>();
        Vector<Double> ZDiv = new Vector<Double>();
        for (int i = 0; i < numRows; ++i) {
            String direction = (String)this.d_mod.getValueAt(i, 0);
            if (direction.compareToIgnoreCase("X") == 0 || direction.compareToIgnoreCase("NX") == 0) {
                numXDiv.add((Integer)this.d_mod.getValueAt(i, 1));
                XDiv.add((Double)this.d_mod.getValueAt(i, 2));
                continue;
            }
            if (direction.compareToIgnoreCase("Y") == 0 || direction.compareToIgnoreCase("NY") == 0) {
                numYDiv.add((Integer)this.d_mod.getValueAt(i, 1));
                YDiv.add((Double)this.d_mod.getValueAt(i, 2));
                continue;
            }
            if (direction.compareToIgnoreCase("Z") != 0 && direction.compareToIgnoreCase("NZ") != 0) continue;
            numZDiv.add((Integer)this.d_mod.getValueAt(i, 1));
            ZDiv.add((Double)this.d_mod.getValueAt(i, 2));
        }
        this.d_XCells = this.calcSizes(numXDiv, XDiv);
        this.d_YCells = this.calcSizes(numYDiv, YDiv);
        this.d_ZCells = this.calcSizes(numZDiv, ZDiv);
    }

    private double[] calcSizes(Vector numDiv, Vector div) {
        int num = 0;
        for (int i = 0; i < numDiv.size(); ++i) {
            num += ((Integer)numDiv.elementAt(i)).intValue();
        }
        double[] sizes = new double[num];
        int count = 0;
        for (int i = 0; i < numDiv.size(); ++i) {
            for (int j = 0; j < (Integer)numDiv.elementAt(i); ++j) {
                sizes[count] = (Double)div.elementAt(i);
                ++count;
            }
        }
        return sizes;
    }

    protected void showMessageBox(String msg) {
        JOptionPane.showMessageDialog(this.d_table, msg, Intl.intl("Invalid Entry"), 2);
    }

    protected void showDimensionError(String axis, double meshmaker, double model, double tol) {
        Object msg = "";
        msg = (String)msg + String.format(Intl.intl("Mesh dimensions do not match model dimensions along the %s axis."), axis) + "\n";
        msg = (String)msg + Intl.intl("Mesh axis length") + ": " + meshmaker + "\n";
        msg = (String)msg + Intl.intl("Model axis length") + ": " + model + "\n";
        msg = (String)msg + Intl.intl("Tolerance") + ": " + tol;
        this.showMessageBox((String)msg);
    }

    public static MeshmakerEntry buildEntryList(UnitDouble[] lengths, Unit dispUnit) {
        double tol = UnitDouble.convert(TOL, Geometry.LU, dispUnit);
        MeshmakerEntry entry = null;
        MeshmakerEntry root = null;
        for (int m = 0; m < lengths.length; ++m) {
            MeshmakerEntry next;
            double v = lengths[m].getValue(dispUnit);
            if (m == 0) {
                entry = root = new MeshmakerEntry(v);
                continue;
            }
            if (theUtil.eq(entry.value, v, tol)) {
                ++entry.numCells;
                continue;
            }
            entry.next = next = new MeshmakerEntry(v);
            entry = next;
        }
        return root;
    }

    public void clearTable() {
        ResizableTableModel mod = (ResizableTableModel)this.d_table.getModel();
        for (int m = mod.getRowCount() - 1; m >= 0; --m) {
            mod.removeRow(m);
        }
    }

    public static class MeshmakerEntry {
        public final double value;
        public int numCells;
        public MeshmakerEntry next;

        public MeshmakerEntry(double value) {
            this.value = value;
            this.numCells = 1;
            this.next = null;
        }
    }
}

