/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.domain.tasks.TranslateTask;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.GeomUtil;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class TranslateDialog
extends TransformDialog {
    private static final long serialVersionUID = 8529781172286773747L;
    private ValueField<UnitDouble> d_x = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_y = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_z = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_minXField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_minYField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_minZField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_maxXField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_maxYField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_maxZField = ValueFields.udFld(UnitSystem.getSource(0));
    protected static final String TRANSLATE = Intl.intl("Move");

    public TranslateDialog(PyroMod mediator, Collection<? extends IPyroObject> objs) {
        super(Intl.intl(TRANSLATE), mediator, objs, true, true);
        this.d_minXField.setEditable(false);
        this.d_minYField.setEditable(false);
        this.d_minZField.setEditable(false);
        this.d_maxXField.setEditable(false);
        this.d_maxYField.setEditable(false);
        this.d_maxZField.setEditable(false);
        this.d_minXField.setFocusable(false);
        this.d_minYField.setFocusable(false);
        this.d_minZField.setFocusable(false);
        this.d_maxXField.setFocusable(false);
        this.d_maxYField.setFocusable(false);
        this.d_maxZField.setFocusable(false);
        guiPanel dlgPane = this.getDialogPane();
        dlgPane.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(dlgPane, this.getModePanel(), 0, row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(dlgPane, this.getPanel(), 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        this.updateSelection(objs);
        super.init();
    }

    @Override
    protected String getTransformTypeName() {
        return TRANSLATE;
    }

    private guiPanel getPanel() {
        guiPanel p = new guiPanel(new GridBagLayout());
        int row = 0;
        TitleSeparator ts = new TitleSeparator(Intl.intl("Translate"));
        GridBagUtil.add(p, ts, 0, row, 99, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(p, new guiLabel("X"), 1, ++row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 10);
        GridBagUtil.add(p, new guiLabel("Y"), 2, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 10);
        GridBagUtil.add(p, new guiLabel("Z"), 3, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 10);
        GridBagUtil.add(p, new guiLabel(Intl.intl("Offset") + ": "), 0, ++row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_x, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_y, 2, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_z, 3, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, new TitleSeparator(Intl.intl("Selected Border")), 0, ++row, 40, 1, 6, 0, 6, 12, 2, 0.0, 0.0, 17);
        GridBagUtil.add(p, new guiLabel(Intl.intl("Min") + ": "), 0, ++row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_minXField, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_minYField, 2, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_minZField, 3, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, new guiLabel(Intl.intl("Max") + ": "), 0, ++row, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_maxXField, 1, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_maxYField, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_maxZField, 3, row, 1, 1, 0, 0, 6, 0, 0, 1.0, 1.0, 17);
        return p;
    }

    private UnitPoint3D getOffset() {
        return new UnitPoint3D((UnitDouble)this.d_x.getValue(), (UnitDouble)this.d_y.getValue(), (UnitDouble)this.d_z.getValue());
    }

    private void updateSelection(Collection<? extends IPyroObject> selectedObjects) {
        UnitAABox bb = GeomUtil.getUnitBounds(Hierarchy.flatten(selectedObjects, IPyroGeomSrc.class));
        UnitPoint3D min = bb.getMin();
        UnitPoint3D max = bb.getMax();
        this.d_minXField.setValue(min.xu());
        this.d_minYField.setValue(min.yu());
        this.d_minZField.setValue(min.zu());
        this.d_maxXField.setValue(max.xu());
        this.d_maxYField.setValue(max.yu());
        this.d_maxZField.setValue(max.zu());
    }

    @Override
    protected boolean isIdentityTransform() {
        return this.getOffset().equals(new UnitPoint3D(0.0, 0.0, 0.0, UnitSystem.getSource(0).getUnit()));
    }

    @Override
    protected TransformTask taskTransform(Collection<? extends IPyroObject> objs) {
        return new TranslateTask(this.getMediator(), objs, this.getNumCopies(), this.getOffset());
    }
}

