/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class TransformEditor
extends guiPanel
implements IGeomEditor<IGeom> {
    private static final long serialVersionUID = -218588775812816631L;
    private final Point3DPanel d_rotAxisPnl;
    private final ValueField<UnitDouble> d_rotAngleFld;
    private final Point3DPanel d_offsetPnl;
    private final Point3DPanel d_scalePnl;
    private final PropertyUtil.IProp<IPyroGeomSrc, TransformInfo> xformProp = new PropertyUtil.AProp<IPyroGeomSrc, TransformInfo>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc obj) {
            return obj.getGeom().getLocalTransform();
        }

        @Override
        public void set(IPyroGeomSrc obj, TransformInfo prop) {
            if (prop == null) {
                return;
            }
            obj.setGeom(obj.getGeom().applyLocalTransform(prop.xform));
        }
    };

    public TransformEditor() {
        super(new GridBagLayout());
        this.d_offsetPnl = new Point3DPanel(Intl.intl("Location") + ":", true);
        this.d_rotAxisPnl = new Point3DPanel(Intl.intl("Rotation Axis") + ":", true, 28);
        guiLabel angleLbl = new guiLabel(Intl.intl("Rotation Angle") + ":");
        this.d_rotAngleFld = ValueFields.udFld(0.0, SI.RADIAN, UnitSystem.getSource(29));
        this.d_rotAngleFld.setNullAllowed(true);
        this.d_scalePnl = new Point3DPanel(Intl.intl("Scale") + ":", true, 28);
        int row = 0;
        this.d_offsetPnl.addToPanel(this, 0, row);
        this.d_rotAxisPnl.addToPanel(this, 0, ++row);
        GridBagUtil.add(this, angleLbl, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rotAngleFld, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        this.d_scalePnl.addToPanel(this, 0, ++row);
        GridBagUtil.addGlue(this);
    }

    public static boolean isNeeded(Collection<? extends IPyroGeomSrc> objs) {
        return objs.stream().anyMatch(obj -> !obj.getGeom().getLocalTransform().isIdentity());
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Transformation");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        UnitPoint3D axis = this.d_rotAxisPnl.save();
        if (axis != null && axis.x() == 0.0 && axis.y() == 0.0 && axis.z() == 0.0) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this.getParent(), Intl.intl("The rotation axis must have non-zero length."), Intl.intl("Invalid Rotation Axis"), 0);
            }
            return false;
        }
        UnitPoint3D scale = this.d_scalePnl.save();
        if (scale != null && (scale.x() == 0.0 || scale.y() == 0.0 || scale.z() == 0.0)) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this.getParent(), Intl.intl("The scale must be non-zero in every dimension."), Intl.intl("Invalid Scale"), 0);
            }
            return false;
        }
        return true;
    }

    private void load(ITransform transform) {
        if (transform == null) {
            this.d_rotAngleFld.setValue(null);
            this.d_rotAxisPnl.load(null);
            this.d_offsetPnl.load(null);
            this.d_scalePnl.load(null);
            return;
        }
        Matrix4d xform = transform.toMatrix(false);
        AxisAngle4d[] rotate = new AxisAngle4d[]{null};
        UnitPoint3D[] offset = new UnitPoint3D[]{null};
        UnitPoint3D[] scale = new UnitPoint3D[]{null};
        GeomUtil.decompose(xform, 1.0E-9, t -> {
            offset[0] = new UnitPoint3D((Tuple3d)t, Geometry.LU);
        }, r -> {
            rotate[0] = r;
        }, s -> {
            scale[0] = new UnitPoint3D((Tuple3d)s, Unit.ONE);
        });
        if (rotate[0] != null) {
            AxisAngle4d aa = rotate[0];
            this.d_rotAngleFld.setValue(new UnitDouble(aa.angle, SI.RADIAN));
            Vector3d axis = new Vector3d(aa.x, aa.y, aa.z);
            axis.normalize();
            this.d_rotAxisPnl.load(new UnitPoint3D(axis.x, axis.y, axis.z, Unit.ONE));
        } else {
            this.d_rotAngleFld.setValue(null);
            this.d_rotAxisPnl.load(null);
        }
        assert (offset[0] != null);
        this.d_offsetPnl.load(offset[0]);
        this.d_scalePnl.load(scale[0]);
    }

    private static double getScale(double s1, double s2, double s3) {
        if (s1 == 0.0 && s2 == 0.0 && s3 == 0.0) {
            return 0.0;
        }
        if (s1 == 0.0 && s2 == 0.0) {
            return s3;
        }
        if (s1 == 0.0 && s3 == 0.0) {
            return s2;
        }
        if (s2 == 0.0 && s3 == 0.0) {
            return s1;
        }
        if (s1 == 0.0) {
            return theUtil.eq(s2, s3, 1.0E-5) ? s2 : Double.NaN;
        }
        if (s2 == 0.0) {
            return theUtil.eq(s1, s3, 1.0E-5) ? s1 : Double.NaN;
        }
        if (s3 == 0.0) {
            return theUtil.eq(s1, s2, 1.0E-5) ? s1 : Double.NaN;
        }
        return theUtil.eq(s1, s2, 1.0E-5) && theUtil.eq(s1, s3, 1.0E-5) ? s1 : Double.NaN;
    }

    private ITransform save() {
        UnitPoint3D axis = this.d_rotAxisPnl.save();
        UnitDouble angle = (UnitDouble)this.d_rotAngleFld.getValue();
        UnitPoint3D offset = this.d_offsetPnl.save();
        UnitPoint3D scale = this.d_scalePnl.save();
        if (axis == null || angle == null || offset == null || scale == null) {
            return null;
        }
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        xform.setRotation(new AxisAngle4d(axis.x(), axis.y(), axis.z(), angle.getValue(SI.RADIAN)));
        xform.m03 = offset.x(Geometry.LU);
        xform.m13 = offset.y(Geometry.LU);
        xform.m23 = offset.z(Geometry.LU);
        xform.m00 *= scale.x();
        xform.m10 *= scale.x();
        xform.m20 *= scale.x();
        xform.m01 *= scale.y();
        xform.m11 *= scale.y();
        xform.m21 *= scale.y();
        xform.m02 *= scale.z();
        xform.m12 *= scale.z();
        xform.m22 *= scale.z();
        return new MatrixXform(xform).optimize();
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        Object transform = PropertyUtil.getProperty(this.xformProp, geoms);
        if (!(transform instanceof ITransform)) {
            transform = null;
        }
        this.load((ITransform)transform);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        ITransform xform = this.save();
        TransformInfo ti = xform != null ? xform.getInfo() : null;
        PropertyUtil.setProperty(this.xformProp, ti, geoms);
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return new String[0];
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }
}

