/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.PointListEditor;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.PropertyUtil;

public class PolygonEditor
extends guiPanel
implements IGeomEditor<IPolygon> {
    private static final long serialVersionUID = -2681259453484325881L;
    public static final String FACE_NAME = Intl.intl("Face");
    private final PointListEditor d_pointEditor;
    private final PropertyUtil.IProp<IPyroGeomSrc, IPolygon> polyProp = new PropertyUtil.AProp<IPyroGeomSrc, IPolygon>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc obj) {
            return (IPolygon)obj.getGeom().getLocalGeom();
        }

        @Override
        public void set(IPyroGeomSrc obj, IPolygon prop) {
            obj.setGeom(obj.getGeom().applyLocalGeom(prop));
        }

        @Override
        public boolean equal(IPolygon obj1, IPolygon obj2) {
            return PolyUtil.polysEqual(obj1, obj2);
        }
    };

    public PolygonEditor() {
        super(new BorderLayout());
        this.d_pointEditor = new PointListEditor(true);
        this.add((Component)this.d_pointEditor, "Center");
    }

    public int getNumSides() {
        return this.d_pointEditor.getNumPoints();
    }

    @Override
    public String[] getFaceNames() {
        return new String[]{FACE_NAME};
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Polygon");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        Point3d[] points = this.getPoints();
        if (points == null) {
            this.error(showWarn, Intl.intl("Empty cells are not permitted."));
            return false;
        }
        if (points.length == 0 && geoms.size() > 1) {
            return true;
        }
        if (points.length < 3) {
            this.error(showWarn, Intl.intl("Polygons must have at least 3 points."));
            return false;
        }
        int[] nonCoplanar = Util3D.getNonCoplanar(1.0E-6, points);
        if (nonCoplanar.length > 0) {
            this.d_pointEditor.markRows(nonCoplanar);
            this.error(showWarn, Intl.intl("All points must be coplanar."));
            return false;
        }
        return true;
    }

    private void error(boolean show, String msg) {
        JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid Polygon"), 0);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        Object poly = PropertyUtil.getProperty(this.polyProp, geoms);
        if (!(poly instanceof IPolygon)) {
            poly = null;
        }
        this.load((IPolygon)poly);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        IPolygon poly = this.save();
        if (poly != null) {
            PropertyUtil.setProperty(this.polyProp, poly, geoms);
        }
    }

    private Point3d[] getPoints() {
        List<Point3d> points = this.d_pointEditor.save();
        if (points == null) {
            return null;
        }
        return points.toArray(new Point3d[points.size()]);
    }

    public void load(IPolygon polygon) {
        if (polygon == null) {
            this.d_pointEditor.load(Collections.EMPTY_LIST);
            return;
        }
        assert (polygon.getNumLoops() == 1);
        Point3d[] points = PolyUtil.getLoop(polygon, 0, false);
        this.d_pointEditor.load(Arrays.asList(points));
    }

    public IPolygon save() {
        Point3d[] points = this.getPoints();
        return points == null || points.length == 0 ? null : PolyUtil.newPoly(points);
    }
}

