/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.geom.plane.AAPlane;
import pyrosim.domain.geom.plane.EuclideanPlane;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.domain.geom.plane.PointNormalPlane;
import pyrosim.geom.Geometry;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypeFilter;

public class PlaneDialog
extends guiDialog {
    private static final long serialVersionUID = -1067265634156487241L;
    private final guiComboBox<IEditor<? extends IPlane>> d_editorCB;
    private final CardLayout d_cards;

    public PlaneDialog(Window parent) {
        super(parent, Intl.intl("Edit Plane"), 9);
        List<IEditor> editors = Arrays.asList(new AAEditor(), new PointNormalEditor(), new EuclideanEditor());
        this.d_editorCB = new guiComboBox<IEditor>((Collection<IEditor>)editors);
        this.d_cards = new CardLayout();
        guiPanel editorPanel = new guiPanel(this.d_cards);
        for (IEditor editor : editors) {
            editorPanel.add((Component)editor.getComponent(), editor.toString());
        }
        this.d_editorCB.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            IEditor newItem = (IEditor)e.getItem();
            this.d_cards.show(editorPanel, newItem.toString());
        });
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Plane type:"), this.d_editorCB);
        gb.addFilledRow(new JSeparator());
        gb.indent();
        gb.addFilledRow(editorPanel);
        gb.finalizeRows();
    }

    public void load(IPlane plane) {
        for (IEditor<? extends IPlane> editor : this.d_editorCB.getAllItems()) {
            editor.load(plane);
            if (!editor.getFilter().test(plane)) continue;
            this.d_editorCB.setSelectedItem(editor);
        }
    }

    public IPlane save() {
        return this.d_editorCB.getSelectedItem().save();
    }

    private static class PointNormalEditor
    extends AEditor<PointNormalPlane> {
        private static final long serialVersionUID = 2172327532059096893L;
        private final ValueField<Double> d_nx = ValueFields.doubleFld();
        private final ValueField<Double> d_ny = ValueFields.doubleFld();
        private final ValueField<Double> d_nz = ValueFields.doubleFld();
        private final ValueField<UnitDouble> d_x;
        private final ValueField<UnitDouble> d_y;
        private final ValueField<UnitDouble> d_z;

        public PointNormalEditor() {
            super(PointNormalPlane.class);
            IUnitSrc lu = UnitSystem.getSource(0);
            this.d_x = ValueFields.udFld(lu);
            this.d_y = ValueFields.udFld(lu);
            this.d_z = ValueFields.udFld(lu);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Point on Plane:"), "X:", this.d_x, "Y:", this.d_y, "Z:", this.d_z);
            gb.addRow(Intl.intl("Normal to Plane:"), "X:", this.d_nx, "Y:", this.d_ny, "Z:", this.d_nz);
            gb.finalizeRows();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if ((Double)this.d_nx.getValue() == 0.0 && (Double)this.d_ny.getValue() == 0.0 && (Double)this.d_nz.getValue() == 0.0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("At least one of normal's x,y, or z components must not be zero."), Intl.intl("Invalid Plane Equation"), 0);
                }
                return false;
            }
            return true;
        }

        @Override
        public void load(IPlane plane) {
            Point3d p;
            Vector3d n;
            if (plane instanceof PointNormalPlane) {
                PointNormalPlane pnp = (PointNormalPlane)plane;
                n = pnp.normal;
                p = pnp.point;
            } else {
                Plane3d plane3d = plane.get();
                n = plane3d.getNormal();
                p = plane3d.getPointOnPlane();
            }
            this.d_nx.setValue(n.x);
            this.d_ny.setValue(n.y);
            this.d_nz.setValue(n.z);
            Unit lu = Geometry.LU;
            this.d_x.setValue(new UnitDouble(p.x, lu));
            this.d_y.setValue(new UnitDouble(p.y, lu));
            this.d_z.setValue(new UnitDouble(p.z, lu));
        }

        @Override
        public PointNormalPlane save() {
            Unit lu = Geometry.LU;
            Point3d p = new Point3d(((UnitDouble)this.d_x.getValue()).get(lu), ((UnitDouble)this.d_y.getValue()).get(lu), ((UnitDouble)this.d_z.getValue()).get(lu));
            Vector3d n = new Vector3d((Double)this.d_nx.getValue(), (Double)this.d_ny.getValue(), (Double)this.d_nz.getValue());
            n.normalize();
            return new PointNormalPlane(p, n);
        }

        @Override
        public String toString() {
            return Intl.intl("Point+Normal");
        }
    }

    private static class EuclideanEditor
    extends AEditor<EuclideanPlane> {
        private static final long serialVersionUID = -3442108797140848653L;
        private final ValueField<Double> d_x;
        private final ValueField<Double> d_y;
        private final ValueField<Double> d_z;
        private final ValueField<UnitDouble> d_w;

        public EuclideanEditor() {
            super(EuclideanPlane.class);
            IUnitSrc lu = UnitSystem.getSource(0);
            this.d_x = ValueFields.doubleFld();
            this.d_y = ValueFields.doubleFld();
            this.d_z = ValueFields.doubleFld();
            this.d_w = ValueFields.udFld(lu);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(Intl.intl("Enter the plane equation (ax + by + cz + d = 0):"));
            gb.addRow("a:", this.d_x, "b:", this.d_y, "c:", this.d_z, "d:", this.d_w);
            gb.finalizeRows();
        }

        @Override
        public void load(IPlane plane) {
            if (plane instanceof EuclideanPlane) {
                EuclideanPlane p = (EuclideanPlane)plane;
                this.d_x.setValue(p.x);
                this.d_y.setValue(p.y);
                this.d_z.setValue(p.z);
                this.d_w.setValue(new UnitDouble(p.w, Geometry.LU));
            } else {
                Plane3d p = plane.get();
                this.d_x.setValue(p.x);
                this.d_y.setValue(p.y);
                this.d_z.setValue(p.z);
                this.d_w.setValue(new UnitDouble(p.w, Geometry.LU));
            }
        }

        @Override
        public EuclideanPlane save() {
            return new EuclideanPlane((Double)this.d_x.getValue(), (Double)this.d_y.getValue(), (Double)this.d_z.getValue(), ((UnitDouble)this.d_w.getValue()).get(Geometry.LU));
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if ((Double)this.d_x.getValue() == 0.0 && (Double)this.d_y.getValue() == 0.0 && (Double)this.d_z.getValue() == 0.0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("At least one of a, b, or c must not be zero."), Intl.intl("Invalid Plane Equation"), 0);
                }
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            return Intl.intl("Equation");
        }
    }

    private static class AAEditor
    extends AEditor<AAPlane> {
        private static final long serialVersionUID = -605447132620261232L;
        private final guiComboBox<AAPlane.Axis> d_axis = new guiComboBox<AAPlane.Axis>(AAPlane.Axis.values());
        private final ValueField<UnitDouble> d_val = ValueFields.udFld(UnitSystem.getSource(0));
        private final guiComboBox<Boolean> d_dirCB = new guiComboBox<Boolean>((T[])new Boolean[]{true, false});

        public AAEditor() {
            super(AAPlane.class);
            this.d_dirCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -726292616128815378L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    Boolean dir = (Boolean)value;
                    char c = dir != false ? (char)'+' : '-';
                    String lbl = String.format("%c%s", new Object[]{Character.valueOf(c), d_axis.getSelectedItem()});
                    this.setText(lbl);
                    return this;
                }
            });
            this.d_axis.addItemListener(e -> this.d_dirCB.repaint());
            GridBagHelper gb = new GridBagHelper(this);
            guiPanel axisPnl = new guiPanel(new FlowLayout(0, gb.colSpace, 0));
            axisPnl.add(this.d_axis);
            axisPnl.add(new guiLabel("="));
            axisPnl.add(this.d_val);
            gb.addRow(axisPnl, 0);
            gb.addRow(Intl.intl("Normal:"), this.d_dirCB, 0);
            gb.finalizeRows();
        }

        @Override
        public void load(IPlane plane) {
            if (plane instanceof AAPlane) {
                AAPlane aplane = (AAPlane)plane;
                this.d_axis.setSelectedItem((Object)aplane.axis);
                this.d_val.setValue(new UnitDouble(aplane.val, Geometry.LU));
                this.d_dirCB.setSelectedItem(aplane.pnormal);
            }
        }

        @Override
        public AAPlane save() {
            return new AAPlane(this.d_axis.getSelectedItem(), ((UnitDouble)this.d_val.getValue()).get(Geometry.LU), this.d_dirCB.getSelectedItem());
        }

        @Override
        public String toString() {
            return Intl.intl("Axis-aligned");
        }
    }

    private static abstract class AEditor<T extends IPlane>
    extends guiPanel
    implements IEditor<T> {
        private static final long serialVersionUID = 7079981840797444311L;
        private final Class<T> d_clazz;

        public AEditor(Class<T> clazz) {
            this.d_clazz = clazz;
        }

        @Override
        public Predicate<IPlane> getFilter() {
            return new TypeFilter<IPlane>(this.d_clazz);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }
    }

    private static interface IEditor<T extends IPlane> {
        public Predicate<IPlane> getFilter();

        public JComponent getComponent();

        public void load(IPlane var1);

        public T save();
    }
}

