/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.Property;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class PartCloudEditor
implements ModelObjectDialog.IEditor<PartCloud> {
    private final ModelObjectDialog d_parent;
    private final ParticleComboBox d_particleCombo;
    private final DropletCountPanel d_dropletCountPanel;
    private final InsertionPanel d_insertPanel;
    private final JButton d_editPartBtn;
    private Property<Boolean> d_geom3d;
    private Collection<? extends PartCloud> d_loadedObjs = Collections.EMPTY_LIST;
    Composite.AObjectProp<PartCloud, Boolean> hasVolumeProp = new Composite.AObjectProp<PartCloud, Boolean>(PartCloud.class){

        @Override
        public Object get(PartCloud obj) {
            return !(obj.getGeom().getLocalGeom() instanceof Point);
        }

        @Override
        public void set(PartCloud obj, Boolean prop) {
        }
    };

    public PartCloudEditor(ModelObjectDialog parent, PyroMod domain) {
        this.d_parent = parent;
        this.d_dropletCountPanel = new DropletCountPanel(true);
        this.d_insertPanel = new InsertionPanel(domain, parent.getNameSource(), true);
        this.d_geom3d = Property.nonUniform();
        this.d_particleCombo = new ParticleComboBox(PyroSim.getApp().getMediator().getPartList(), null, null);
        this.d_particleCombo.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                this.updateEnabled();
            }
        });
        this.d_editPartBtn = new JButton(Intl.intl("Edit Particles") + "...");
        this.d_editPartBtn.addActionListener(evt -> {
            Actions.editParticles((Particle)this.d_particleCombo.getSelectedItem());
            if (this.d_particleCombo.getSelectedItem() == null && this.d_particleCombo.getItemCount() > 0 && this.d_parent.getMode() == 0) {
                this.d_particleCombo.setSelectedIndex(0);
            }
            this.updateEnabled();
        });
    }

    @Override
    public boolean isControllable(PartCloud obj) {
        return false;
    }

    public void updateEnabled() {
        Property<Boolean> massless = this.d_particleCombo.getSelectedItem() == null ? Property.nonUniform() : Property.of(((Particle)this.d_particleCombo.getSelectedItem()).isType(Particle.Type.TRACER));
        this.d_insertPanel.updateEnabled(massless, this.d_geom3d);
        this.d_dropletCountPanel.updateEnabled(massless, this.d_geom3d);
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Particle Cloud Properties");
    }

    @Override
    public Class<PartCloud> getType() {
        return PartCloud.class;
    }

    @Override
    public boolean validateData(Component parent, Collection<? extends PartCloud> objs, boolean showWarn, boolean allowModify) {
        if (this.d_particleCombo.getSelectedItem() == null && this.d_parent.getMode() == 0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(parent, Intl.intl("A valid particle must be selected."));
            }
            return false;
        }
        return true;
    }

    @Override
    public void add(ModelObjectDialog dlg, GridBagHelper gb) {
        gb.addRow(Intl.intl("Particle") + ":", this.d_particleCombo, this.d_editPartBtn, 0);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Particle Count")));
        gb.addIdentRow(this.d_dropletCountPanel, 1.0, 0);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Insertion")));
        gb.addIdentRow(this.d_insertPanel, 1.0, 0);
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void load(PyroMod domain, Collection<? extends PartCloud> objs) {
        this.d_insertPanel.loadData(objs);
        Property particle = Composite.getProp(PartCloud.partProp, objs);
        this.d_particleCombo.setSelectedItem(particle.orElse(null));
        this.d_dropletCountPanel.loadData(objs);
        this.d_geom3d = Composite.getProp(this.hasVolumeProp, objs);
        this.updateEnabled();
        this.d_loadedObjs = objs;
    }

    @Override
    public void save(PyroMod domain, Collection<? extends PartCloud> objs) {
        this.d_insertPanel.saveData(objs);
        Property<Particle> part = Property.ofNullable((Particle)this.d_particleCombo.getSelectedItem());
        Composite.setProp(PartCloud.partProp, part, objs);
        this.d_dropletCountPanel.saveData(objs);
    }

    private static abstract class AProp<PropT>
    extends Composite.AObjectProp<PartCloud, PropT> {
        public AProp() {
            super(PartCloud.class);
        }
    }

    public static class DropletCountPanel
    extends guiPanel {
        private static final long serialVersionUID = 4753295072047403454L;
        private final guiRadioButton d_densityRB;
        private final guiRadioButton d_constantRB;
        private final guiRadioButton d_cellDensityRB;
        private final ValueField<Integer> d_constant;
        private final ValueField<UnitDouble> d_density;
        private final ValueField<Integer> d_cellDensity;
        private final guiMultiStateCheckBox d_cellCenteredCB;
        private final ButtonGroup d_group;
        private Collection<? extends PartCloud> d_loadedObjs = Collections.EMPTY_LIST;
        private AProp<Type> typeProp = new AProp<Type>(){

            @Override
            public Object get(PartCloud obj) {
                PartCloud.IDropletCount count = obj.getInitDrops();
                Type type = Type.get(count);
                return type == null ? Composite.NOT_SUPPORTED : type;
            }

            @Override
            public void set(PartCloud obj, Type prop) {
                PartCloud.IDropletCount count;
                if (prop == this.get(obj)) {
                    return;
                }
                switch (prop) {
                    case DENSITY: {
                        count = new PartCloud.DropDensityCount();
                        break;
                    }
                    case CONSTANT: {
                        count = new PartCloud.ConstDropletCount();
                        break;
                    }
                    case CELL_DENSITY: {
                        count = new PartCloud.PerCellCount();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                obj.setInitDrops(count);
            }
        };
        private AProp<Integer> constCountProp = new AProp<Integer>(){

            @Override
            public Object get(PartCloud obj) {
                return ((PartCloud.ConstDropletCount)obj.getInitDrops()).d_dropCount;
            }

            @Override
            public void set(PartCloud obj, Integer prop) {
                obj.setInitDrops(new PartCloud.ConstDropletCount(prop));
            }
        };
        private AProp<UnitDouble> densityProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud obj) {
                return ((PartCloud.DropDensityCount)obj.getInitDrops()).d_density;
            }

            @Override
            public void set(PartCloud obj, UnitDouble prop) {
                obj.setInitDrops(new PartCloud.DropDensityCount(prop));
            }
        };
        private AProp<Integer> perCellProp = new AProp<Integer>(){

            @Override
            public Object get(PartCloud obj) {
                return ((PartCloud.PerCellCount)obj.getInitDrops()).partPerCell;
            }

            @Override
            public void set(PartCloud obj, Integer prop) {
                obj.setInitDrops(new PartCloud.PerCellCount(prop, ((PartCloud.PerCellCount)obj.getInitDrops()).cellCentered));
            }
        };
        private AProp<Boolean> cellCenteredProp = new AProp<Boolean>(){

            @Override
            public Object get(PartCloud obj) {
                return ((PartCloud.PerCellCount)obj.getInitDrops()).cellCentered;
            }

            @Override
            public void set(PartCloud obj, Boolean prop) {
                obj.setInitDrops(new PartCloud.PerCellCount(((PartCloud.PerCellCount)obj.getInitDrops()).partPerCell, prop));
            }
        };

        public DropletCountPanel(boolean emptyAllowed) {
            this.setLayout(new GridBagLayout());
            this.d_densityRB = new guiRadioButton(Intl.intl("Density") + ":");
            this.d_cellDensityRB = new guiRadioButton(Intl.intl("Particles/cell:"));
            this.d_constantRB = new guiRadioButton(Intl.intl("Constant") + ":");
            this.d_densityRB.setSelected(true);
            this.d_density = ValueFields.udFld(10.0, SIUS.unit(55), UnitSystem.getSource(55));
            this.d_cellDensity = ValueFields.intFld(1);
            this.d_cellCenteredCB = new guiMultiStateCheckBox(Intl.intl("Cell-centered"));
            this.d_constant = ValueFields.intFld();
            this.d_cellDensity.setNullAllowed(emptyAllowed);
            this.d_constant.setNullAllowed(emptyAllowed);
            this.d_density.setNullAllowed(emptyAllowed);
            this.d_group = guiUtil.group(new AbstractButton[]{this.d_densityRB, this.d_cellDensityRB, this.d_constantRB});
            LinkStatus.link((AbstractButton)this.d_densityRB, this.d_density);
            LinkStatus.link((AbstractButton)this.d_constantRB, this.d_constant);
            LinkStatus.link((AbstractButton)this.d_cellDensityRB, this.d_cellDensity, this.d_cellCenteredCB);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_densityRB, this.d_density, 0);
            gb.addRow(this.d_cellDensityRB, this.d_cellDensity, this.d_cellCenteredCB, 0);
            gb.addRow(this.d_constantRB, this.d_constant, 0);
            gb.finalizeRows();
            this.d_density.setValue(new PartCloud.DropDensityCount().d_density);
            this.d_constant.setValue(new PartCloud.ConstDropletCount().d_dropCount);
            this.d_cellDensity.setValue(new PartCloud.PerCellCount().partPerCell);
            this.d_cellCenteredCB.setSelected(new PartCloud.PerCellCount().cellCentered);
        }

        public void unselect() {
            this.d_group.clearSelection();
        }

        public void updateEnabled(Property<Boolean> massless, Property<Boolean> geom3d) {
            boolean showDensity = geom3d.orElse(true);
            if (showDensity != this.d_densityRB.isVisible()) {
                this.d_densityRB.setVisible(showDensity);
                this.d_density.setVisible(showDensity);
                if (!showDensity && this.d_densityRB.isSelected()) {
                    this.d_constantRB.setSelected(true);
                }
                SwingUtilities.invokeLater(() -> SwingUtilities.getWindowAncestor(this).pack());
            }
        }

        public void loadData(Collection<? extends PartCloud> objs) {
            Property type = Composite.getProp(this.typeProp, objs);
            if (!type.isUniform()) {
                this.unselect();
            } else {
                switch ((Type)((Object)type.get())) {
                    case DENSITY: {
                        this.d_densityRB.setSelected(true);
                        Property density = Composite.getProp(this.densityProp, objs);
                        this.d_density.setValue(density.orElse(null));
                        break;
                    }
                    case CONSTANT: {
                        this.d_constantRB.setSelected(true);
                        Property constCount = Composite.getProp(this.constCountProp, objs, Type.CONSTANT.getFilter());
                        this.d_constant.setValue(constCount.orElse(null));
                        break;
                    }
                    case CELL_DENSITY: {
                        this.d_cellDensityRB.setSelected(true);
                        Property perCellCount = Composite.getProp(this.perCellProp, objs, Type.CELL_DENSITY.getFilter());
                        this.d_cellDensity.setValue(perCellCount.orElse(null));
                        Property cellCentered = Composite.getProp(this.cellCenteredProp, objs, Type.CELL_DENSITY.getFilter());
                        if (!cellCentered.isUniform()) {
                            this.d_cellCenteredCB.setState(2);
                            break;
                        }
                        this.d_cellCenteredCB.setSelected((Boolean)cellCentered.get());
                    }
                }
            }
            this.d_loadedObjs = objs;
        }

        public void loadData(Property<PartCloud.IDropletCount> droplet) {
            if (!droplet.isUniform()) {
                this.unselect();
            } else if (droplet.get() instanceof PartCloud.DropDensityCount) {
                this.d_densityRB.setSelected(true);
                this.d_density.setValue(((PartCloud.DropDensityCount)droplet.get()).d_density);
            } else if (droplet.get() instanceof PartCloud.ConstDropletCount) {
                this.d_constantRB.setSelected(true);
                this.d_constant.setValue(((PartCloud.ConstDropletCount)droplet.get()).getNumDrops(null));
            } else if (droplet.get() instanceof PartCloud.PerCellCount) {
                PartCloud.PerCellCount pc = (PartCloud.PerCellCount)droplet.get();
                this.d_cellDensityRB.setSelected(true);
                this.d_cellDensity.setValue(pc.partPerCell);
                this.d_cellCenteredCB.setSelected(pc.cellCentered);
            }
        }

        public void saveData(Collection<? extends PartCloud> objs) {
            objs = theUtil.filter(objs, this.getSaveFilter());
            if (this.d_densityRB.isSelected()) {
                Composite.setProperty(this.typeProp, Type.DENSITY, objs);
                Composite.setProp(this.densityProp, Property.ofNullable((UnitDouble)this.d_density.getValue()), objs);
            } else if (this.d_constantRB.isSelected()) {
                Composite.setProperty(this.typeProp, Type.CONSTANT, objs);
                Composite.setProp(this.constCountProp, Property.ofNullable((Integer)this.d_constant.getValue()), objs);
            } else if (this.d_cellDensityRB.isSelected()) {
                Composite.setProperty(this.typeProp, Type.CELL_DENSITY, objs);
                Composite.setProp(this.perCellProp, Property.ofNullable((Integer)this.d_cellDensity.getValue()), objs);
                Property cellCentered = this.d_cellCenteredCB.getState() == 2 ? Property.nonUniform() : Property.of(this.d_cellCenteredCB.isSelected());
                Composite.setProp(this.cellCenteredProp, cellCentered, objs);
            }
        }

        public Predicate<PartCloud> getSaveFilter() {
            if (this.d_densityRB.isSelected()) {
                return obj -> !(obj.getGeom().getLocalGeom() instanceof Point);
            }
            return Predicates.alwaysTrue();
        }

        public Property<PartCloud.IDropletCount> saveData() {
            if (this.d_densityRB.isSelected()) {
                return Property.of(new PartCloud.DropDensityCount((UnitDouble)this.d_density.getValue()));
            }
            if (this.d_constantRB.isSelected()) {
                return Property.of(new PartCloud.ConstDropletCount((Integer)this.d_constant.getValue()));
            }
            if (this.d_cellDensityRB.isSelected()) {
                return Property.of(new PartCloud.PerCellCount((Integer)this.d_cellDensity.getValue(), this.d_cellCenteredCB.isSelected()));
            }
            return Property.nonUniform();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!this.d_loadedObjs.stream().allMatch(this.getSaveFilter()) && showWarn) {
                String msg = Intl.intl("Some objects in the selection have point-geometry specified. Only\nthose with non-point geometry will have their particle count updated.");
                int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), msg, Intl.intl("Point Geometry"), 2);
                if (option != 0) {
                    return false;
                }
            }
            return true;
        }

        private static enum Type {
            DENSITY,
            CONSTANT,
            CELL_DENSITY;


            public static Type get(PartCloud.IDropletCount count) {
                if (count instanceof PartCloud.DropDensityCount) {
                    return DENSITY;
                }
                if (count instanceof PartCloud.ConstDropletCount) {
                    return CONSTANT;
                }
                if (count instanceof PartCloud.PerCellCount) {
                    return CELL_DENSITY;
                }
                return null;
            }

            public boolean isType(PartCloud.IDropletCount count) {
                return Type.get(count) == this;
            }

            public Predicate<PartCloud> getFilter() {
                return obj -> this.isType(obj.getInitDrops());
            }
        }
    }

    public static class InsertionPanel
    extends guiPanel {
        private static final long serialVersionUID = 8172418242064934739L;
        private static final String ONCE_CARD = "ONCE";
        private static final String PERIODIC_CARD = "PERIODIC";
        private static final String NULL_CARD = "NULL";
        private final guiRadioButton d_insertOnceBtn;
        private final guiRadioButton d_insertPerBtn;
        private final ValueField<UnitDouble> d_massPerVol;
        private final ValueField<UnitDouble> d_dt;
        private final ValueField<UnitDouble> d_massPerTime;
        private final ButtonGroup d_typeGroup;
        private final ComponentGroup d_dtGroup;
        private final ComponentGroup d_massPerVolGroup;
        private final ComponentGroup d_massPerTimeGroup;
        private final ControlSelPnl d_controlPnl;
        private final Pair<guiPanel, CardLayout> d_cards;
        private final ControlSelPnl.INameSource d_nameSrc;
        private final AProp<Type> typeProp = new AProp<Type>(){

            @Override
            public Object get(PartCloud obj) {
                return Type.get(obj.getInsertion());
            }

            @Override
            public void set(PartCloud obj, Type prop) {
                PartCloud.IInsertion insertion;
                if (prop == this.get(obj)) {
                    return;
                }
                switch (prop) {
                    case ONCE: {
                        insertion = new PartCloud.InsertOnce();
                        break;
                    }
                    case PERIODIC: {
                        insertion = new PartCloud.InsertPeriodically();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                obj.setInsertion(insertion);
            }
        };
        private final AProp<UnitDouble> massPerVolProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud obj) {
                return ((PartCloud.InsertOnce)obj.getInsertion()).massPerVolume;
            }

            @Override
            public void set(PartCloud obj, UnitDouble prop) {
                obj.setInsertion(new PartCloud.InsertOnce(prop));
            }
        };
        private final AProp<UnitDouble> massPerTimeProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud obj) {
                return ((PartCloud.InsertPeriodically)obj.getInsertion()).massPerTime;
            }

            @Override
            public void set(PartCloud obj, UnitDouble prop) {
                obj.setInsertion(new PartCloud.InsertPeriodically(((PartCloud.InsertPeriodically)obj.getInsertion()).dt, prop));
            }
        };
        private final AProp<UnitDouble> dtProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud obj) {
                return ((PartCloud.InsertPeriodically)obj.getInsertion()).dt;
            }

            @Override
            public void set(PartCloud obj, UnitDouble prop) {
                obj.setInsertion(new PartCloud.InsertPeriodically(prop, ((PartCloud.InsertPeriodically)obj.getInsertion()).massPerTime));
            }
        };
        private final Composite.IObjectProp<PartCloud, ControlBridge> ctrlProp = ControlSelPnl.getControlProp(PartCloud.class);

        public InsertionPanel(PyroMod mod, ControlSelPnl.INameSource nameSrc, boolean emptyAllowed) {
            super(new GridBagLayout());
            this.d_nameSrc = nameSrc;
            this.d_insertOnceBtn = new guiRadioButton(Intl.intl("Insert Once"));
            this.d_insertPerBtn = new guiRadioButton(Intl.intl("Insert Periodically"));
            this.d_typeGroup = new guiButtonGroup(this.d_insertOnceBtn, this.d_insertPerBtn);
            this.d_massPerVol = ValueFields.udFld(new PartCloud.InsertOnce().massPerVolume, UnitSystem.getSource(4));
            this.d_massPerVol.setNullAllowed(emptyAllowed);
            this.d_massPerTime = ValueFields.udFld(new PartCloud.InsertPeriodically().massPerTime, UnitSystem.getSource(76));
            this.d_massPerTime.setNullAllowed(emptyAllowed);
            this.d_dt = ValueFields.udFld(new PartCloud.InsertPeriodically().dt, UnitSystem.getSource(2));
            this.d_dt.setNullAllowed(emptyAllowed);
            this.d_controlPnl = new ControlSelPnl(mod.getControls());
            this.d_controlPnl.setNameSrc(this.d_nameSrc, (Collection<? extends INamed>)Collections.EMPTY_LIST);
            guiLabel dtLbl = new guiLabel(Intl.intl("Insertion Interval") + ":");
            guiLabel massPerVolLbl = new guiLabel(Intl.intl("Mass Per Volume") + ":");
            guiLabel massPerTimeLbl = new guiLabel(Intl.intl("Mass Per Time") + ":");
            this.d_massPerVolGroup = new ComponentGroup(new Component[]{massPerVolLbl, this.d_massPerVol});
            this.d_massPerTimeGroup = new ComponentGroup(new Component[]{massPerTimeLbl, this.d_massPerTime});
            this.d_dtGroup = new ComponentGroup(new Component[]{dtLbl, this.d_dt});
            guiPanel oncePnl = new guiPanel();
            GridBagHelper gb = new GridBagHelper(oncePnl);
            gb.addRow(massPerVolLbl, this.d_massPerVol);
            gb.finalizeRows();
            guiPanel periodicPnl = new guiPanel();
            gb = new GridBagHelper(periodicPnl);
            this.d_controlPnl.add(gb);
            gb.addRow(dtLbl, this.d_dt);
            gb.addRow(massPerTimeLbl, this.d_massPerTime);
            gb.finalizeRows();
            CardLayout cardLayout = new CardLayout();
            guiPanel cardPnl = new guiPanel(cardLayout);
            this.d_cards = new Pair<guiPanel, CardLayout>(cardPnl, cardLayout);
            cardPnl.add((Component)oncePnl, ONCE_CARD);
            cardPnl.add((Component)periodicPnl, PERIODIC_CARD);
            cardPnl.add((Component)new guiPanel(), NULL_CARD);
            Function<String, ItemListener> listenerFactory = cardName -> evt -> {
                if (evt.getStateChange() == 1) {
                    cardLayout.show(cardPnl, (String)cardName);
                    SwingUtilities.invokeLater(() -> SwingUtilities.getWindowAncestor(this).pack());
                }
            };
            this.d_insertOnceBtn.addItemListener(listenerFactory.apply(ONCE_CARD));
            this.d_insertPerBtn.addItemListener(listenerFactory.apply(PERIODIC_CARD));
            gb = new GridBagHelper(this);
            gb.addRow(this.d_insertOnceBtn, this.d_insertPerBtn);
            gb.addFilledRow(cardPnl);
            gb.finalizeRows();
            this.d_insertPerBtn.setSelected(true);
        }

        public void unselect() {
            this.d_typeGroup.clearSelection();
            ((CardLayout)this.d_cards.v2).show((Container)this.d_cards.v1, NULL_CARD);
            SwingUtilities.invokeLater(() -> SwingUtilities.getWindowAncestor(this).pack());
        }

        public void updateEnabled(Property<Boolean> massless, Property<Boolean> geom3d) {
            this.d_massPerTimeGroup.setEnabled(massless.orElse(false) == false);
            this.d_massPerVolGroup.setEnabled(massless.orElse(false) == false && geom3d.orElse(true) != false);
        }

        public void loadData(PartCloud.IInsertion insertion, ControlBridge control) {
            if (insertion instanceof PartCloud.InsertOnce) {
                PartCloud.InsertOnce ionce = (PartCloud.InsertOnce)insertion;
                this.d_insertOnceBtn.setSelected(true);
                this.d_massPerVol.setValue(ionce.massPerVolume);
            } else if (insertion instanceof PartCloud.InsertPeriodically) {
                PartCloud.InsertPeriodically iper = (PartCloud.InsertPeriodically)insertion;
                this.d_insertPerBtn.setSelected(true);
                this.d_dt.setValue(iper.dt);
                this.d_massPerTime.setValue(iper.massPerTime);
                this.d_controlPnl.load(Property.of(control));
            }
        }

        public Pair<PartCloud.IInsertion, ControlBridge> saveData() {
            if (this.d_insertOnceBtn.isSelected()) {
                return new Pair<PartCloud.InsertOnce, Object>(new PartCloud.InsertOnce((UnitDouble)this.d_massPerVol.getValue()), null);
            }
            if (this.d_insertPerBtn.isSelected()) {
                return new Pair<PartCloud.IInsertion, ControlBridge>(new PartCloud.InsertPeriodically((UnitDouble)this.d_dt.getValue(), (UnitDouble)this.d_massPerTime.getValue()), this.d_controlPnl.save().orElse(null));
            }
            assert (false);
            return null;
        }

        public void loadData(Collection<? extends PartCloud> objs) {
            this.d_controlPnl.setNameSrc(this.d_nameSrc, objs);
            Property type = Composite.getProp(this.typeProp, objs);
            if (!type.isUniform()) {
                this.unselect();
            } else {
                switch ((Type)((Object)type.get())) {
                    case ONCE: {
                        this.d_insertOnceBtn.setSelected(true);
                        Property massPerVol = Composite.getProp(this.massPerVolProp, objs);
                        this.d_massPerVol.setValue(massPerVol.orElse(null));
                        break;
                    }
                    case PERIODIC: {
                        this.d_insertPerBtn.setSelected(true);
                        Property massPerTime = Composite.getProp(this.massPerTimeProp, objs);
                        this.d_massPerTime.setValue(massPerTime.orElse(null));
                        Property dt = Composite.getProp(this.dtProp, objs);
                        this.d_dt.setValue(dt.orElse(null));
                        this.d_controlPnl.load(Composite.getProp(this.ctrlProp, objs));
                    }
                }
            }
        }

        public void saveData(Collection<? extends PartCloud> objs) {
            if (this.d_insertOnceBtn.isSelected()) {
                Composite.setProp(this.typeProp, Property.of(Type.ONCE), objs);
                Composite.setProp(this.massPerVolProp, Property.ofNullable((UnitDouble)this.d_massPerVol.getValue()), objs);
                Composite.setProp(this.ctrlProp, Property.of(null), objs);
            } else if (this.d_insertPerBtn.isSelected()) {
                Composite.setProp(this.typeProp, Property.of(Type.PERIODIC), objs);
                Composite.setProp(this.massPerTimeProp, Property.ofNullable((UnitDouble)this.d_massPerTime.getValue()), objs);
                Composite.setProp(this.dtProp, Property.ofNullable((UnitDouble)this.d_dt.getValue()), objs);
                Composite.setProp(this.ctrlProp, this.d_controlPnl.save(), objs);
            }
        }

        private static enum Type {
            ONCE,
            PERIODIC;


            public static Type get(PartCloud.IInsertion insertion) {
                if (insertion instanceof PartCloud.InsertPeriodically) {
                    return PERIODIC;
                }
                return ONCE;
            }
        }
    }
}

