/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Property;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.geom.Geometry;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.NodeLossDialog;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class NodeEditor
implements ModelObjectDialog.IEditor<HvacNode> {
    private final ModelObjectDialog d_parent;
    private final IGeomEditor d_geomEditor;
    private final PyroMod d_domain;
    private final guiTextField d_fyi;
    private final guiTextField d_networkId;
    private final PyroComboBox<HvacFilter> d_filterCB;
    private final PyroComboBox<Vent> d_ventCB;
    private final guiLabel d_invalid;
    private final guiLabel d_minDucts2;
    private final guiLabel d_maxDucts10;
    private final guiLabel d_ductCount1;
    private final guiLabel d_minDucts1;
    private final guiLabel d_filterErr;
    private final MultiLineLabel d_connectedDuctLbl;
    private final guiRadioButton d_autoBtn;
    private final guiRadioButton d_ventBtn;
    private final guiRadioButton d_ambientBtn;
    private final guiRadioButton d_internalBtn;
    private final JButton d_lossBtn;
    private final ValueField<UnitDouble> d_lossIn;
    private final ValueField<UnitDouble> d_lossOut;
    private final ComponentGroup d_termLossGroup;
    private List<HvacNode> d_nodes;
    private List<HvacDuctLoss> d_losses;
    private NodeLossDialog d_nodeLossDlg;
    private static final HvacFilter FILTER_NONE = new HvacFilter(Intl.intl("<none>"));
    private final guiPanel d_dlgPanel = new guiPanel();
    private static final StandardProp<String> fyiProp = new StandardProp<String>(HvacComponent::getDesc, HvacComponent::setDesc);
    private static final GenericProp<String> networkIdProp = new GenericProp("NETWORK_ID");
    private static final StandardProp<HvacNode.NodeType> nodeTypeProp = new StandardProp<HvacNode.NodeType>(HvacNode::getNodeType, HvacNode::setNodeType);
    private static final StandardProp<Vent> ventProp = new StandardProp<Vent>(HvacNode::getVent, HvacNode::setVent);
    private static final GenericProp<HvacFilter> filterProp = new GenericProp("FILTER_ID");

    public NodeEditor(ModelObjectDialog parent, PyroMod mod, IGeomEditor geomEditor) {
        this.d_parent = parent;
        this.d_domain = mod;
        this.d_geomEditor = geomEditor;
        this.d_nodes = Collections.EMPTY_LIST;
        guiLabel fyi = new guiLabel(Intl.intl("FYI: "));
        this.d_fyi = new guiTextField();
        this.d_networkId = new guiTextField();
        this.d_networkId.setToolTipText(Intl.intl("HVAC node Network ID"));
        this.d_connectedDuctLbl = new MultiLineLabel("");
        this.d_connectedDuctLbl.setFont(this.d_connectedDuctLbl.getFont().deriveFont(2));
        this.d_autoBtn = new guiRadioButton(Intl.intl("Auto"));
        this.d_autoBtn.setToolTipText("<html>" + Intl.intl("This option selects <b>Ambient Endpoint</b> if exactly one duct is<br>connected or <b>Internal</b> if more are connected.") + "</html>");
        this.d_ambientBtn = new guiRadioButton(Intl.intl("Ambient Endpoint"));
        this.d_ambientBtn.setToolTipText("<html>" + Intl.intl("This option connects the node to the outside of the domain.<br>Only one duct may be connected to this node.") + "</html>");
        this.d_ventBtn = new guiRadioButton(Intl.intl("Vent Endpoint"));
        this.d_ventBtn.setToolTipText("<html>" + Intl.intl("This option connects the node to a vent on the interior of the domain.<br>Only one duct may be connected to this node.") + "</html>");
        this.d_internalBtn = new guiRadioButton(Intl.intl("Internal"));
        this.d_internalBtn.setToolTipText("<html>" + Intl.intl("This option makes the node a junction. At least two ducts must be<br>connected to the node.") + "</html>");
        new guiButtonGroup(this.d_autoBtn, this.d_ambientBtn, this.d_ventBtn, this.d_internalBtn);
        final Surface hvacSurf = mod.getSurfaceMgr().get(PredefSurf.HVAC);
        assert (hvacSurf != null);
        this.d_ventCB = new PyroComboBox<Vent>((IPyroObject)mod.getObstructions(), Vent.class){
            private static final long serialVersionUID = -3252193814719931186L;

            @Override
            public void update(Events events) {
                super.update(events);
                NodeEditor.this.d_ventBtn.setEnabled(this.getItemCount() > 0);
            }
        };
        this.d_ventCB.setFilter(new Predicate<Vent>(){

            @Override
            public boolean test(Vent o) {
                return o.getSurface() == hvacSurf;
            }
        });
        this.d_filterCB = new PyroComboBox<HvacFilter>((IPyroObject)mod.getHvacList(), HvacFilter.class){
            private static final long serialVersionUID = 967290516795513307L;

            @Override
            protected Collection<?> getObjList() {
                Collection<?> objs = super.getObjList();
                ArrayList<HvacFilter> newObjs = new ArrayList<HvacFilter>(objs.size() + 1);
                newObjs.add(FILTER_NONE);
                newObjs.addAll(objs);
                return newObjs;
            }
        };
        this.d_lossBtn = new JButton(Intl.intl("Edit Duct Losses"));
        this.d_lossBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NodeEditor.this.d_nodes.size() != 1) {
                    guiDialog.showInvalidEntryMessage(NodeEditor.this.d_dlgPanel, Intl.intl("Select only one node to edit losses."));
                    return;
                }
                if (NodeEditor.this.d_nodeLossDlg.doModal() == 1) {
                    NodeEditor.this.d_losses = NodeEditor.this.d_nodeLossDlg.getLosses(NodeEditor.this.d_domain.getObstructions(), NodeEditor.this.d_nodes.get(0));
                    NodeEditor.this.d_dlgPanel.setModified(true);
                }
            }
        });
        this.d_lossIn = ValueFields.udFld(UnitSystem.getSource(85));
        this.d_lossOut = ValueFields.udFld(UnitSystem.getSource(85));
        Stream.of(this.d_lossIn, this.d_lossOut).forEach(fld -> fld.setNullAllowed(true));
        guiLabel lossInLbl = new guiLabel(Intl.intl("In Loss"));
        lossInLbl.setToolTipText(Intl.intl("The loss for flow entering the HVAC system through a terminal node."));
        guiLabel lossOutLbl = new guiLabel(Intl.intl("Out Loss"));
        lossOutLbl.setToolTipText(Intl.intl("The loss for flow exiting the HVAC system through a terminal node."));
        this.d_termLossGroup = new ComponentGroup2(new Component[]{this.d_lossIn, lossInLbl, this.d_lossOut, lossOutLbl});
        ItemListener typeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NodeEditor.this.updateTypeState();
                }
            }
        };
        this.d_internalBtn.addItemListener(typeListener);
        this.d_ambientBtn.addItemListener(typeListener);
        this.d_autoBtn.addItemListener(typeListener);
        this.d_ventBtn.addItemListener(typeListener);
        this.d_nodeLossDlg = null;
        this.d_invalid = NodeEditor.newErrorLbl(Intl.intl("Warning: Node is invalid."));
        this.d_minDucts2 = NodeEditor.newErrorLbl(Intl.intl("A minimum of two ducts must be connected to an interior node."));
        this.d_maxDucts10 = NodeEditor.newErrorLbl(Intl.intl("A maximum of ten ducts may be connected to an interior node."));
        this.d_ductCount1 = NodeEditor.newErrorLbl(Intl.intl("An endpoint node must be connected to exactly one duct."));
        this.d_filterErr = NodeEditor.newErrorLbl(Intl.intl("A maximum of two ducts may be connected to a node with a filter."));
        this.d_minDucts1 = NodeEditor.newErrorLbl(Intl.intl("A minimum of one duct must be connected to an auto node."));
        Observer ob = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                NodeEditor.this.checkValidNode();
            }
        };
        this.d_dlgPanel.addObserver(ob);
        guiPanel typePnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(typePnl);
        gb.addRow(this.d_autoBtn);
        gb.addRow(this.d_internalBtn);
        gb.addRow(this.d_ambientBtn);
        gb.addRow(this.d_ventBtn, this.d_ventCB, 0);
        gb.finalizeRows();
        guiPanel ductsPnl = new guiPanel();
        gb = new GridBagHelper(ductsPnl);
        gb.addRow(this.d_connectedDuctLbl, new double[]{1.0, 1.0}, new int[]{0, 1});
        gb.addRow(this.d_lossBtn, 0);
        gb.addRow(lossInLbl, this.d_lossIn, 0);
        gb.addRow(lossOutLbl, this.d_lossOut, 0);
        gb.finalizeRows();
        GridBagHelper gbProps = new GridBagHelper(this.d_dlgPanel, false);
        gbProps.addFilledRow(new JSeparator());
        gbProps.addRow(Intl.intl("Network ID:"), this.d_networkId, 1.0, GridBagHelper.REMAINING);
        gbProps.addRow(fyi, this.d_fyi, 1.0, GridBagHelper.REMAINING);
        gbProps.addRow(Intl.intl("Filter:"), this.d_filterCB, 0);
        gbProps.addRow(Intl.intl("Node Type:"), 0);
        gbProps.addIdentRow(typePnl, 1.0, 0);
        gbProps.addRow(Intl.intl("Ducts:"), 0);
        gbProps.addIdentRow(ductsPnl, new double[]{1.0, 1.0}, new int[]{0, 1});
        gbProps.addFilledRow(this.d_invalid);
        gbProps.addFilledRow(this.d_minDucts2);
        gbProps.addFilledRow(this.d_maxDucts10);
        gbProps.addFilledRow(this.d_ductCount1);
        gbProps.addFilledRow(this.d_filterErr);
        gbProps.addFilledRow(this.d_minDucts1);
        gbProps.finalizeRows();
        this.updateTypeState();
        this.d_ventBtn.setEnabled(this.d_ventCB.getItemCount() > 0);
    }

    private static guiLabel newErrorLbl(String msg) {
        guiLabel lbl = new guiLabel(msg);
        lbl.setForeground(Color.RED);
        lbl.setVisible(false);
        return lbl;
    }

    private static void addUngriddedRow(GridBagHelper gb, Object ... args) {
        FlowLayout fl = new FlowLayout(0, gb.colSpace, 0);
        guiPanel pnl = new guiPanel(fl);
        for (Object arg : args) {
            if (arg instanceof String) {
                arg = new guiLabel((String)arg);
            }
            if (!(arg instanceof Component)) continue;
            pnl.add((Component)arg);
        }
        gb.addFilledRow(pnl);
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("HVAC Node Properties");
    }

    @Override
    public Class<HvacNode> getType() {
        return HvacNode.class;
    }

    @Override
    public void add(ModelObjectDialog dlg, GridBagHelper gb) {
        gb.addFilledRow(this.d_dlgPanel);
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isControllable(HvacNode obj) {
        return false;
    }

    private HvacNode.NodeType getSelectedNodeType() {
        if (this.d_autoBtn.isSelected()) {
            return HvacNode.NodeType.AUTO;
        }
        if (this.d_ambientBtn.isSelected()) {
            return HvacNode.NodeType.AMBIENT;
        }
        if (this.d_internalBtn.isSelected()) {
            return HvacNode.NodeType.INTERNAL;
        }
        if (this.d_ventBtn.isSelected()) {
            return HvacNode.NodeType.VENT;
        }
        return null;
    }

    private static boolean isTerminal(HvacNode.NodeType type) {
        switch (type) {
            case AMBIENT: 
            case AUTO: 
            case VENT: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNonTerminal(HvacNode.NodeType type) {
        switch (type) {
            case AUTO: 
            case INTERNAL: {
                return true;
            }
        }
        return false;
    }

    private void updateLossVis() {
        this.d_termLossGroup.setVisible(this.getSelectedNodeType() != null ? NodeEditor.isTerminal(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(node -> NodeEditor.isTerminal(node.getNodeType())));
        this.d_lossBtn.setVisible(this.getSelectedNodeType() != null ? NodeEditor.isNonTerminal(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(node -> NodeEditor.isNonTerminal(node.getNodeType())));
        guiDialog parent = (guiDialog)SwingUtilities.getAncestorOfClass(guiDialog.class, this.d_dlgPanel);
        if (parent != null) {
            parent.pack();
        }
    }

    private static boolean requiresLocation(HvacNode.NodeType type) {
        switch (type) {
            case AMBIENT: 
            case AUTO: 
            case INTERNAL: {
                return true;
            }
        }
        return false;
    }

    private void updateCoords() {
        boolean enabled = this.getSelectedNodeType() != null ? NodeEditor.requiresLocation(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(node -> NodeEditor.requiresLocation(node.getNodeType()));
        this.d_parent.setGeomTabVis(enabled);
    }

    private static boolean requiresVent(HvacNode.NodeType type) {
        return type == HvacNode.NodeType.VENT;
    }

    private void updateVent() {
        boolean enabled = this.getSelectedNodeType() != null ? NodeEditor.requiresVent(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(node -> NodeEditor.requiresVent(node.getNodeType()));
        this.d_ventCB.setEnabled(enabled);
    }

    private void updateTypeState() {
        this.updateCoords();
        this.updateLossVis();
        this.updateVent();
    }

    @Override
    public void load(PyroMod domain, Collection<? extends HvacNode> objs) {
        this.d_nodes = new ArrayList<HvacNode>(objs);
        Property fyi = Composite.getProp(fyiProp, objs);
        this.d_fyi.setText(fyi.orElse(Intl.intl("<multiple>")));
        Property networkId = Composite.getProp(networkIdProp, objs);
        this.d_networkId.setText(networkId.orElse(null));
        Property curFilterProp = Composite.getProp(filterProp, objs);
        if (curFilterProp.isUniform()) {
            HvacFilter filter = curFilterProp.get() == null ? FILTER_NONE : (HvacFilter)curFilterProp.get();
            this.d_filterCB.setSelectedItem(filter);
        } else {
            this.d_filterCB.setSelectedItem(null);
        }
        Property nodeType = Composite.getProp(nodeTypeProp, objs);
        if (nodeType.isUniform()) {
            switch ((HvacNode.NodeType)((Object)nodeType.get())) {
                case AUTO: {
                    this.d_autoBtn.setSelected(true);
                    break;
                }
                case AMBIENT: {
                    this.d_ambientBtn.setSelected(true);
                    break;
                }
                case INTERNAL: {
                    this.d_internalBtn.setSelected(true);
                    break;
                }
                case VENT: {
                    this.d_ventBtn.setSelected(true);
                }
            }
        } else {
            this.d_autoBtn.setSelected(false);
            this.d_ambientBtn.setSelected(false);
            this.d_internalBtn.setSelected(false);
            this.d_ventBtn.setSelected(false);
        }
        Property vent = Composite.getProp(ventProp, theUtil.filter(objs, obj -> NodeEditor.requiresVent(obj.getNodeType())));
        this.d_ventCB.setSelectedItem(vent.orElse(null));
        if (objs.size() == 1) {
            HvacNode node2 = objs.iterator().next();
            this.d_losses = new ArrayList<HvacDuctLoss>(HvacUtil.getDuctLosses(this.d_domain.getBridges(), node2));
            ArrayList<HvacDuct> attachedDucts = new ArrayList<HvacDuct>(HvacUtil.getConnectedDucts(this.d_domain.getObstructions(), node2));
            this.createNodeLossDlg(this.d_domain.getObstructions(), attachedDucts, this.d_losses);
        } else {
            this.d_losses = Collections.EMPTY_LIST;
        }
        IFilteredCollection<HvacNode> terminalNodes = theUtil.filter(objs, node -> NodeEditor.isTerminal(node.getNodeType()));
        ValueField[] lossFlds = new ValueField[]{this.d_lossIn, this.d_lossOut};
        for (int m = 0; m < 2; ++m) {
            Property<UnitDouble> prop = Composite.getProp(new LossProp(m), terminalNodes);
            lossFlds[m].setValue(prop.orElse(null));
        }
        this.updateTypeState();
        this.d_dlgPanel.setModified(false);
    }

    @Override
    public boolean validateData(Component parent, Collection<? extends HvacNode> objs, boolean showWarn, boolean allowModify) {
        Predicate<HvacNode> ventTest = node -> node.getNodeType() == HvacNode.NodeType.VENT;
        IFilteredCollection<HvacNode> nonVentNodes = theUtil.filter(this.d_nodes, ventTest.negate());
        if (this.d_ventBtn.isSelected() && !nonVentNodes.isEmpty() && this.d_ventCB.getSelectedItem() == null) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this.d_dlgPanel, Intl.intl("A vent must be selected."));
            }
            if (allowModify) {
                this.d_ventCB.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public void save(PyroMod domain, Collection<? extends HvacNode> objs) {
        HvacFilter filter;
        if (this.d_fyi.isModified()) {
            String fyi = this.d_fyi.getText();
            Composite.setProperty(fyiProp, fyi, objs);
        }
        if (this.d_networkId.isModified()) {
            Composite.setProperty(networkIdProp, this.d_networkId.getText(), objs);
        }
        if ((filter = (HvacFilter)this.d_filterCB.getSelectedItem()) != null) {
            if (filter == FILTER_NONE) {
                filter = null;
            }
            Composite.setProperty(filterProp, filter, objs);
        }
        HvacNode.NodeType nodeType = null;
        if (this.d_ambientBtn.isSelected()) {
            nodeType = HvacNode.NodeType.AMBIENT;
        } else if (this.d_internalBtn.isSelected()) {
            nodeType = HvacNode.NodeType.INTERNAL;
        } else if (this.d_autoBtn.isSelected()) {
            nodeType = HvacNode.NodeType.AUTO;
        } else if (this.d_ventBtn.isSelected()) {
            nodeType = HvacNode.NodeType.VENT;
        }
        if (nodeType != null) {
            if (nodeType != HvacNode.NodeType.VENT) {
                Composite.setProperty(nodeTypeProp, nodeType, objs);
                if (this.d_geomEditor != null) {
                    this.d_geomEditor.save(objs);
                }
            } else {
                Vent vent = (Vent)this.d_ventCB.getSelectedItem();
                Composite.setProp(ventProp, Property.ofNullable(vent), objs);
            }
        }
        IFilteredCollection<HvacNode> ventNodes = theUtil.filter(objs, obj -> NodeEditor.requiresVent(obj.getNodeType()));
        if (nodeType == null) {
            Vent vent = (Vent)this.d_ventCB.getSelectedItem();
            Composite.setProp(ventProp, Property.ofNullable(vent), ventNodes);
        }
        IFilteredCollection<HvacNode> terminalNodes = theUtil.filter(objs, node -> NodeEditor.isTerminal(node.getNodeType()));
        ValueField[] lossFlds = new ValueField[]{this.d_lossIn, this.d_lossOut};
        for (int m = 0; m < 2; ++m) {
            UnitDouble loss = (UnitDouble)lossFlds[m].getValue();
            Composite.setProp(new LossProp(m), Property.ofNullable(loss), terminalNodes);
        }
        if (this.d_nodes.size() == 1) {
            ArrayList<HvacDuctLoss> oldLosses = new ArrayList<HvacDuctLoss>(HvacUtil.getDuctLosses(this.d_domain.getBridges(), this.d_nodes.get(0)));
            this.d_domain.getBridges().removeAll(oldLosses);
            this.d_domain.getBridges().addAll(this.d_losses);
        }
    }

    private void createNodeLossDlg(ModelComposite ductRoot, List<HvacDuct> attDucts, List<HvacDuctLoss> losses) {
        if (!attDucts.isEmpty()) {
            String[] columnHeader = new String[attDucts.size() + 1];
            columnHeader[0] = Intl.intl("*");
            Class[] columnClasses = new Class[attDucts.size() + 1];
            columnClasses[0] = String.class;
            for (int i = 0; i < attDucts.size(); ++i) {
                if (attDucts.get(i) == null) continue;
                columnHeader[i + 1] = attDucts.get(i).getName();
                columnClasses[i + 1] = UnitDouble.class;
            }
            this.d_nodeLossDlg = new NodeLossDialog(SwingUtilities.getWindowAncestor(this.d_dlgPanel), columnHeader, columnClasses);
            this.d_nodeLossDlg.loadLosses(ductRoot, losses);
        } else {
            String[] header = new String[]{Intl.intl("***")};
            Class[] classes = new Class[]{String.class};
            this.d_nodeLossDlg = new NodeLossDialog(SwingUtilities.getWindowAncestor(this.d_dlgPanel), header, classes);
        }
    }

    private void checkValidNode() {
        guiDialog dlg;
        ArrayList<JComponent> toShow = new ArrayList<JComponent>();
        if (this.d_nodes.size() == 1) {
            toShow.add(this.d_connectedDuctLbl);
            HvacNode node = this.d_nodes.get(0);
            ModelComposite root = this.d_domain.getObstructions();
            Collection<HvacDuct> ducts = ((APyroObject)root).flatten(HvacDuct.class);
            StringBuilder connectedDucts = new StringBuilder(Intl.intl("Connected Ducts: "));
            int numDucts = 0;
            for (HvacDuct d : ducts) {
                if (!d.isNodeAttached(node)) continue;
                if (numDucts > 0) {
                    connectedDucts.append(", ");
                }
                connectedDucts.append(d.getName());
                ++numDucts;
            }
            if (numDucts == 0) {
                connectedDucts.append("<none>");
            }
            this.d_connectedDuctLbl.setText(connectedDucts.toString());
            boolean internal = this.d_internalBtn.isSelected();
            boolean ambient = this.d_ambientBtn.isSelected();
            boolean vent = this.d_ventBtn.isSelected();
            boolean auto = this.d_autoBtn.isSelected();
            guiLabel errorLbl = null;
            if (auto) {
                if (numDucts == 0) {
                    errorLbl = this.d_minDucts1;
                } else {
                    internal = numDucts >= 2;
                    boolean bl = ambient = numDucts == 1;
                }
            }
            if (internal) {
                if (numDucts > 2 && this.d_filterCB.getSelectedItem() != null && this.d_filterCB.getSelectedItem() != FILTER_NONE) {
                    errorLbl = this.d_filterErr;
                } else if (numDucts < 2) {
                    errorLbl = this.d_minDucts2;
                } else if (numDucts > 10) {
                    errorLbl = this.d_maxDucts10;
                }
            } else if ((ambient || vent) && numDucts != 1) {
                errorLbl = this.d_ductCount1;
            }
            if (errorLbl != null) {
                toShow.add(this.d_invalid);
                toShow.add(errorLbl);
            }
        }
        boolean[] modified = new boolean[]{false};
        Stream.of(this.d_invalid, this.d_ductCount1, this.d_minDucts2, this.d_maxDucts10, this.d_filterErr, this.d_minDucts1, this.d_connectedDuctLbl).forEach(lbl -> {
            boolean visible = toShow.contains(lbl);
            if (visible != lbl.isVisible()) {
                lbl.setVisible(visible);
                modified[0] = true;
            }
        });
        if (modified[0] && (dlg = (guiDialog)SwingUtilities.getAncestorOfClass(guiDialog.class, this.d_dlgPanel)) != null) {
            dlg.pack();
        }
    }

    private static class StandardProp<T>
    extends Composite.AObjectProp<HvacNode, T> {
        private final Function<HvacNode, T> d_getter;
        private final BiConsumer<HvacNode, T> d_setter;

        public StandardProp(Function<HvacNode, T> getter, BiConsumer<HvacNode, T> setter) {
            super(HvacNode.class);
            this.d_setter = setter;
            this.d_getter = getter;
        }

        @Override
        public Object get(HvacNode obj) {
            return this.d_getter.apply(obj);
        }

        @Override
        public void set(HvacNode obj, T prop) {
            this.d_setter.accept(obj, (HvacNode)prop);
        }
    }

    private static class GenericProp<T>
    extends Composite.AObjectProp<HvacNode, T> {
        private final String d_propKey;

        public GenericProp(String propKey) {
            super(HvacNode.class);
            this.d_propKey = propKey;
        }

        @Override
        public Object get(HvacNode obj) {
            return obj.getProp(this.d_propKey);
        }

        @Override
        public void set(HvacNode obj, T prop) {
            obj.setProp(this.d_propKey, prop);
        }
    }

    private static class LossProp
    extends Composite.AObjectProp<HvacNode, UnitDouble> {
        private final int d_index;

        public LossProp(int index) {
            super(HvacNode.class);
            this.d_index = index;
        }

        @Override
        public Object get(HvacNode obj) {
            return obj.getTerminalLoss().get(this.d_index);
        }

        @Override
        public void set(HvacNode obj, UnitDouble prop) {
            ArrayList<UnitDouble> loss = new ArrayList<UnitDouble>(obj.getTerminalLoss());
            loss.set(this.d_index, prop);
            obj.setTerminalLoss((UnitDouble)loss.get(0), (UnitDouble)loss.get(1));
        }
    }

    private static class LocProp
    extends Composite.AObjectProp<HvacNode, UnitDouble> {
        private final int d_coord;

        public LocProp(int coord) {
            super(HvacNode.class);
            this.d_coord = coord;
        }

        @Override
        public void set(HvacNode obj, UnitDouble prop) {
            UnitPoint3D loc = (UnitPoint3D)obj.getProp("XYZ");
            if (loc == null) {
                loc = new UnitPoint3D(new UnitDouble[0]);
            }
            UnitDouble[] vals = new UnitDouble[]{loc.xu(), loc.yu(), loc.zu()};
            vals[this.d_coord] = prop;
            obj.setProp("XYZ", new UnitPoint3D(vals));
        }

        @Override
        public Object get(HvacNode obj) {
            if (NodeEditor.requiresVent(obj.getNodeType())) {
                Point3d center = obj.getVent().getBounds().getCenter();
                switch (this.d_coord) {
                    case 0: {
                        return new UnitDouble(center.x, Geometry.LU);
                    }
                    case 1: {
                        return new UnitDouble(center.y, Geometry.LU);
                    }
                }
                return new UnitDouble(center.z, Geometry.LU);
            }
            UnitPoint3D loc = (UnitPoint3D)obj.getProp("XYZ");
            if (loc == null) {
                return null;
            }
            switch (this.d_coord) {
                case 0: {
                    return loc.xu();
                }
                case 1: {
                    return loc.yu();
                }
            }
            return loc.zu();
        }
    }
}

