/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import pyrosim.Intl;
import pyrosim.PyroSim;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.util.Pair;

public class ImageLoader
implements BGImageDlg.IImageLoader {
    private static final String[] FILTERS = new String[]{"bmp", Intl.intl("BMP Files"), "gif", Intl.intl("GIF Files"), "jpg", Intl.intl("JPEG Files"), "jpeg", Intl.intl("JPEG Files"), "jif", Intl.intl("JPEG Files"), "jpe", Intl.intl("JPEG Files"), "png", Intl.intl("PNG Files"), "tif", Intl.intl("TIF Files"), "tga", Intl.intl("TARGA Files"), "targa", Intl.intl("TARGA Files")};

    @Override
    public File choose(Component parent, File currFile) {
        return PyroSim.getFilenames().getOpenFile((Component)PyroSim.getApp().getActiveFrame(), currFile, FILTERS);
    }

    @Override
    public Pair<Image, BGImageXform> load(File file) throws IOException {
        String filename = file.getAbsolutePath();
        try {
            IImage img = ImageManager.getImage(filename);
            if (img == null) {
                throw new IOException(Intl.intl("Could not load image."));
            }
            return new Pair<Image, Object>((Image)img, null);
        }
        catch (OutOfMemoryError e) {
            throw new IOException(Intl.intl("Unable to load image file, the file is too large."));
        }
    }
}

