/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.floorview.NewFloorDlg;
import pyrosim.util.Util;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Task;

public class FloorComboBox
extends guiComboBox<Floor> {
    private static final long serialVersionUID = 1L;

    public FloorComboBox(PyroMod mod) {
        ComboModel model = new ComboModel(mod);
        CellRenderer renderer = new CellRenderer(model);
        this.setModel(model);
        mod.getEvents().addObserver(model);
        this.setRenderer(renderer);
        this.setLightWeightPopupEnabled(false);
        this.setToolTipText(Intl.intl("Change the Floor View"));
    }

    public static class AddAction
    extends AbstractAction {
        public final Floor add;

        public AddAction(Floor floor) {
            this.add = floor;
            this.putValue("Name", floor.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddAction.run(PyroSim.getApp().getMediator(), this.add);
        }

        public static void run(PyroMod mod, Floor floor) {
            AddTask task = new AddTask((IPyroObject)mod.getFloorManager(), (IPyroObject[])new Floor[]{floor});
            SelectTask wrapper = new SelectTask(mod, floor);
            wrapper.addTask(task);
            mod.getTaskManager().exec(wrapper, Intl.intl("New Floor"));
        }
    }

    public static class ActivateAction
    extends AbstractAction {
        public final Floor active;

        public ActivateAction(Floor floor) {
            this.active = floor;
            this.putValue("Name", floor.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActivateAction.run(PyroSim.getApp().getMediator(), this.active);
        }

        public static void run(PyroMod mod, Floor floor) {
            Task task = mod.getFloorManager().taskSetActive(floor);
            mod.getTaskManager().exec(task, Intl.intl("Change Active Floor"));
        }
    }

    private static class ComboModel
    extends AbstractListModel<Object>
    implements ComboBoxModel<Object>,
    IEventObserver {
        private static final long serialVersionUID = 1L;
        private final PyroMod d_mod;
        private ArrayList<Object> d_items;
        public static final Object ADD_NEW_ITEM = Intl.intl("<Add New...>");
        public static final Object SHOW_ALL_ITEM = Intl.intl("<Show All>");
        public static final Object SEPARATOR = new JSeparator(0);

        public ComboModel(PyroMod mod) {
            this.d_mod = mod;
            this.refreshFloors();
        }

        private void refreshFloors() {
            Collection floors = this.d_mod.getFloorManager().flatten().stream().sorted(new Floor.CompareLevel()).collect(Collectors.toList());
            ArrayList<Object> objects = new ArrayList<Object>(floors.size() + 2);
            objects.add(ADD_NEW_ITEM);
            objects.add(SHOW_ALL_ITEM);
            if (!floors.isEmpty()) {
                objects.add(SEPARATOR);
                objects.addAll(floors);
            }
            this.d_items = objects;
            this.fireContentsChanged(this, 0, this.d_items.size());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == ADD_NEW_ITEM) {
                FloorManager manager = this.d_mod.getFloorManager();
                List floors = manager.flatten().stream().sorted(new Floor.CompareLevel()).collect(Collectors.toList());
                EventQueue.invokeLater(() -> NewFloorDlg.open(PyroSim.getApp().getMainFrame(), floors, f -> AddAction.run(this.d_mod, f)));
                return;
            }
            if (anItem == SHOW_ALL_ITEM) {
                ActivateAction.run(this.d_mod, null);
                return;
            }
            if (anItem instanceof Floor) {
                ActivateAction.run(this.d_mod, (Floor)anItem);
            }
        }

        @Override
        public Object getSelectedItem() {
            Floor active = this.d_mod.getFloorManager().getActive();
            return active == null ? SHOW_ALL_ITEM : active;
        }

        @Override
        public int getSize() {
            return this.d_items.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.d_items.get(index);
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_UNITSYSTEM_CHANGED)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED) || events.getEvents(FloorManager.class, new Class[0]).isModified() || events.getEvents(Floor.class, new Class[0]).isModified()) {
                this.refreshFloors();
            }
        }
    }

    private static class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final ComboModel d_model;

        public CellRenderer(ComboModel model) {
            this.d_model = model;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof JSeparator) {
                return (JSeparator)value;
            }
            if (value == ComboModel.SHOW_ALL_ITEM) {
                this.setText((String)value);
                Object selected = this.d_model.getSelectedItem();
                this.setFont(this.getFont().deriveFont(selected == value ? 1 : 0));
                return this;
            }
            if (value instanceof Floor) {
                Floor floor = (Floor)value;
                String text = Util.getName(floor);
                Object selected = this.d_model.getSelectedItem();
                this.setFont(this.getFont().deriveFont(selected == value ? 1 : 0));
                this.setIcon(PyroGuiUtil.loadPyroSimIcon("floor16.png"));
                this.setText(text);
            }
            return this;
        }
    }
}

