/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.fds;

import java.awt.Window;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.domain.ResultsArchive;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.TypedProp;

public class ArchiveResultsDlg
extends guiDialog {
    private static final long serialVersionUID = -3281200301754176316L;
    public static final TypedProp<Boolean> PREF_RETAIN = new TypedProp<Boolean>((Object)"ArchiveResultsDlg.retainResults", true);
    public static final TypedProp<Integer> PREF_METHOD = new TypedProp<Integer>((Object)"ArchiveResultsDlg.method", 0);
    public static final TypedProp<Integer> PREF_COMPRESSION = new TypedProp<Integer>((Object)"ArchiveResultsDlg.compression", 10);
    private final guiTextField d_nameFld = new guiTextField();
    private final guiCheckBox d_retainOldCB;
    private final guiCheckBox d_compressCB;

    public ArchiveResultsDlg(Window parent) {
        super(parent, Intl.intl("Archive FDS Results"), 9);
        this.d_nameFld.setColumns(30);
        this.d_retainOldCB = new guiCheckBox(Intl.intl("Retain current results"), true);
        this.d_compressCB = new guiCheckBox(Intl.intl("Compress to a ZIP file"), true);
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Archive name:"), this.d_nameFld, 1.0, 0);
        gb.addRow(this.d_retainOldCB, 0);
        gb.addRow(this.d_compressCB, 0);
        gb.finalizeRows();
    }

    @Override
    public int doModal() {
        this.loadPrefs();
        int result = super.doModal();
        if (result == 1) {
            this.savePrefs();
        }
        return result;
    }

    private void loadPrefs() {
        this.d_retainOldCB.setSelected(PyroPrefs.getBoolean(PREF_RETAIN));
        int selMethod = PyroPrefs.getInt(PREF_METHOD);
        this.d_compressCB.setSelected(selMethod != 0);
    }

    private void savePrefs() {
        PyroPrefs.set(PREF_RETAIN, this.d_retainOldCB.isSelected(), false);
        PyroPrefs.set(PREF_METHOD, this.d_compressCB.isSelected() ? 2 : 0, true);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_nameFld.getText().trim().isEmpty()) {
            return this.invalidateFld(showWarn, allowModify, this.d_nameFld, Intl.intl("You must specify an archive name."));
        }
        return true;
    }

    @Override
    public void setName(String name) {
        this.d_nameFld.setText(name);
    }

    @Override
    public String getName() {
        return this.d_nameFld.getText();
    }

    public ResultsArchive.IMethod getMethod() {
        return this.d_compressCB.isSelected() ? ResultsArchive.COMPRESSED : ResultsArchive.DIRECTORY;
    }

    public Object getOptions() {
        int compression = PyroPrefs.getInt(PREF_COMPRESSION) - 1;
        if (compression < 0 || compression > 9) {
            compression = 9;
        }
        return this.d_compressCB.isSelected() ? new ResultsArchive.CompressedOptions(compression) : null;
    }

    public boolean getRetainCurrentResults() {
        return this.d_retainOldCB.isSelected();
    }
}

