/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiConstUnitDoubleField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;

public class SprinklerLinkModelPanel
extends guiPanel
implements IEditor<SprinklerLinkModel> {
    private static final long serialVersionUID = -3162190571986760271L;
    private final SprinklerLinkModelMgr d_sprinklerLMMgr;
    private final guiDialog d_parent;
    private final UnitSystem d_currentUS;
    private final guiCheckBox d_initTempCB;
    private final ValueField<UnitDouble> d_initTemp;
    private final ValueField<UnitDouble> d_activTemp;
    private final guiConstUnitDoubleField d_respTimeInd;
    private final guiConstUnitDoubleField d_cFactor;
    private final CustomFDSPanel d_customPnl;
    private final guiTextField d_name;
    private final guiTextField d_fyi;

    public SprinklerLinkModelPanel(guiDialog parent) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        this.d_sprinklerLMMgr = pyMod.getSprinklerLinkModels();
        this.d_currentUS = pySim.getUnitSystem();
        this.d_parent = parent;
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_fyi = new guiTextField();
        this.d_customPnl = new CustomFDSPanel(6);
        this.d_initTempCB = new guiCheckBox(Intl.intl("Initial Temperature") + ":");
        this.d_initTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_activTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_respTimeInd = new guiConstUnitDoubleField(UnitSystem.getSource(3).getUnit());
        this.d_cFactor = new guiConstUnitDoubleField(UnitSystem.getSource(60).getUnit());
        guiLabel activTempLab = new guiLabel(Intl.intl("Activation Temperature") + ":");
        guiLabel respTimeIndLab = new guiLabel(Intl.intl("Response Time Index") + ":");
        guiLabel cFactorLab = new guiLabel(Intl.intl("C Factor") + ":");
        guiLabel respTimeIndULab = new guiLabel(this.d_respTimeInd.getUnit().toString());
        guiLabel cFactorULab = new guiLabel(this.d_cFactor.getUnit().toString());
        guiPanel propPnl = new guiPanel(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(propPnl, new guiLabel(Intl.intl("Sprinkler Link Model ID") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_name, 1, row++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(propPnl, new guiLabel(Intl.intl("Description") + ":"), 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_fyi, 1, row++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_initTempCB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_initTemp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, activTempLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_activTemp, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, respTimeIndLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_respTimeInd, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, respTimeIndULab, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, cFactorLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, this.d_cFactor, 1, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(propPnl, cFactorULab, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(propPnl);
        LinkStatus.link((AbstractButton)this.d_initTempCB, this.d_initTemp);
        propPnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JTabbedPane tpane = new JTabbedPane();
        tpane.addTab(Intl.intl("Properties"), propPnl);
        tpane.addTab(Intl.intl("Advanced"), this.d_customPnl);
        this.add((Component)tpane, "Center");
        this.init(new SprinklerLinkModel(""));
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public SprinklerLinkModel commit(final SprinklerLinkModel slm) {
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                SprinklerLinkModelPanel.this.save(slm);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Sprinkler Link Model"));
        this.setModified(false);
        return slm;
    }

    @Override
    public SprinklerLinkModel preview(SprinklerLinkModel previewObj) {
        this.save(previewObj);
        return previewObj;
    }

    private void save(SprinklerLinkModel slm) {
        slm.setFYI(this.d_fyi.getText());
        UnitDouble initTemp = null;
        if (this.d_initTempCB.isSelected()) {
            initTemp = (UnitDouble)this.d_initTemp.getValue();
        }
        slm.setCFactor((UnitDouble)this.d_cFactor.getValue());
        slm.setActivationTemp((UnitDouble)this.d_activTemp.getValue());
        slm.setRti((UnitDouble)this.d_respTimeInd.getValue());
        slm.setInitialTemp(initTemp);
        this.d_customPnl.save(slm);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(SprinklerLinkModel slm) {
        this.setEnabled(slm != null);
        if (slm != null) {
            this.d_name.setText(slm.getName());
            this.d_fyi.setText(slm.getFYI());
            if (slm.getInitialTemp() != null) {
                this.d_initTempCB.setSelected(true);
                this.d_initTemp.setValue(slm.getInitialTemp());
            } else {
                this.d_initTempCB.setSelected(false);
                this.d_initTemp.setValue(new UnitDouble(20.0, SI.CELSIUS));
            }
            this.d_activTemp.setValue(slm.getActivationTemp());
            this.d_respTimeInd.setValue(slm.getRti());
            this.d_cFactor.setValue(slm.getCFactor());
            this.d_customPnl.load(slm);
        }
        this.setModified(false);
    }
}

