/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.domain.devices.simctrl.KillDevice;
import pyrosim.domain.devices.simctrl.RestartFileDevc;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Sets;

public class SimControlEditor
extends ADevcEditor<ASimCtrlDevice> {
    private final guiComboBox<Type> d_typeCB = new guiComboBox<Type>(Type.values());

    public SimControlEditor() {
        this.d_typeCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 5362227047987164669L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String name = ((Type)((Object)value)).name;
                this.setText(name);
                return this;
            }
        });
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("CTRL");
    }

    @Override
    public String getDesc() {
        return Intl.intl("Simulation Control");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SIMCTRL");
    }

    @Override
    public guiPanel getDataPanel() {
        guiPanel pnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(pnl);
        gb.addRow(Intl.intl("Action to perform:"), this.d_typeCB, 0);
        gb.finalizeRows();
        return pnl;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return null;
    }

    @Override
    public boolean validateData(Component parent, ASimCtrlDevice loadedObj, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public ASimCtrlDevice create() {
        if (this.d_typeCB.getSelectedItem() == Type.KILL) {
            return new KillDevice("");
        }
        return new RestartFileDevc("");
    }

    @Override
    public void load(ASimCtrlDevice devc) {
        Type type = devc instanceof KillDevice ? Type.KILL : Type.RESTART;
        this.d_typeCB.setSelectedItem((Object)type);
        this.d_typeCB.setEnabled(false);
    }

    @Override
    public void save(ASimCtrlDevice devc) {
    }

    private static enum Type {
        KILL(Intl.intl("Kill Simulation")),
        RESTART(Intl.intl("Create Restart File"));

        public final String name;

        private Type(String name) {
            this.name = name;
        }
    }
}

