/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;

public class DryPipeEditor
extends ADevcEditor<DryPipe> {
    private final ValueField<UnitDouble> d_delayFld = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.SECOND, UnitSystem.getSource(2));

    public DryPipeEditor() {
        DryPipe defaultPipe = new DryPipe("");
        this.d_delayFld.setValue(defaultPipe.getDelay());
    }

    @Override
    public String getDesc() {
        return Intl.intl("Dry Pipe");
    }

    @Override
    public String getDefName() {
        return Intl.intl("DRYPIPE");
    }

    @Override
    public boolean getCustomEnabled() {
        return false;
    }

    @Override
    public boolean getPreviewEnabled() {
        return false;
    }

    @Override
    public DryPipe create() {
        return new DryPipe("");
    }

    @Override
    public void load(DryPipe pipe) {
        this.d_delayFld.setValue(pipe.getDelay());
    }

    @Override
    public void save(DryPipe pipe) {
        pipe.setDelay((UnitDouble)this.d_delayFld.getValue());
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return null;
    }

    @Override
    public guiPanel getDataPanel() {
        guiPanel pnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(pnl);
        gb.addRow(Intl.intl("Depressurize delay:"), this.d_delayFld, 0);
        gb.finalizeRows();
        return pnl;
    }

    @Override
    public boolean validateData(Component parent, DryPipe loadedObj, boolean showWarn, boolean allowModify) {
        return true;
    }
}

