/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;

public class AlarmInfoPanel
extends guiPanel {
    private static final long serialVersionUID = -8046233980788354678L;
    public static final int LAYOUT_VERTICAL = 0;
    public static final int LAYOUT_HORIZONTAL = 1;
    private final AlarmInfoPanelModel d_model;
    private final int d_layout;

    public AlarmInfoPanel(IQuantity msr) {
        this(msr, 0);
    }

    public AlarmInfoPanel(IQuantity msr, int layout) {
        this(msr.get().unitType, layout);
    }

    public AlarmInfoPanel(int unitType) {
        this(unitType, 0);
    }

    public AlarmInfoPanel(int unitType, int layout) {
        super(new GridBagLayout());
        this.d_layout = layout;
        this.d_model = new AlarmInfoPanelModel(unitType);
        GridBagHelper gbh = new GridBagHelper(this);
        this.d_model.addComponents(gbh, this.d_layout);
        gbh.finalizeRows();
    }

    public void setCurrentMsr(IQuantity msr) {
        this.reinitSetpoint(msr.get().unitType);
    }

    public void setCurrentUnitType(int unitType) {
        this.reinitSetpoint(unitType);
    }

    private void reinitSetpoint(int unitType) {
        this.d_model.reinitSetpoint(unitType);
        this.invalidate();
        this.validate();
    }

    public void load(IQuantity msr, AlarmInfo ai) {
        this.load(msr.get().unitType, ai);
    }

    public void load(int unitType, AlarmInfo ai) {
        this.d_model.load(unitType, ai);
    }

    public AlarmInfo save() {
        return this.d_model.save();
    }

    public static class AlarmInfoPanelModel {
        private final guiCheckBox d_enableAlarmCB = new guiCheckBox(Intl.intl("Enable Setpoint:"));
        private ValueField<UnitDouble> d_setpointFld;
        private final guiCheckBox d_initStateCB;
        private final guiCheckBox d_latchCB;
        private final guiLabel d_tripDirDesc;
        private final guiComboBox<String> d_tripDirCombo;
        private static final String TRIP_DIR_ASCENDING = Intl.intl("Ascending");
        private static final String TRIP_DIR_DESCENDING = Intl.intl("Descending");

        public AlarmInfoPanelModel(int unitType) {
            this.d_setpointFld = ValueFields.udFld(UnitSystem.getSource(unitType));
            this.d_initStateCB = new guiCheckBox(Intl.intl("Initially activated"));
            this.d_latchCB = new guiCheckBox(Intl.intl("Trigger only once"));
            this.d_tripDirDesc = new guiLabel(Intl.intl("Trip Direction:"));
            this.d_tripDirCombo = new guiComboBox<String>((T[])new String[]{TRIP_DIR_ASCENDING, TRIP_DIR_DESCENDING});
            this.loadTripFlags(1);
            LinkStatus.link((AbstractButton)this.d_enableAlarmCB, this.d_setpointFld, this.d_initStateCB, this.d_latchCB, this.d_tripDirDesc, this.d_tripDirCombo);
        }

        public void addComponents(GridBagHelper panel, int layout) {
            if (layout == 0) {
                panel.addRow(new Object[]{this.d_enableAlarmCB, this.d_setpointFld, GridBagHelper.Fill.HORIZONTAL});
                panel.addIdentRow(this.d_latchCB, 0);
                panel.addIdentRow(this.d_initStateCB, 0);
                panel.addIdentRow(this.d_tripDirDesc, this.d_tripDirCombo);
            } else {
                panel.addRow(this.d_enableAlarmCB, this.d_setpointFld, this.d_latchCB, this.d_initStateCB, this.d_tripDirDesc, this.d_tripDirCombo);
            }
        }

        public void setCurrentMsr(IQuantity msr) {
            this.reinitSetpoint(msr.get().unitType);
        }

        public void setCurrentUnitType(int unitType) {
            this.reinitSetpoint(unitType);
        }

        private void reinitSetpoint(int unitType) {
            IUnitSrc newSrc = UnitSystem.getSource(unitType);
            ValueFields.setUnitSource(this.d_setpointFld, newSrc);
        }

        public void load(int unitType, AlarmInfo ai) {
            this.d_enableAlarmCB.setSelected(ai != null);
            if (ai != null) {
                this.reinitSetpoint(unitType);
                this.d_setpointFld.setValue(ai.setpoint);
                this.d_initStateCB.setSelected(TripFlags.initiallyOn(ai.tripFlags));
                this.d_latchCB.setSelected(TripFlags.latch(ai.tripFlags));
                boolean tripDirDescending = TripFlags.tripDirDescending(ai.tripFlags);
                if (tripDirDescending) {
                    this.d_tripDirCombo.setSelectedItem(TRIP_DIR_DESCENDING);
                } else {
                    this.d_tripDirCombo.setSelectedItem(TRIP_DIR_ASCENDING);
                }
            }
        }

        public AlarmInfo save() {
            if (!this.d_enableAlarmCB.isSelected()) {
                return null;
            }
            int tripFlags = 0;
            if (this.d_initStateCB.isSelected()) {
                tripFlags |= 2;
            }
            if (this.d_latchCB.isSelected()) {
                tripFlags |= 1;
            }
            if (this.d_tripDirCombo.getSelectedItem().equals(TRIP_DIR_DESCENDING)) {
                tripFlags |= 4;
            }
            return new AlarmInfo((UnitDouble)this.d_setpointFld.getValue(), tripFlags);
        }

        private void loadTripFlags(int flags) {
            this.d_initStateCB.setSelected(TripFlags.initiallyOn(flags));
            this.d_latchCB.setSelected(TripFlags.latch(flags));
            boolean tripDirDesc = TripFlags.tripDirDescending(flags);
            if (tripDirDesc) {
                this.d_tripDirCombo.setSelectedItem(TRIP_DIR_DESCENDING);
            } else {
                this.d_tripDirCombo.setSelectedItem(TRIP_DIR_ASCENDING);
            }
        }
    }
}

