/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.Intl;
import pyrosim.gui.controls.ControlDesc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public interface ICtrlDescStringFormatter {
    public String formatActivateWhenActivate(boolean var1, String var2, String var3);

    public String formatActivateWhenDeactivate(boolean var1, String var2, String var3);

    public String formatDeactivateWhenActivate(boolean var1, String var2, String var3);

    public String formatDeactivateWhenDeactivate(boolean var1, String var2, String var3);

    public String formatActivateWhenAnyActivate(boolean var1, String var2, String var3);

    public String formatActivateWhenAnyDeactivate(boolean var1, String var2, String var3);

    public String formatActivateWhenAllActivate(boolean var1, String var2, String var3);

    public String formatActivateWhenAllDeactivate(boolean var1, String var2, String var3);

    public String formatActivateWhenNoMoreThanActivate(boolean var1, String var2, int var3, String var4);

    public String formatActivateWhenNoMoreThanDeactivate(boolean var1, String var2, int var3, String var4);

    public String formatActivateWhenAtLeastActivate(boolean var1, String var2, int var3, String var4);

    public String formatActivateWhenAtLeastDeactivate(boolean var1, String var2, int var3, String var4);

    public String formatActivateWhenExactlyActivate(boolean var1, String var2, int var3, String var4);

    public String formatActivateWhenExactlyDeactivate(boolean var1, String var2, int var3, String var4);

    public String formatDeactivateWhenAnyActivate(boolean var1, String var2, String var3);

    public String formatDeactivateWhenAnyDeactivate(boolean var1, String var2, String var3);

    public String formatDeactivateWhenAllActivate(boolean var1, String var2, String var3);

    public String formatDeactivateWhenAllDeactivate(boolean var1, String var2, String var3);

    public String formatDeactivateWhenNoMoreThanActivate(boolean var1, String var2, int var3, String var4);

    public String formatDeactivateWhenNoMoreThanDeactivate(boolean var1, String var2, int var3, String var4);

    public String formatDeactivateWhenAtLeastActivate(boolean var1, String var2, int var3, String var4);

    public String formatDeactivateWhenAtLeastDeactivate(boolean var1, String var2, int var3, String var4);

    public String formatDeactivateWhenExactlyActivate(boolean var1, String var2, int var3, String var4);

    public String formatDeactivateWhenExactlyDeactivate(boolean var1, String var2, int var3, String var4);

    public String formatDelayDeactivation(boolean var1, UnitDouble var2);

    public String formatDelayActivation(boolean var1, UnitDouble var2);

    public String formatActivateAtTime(boolean var1, String var2, UnitDouble var3);

    public String formatDeactivateAtTime(boolean var1, String var2, UnitDouble var3);

    public String formatControlOnSequence(boolean var1, String var2);

    public String formatControlOnTimedEvents(boolean var1, String var2);

    public String formatTurnOffWhenBelowOnWhenAbove(boolean var1, String var2, String var3, UnitDouble var4, UnitDouble var5);

    public String formatTurnOnWhenBelowOffWhenAbove(boolean var1, String var2, String var3, UnitDouble var4, UnitDouble var5);

    public String formatExistsWhenTrue(boolean var1, String var2, String var3);

    public String formatExistWhenTrue(boolean var1, String var2, String var3);

    public String formatCustomActivation();

    public static class FreezeStrings
    extends Strings
    implements ICtrlDescStringFormatter {
        public FreezeStrings() {
            super(Intl.intl("<Never>"), Intl.intl("freeze"), Intl.intl("unfreeze"), Intl.intl("Freeze"), Intl.intl("Unfreeze"));
        }

        @Override
        public String formatActivateWhenActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3> <%5activates>.") : Intl.intl("Freeze <%1> when <%3> <%5activates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3> <%5deactivates>.") : Intl.intl("Freeze <%1> when <%3> <%5deactivates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3> <%5activates>.") : Intl.intl("Unfreeze <%1> when <%3> <%5activates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3> <%5deactivates>.") : Intl.intl("Unfreeze <%1> when <%3> <%5deactivates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAnyActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3any of> <%4> <%6activates>.") : Intl.intl("Freeze <%1> when <%3any of> <%4> <%6activates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAnyDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3any of> <%4> <%6deactivates>.") : Intl.intl("Freeze <%1> when <%3any of> <%4> <%6deactivates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAllActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3all of> <%4> <%6activate>.") : Intl.intl("Freeze <%1> when <%3all of> <%4> <%6activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAllDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3all of> <%4> <%6deactivate>.") : Intl.intl("Freeze <%1> when <%3all of> <%4> <%6deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenNoMoreThanActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3no more than> <%4> of <%6> <%8activate>.") : Intl.intl("Freeze <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenNoMoreThanDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3no more than> <%4> of <%6> <%8deactivate>.") : Intl.intl("Freeze <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAtLeastActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3at least> <%4> of <%6> <%8activate>.") : Intl.intl("Freeze <%1> when <%3at least> <%4> of <%6> <%8activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAtLeastDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%at least> <%4> of <%6> <%8deactivate>.") : Intl.intl("Freeze <%1> when <%at least> <%4> of <%6> <%8deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenExactlyActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3exactly> <%4> of <%6> <%8activate>.") : Intl.intl("Freeze <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenExactlyDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3exactly> <%4> of <%6> <%8deactivate>.") : Intl.intl("Freeze <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAnyActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3any of> <%4> <%6activates>.") : Intl.intl("Unfreeze <%1> when <%3any of> <%4> <%6activates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAnyDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3any of> <%4> <%6deactivates>.") : Intl.intl("Unfreeze <%1> when <%3any of> <%4> <%6deactivates>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAllActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3all of> <%4> <%6activate>.") : Intl.intl("Unfreeze <%1> when <%3all of> <%4> <%6activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAllDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3all of> <%4> <%6deactivate>.") : Intl.intl("Unfreeze <%1> when <%3all of> <%4> <%6deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenNoMoreThanActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3no more than> <%4> of <%6> <%8activate>.") : Intl.intl("Unfreeze <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenNoMoreThanDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3no more than> <%4> of <%6> <%8deactivate>.") : Intl.intl("Unfreeze <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAtLeastActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3at least> <%4> of <%6> <%8activate>.") : Intl.intl("Unfreeze <%1> when <%3at least> <%4> of <%6> <%8activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAtLeastDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3at least> <%4> of <%6> <%8deactivate>.") : Intl.intl("Unfreeze <%1> when <%3at least> <%4> of <%6> <%8deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenExactlyActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3exactly> <%4> of <%6> <%8activate>.") : Intl.intl("Unfreeze <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenExactlyDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze when <%3exactly> <%4> of <%6> <%8deactivate>.") : Intl.intl("Unfreeze <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDelayDeactivation(boolean editable, UnitDouble delay) {
            return FreezeStrings.formatHTMLString(Intl.intl("Delay unfreezing by <%1>."), editable, "DELAY", Global.format(delay));
        }

        @Override
        public String formatDelayActivation(boolean editable, UnitDouble delay) {
            return FreezeStrings.formatHTMLString(Intl.intl("Delay freezing by <%1>."), editable, "DELAY", Global.format(delay));
        }

        @Override
        public String formatActivateAtTime(boolean editable, String sinksStr, UnitDouble time) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze at t = <%3>.") : Intl.intl("Freeze <%1> at t = <%3>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "T", FreezeStrings.formatTime(time));
        }

        @Override
        public String formatDeactivateAtTime(boolean editable, String sinksStr, UnitDouble time) {
            String unformattedStr = sinksStr == null ? Intl.intl("Unfreeze at t = <%3>.") : Intl.intl("Unfreeze <%1> at t = <%3>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "T", FreezeStrings.formatTime(time));
        }

        @Override
        public String formatControlOnSequence(boolean editable, String sinksStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze and unfreeze based on the following sequence of events:") : Intl.intl("Freeze and unfreeze <%1> based on the following sequence of events:");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr);
        }

        @Override
        public String formatControlOnTimedEvents(boolean editable, String sinksStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze and unfreeze based on multiple timed events.") : Intl.intl("Freeze and unfreeze <%1> based on multiple timed events.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr);
        }

        @Override
        public String formatTurnOffWhenBelowOnWhenAbove(boolean editable, String sinksStr, String srcStr, UnitDouble lowerBound, UnitDouble upperBound) {
            String unformattedStr = sinksStr == null ? Intl.intl("<%1Unfreeze> when <%4> falls below <%6> and <%8freeze> when %5$s rises above <%9>.") : Intl.intl("<%1Unfreeze> <%2> when <%4> falls below <%6> and <%8freeze> when %5$s rises above <%9>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "DBLOWERL", "SINKS", sinksStr, "MSRSOURCES", srcStr, "DBLOWERV", lowerBound, "DBUPPERL", "DBUPPERV", upperBound);
        }

        @Override
        public String formatTurnOnWhenBelowOffWhenAbove(boolean editable, String sinksStr, String srcStr, UnitDouble lowerBound, UnitDouble upperBound) {
            String unformattedStr = sinksStr == null ? Intl.intl("<%1Freeze> when <%4> falls below <%6> and <%8unfreeze> when %5$s rises above <%9>.") : Intl.intl("<%1Freeze> <%2> when <%4> falls below <%6> and <%8unfreeze> when %5$s rises above <%9>.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "DBLOWERL", "SINKS", sinksStr, "MSRSOURCES", srcStr, "DBLOWERV", lowerBound, "DBUPPERL", "DBUPPERV", upperBound);
        }

        @Override
        public String formatExistsWhenTrue(boolean editable, String sinksStr, String srcStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freezes when <%3> is true.") : Intl.intl("<%1> freezes when <%3> is true.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "CUSTOMINPUT", srcStr);
        }

        @Override
        public String formatExistWhenTrue(boolean editable, String sinksStr, String srcStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Freeze when <%3> is true.") : Intl.intl("<%1> freeze when <%3> is true.");
            return FreezeStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "CUSTOMINPUT", srcStr);
        }

        @Override
        public String formatCustomActivation() {
            return Intl.intl("Freezing is based on custom logic.");
        }
    }

    public static class ActivateStrings
    extends Strings
    implements ICtrlDescStringFormatter {
        public ActivateStrings() {
            super(Intl.intl("<Always On>"), Intl.intl("on"), Intl.intl("off"), Intl.intl("Activate"), Intl.intl("Deactivate"));
        }

        @Override
        public String formatActivateWhenActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3> <%5activates>.") : Intl.intl("Activate <%1> when <%3> <%5activates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3> <%5deactivates>.") : Intl.intl("Activate <%1> when <%3> <%5deactivates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3> <%5activates>.") : Intl.intl("Deactivate <%1> when <%3> <%5activates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3> <%5deactivates>.") : Intl.intl("Deactivate <%1> when <%3> <%5deactivates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAnyActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3any of> <%4> <%6activates>.") : Intl.intl("Activate <%1> when <%3any of> <%4> <%6activates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAnyDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3any of> <%4> <%6deactivates>.") : Intl.intl("Activate <%1> when <%3any of> <%4> <%6deactivates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAllActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3all of> <%4> <%6activate>.") : Intl.intl("Activate <%1> when <%3all of> <%4> <%6activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAllDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3all of> <%4> <%6deactivate>.") : Intl.intl("Activate <%1> when <%3all of> <%4> <%6deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenNoMoreThanActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3no more than> <%4> of <%6> <%8activate>.") : Intl.intl("Activate <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenNoMoreThanDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3no more than> <%4> of <%6> <%8deactivate>.") : Intl.intl("Activate <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAtLeastActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3at least> <%4> of <%6> <%8activate>.") : Intl.intl("Activate <%1> when <%3at least> <%4> of <%6> <%8activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenAtLeastDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3at least> <%4> of <%6> <%8deactivate>.") : Intl.intl("Activate <%1> when <%3at least> <%4> of <%6> <%8deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenExactlyActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3exactly> <%4> of <%6> <%8activate>.") : Intl.intl("Activate <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatActivateWhenExactlyDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate when <%3exactly> <%4> of <%6> <%8deactivate>.") : Intl.intl("Activate <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAnyActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3any of> <%4> <%6activates>.") : Intl.intl("Deactivate <%1> when <%3any of> <%4> <%6activates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAnyDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3any of> <%4> <%6deactivates>.") : Intl.intl("Deactivate <%1> when <%3any of> <%4> <%6deactivates>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAllActivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3all of> <%4> <%6activate>.") : Intl.intl("Deactivate <%1> when <%3all of> <%4> <%6activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAllDeactivate(boolean editable, String sinksStr, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3all of> <%4> <%6deactivate>.") : Intl.intl("Deactivate <%1> when <%3all of> <%4> <%6deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenNoMoreThanActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3no more than> <%4> of <%6> <%8activate>.") : Intl.intl("Deactivate <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenNoMoreThanDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3no more than> <%4> of <%6> <%8deactivate>.") : Intl.intl("Deactivate <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAtLeastActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3at least> <%4> of <%6> <%8activate>.") : Intl.intl("Deactivate <%1> when <%3at least> <%4> of <%6> <%8activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenAtLeastDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3at least> <%4> of <%6> <%8deactivate>.") : Intl.intl("Deactivate <%1> when <%3at least> <%4> of <%6> <%8deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenExactlyActivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3exactly> <%4> of <%6> <%8activate>.") : Intl.intl("Deactivate <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDeactivateWhenExactlyDeactivate(boolean editable, String sinksStr, int count, String inputStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate when <%3exactly> <%4> of <%6> <%8deactivate>.") : Intl.intl("Deactivate <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "LOGIC", "N", Integer.toString(count), "DETSOURCES", inputStr, "ACTIVATE");
        }

        @Override
        public String formatDelayDeactivation(boolean editable, UnitDouble delay) {
            return ActivateStrings.formatHTMLString(Intl.intl("Delay deactivation by <%1>."), editable, "DELAY", Global.format(delay));
        }

        @Override
        public String formatDelayActivation(boolean editable, UnitDouble delay) {
            return ActivateStrings.formatHTMLString(Intl.intl("Delay activation by <%1>."), editable, "DELAY", Global.format(delay));
        }

        @Override
        public String formatActivateAtTime(boolean editable, String sinksStr, UnitDouble time) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate at t = <%3>.") : Intl.intl("Activate <%1> at t = <%3>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "T", ActivateStrings.formatTime(time));
        }

        @Override
        public String formatDeactivateAtTime(boolean editable, String sinksStr, UnitDouble time) {
            String unformattedStr = sinksStr == null ? Intl.intl("Deactivate at t = <%3>.") : Intl.intl("Deactivate <%1> at t = <%3>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "T", ActivateStrings.formatTime(time));
        }

        @Override
        public String formatControlOnSequence(boolean editable, String sinksStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate and deactivate based on the following sequence of events:") : Intl.intl("Activate and deactivate <%1> based on the following sequence of events:");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr);
        }

        @Override
        public String formatControlOnTimedEvents(boolean editable, String sinksStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Activate and deactivate based on multiple timed events.") : Intl.intl("Activate and deactivate <%1> based on multiple timed events.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr);
        }

        @Override
        public String formatTurnOffWhenBelowOnWhenAbove(boolean editable, String sinksStr, String srcStr, UnitDouble lowerBound, UnitDouble upperBound) {
            String unformattedStr = sinksStr == null ? Intl.intl("Turn <%1off> when <%4> falls below <%6> and turn <%8on> when %5$s rises above <%9>.") : Intl.intl("Turn <%1off> <%2> when <%4> falls below <%6> and turn <%8on> when %5$s rises above <%9>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "DBLOWERL", "SINKS", sinksStr, "MSRSOURCES", srcStr, "DBLOWERV", lowerBound, "DBUPPERL", "DBUPPERV", upperBound);
        }

        @Override
        public String formatTurnOnWhenBelowOffWhenAbove(boolean editable, String sinksStr, String srcStr, UnitDouble lowerBound, UnitDouble upperBound) {
            String unformattedStr = sinksStr == null ? Intl.intl("Turn <%1on> when <%4> falls below <%6> and turn <%8off> when %5$s rises above <%9>.") : Intl.intl("Turn <%1on> <%2> when <%4> falls below <%6> and turn <%8off> when %5$s rises above <%9>.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "DBLOWERL", "SINKS", sinksStr, "MSRSOURCES", srcStr, "DBLOWERV", lowerBound, "DBUPPERL", "DBUPPERV", upperBound);
        }

        @Override
        public String formatExistsWhenTrue(boolean editable, String sinksStr, String srcStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Exists when <%3> is true.") : Intl.intl("<%1> exists when <%3> is true.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "CUSTOMINPUT", srcStr);
        }

        @Override
        public String formatExistWhenTrue(boolean editable, String sinksStr, String srcStr) {
            String unformattedStr = sinksStr == null ? Intl.intl("Exist when <%3> is true.") : Intl.intl("<%1> exist when <%3> is true.");
            return ActivateStrings.formatHTMLString(unformattedStr, editable, "SINKS", sinksStr, "CUSTOMINPUT", srcStr);
        }

        @Override
        public String formatCustomActivation() {
            return Intl.intl("Activation is based on custom logic.");
        }
    }

    public static abstract class Strings
    implements ICtrlDescStringFormatter {
        public final String defaultDesc;
        public final String on;
        public final String off;
        public final String activate;
        public final String deactivate;

        protected Strings(String defaultDesc, String on, String off, String activate, String deactivate) {
            this.defaultDesc = defaultDesc;
            this.on = on;
            this.off = off;
            this.activate = activate;
            this.deactivate = deactivate;
        }

        protected static String formatHTMLString(String htmlMsg, boolean editable, Object ... args) {
            String ix;
            StringBuffer buf = new StringBuffer(htmlMsg.length());
            Pattern pattern = Pattern.compile("\\<\\%([0-9]+)\\>");
            Matcher matcher = pattern.matcher(htmlMsg);
            while (matcher.find()) {
                ix = matcher.group(1);
                int i = Integer.parseInt(ix);
                if (editable) {
                    matcher.appendReplacement(buf, "<a href=\"%" + i + "\\$s\">%" + (i + 1) + "\\$s</a>");
                    continue;
                }
                matcher.appendReplacement(buf, "%" + (i + 1) + "\\$s");
            }
            matcher.appendTail(buf);
            htmlMsg = buf.toString();
            buf.setLength(0);
            pattern = Pattern.compile("\\<\\%([0-9]+)([^\\>.]+)\\>");
            matcher = pattern.matcher(htmlMsg);
            while (matcher.find()) {
                ix = matcher.group(1);
                String str = matcher.group(2);
                int i = Integer.parseInt(ix);
                if (editable) {
                    matcher.appendReplacement(buf, "<a href=\"%" + i + "\\$s\">" + str + "</a>");
                    continue;
                }
                matcher.appendReplacement(buf, str);
            }
            matcher.appendTail(buf);
            htmlMsg = buf.toString();
            return String.format(htmlMsg, args);
        }

        protected static String formatTime(UnitDouble t) {
            return t == null ? ControlDesc.TBEGIN : Global.format(t);
        }
    }
}

