/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.theUtil;

public class QuantityComboBox
extends guiComboBox<IQuantity> {
    private static final long serialVersionUID = -4971250756057794463L;
    private final String d_nullName;
    private final Set<ObjectQuantity> d_importedObjMsrs = new LinkedHashSet<ObjectQuantity>();
    private boolean d_expandObjMsrs;
    private Predicate<Quantity> d_filter;

    public QuantityComboBox() {
        this(Filters.acceptAll(Quantity.class));
    }

    public QuantityComboBox(long outputTypes, QuantityType ... quantityTypes) {
        this(new QuantityUtil.TypeFilter(outputTypes, quantityTypes));
    }

    public QuantityComboBox(Predicate<Quantity> filter) {
        this(null, filter);
    }

    public QuantityComboBox(String nullName, long outputTypes, QuantityType ... quantityTypes) {
        this(nullName, new QuantityUtil.TypeFilter(outputTypes, quantityTypes));
    }

    public QuantityComboBox(String nullName, Predicate<Quantity> filter) {
        this.d_nullName = nullName;
        this.d_filter = filter;
        this.setMaximumRowCount(12);
        this.d_expandObjMsrs = false;
        this.updateList((IQuantity)this.getSelectedItem());
        this.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 39318149364329461L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name;
                if (value instanceof Component) {
                    return (Component)value;
                }
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    if (QuantityComboBox.this.d_nullName == null) {
                        return this;
                    }
                    name = QuantityComboBox.this.d_nullName;
                } else {
                    name = value instanceof IQuantity ? ((IQuantity)value).getDescription() : value.toString();
                }
                this.setText(name);
                return this;
            }
        });
        this.setMinimumSize(this.getPreferredSize());
    }

    public Predicate<Quantity> getFilter() {
        return this.d_filter;
    }

    public void setFilter(Predicate<Quantity> filter) {
        if (filter == this.d_filter) {
            return;
        }
        this.d_filter = filter;
        this.updateList((IQuantity)this.getSelectedItem());
    }

    public void setObjectMsrsExpanded(boolean expanded) {
        if (this.d_expandObjMsrs == expanded) {
            return;
        }
        this.d_expandObjMsrs = expanded;
        this.updateList((IQuantity)this.getSelectedItem());
    }

    protected void updateList(IQuantity newSel) {
        IQuantity oldSel = (IQuantity)this.getSelectedItem();
        ArrayList items = new ArrayList();
        if (this.d_nullName != null) {
            items.add(null);
        }
        items.addAll(this.getDefaultList());
        this.setModel(new DefaultComboBoxModel<Object>(items.toArray(new Object[items.size()])));
        if (!items.contains(newSel)) {
            newSel = null;
            for (Object obj : items) {
                if (!(obj instanceof IQuantity)) continue;
                newSel = (IQuantity)obj;
                break;
            }
            this.setSelectedItem(newSel);
        } else if (theUtil.equal(newSel, oldSel)) {
            ActionListener[] alisteners = this.getActionListeners();
            ItemListener[] ilisteners = this.getItemListeners();
            for (ActionListener actionListener : alisteners) {
                this.removeActionListener(actionListener);
            }
            for (EventListener eventListener : ilisteners) {
                this.removeItemListener((ItemListener)eventListener);
            }
            this.setSelectedItem(newSel);
            for (EventListener eventListener : alisteners) {
                this.addActionListener((ActionListener)eventListener);
            }
            for (EventListener eventListener : ilisteners) {
                this.addItemListener((ItemListener)eventListener);
            }
        } else {
            this.setSelectedItem(newSel);
        }
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null) {
            parent.pack();
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject instanceof ObjectQuantEntry) {
            ObjQuantDlg dlg = new ObjQuantDlg(this, (ObjectQuantEntry)anObject, this.d_filter);
            this.setPopupVisible(false);
            if (dlg.doModal() == 1) {
                this.setSelectedItem(dlg.saveData());
            }
        } else if (anObject instanceof ObjectQuantity) {
            if (this.d_importedObjMsrs.add((ObjectQuantity)anObject)) {
                this.updateList((ObjectQuantity)anObject);
            } else {
                super.setSelectedItem(anObject);
            }
        } else if (!(anObject instanceof Component)) {
            super.setSelectedItem(anObject);
        }
    }

    protected Collection<?> getDefaultList() {
        LinkedHashSet<Object> vals = new LinkedHashSet<Object>();
        if (this.d_expandObjMsrs) {
            List<ObjectQuantity> oqs = QuantityUtil.generateAllObjectQuanties(PyroSim.getApp().getMediator(), this.d_filter, true);
            vals.addAll(oqs);
        } else {
            List<ObjectQuantEntry> entries = this.getCollapsedObjectEntries();
            if (!entries.isEmpty()) {
                vals.addAll(entries);
                vals.add(new JSeparator());
            }
        }
        if (this.d_importedObjMsrs != null && !this.d_importedObjMsrs.isEmpty()) {
            vals.addAll(this.d_importedObjMsrs);
            vals.add(new JSeparator());
        }
        vals.addAll(QuantityUtil.generateStaticQuantities(this.d_filter, true));
        return vals;
    }

    private List<ObjectQuantEntry> getCollapsedObjectEntries() {
        Map<String, List<Quantity>> categoryMap = QuantityUtil.groupObjQuantities();
        Predicate<Quantity> objectsExistFilter = new Predicate<Quantity>(){

            @Override
            public boolean test(Quantity o) {
                for (int m = 0; m < o.getNumArgs(); ++m) {
                    Collection<? extends IPyroObject> objs = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), o, m);
                    if (!objs.isEmpty()) continue;
                    return false;
                }
                return true;
            }
        };
        Predicate<Quantity> filter = this.d_filter.and(objectsExistFilter);
        ArrayList<ObjectQuantEntry> entries = new ArrayList<ObjectQuantEntry>();
        for (Map.Entry<String, List<Quantity>> entry : categoryMap.entrySet()) {
            if (theUtil.filter((Collection)entry.getValue(), filter).isEmpty()) continue;
            Collection<Quantity> objQuants = QuantityUtil.sort((Collection<Quantity>)entry.getValue());
            ObjectQuantEntry ent = new ObjectQuantEntry(QuantityUtil.getDefaultQuantForCategory(entry.getKey()), objQuants.toArray(new Quantity[objQuants.size()]));
            entries.add(ent);
        }
        Collections.sort(entries, new ANameSorter<ObjectQuantEntry>(){

            @Override
            protected String getName(ObjectQuantEntry o) {
                return o.comboDesc;
            }
        });
        return entries;
    }

    private static class ObjQuantDlg
    extends guiDialog {
        private static final long serialVersionUID = 1891475417110161943L;
        private final guiComboBox<Quantity> d_quantCB;
        private final ObjectPanel d_objectPnl;

        public ObjQuantDlg(Component owner, ObjectQuantEntry entry, Predicate<Quantity> filter) {
            super(SwingUtilities.getWindowAncestor(owner), Intl.intl("Choose Quantity"), 9);
            Predicate<Quantity> objFilter = new Predicate<Quantity>(){

                @Override
                public boolean test(Quantity o) {
                    for (int m = 0; m < o.getNumArgs(); ++m) {
                        Collection<? extends IPyroObject> objs = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), o, m);
                        if (!objs.isEmpty()) continue;
                        return false;
                    }
                    return true;
                }
            };
            filter = filter.and(objFilter);
            this.d_quantCB = new guiComboBox<Quantity>((Collection<Quantity>)theUtil.filter(Arrays.asList(entry.quantities), filter));
            this.d_quantCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -6557235785954199277L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof Quantity) {
                        Quantity msr = (Quantity)((Object)value);
                        this.setText(msr.name);
                    }
                    return c;
                }
            });
            this.d_objectPnl = new ObjectPanel();
            this.d_quantCB.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.d_objectPnl.update();
                    this.updateLayout();
                    this.pack();
                }
            });
            if (entry.preferredDefault != null) {
                this.d_quantCB.setSelectedItem((Object)entry.preferredDefault);
            }
            this.updateLayout();
        }

        private void updateLayout() {
            this.getDialogPane().removeAll();
            GridBagHelper gb = new GridBagHelper(this.getDialogPane(), true);
            gb.addRow(Intl.intl("Quantity:"), this.d_quantCB);
            for (int m = 0; m < this.d_objectPnl.d_objectLabels.length; ++m) {
                gb.addRow(this.d_objectPnl.d_objectLabels[m] + ":", this.d_objectPnl.d_objectCBs[m], 1.0);
            }
            gb.finalizeRows();
        }

        public ObjectQuantity saveData() {
            Quantity quant = this.d_quantCB.getSelectedItem();
            return quant.create(this.d_objectPnl.saveData());
        }

        private class ObjectPanel
        extends guiPanel {
            private static final long serialVersionUID = -3976662525118510111L;
            private guiComboBox<? extends IPyroObject>[] d_objectCBs;
            private String[] d_objectLabels;

            public ObjectPanel() {
                this.update();
            }

            public void update() {
                this.removeAll();
                GridBagHelper gb = new GridBagHelper(this);
                Quantity quantity = ObjQuantDlg.this.d_quantCB.getSelectedItem();
                int numObjectCbs = this.d_objectCBs == null ? 0 : this.d_objectCBs.length;
                IPyroObject[] prevSelections = new IPyroObject[numObjectCbs];
                if (numObjectCbs > 0) {
                    for (int i = 0; i < this.d_objectCBs.length; ++i) {
                        prevSelections[i] = this.d_objectCBs[i].getSelectedItem();
                    }
                }
                this.d_objectCBs = new guiComboBox[quantity.getNumArgs()];
                this.d_objectLabels = new String[quantity.getNumArgs()];
                for (int m = 0; m < quantity.getNumArgs(); ++m) {
                    Collection<? extends IPyroObject> objs = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), quantity, m);
                    this.d_objectCBs[m] = new guiComboBox<IPyroObject>((Collection<? extends IPyroObject>)Util.sort(objs));
                    this.d_objectCBs[m].setRenderer(new DefaultListCellRenderer(){
                        private static final long serialVersionUID = -8989509286590543699L;

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                            if (value instanceof INamed) {
                                this.setText(((INamed)value).getName());
                            }
                            return c;
                        }
                    });
                    if (m < prevSelections.length && objs.contains(prevSelections[m])) {
                        this.d_objectCBs[m].setSelectedItem(prevSelections[m]);
                    }
                    Class<? extends IPyroObject> type = quantity.requiredTypes[m];
                    this.d_objectLabels[m] = TVEntryPoints.ep(type).getCategoryName();
                }
                gb.finalizeRows();
            }

            public IPyroObject[] saveData() {
                IPyroObject[] data = new IPyroObject[this.d_objectCBs.length];
                for (int m = 0; m < data.length; ++m) {
                    data[m] = this.d_objectCBs[m].getSelectedItem();
                }
                return data;
            }
        }
    }

    private static class ObjectQuantEntry {
        public final Quantity[] quantities;
        public final Quantity preferredDefault;
        public final String typeName;
        public final String comboDesc;

        public ObjectQuantEntry(Quantity preferredDefault, Quantity ... quantities) {
            this.quantities = quantities;
            this.preferredDefault = preferredDefault;
            assert (quantities[0].category != null);
            this.typeName = quantities[0].category;
            this.comboDesc = String.format(Intl.intl("[%s Quantity]..."), this.typeName);
        }

        public String toString() {
            return this.comboDesc;
        }
    }
}

