/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.appearance;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.appearance.ImageBtnListener;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.gui.materialdlg.AMaterialDialog;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Task;

public class MaterialDlg
extends AMaterialDialog<Material, MaterialDB> {
    private static final long serialVersionUID = 1L;

    public MaterialDlg(JFrame parent, String title, MaterialDB texDB, Material init, boolean includeNull) {
        super(parent, title, PyroSim.getApp().getMediator().getEvents(), Material.class, texDB, init, includeNull);
    }

    @Override
    protected void actionNew(ActionEvent e) {
        if (!this.preSave()) {
            return;
        }
        final ArrayList exceptions = new ArrayList();
        PyroMod mod = PyroSim.getApp().getMediator();
        AOneTimeTask op = new AOneTimeTask(){

            @Override
            public void run() {
                String name = JOptionPane.showInputDialog(MaterialDlg.this, (Object)Intl.intl("Enter material name:"));
                if (name == null) {
                    return;
                }
                try {
                    if (name.equals("")) {
                        name = Intl.intl("untitled");
                    }
                    MatAttrs matAttrs = MaterialDlg.newAttrs(null);
                    Material newMat = new Material(name, matAttrs);
                    ((MaterialDB)MaterialDlg.this.d_texDB).add(newMat);
                    ((MaterialDB)MaterialDlg.this.d_texDB).importToDB(newMat);
                    MaterialDlg.this.setChoice(newMat);
                }
                catch (Exception exp) {
                    exceptions.add(exp);
                }
            }
        };
        mod.getTaskManager().exec((Task)op, Intl.intl("Create New Materials"), 1);
        if (!exceptions.isEmpty()) {
            this.showException((Exception)exceptions.get(0), Intl.intl("Error creating material."));
        }
    }

    @Override
    protected void actionImport(ActionEvent e) {
        if (!this.preSave()) {
            return;
        }
        guiFileChooser chooser = PyroSim.getApp().getFilenameManager().getFileChooser(((MaterialDB)this.d_texDB).getFileFilters());
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        final File[] texfiles = chooser.getSelectedFiles();
        final ArrayList newMaterials = new ArrayList(texfiles.length);
        final ArrayList exceptions = new ArrayList();
        PyroMod mod = PyroSim.getApp().getMediator();
        AOneTimeTask op = new AOneTimeTask(){

            @Override
            public void run() {
                try {
                    boolean selected = false;
                    for (File texFile : texfiles) {
                        IImage img = ImageManager.getImage(texFile.getAbsolutePath(), 3, 0);
                        String name = FilenameManager.splitFilename(texFile.getName())[0];
                        Texture diffTex = Texture.repeated(img, "uvset");
                        MatAttrs matAttrs = MaterialDlg.newAttrs(diffTex);
                        Material newMat = new Material(name, matAttrs);
                        ((MaterialDB)MaterialDlg.this.d_texDB).add(newMat);
                        ((MaterialDB)MaterialDlg.this.d_texDB).importToDB(newMat);
                        newMaterials.add(newMat);
                        if (selected) continue;
                        MaterialDlg.this.setChoice(newMat);
                        selected = true;
                        SwingUtilities.invokeLater(() -> MaterialDlg.this.getImageBtnListener().setDefaultFile(texFile));
                    }
                }
                catch (Exception exp) {
                    exceptions.add(exp);
                }
            }
        };
        mod.getTaskManager().exec((Task)op, Intl.intl("Import Appearances"), 1);
        if (!exceptions.isEmpty()) {
            this.showException((Exception)exceptions.get(0), Intl.intl("Error importing material."));
        }
    }

    @Override
    protected void actionRemoveUnused(ActionEvent e) {
        final PyroMod mod = PyroSim.getApp().getMediator();
        AOneTimeTask op = new AOneTimeTask(){

            @Override
            public void run() {
                ArrayList<Object> unused = new ArrayList();
                Set<Material> inuse = mod.getInUseAppearances();
                Predicate<Material> filter = Filters.reject(inuse).and(mat -> mod.getAppearances().isLocal((Material)mat));
                unused = new ArrayList<Material>(mod.getAppearances().flatten(Material.class, filter));
                if (unused.isEmpty()) {
                    JOptionPane.showMessageDialog(MaterialDlg.this, Intl.intl("All unused appearances are stored in the global database and will not be deleted."), Intl.intl("Delete Warning"), 2);
                    return;
                }
                Task delTask = Actions.getDeleteTask((PyroMod)((MaterialDB)MaterialDlg.this.d_texDB).getDomain(), unused);
                if (delTask == null) {
                    return;
                }
                mod.getTaskManager().exec(delTask, Intl.intl("Remove Appearance"), 1);
            }
        };
        mod.getTaskManager().exec((Task)op, Intl.intl("Remove unused appearances"), 1);
    }

    @Override
    protected void actionRemove(ActionEvent e) {
        Task delTask;
        if (this.d_choice == null) {
            return;
        }
        String id = ((Material)this.d_choice).getName();
        if (((MaterialDB)this.d_texDB).isPermanent((Material)this.d_choice)) {
            String title;
            Object msg = String.format(Intl.intl("Permanently remove database appearance: %s?<br><b>NOTE:</b> This operation cannot be undone."), id);
            int choice = JOptionPane.showConfirmDialog(this, msg = "<html>" + (String)msg + "</html>", title = Intl.intl("Remove Appearance?"), 0, 2);
            if (choice != 0) {
                return;
            }
        }
        if ((delTask = Actions.getDeleteTask((PyroMod)((MaterialDB)this.d_texDB).getDomain(), Arrays.asList((Material)this.d_choice))) == null) {
            return;
        }
        if (((MaterialDB)this.d_texDB).isPermanent((Material)this.d_choice)) {
            final Task undoableTsk = delTask;
            delTask = new AOneTimeTask(){

                @Override
                public void run() {
                    undoableTsk.run();
                }
            };
        }
        PyroMod mod = PyroSim.getApp().getMediator();
        mod.getTaskManager().exec(delTask, Intl.intl("Remove Appearance"), 1);
    }

    @Override
    protected void commitMaterial(final Material entry, final UnitDouble width, final UnitDouble height, final IMatAttrs previewAttrs, final Component source) {
        final PyroMod mod = PyroSim.getApp().getMediator();
        AOneTimeTask op = new AOneTimeTask(){

            @Override
            public void run() {
                try {
                    entry.setSize(width, height);
                    MatAttrs attrs = (MatAttrs)entry.getAttributes();
                    attrs = attrs.mergeWith(previewAttrs, IMatAttrs.ALL);
                    entry.setAttributes(attrs);
                    mod.getAppearances().updateFile(entry);
                }
                catch (IOException exp) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PyroGuiUtil.showError(source, Intl.intl("Error"), Intl.intl("Error saving appearance to file."), (Throwable)exp);
                        }
                    });
                }
            }
        };
        mod.getTaskManager().exec((Task)op, Intl.intl("Edit Appearance"), 1);
    }

    @Override
    protected ImageBtnListener getImageBtnListener() {
        return ImageBtnListener.INSTANCE;
    }

    @Override
    protected IUnitSrc getLengthUnit() {
        return UnitSystem.getSource(0);
    }

    @Override
    protected IUnitSrc getPercentageUnit() {
        return UnitSystem.getSource(84);
    }

    @Override
    protected IUnitSrc getUnitlessUnit() {
        return UnitSystem.getSource(28);
    }
}

