/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.Floor;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialCache;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.geom.Geometry;
import pyrosim.gui.CancelledException;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.io.ImportFDSFile;
import pyrosim.io.STLReader;
import pyrosim.io.fds.INIReader;
import pyrosim.io.fds.SMVReader;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.NewObjCache;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.cad.in.CadImportUI;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.nmt.NmtSolidUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.gui.wizard.WizardDlg;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsUtil;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.FileWarning;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Task;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class ImportAction
extends guiAction {
    private static final long serialVersionUID = 2465596277560605809L;
    private static final IPropertySet.Prop<MaterialCache> PROP_MAT_CACHE = new IPropertySet.Prop<Object>("ImportAction.MAT_CACHE", null);
    private static final IPropertySet.Prop<NewObjCache<SurfKey, Surface>> PROP_SURF_CACHE = new IPropertySet.Prop<Object>("ImportAction.SURF_CACHE", null);
    private static STLOptions s_defSTLOptions = null;

    public ImportAction() {
        super(Intl.intl("Import FDS/CAD File..."), PyroGuiUtil.loadTeciIcon("Import16.gif"));
        this.putValue("ShortDescription", this.getName());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PyroSim pySim = PyroSim.getApp();
        JFrame mf = pySim.getMainFrame();
        HashSet<String> cadExt = new HashSet<String>();
        ArrayList<String> filters = new ArrayList<String>(Arrays.asList("fds", Intl.intl("FDS 5/6 Input Files"), "data", Intl.intl("FDS 4 Input Files"), "txt", Intl.intl("FDS 4 Input Files")));
        String[] cadFilters = CadImporter.getSupportedFileFormats();
        for (int m = 0; m < cadFilters.length; ++m) {
            if (m % 2 == 0) {
                cadExt.add(cadFilters[m].toLowerCase());
            }
            filters.add(cadFilters[m]);
        }
        filters.addAll(Arrays.asList("stl", Intl.intl("STereoLithography"), "ini", Intl.intl("Smokeview INI Files")));
        File f = PyroSim.getFilenames().getOpenFile((Component)mf, theUtil.toArray(filters, String.class));
        if (f == null) {
            return;
        }
        pySim.savePreferences();
        String ext = FilenameManager.getExtension(f.getAbsolutePath());
        if (ext.equalsIgnoreCase("fds") || ext.equalsIgnoreCase("data") || ext.equalsIgnoreCase("txt")) {
            if (!pySim.promptSaveIfModified(true)) {
                return;
            }
            PyroMod pyMod = pySim.getMediator();
            ImportFDSFile tsk = new ImportFDSFile(pySim, pyMod, f.getAbsolutePath());
            pyMod.getTaskManager().exec((Task)tsk, Intl.intl("Import FDS File"), 2);
        } else {
            Runnable r = () -> {
                block16: {
                    pySim.beginWaitCursor();
                    try {
                        if (ext.equalsIgnoreCase("stl")) {
                            this.importSTL(pySim, f);
                            break block16;
                        }
                        if (ext.equalsIgnoreCase("ini")) {
                            this.importINI(pySim, f);
                            break block16;
                        }
                        if (cadExt.contains(ext.toLowerCase())) {
                            this.importCad(pySim, pySim.getMediator(), f);
                            break block16;
                        }
                        String msg = String.format(Intl.intl("%s files are not supported."), ext);
                        throw new IOException(msg);
                    }
                    catch (CancellationException msg) {
                    }
                    catch (CancelledException msg) {
                    }
                    catch (ParseException e) {
                        PyroGuiUtil.showError(pySim, Intl.intl("File Error"), String.format(Intl.intl("Error on line %d."), e.getErrorOffset()), (Throwable)e);
                    }
                    catch (IOException e) {
                        PyroGuiUtil.showError(pySim, Intl.intl("File Error"), Intl.intl("Could not import file."), (Throwable)e);
                    }
                    catch (Throwable t) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                throw new RuntimeException(t);
                            }
                        });
                    }
                    finally {
                        pySim.endWaitCursor();
                    }
                }
            };
            Thread t = new Thread(r);
            t.setPriority(1);
            t.start();
        }
    }

    private static AWizardCard<IPropertySet> getImportCard(PyroMod pyroMod, File file, IPropertySet options) {
        MaterialCache matCache = new MaterialCache(pyroMod.getAppearances().flatten());
        NewObjCache<SurfKey, Surface> surfCache = new NewObjCache<SurfKey, Surface>(pyroMod.getSurfaceMgr().flatten(), s -> new SurfKey((Surface)s));
        options.setIfNotDefault(PROP_SURF_CACHE, surfCache);
        options.setIfNotDefault(PROP_MAT_CACHE, matCache);
        options.setIfNotDefault(IGeomImportSession.DST_LENGTH_UNIT, Geometry.LU);
        options.setIfNotDefault(CadImportUI.LENGTH_UNIT_SRC, UnitSystem.getSource(0));
        options.setIfNotDefault(CadImportUI.MAT_FACTORY, (name, attrs) -> {
            String matName = name.trim();
            Material appearance = new Material(matName, (IMatAttrs)attrs);
            appearance = matCache.add(appearance);
            String surfName = matName;
            Surface surf = new Surface(surfName, appearance.getAttributes().getDiffuseColorWithOpacity(), appearance);
            return options.get(PROP_SURF_CACHE).add(surf);
        });
        Floor afloor = PyroSim.getApp().get3DView().getActiveFloor();
        if (afloor != null) {
            options.set(CadImportUI.DEF_OFFSET, afloor.getElevation());
        }
        options.set(CadImportUI.FILE, file);
        return CadImportUI.getFirstWizardCard(options);
    }

    private static void cleanupCad(IPropertySet options) {
        options.remove(PROP_SURF_CACHE);
        options.remove(PROP_MAT_CACHE);
        options.remove(IGeomImportSession.DST_LENGTH_UNIT);
        options.remove(CadImportUI.FILE);
        options.remove(CadImportUI.LENGTH_UNIT_SRC);
        options.remove(CadImportUI.DEF_OFFSET);
        options.remove(CadImportUI.MAT_FACTORY);
        options.remove(CadImportUI.WARNINGS);
        CadImportUI.cleanup(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCad(PyroSim pySim, final PyroMod pyroMod, File f) throws IOException, CancelledException {
        final Semaphore waitSema = new Semaphore(0);
        PropertySet options = new PropertySet();
        options.set(CadImportUI.WARNINGS, new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0));
        AWizardCard<IPropertySet> importCard = ImportAction.getImportCard(pyroMod, f, options);
        try {
            WizardDlg<IPropertySet> wizard = new WizardDlg<IPropertySet>((Window)pySim.getActiveFrame(), Intl.intl("Import"), String.format(Intl.intl("Import %s"), f.getName()), importCard);
            wizard.init(options);
            if (wizard.doModal() != 1) {
                return;
            }
            ModelComposite importGroup = this.convert(pyroMod, f, options, CadImportUI.finalizeResult(options));
            LinkedIdentityHashSet usedSurfs = new LinkedIdentityHashSet();
            for (IObstruction iObstruction : ((APyroObject)importGroup).flatten(IObstruction.class)) {
                Surface[] surfs = iObstruction.getSurfaces();
                usedSurfs.addAll(Arrays.asList(surfs));
            }
            usedSurfs.retainAll(options.get(PROP_SURF_CACHE).getAddedObjects());
            LinkedIdentityHashSet<IMaterial> usedMats = new LinkedIdentityHashSet<IMaterial>();
            for (Surface surf : usedSurfs) {
                Material mat = surf.getAppearance();
                if (mat == null) continue;
                usedMats.add(mat);
            }
            for (GenericGeomSrc geom : ((APyroObject)importGroup).flatten(GenericGeomSrc.class)) {
                PropsUtil.getReferencedMaterials(geom.getGeom(), geom.getDisplayProps(), usedMats);
            }
            usedMats.retainAll(options.get(PROP_MAT_CACHE).getAddedMaterials());
            final CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
            compositeTask.addTask(new AddAutoRenameTask<IMaterial>((Composite<IMaterial>)pyroMod.getAppearances(), (Collection<IMaterial>)usedMats));
            compositeTask.addTask(new AddAutoRenameTask<Surface>((Composite<Surface>)pyroMod.getSurfaceMgr(), (Collection<Surface>)usedSurfs));
            compositeTask.addTask(new AddTask((IPyroObject)pyroMod.getObstructions(), new IPyroObject[]{importGroup}));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pyroMod.getTaskManager().exec((Task)compositeTask, Intl.intl("Import CAD"), 2);
                    waitSema.release();
                }
            });
            try {
                waitSema.acquire();
            }
            catch (InterruptedException geom) {
                // empty catch block
            }
            WarningReport<Warning> warningReport = options.get(CadImportUI.WARNINGS);
            if (!warningReport.isEmpty()) {
                new WarningDlg<Warning>((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("Import Warning"), Intl.intl("Problem importing model."), options.get(CadImportUI.WARNINGS)).doModal();
            }
        }
        finally {
            ImportAction.cleanupCad(options);
        }
    }

    private ModelComposite convert(PyroMod pyroMod, File fn, IPropertySet options, Collection<IGeomImportSession.Node> inodes) throws IOException {
        GenericGeomSrc ig;
        if (inodes.isEmpty()) {
            throw new IOException(Intl.intl("File contains no geometric data."));
        }
        ArrayList<IPyroObject> cobjs = new ArrayList<IPyroObject>();
        for (IGeomImportSession.Node node : inodes) {
            cobjs.add(ImportAction.convert(pyroMod, TransformUtil.IDENTITY_INFO, node));
        }
        DisplayGeom bgquad = CadImportUI.createBackgroundQuad(options, () -> {
            AABox importBounds = new AABox();
            for (IPyroGeomSrc gobj : Hierarchy.flatten(cobjs, IPyroGeomSrc.class)) {
                importBounds.add(gobj.getBounds());
            }
            return importBounds;
        });
        if (bgquad != null && !(ig = new GenericGeomSrc(Intl.intl("background"), bgquad.node, bgquad.props)).getBounds().isInfinite()) {
            cobjs.add(0, ig);
        }
        ModelComposite mresult = new ModelComposite(fn.getName());
        mresult.addAll(cobjs);
        return mresult;
    }

    private static IPyroObject convert(PyroMod pyroMod, TransformInfo parentToWorldXform, IGeomImportSession.Node node) {
        ArrayList<IPyroObject> objs = new ArrayList<IPyroObject>();
        TransformInfo nodeToWorld = parentToWorldXform.concatenate(node.transform);
        if (node.dg != DisplayGeom.EMPTY) {
            NamedPyroObject obj;
            DisplayGeom dg = node.dg.transform(nodeToWorld);
            int nfaces = dg.node.getNumPrims(1);
            if (nfaces > 0) {
                Pair<Color[], Surface[]> faceProps = ImportAction.getFaceProps(dg.props, nfaces, pyroMod.getDefaultSurface());
                Obstruction obst = new Obstruction(node.name, dg.node, (Surface[])faceProps.v2, node.props.getBIMType());
                obst.setColors((Color[])faceProps.v1);
                obj = obst;
            } else {
                obj = new GenericGeomSrc(node.name, dg.node, dg.props, node.props.getBIMType());
            }
            objs.add(obj);
            if (node.children.isEmpty()) {
                return (IPyroObject)objs.get(0);
            }
        }
        for (IGeomImportSession.Node child : node.children) {
            if (child.props.getBIMType().isDescendentOf(BIMType.Space)) continue;
            objs.add(ImportAction.convert(pyroMod, nodeToWorld, child));
        }
        ModelComposite group = new ModelComposite(node.name);
        group.addAll(objs);
        return group;
    }

    private static Pair<Color[], Surface[]> getFaceProps(IPropsSrc props, int primCount, Surface defSurf) {
        if (primCount == 0) {
            return new Pair<Color[], Surface[]>(new Color[0], new Surface[0]);
        }
        if (props.getUniformCount(0, primCount) == primCount) {
            IPrimProps pprops = props.get(0);
            Surface surf = (Surface)pprops.getMaterial();
            if (surf == null) {
                surf = defSurf;
            }
            return new Pair<Color[], Surface[]>(new Color[]{pprops.getColor()}, new Surface[]{surf});
        }
        Color[] colors = new Color[primCount];
        Surface[] surfs = new Surface[primCount];
        for (int m = 0; m < primCount; ++m) {
            IPrimProps pprops = props.get(m);
            colors[m] = pprops.getColor();
            surfs[m] = pprops.getMaterial() == null ? defSurf : (Surface)pprops.getMaterial();
        }
        return new Pair<Color[], Surface[]>(ImportAction.finalizeColors(colors), ImportAction.finalizeSurfs(surfs));
    }

    private static Color[] finalizeColors(Color[] colors) {
        Color[] colorArray;
        if (colors.length > 0 && GeomUtil.isUniform(colors)) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = colors[0];
        } else {
            colorArray = colors;
        }
        return colorArray;
    }

    private static Surface[] finalizeSurfs(Surface[] surfs) {
        Surface[] surfaceArray;
        if (surfs.length > 0 && GeomUtil.isUniform(surfs)) {
            Surface[] surfaceArray2 = new Surface[1];
            surfaceArray = surfaceArray2;
            surfaceArray2[0] = surfs[0];
        } else {
            surfaceArray = surfs;
        }
        return surfaceArray;
    }

    private void importSTL(PyroSim pySim, File f) throws IOException {
        List<? extends IGeom> geoms;
        STLOptions options;
        STLOptions defOptions = s_defSTLOptions;
        if (defOptions == null) {
            defOptions = new STLOptions(NonSI.INCH, Geometry.LU, new UnitDouble(1.0E-5, SI.METER), STLOptions.ObjType.SOLID_OBSTRUCTION, pySim.getMediator().getDefaultSurface());
        }
        if ((options = ImportAction.getSTLOptions(pySim, defOptions)) == null) {
            return;
        }
        s_defSTLOptions = options;
        STLReader reader = new STLReader(f, options.getReaderOptions());
        reader.read();
        String name = reader.getName();
        if (name.isEmpty()) {
            name = f.getName();
        }
        if ((geoms = reader.getGeometry()).isEmpty()) {
            String msg = Intl.intl("Warning: The STL file contained no valid triangles.  The weld tolerance may be set too high.");
            JOptionPane.showMessageDialog(pySim.getActiveFrame(), msg, Intl.intl("Warning"), 2);
        }
        String fname = name;
        Consumer<List> addObjs = objs -> {
            IPyroObject obj;
            if (objs.isEmpty()) {
                return;
            }
            if (objs.size() == 1) {
                obj = (IPyroObject)objs.get(0);
            } else {
                ModelComposite comp = new ModelComposite(fname);
                comp.addAll((Collection<? extends IPyroObject>)objs);
                obj = comp;
            }
            EventQueue.invokeLater(() -> {
                SelectTask ct = new SelectTask(pySim.getMediator(), obj);
                ct.addTask(new AddTask((IPyroObject)pySim.getMediator().getObstructions(), new IPyroObject[]{obj}));
                pySim.getMediator().getTaskManager().exec((Task)ct, Intl.intl("Import STL File"), 2);
            });
        };
        try {
            List<IPyroObject> objs2 = ImportAction.constructObjs(name, geoms, options);
            addObjs.accept(objs2);
        }
        catch (NmtSolidUtil.ManifoldException e) {
            String excStr;
            String string = excStr = e.getLocalizedMessage().isEmpty() ? e.getClass().getSimpleName() : e.getLocalizedMessage();
            if (options.type == STLOptions.ObjType.HOLE) {
                EventQueue.invokeLater(() -> {
                    String msg = String.format(Intl.intl("Warning: Could not construct a hole from the geometry.%nCause: %s"), excStr);
                    JOptionPane.showMessageDialog(pySim.getActiveFrame(), msg, Intl.intl("Warning"), 2);
                });
            }
            EventQueue.invokeLater(() -> {
                block3: {
                    String msg = String.format(Intl.intl("Warning: Could not construct a manifold solid out of the geometry.%nCause: %s%nWould you like to convert to an unfilled obstruction instead?"), excStr);
                    int opt = JOptionPane.showConfirmDialog(pySim.getActiveFrame(), msg, Intl.intl("Warning"), 0);
                    if (opt != 0) {
                        return;
                    }
                    STLOptions newOpts = new STLOptions(options.srcUnit, options.dstUnit, options.weldTol, STLOptions.ObjType.SHELL_OBSTRUCTION, options.surf());
                    try {
                        addObjs.accept(ImportAction.constructObjs(fname, geoms, newOpts));
                    }
                    catch (NmtSolidUtil.ManifoldException e2) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
            });
        }
    }

    private static DisplayGeom toSTLDisplayGeom(STLOptions options, IGeom geom) {
        Supplier<IPrimProps> getPrimProps = () -> {
            if (options.type.isHole) {
                return new IPrimProps.Face(Color.WHITE, null, 0);
            }
            return new IPrimProps.Face(Color.WHITE, options.surf(), 0);
        };
        UniformProps dprops = new UniformProps(getPrimProps.get());
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), dprops);
    }

    private static IGeomNode finalizeSTLGeom(STLOptions options, IGeomNode geom, IPropsSrc dprops) {
        IGeomNode fgeom = geom.flatten();
        IElemSource<Elements.Orient> orients = fgeom.getElements(Elements.ORIENT);
        Mesh mesh = (Mesh)thunderheadeng.geometry.objs.GeomUtil.convertToMesh((double)0.1, (IGeom)fgeom.getLocalGeom(), orients).v1;
        IElemSource<Vector3d> normals = Elements.generateNormals(mesh, Elements.CCW, Math.toRadians(60.0));
        IElemSource<Boolean> creases = Elements.generateCreasesFromNormals(mesh, dprops, normals, orients);
        IPropertySet elements = Elements.newElements(Elements.CREASE, creases, Elements.ORIENT, Elements.CCW, Elements.NORMAL, normals);
        return GeomNodeUtil.newNode(mesh, elements);
    }

    private static List<IPyroObject> constructObjs(String name, List<? extends IGeom> geoms, STLOptions options) throws NmtSolidUtil.ManifoldException {
        boolean solid = options.type.isSolid;
        BiFunction<IGeomNode, IPropsSrc, IPyroObject> toObj = (node, dprops) -> {
            node = ImportAction.finalizeSTLGeom(options, node, dprops);
            if (options.type.isHole) {
                return new Hole(name, (IGeomNode)node);
            }
            Obstruction obst = new Obstruction(name, (IGeomNode)node, new Surface[]{options.surf()});
            if (options.type == STLOptions.ObjType.GEOM) {
                obst.setOptions(128, true);
            }
            return obst;
        };
        ArrayList<IPyroObject> result = new ArrayList<IPyroObject>();
        if (!solid) {
            for (IGeom iGeom : geoms) {
                DisplayGeom dg = ImportAction.toSTLDisplayGeom(options, iGeom);
                result.add(toObj.apply(dg.node, dg.props));
            }
            return result;
        }
        List<DisplayGeom> solidGeoms = ImportAction.toSolids(options, geoms);
        for (DisplayGeom geom : solidGeoms) {
            result.add(toObj.apply(geom.node, geom.props));
        }
        return result;
    }

    private static List<DisplayGeom> toSolids(STLOptions options, List<? extends IGeom> geoms) throws NmtSolidUtil.ManifoldException {
        IGeom grouped = thunderheadeng.geometry.objs.GeomUtil.group(geoms);
        DisplayGeom dgeom = ImportAction.toSTLDisplayGeom(options, grouped);
        List<Pair<IGeomNode, IntUnaryOperator>> result = GeomUtil.makeManifold(new GeomUtil.GEOMValidateParams(66), dgeom.node, dgeom.props);
        return result.stream().map(p -> {
            assert (dgeom.props.getUniformCount(0, ((IGeomNode)p.v1).getNumPrims(1)) == ((IGeomNode)p.v1).getNumPrims(1));
            return new DisplayGeom((IGeomNode)p.v1, dgeom.props);
        }).collect(Collectors.toList());
    }

    private static STLOptions getSTLOptions(PyroSim pySim, STLOptions defOptions) {
        guiDialog dlg = new guiDialog((Window)pySim.getActiveFrame(), Intl.intl("STL Import Options"), 9);
        guiPanel pnl = dlg.getDialogPane();
        pnl.setLayout(new GridBagLayout());
        guiComboBox<Object> lengthUnitCB = new guiComboBox<Object>((T[])new Object[]{SI.MILLI(SI.METER), SI.CENTI(SI.METER), SI.METER, SI.KILO(SI.METER), NonSI.INCH, NonSI.FOOT, NonSI.YARD});
        lengthUnitCB.setSelectedItem(defOptions.srcUnit);
        ValueField<UnitDouble> weldTolFld = ValueFields.udFld(defOptions.weldTol, UnitDoubleVR.above(new UnitDouble(0.0, SI.METER), true), UnitSystem.getSource(0));
        guiRadioButton filledObstBtn = new guiRadioButton(Intl.intl("Filled Obstruction"));
        filledObstBtn.setToolTipText("<html>" + Intl.intl("Attempts to create solid obstructions. The STL geometry must<br>consist of one or more closed manifolds."));
        guiRadioButton shellObstBtn = new guiRadioButton(Intl.intl("Hollow Obstruction"));
        shellObstBtn.setToolTipText(Intl.intl("Creates an obstruction from a collection of thin faces."));
        guiRadioButton geomBtn = new guiRadioButton(Intl.intl("Unstructured GEOM"));
        geomBtn.setToolTipText("<html>" + Intl.intl("Attempts to create unstructured GEOM objects for use with FDS7.<br>The STL geometry must consist of one or more closed manifolds."));
        guiRadioButton holeBtn = new guiRadioButton(Intl.intl("Hole"));
        holeBtn.setToolTipText("<html>" + Intl.intl("Attempts to create holes that will be subtracted from other<br>obstructions and unstructured GEOM objects. The STL geometry must<br>consist of one or more closed manifolds."));
        new guiButtonGroup(filledObstBtn, shellObstBtn, geomBtn, holeBtn);
        TitleSeparator obstSep = new TitleSeparator(Intl.intl("Obstruction/GEOM Properties"));
        Surface defSurf = defOptions.surf();
        if (defSurf == null || !pySim.getMediator().getSurfaceMgr().containsDeep(defSurf)) {
            defSurf = pySim.getMediator().getDefaultSurface();
        }
        SurfaceComboBox surfCB = new SurfaceComboBox(pySim.getMediator().getSurfaceMgr(), defSurf);
        guiLabel surfLbl = new guiLabel(Intl.intl("Surface:"));
        LinkStatus.link((AbstractButton)holeBtn, true, obstSep, surfCB, surfLbl);
        holeBtn.addItemListener(e -> dlg.repaint());
        GridBagHelper gb = new GridBagHelper(pnl);
        gb.addRow(Intl.intl("File Units:"), lengthUnitCB);
        gb.addRow(Intl.intl("Vertex weld tolerance:"), weldTolFld);
        gb.addFilledRow(Intl.intl("What type of geometry should the STL data be imported as?"));
        gb.indent();
        gb.addRow(filledObstBtn, GridBagHelper.REMAINING);
        gb.addRow(shellObstBtn, GridBagHelper.REMAINING);
        if (PyroSim.isFDSGeomEnabled()) {
            gb.addRow(geomBtn, GridBagHelper.REMAINING);
        }
        gb.addRow(holeBtn, GridBagHelper.REMAINING);
        gb.unindent();
        gb.addFilledRow(obstSep);
        gb.addIdentRow(surfLbl, surfCB);
        gb.finalizeRows();
        switch (defOptions.type) {
            case GEOM: {
                geomBtn.setSelected(true);
                break;
            }
            case HOLE: {
                holeBtn.setSelected(true);
                break;
            }
            case SHELL_OBSTRUCTION: {
                shellObstBtn.setSelected(true);
                break;
            }
            case SOLID_OBSTRUCTION: {
                filledObstBtn.setSelected(true);
            }
        }
        if (dlg.doModal() != 1) {
            return null;
        }
        STLOptions.ObjType type = filledObstBtn.isSelected() ? STLOptions.ObjType.SOLID_OBSTRUCTION : (shellObstBtn.isSelected() ? STLOptions.ObjType.SHELL_OBSTRUCTION : (geomBtn.isSelected() ? STLOptions.ObjType.GEOM : (holeBtn.isSelected() ? STLOptions.ObjType.HOLE : STLOptions.ObjType.SHELL_OBSTRUCTION)));
        return new STLOptions((Unit)lengthUnitCB.getSelectedItem(), Geometry.LU, (UnitDouble)weldTolFld.getValue(), type, (Surface)surfCB.getSelectedItem());
    }

    private AABox readSMVBounds(File smvFile) throws IOException {
        AABox aABox;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(smvFile));
        try {
            SMVReader reader = new SMVReader();
            SMVReader.SMVInfo smv = reader.read(in);
            AABox meshBounds = new AABox();
            for (SMVReader.MeshInfo mi : smv.meshes) {
                meshBounds.add(mi.bounds);
            }
            System.out.printf("Read mesh bounds from SMV file, %s:%n%s%n", smvFile.getAbsolutePath(), meshBounds);
            aABox = meshBounds;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new IOException(String.format(Intl.intl("Could not read mesh bounds from \"%s\"."), smvFile.getAbsolutePath(), t));
            }
        }
        ((InputStream)in).close();
        return aABox;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importINI(PyroSim pySim, File f) throws IOException, ParseException {
        Collection<IPyroObject> objs;
        AABox meshBounds;
        PyroMod pyMod = pySim.getMediator();
        File smvFile = new File(FilenameManager.changeExtension(f.getAbsolutePath(), "smv"));
        if (!smvFile.exists()) {
            String useModelBounds;
            String chooseFile = Intl.intl("Choose SMV File");
            int option = PyroGuiUtil.ui(() -> ImportAction.lambda$importINI$12(pySim, chooseFile, useModelBounds = Intl.intl("Use model bounds")));
            if (option == 0) {
                File smvFile2 = smvFile;
                if ((smvFile = PyroGuiUtil.ui(() -> PyroSim.getFilenames().getOpenFile((Component)pySim.getActiveFrame(), smvFile2, "smv", Intl.intl("Smokeview Files")))) == null) {
                    return;
                }
                meshBounds = this.readSMVBounds(smvFile);
            } else {
                if (option != 1) return;
                meshBounds = new AABox();
                for (Grid g2 : pyMod.getGridManager().flatten(g -> g.isEnabled())) {
                    meshBounds.add(g2.getBounds());
                }
            }
        } else {
            meshBounds = this.readSMVBounds(smvFile);
        }
        BoundsCalculator boundsCalc = new BoundsCalculator();
        Stream.of(pySim.getModelView().getClipManager().getClippingScenes()).forEach(s -> s.getBounds(boundsCalc));
        AABox sceneBounds = boundsCalc.getBounds();
        if (!sceneBounds.isValid()) {
            sceneBounds = sceneBounds.ensureValidSize(5.0, 5.0);
        }
        INIReader reader = new INIReader(sceneBounds, meshBounds);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            objs = reader.read(in);
        }
        int objCount = 0;
        CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(pyMod);
        IFilteredCollection<View> views = theUtil.filter(objs, View.class);
        if (!views.isEmpty()) {
            ViewList group = pyMod.getViews().newGroup(f.getName());
            group.addAll(views);
            task.addTask(new AddTask((IPyroObject)pyMod.getViews(), (IPyroObject[])new ViewList[]{group}));
            task.addTask(new SelectTask(pyMod, group));
            objCount += views.size();
        }
        int numObjs = objCount;
        EventQueue.invokeLater(() -> {
            pyMod.getTaskManager().exec(task, Intl.intl("Import INI File"));
            if (!reader.getWarnings().isEmpty()) {
                WarningDlg<FileWarning> dlg = new WarningDlg<FileWarning>((Window)pySim.getActiveFrame(), Intl.intl("Import Warnings"), Intl.intl("There were some problems importing the INI file:"), reader.getWarnings());
                dlg.doModal();
            }
            JOptionPane.showMessageDialog(pySim.getActiveFrame(), String.format(Intl.intl("Imported %d object(s)."), numObjs), numObjs == 0 ? Intl.intl("No Objects Imported") : Intl.intl("Objects Imported"), 1);
        });
    }

    private static /* synthetic */ Integer lambda$importINI$12(PyroSim pySim, String chooseFile, String useModelBounds) throws Exception {
        return JOptionPane.showOptionDialog(pySim.getActiveFrame(), Intl.intl("An SMV file is needed to calculate the mesh bounds, but one cannot\nbe found. What would you like to do?"), Intl.intl("Missing SMV File"), 2, 3, null, new Object[]{chooseFile, useModelBounds, Intl.intl("Cancel")}, chooseFile);
    }

    private static class STLOptions {
        public final ObjType type;
        public final WeakReference<Surface> surf;
        public final UnitDouble weldTol;
        public final Unit srcUnit;
        public final Unit dstUnit;

        public STLOptions(Unit srcUnit, Unit dstUnit, UnitDouble weldTol, ObjType type, Surface surf) {
            this.srcUnit = srcUnit;
            this.dstUnit = dstUnit;
            this.weldTol = weldTol;
            this.type = type;
            this.surf = new WeakReference<Surface>(surf);
        }

        public Surface surf() {
            return (Surface)this.surf.get();
        }

        public STLReader.Options getReaderOptions() {
            double scale = this.srcUnit.getConverterTo(this.dstUnit).convert(1.0);
            Matrix4d lwXform = scale == 1.0 ? null : Util.scaleMat(scale, scale, scale);
            double dstTol = this.weldTol.getValue(this.dstUnit);
            return new STLReader.Options(lwXform, dstTol);
        }

        public static enum ObjType {
            SHELL_OBSTRUCTION(false, false),
            SOLID_OBSTRUCTION(false, true),
            GEOM(false, true),
            HOLE(true, true);

            public final boolean isHole;
            public final boolean isSolid;

            private ObjType(boolean isHole, boolean isSolid) {
                this.isHole = isHole;
                this.isSolid = isSolid;
            }
        }
    }

    private static class SurfKey {
        public final Surface surface;
        public final int hash;

        public SurfKey(Surface surface) {
            this.surface = surface;
            this.hash = surface.getName().hashCode() + (surface.getAppearance() != null ? surface.getAppearance().pseudoHashCode() : 0);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SurfKey && this.surface.getName().equals(((SurfKey)obj).surface.getName()) && this.surface.getAppearance().pseudoEquals(((SurfKey)obj).surface.getAppearance());
        }
    }
}

