/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.HeatTransfer3DSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.gui.actions.ARunFDSValidation;

public class GeomNamelistValidation
extends ARunFDSValidation {
    private boolean hasValidated = false;
    private List<IObstruction> controlWarns = new ArrayList<IObstruction>();
    private List<IObstruction> ht3dWarns = new ArrayList<IObstruction>();
    private List<IObstruction> burnAwayWarns = new ArrayList<IObstruction>();

    public GeomNamelistValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    public boolean hasValidated() {
        return this.hasValidated;
    }

    public Collection<IPyroObject> getControlObjs() {
        return Collections.unmodifiableCollection(this.controlWarns);
    }

    public Collection<IPyroObject> getHt3dObjs() {
        return Collections.unmodifiableCollection(this.ht3dWarns);
    }

    public Collection<IPyroObject> getBurnAwayObjs() {
        return Collections.unmodifiableCollection(this.burnAwayWarns);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        List geoms = ((APyroObject)this.d_pyroMod.getObstructions()).flatten(IObstruction.class).stream().filter(obst -> obst.getOptions(128)).collect(Collectors.toList());
        for (IObstruction obst2 : geoms) {
            if (!obst2.getInputPin().getConnections().isEmpty()) {
                this.controlWarns.add(obst2);
            }
            for (Surface surf : obst2.getSurfaces()) {
                if (surf.getSurfDesc() instanceof HeatTransfer3DSurfDesc) {
                    this.ht3dWarns.add(obst2);
                }
                if (surf.getSurfDesc() instanceof HeatTransfer3DSurfDesc) {
                    HeatTransfer3DSurfDesc ht3d = (HeatTransfer3DSurfDesc)surf.getSurfDesc();
                    if (!ht3d.d_burnAway) continue;
                    this.burnAwayWarns.add(obst2);
                    continue;
                }
                if (!(surf.getSurfDesc() instanceof LayeredSurfDesc)) continue;
                LayeredSurfDesc layered = (LayeredSurfDesc)surf.getSurfDesc();
                if (!layered.d_burnAway) continue;
                this.burnAwayWarns.add(obst2);
            }
        }
        return null;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        return null;
    }

    @Override
    public String getValidationDescription() {
        return null;
    }

    public static class GeomBurnAwayValidation
    extends ARunFDSValidation {
        private final GeomNamelistValidation d_validator;

        public GeomBurnAwayValidation(GeomNamelistValidation worker, PyroSim app, PyroMod mod) {
            super(app, mod);
            this.d_validator = worker;
        }

        @Override
        public Collection<IPyroObject> validateModel() {
            if (!this.d_validator.hasValidated()) {
                this.d_validator.validateModel();
            }
            return this.d_validator.getBurnAwayObjs();
        }

        @Override
        public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
            String instructions = Intl.intl("&GEOM records cannot currently be used in conjunction \nwith &SURF records that use the BURN_AWAY option. \nPyroSim has detected that such &GEOM records are being used. \n\nClick OK to select the invalid geometries. \n\nClick Ignore to disregard this warning and run FDS.");
            ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
            p.overrideButtonDesc(8, Intl.intl("Ignore"));
            return p;
        }

        @Override
        public String getValidationDescription() {
            return Intl.intl("&GEOM Burn Away Validation");
        }
    }

    public static class GeomHt3dValidation
    extends ARunFDSValidation {
        private final GeomNamelistValidation d_validator;

        public GeomHt3dValidation(GeomNamelistValidation worker, PyroSim app, PyroMod mod) {
            super(app, mod);
            this.d_validator = worker;
        }

        @Override
        public Collection<IPyroObject> validateModel() {
            if (!this.d_validator.hasValidated()) {
                this.d_validator.validateModel();
            }
            return this.d_validator.getHt3dObjs();
        }

        @Override
        public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
            String instructions = Intl.intl("&GEOM records cannot currently be used in conjunction \nwith &SURF records that use the HT3D option. \nPyroSim has detected that such &GEOM records are being used. \n\nClick OK to select the invalid geometries. \n\nClick Ignore to disregard this warning and run FDS.");
            ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
            p.overrideButtonDesc(8, Intl.intl("Ignore"));
            return p;
        }

        @Override
        public String getValidationDescription() {
            return Intl.intl("&GEOM HT3D Validation");
        }
    }

    public static class GeomControlValidation
    extends ARunFDSValidation {
        private final GeomNamelistValidation d_validator;

        public GeomControlValidation(GeomNamelistValidation worker, PyroSim app, PyroMod mod) {
            super(app, mod);
            this.d_validator = worker;
        }

        @Override
        public Collection<IPyroObject> validateModel() {
            if (!this.d_validator.hasValidated()) {
                this.d_validator.validateModel();
            }
            return this.d_validator.getControlObjs();
        }

        @Override
        public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
            String instructions = Intl.intl("&GEOM records cannot currently have their activation logic \nmanaged using &CTRL and &DEVC objects. \nPyroSim has detected that such &GEOM records are being used. \n\nClick OK to select the invalid geometries. \n\nClick Ignore to disregard this warning and run FDS. Doing so \nwill convert the records to &OBSTs.");
            ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
            p.overrideButtonDesc(8, Intl.intl("Ignore"));
            return p;
        }

        @Override
        public String getValidationDescription() {
            return Intl.intl("&GEOM Control Logic Validation");
        }
    }
}

