/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.io.fds.FDSRenderProps;

public class PromptingFDSRenderProps
extends FDSRenderProps {
    private final PyroMod d_model;
    private boolean d_expandPrompted;
    private boolean d_linkPyroGeomPrompted;

    public PromptingFDSRenderProps(PyroMod model, FDSRenderProps baseProps) {
        this.imprint(baseProps);
        this.d_model = model;
        this.d_expandPrompted = false;
        this.d_linkPyroGeomPrompted = false;
    }

    @Override
    public boolean expandBoundaryHoles() {
        if (!this.d_expandPrompted) {
            String msg = Intl.intl("PyroSim has detected a hole touching a mesh boundary, which\nmay cause cutting problems in FDS.  Would you like to slightly\nexpand these types of holes?");
            int result = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), msg, Intl.intl("Expand Boundary Holes?"), 0);
            boolean exand = result == 0;
            super.setExpandBoundaryHoles(exand);
            this.d_expandPrompted = true;
        }
        return super.expandBoundaryHoles();
    }

    @Override
    public boolean getLinkPyroGeom() {
        boolean linked = super.getLinkPyroGeom();
        if (!this.d_linkPyroGeomPrompted && !linked) {
            JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("The additional records section contains OBST, VENT, and/or HOLE records.\nThese objects will not appear in the PyroSim Geometry file and will prevent\nthe geometry file from containing activation logic."), Intl.intl("Geometry in Additional Records"), 2);
            this.d_linkPyroGeomPrompted = true;
        }
        return linked;
    }
}

