/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.reaction.Reaction;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class LibraryDlg
extends guiDialog {
    private static final long serialVersionUID = 6394989489998116704L;
    private static final Map<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>> s_retrievers = new HashMap<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>>();
    private final PyroMod d_mediator = PyroSim.getApp().getMediator();
    private final guiComboBox<IMgrRetriever<? extends IPyroObject>> d_libCB;
    private final JList<IPyroObject> d_modelObjs;
    private final JList<IPyroObject> d_libObjs;
    private final JButton d_loadFromLibBtn;
    private final JButton d_saveToLibBtn;
    private final JButton d_chooseLibBtn;
    private final JButton d_saveLibBtn;
    private final JButton d_newLibBtn;
    private final JButton d_deleteLibObjBtn;
    private final JButton d_deleteModelObjBtn;
    private final guiLabel d_libLbl;
    private guiFileChooser d_libChooser;
    private String d_currentLib = "";
    private PyroMod d_libModel = null;
    private boolean d_libUnsaved = false;

    private static <T extends IPyroObject> void registerRetriever(IMgrRetriever<T> retriever) {
        s_retrievers.put(retriever.getType(), retriever);
    }

    public LibraryDlg(JFrame owner, Class<? extends IPyroObject> defLibType) {
        super((Window)owner, Intl.intl("PyroSim Libraries"), 16);
        WindowListener[] listeners = this.getWindowListeners();
        for (int m = 0; m < listeners.length; ++m) {
            this.removeWindowListener(listeners[m]);
        }
        this.addWindowListener(new CloseListener());
        this.d_libCB = new guiComboBox();
        this.d_libCB.setRenderer(new RetrieverRenderer());
        this.d_libCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LibraryDlg.this.updateLibSelection();
            }
        });
        this.d_libChooser = new guiFileChooser();
        this.d_libChooser.setAcceptAllFileFilterUsed(true);
        this.d_libChooser.addChoosableFileFilter(new ExampleFileFilter("fds", "Database File"));
        this.d_modelObjs = new JList(new DefaultListModel());
        this.d_libObjs = new JList(new DefaultListModel());
        JScrollPane currentObjsSP = new JScrollPane(this.d_modelObjs);
        JScrollPane libSP = new JScrollPane(this.d_libObjs);
        currentObjsSP.setVerticalScrollBarPolicy(22);
        libSP.setVerticalScrollBarPolicy(22);
        currentObjsSP.getViewport().setScrollMode(2);
        libSP.getViewport().setScrollMode(2);
        Dimension listSize = new Dimension(170, 200);
        libSP.setPreferredSize(listSize);
        currentObjsSP.setPreferredSize(listSize);
        this.d_loadFromLibBtn = new JButton("<--");
        this.d_saveToLibBtn = new JButton("-->");
        this.d_chooseLibBtn = new JButton(Intl.intl("Load Library..."));
        this.d_saveLibBtn = new JButton(Intl.intl("Save Current Library..."));
        this.d_newLibBtn = new JButton(Intl.intl("Create New Library"));
        this.d_deleteModelObjBtn = new JButton(Intl.intl("Delete Selected Objects..."));
        this.d_deleteLibObjBtn = new JButton(Intl.intl("Delete Selected Objects..."));
        this.d_chooseLibBtn.addActionListener(new LoadLibraryAction());
        this.d_saveToLibBtn.addActionListener(new SaveToLibraryAction());
        this.d_loadFromLibBtn.addActionListener(new LoadFromLibraryAction());
        this.d_saveLibBtn.addActionListener(new SaveLibraryAction());
        this.d_newLibBtn.addActionListener(new CreateLibraryAction());
        guiLabel currentSurfsL = new guiLabel(Intl.intl("Current Model"));
        this.d_libLbl = new guiLabel(Intl.intl("Library - \"untitled\""));
        Dimension libDim = this.d_libLbl.getPreferredSize();
        libDim.width = listSize.width;
        this.d_libLbl.setPreferredSize(libDim);
        int row = 0;
        guiPanel libPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(libPanel, this.d_libLbl, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, libSP, 0, row++, 1, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(libPanel, this.d_newLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, this.d_chooseLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, this.d_saveLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, this.d_deleteLibObjBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        row = 0;
        guiPanel modelPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(modelPanel, currentSurfsL, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(modelPanel, currentObjsSP, 0, row++, 1, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(modelPanel, this.d_deleteModelObjBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        JPanel arrowPanel = new JPanel(new GridLayout(2, 1, 0, 6));
        arrowPanel.add(this.d_loadFromLibBtn);
        arrowPanel.add(this.d_saveToLibBtn);
        row = 0;
        guiPanel managePanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(managePanel, modelPanel, 0, 1, 1, 4, 0, 0, 6, 0, 3, 0.0, 1.0, 17);
        GridBagUtil.add(managePanel, arrowPanel, 1, 1, 1, 4, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(managePanel, libPanel, 2, 1, 1, 4, 0, 0, 6, 0, 3, 0.0, 1.0, 17);
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new GridBagLayout());
        GridBagUtil.add(mainPanel, new guiLabel(Intl.intl("Category:")), 0, 0, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_libCB, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, new JSeparator(0), 0, 1, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(mainPanel, managePanel, 0, 2, 10, 1, 0, 0, 6, 6, 1, 1.0, 1.0, 17);
        ListSelectionListener updateSelAction = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LibraryDlg.this.updateActions();
            }
        };
        this.d_modelObjs.addListSelectionListener(updateSelAction);
        this.d_libObjs.addListSelectionListener(updateSelAction);
        DeleteModelObjectsAction deleteModelListener = new DeleteModelObjectsAction();
        DeleteLibraryObjectsAction deleteLibListener = new DeleteLibraryObjectsAction();
        this.d_modelObjs.addKeyListener(deleteModelListener);
        this.d_libObjs.addKeyListener(deleteLibListener);
        this.d_deleteLibObjBtn.addActionListener(deleteLibListener);
        this.d_deleteModelObjBtn.addActionListener(deleteModelListener);
        ManagerRenderer renderer = new ManagerRenderer();
        this.d_modelObjs.setCellRenderer(renderer);
        this.d_libObjs.setCellRenderer(renderer);
        this.d_saveToLibBtn.setEnabled(false);
        this.d_loadFromLibBtn.setEnabled(false);
        this.d_deleteModelObjBtn.setEnabled(false);
        this.d_deleteLibObjBtn.setEnabled(false);
        this.init();
        Collection<IMgrRetriever<? extends IPyroObject>> retrievers = theUtil.sort(new ANameSorter<IMgrRetriever<? extends IPyroObject>>(){

            @Override
            protected String getName(IMgrRetriever<? extends IPyroObject> o) {
                return o.getDescription();
            }
        }, s_retrievers.values());
        this.d_libCB.setItems(retrievers);
        if (defLibType != null) {
            this.d_libCB.setSelectedItem(s_retrievers.get(defLibType));
        } else {
            this.d_libCB.setSelectedIndex(0);
        }
        this.updateLibSelection();
    }

    private void updateLibSelection() {
        this.loadList(this.d_mediator, this.d_modelObjs);
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    private Composite getManager(PyroMod model) {
        return this.d_libCB.getSelectedItem().getManager(model);
    }

    private Predicate<? extends IPyroObject> getFilter() {
        return this.d_libCB.getSelectedItem().getFilter();
    }

    private void updateActions() {
        boolean modSel = !this.d_modelObjs.isSelectionEmpty();
        boolean libSel = !this.d_libObjs.isSelectionEmpty();
        this.d_deleteLibObjBtn.setEnabled(libSel);
        this.d_loadFromLibBtn.setEnabled(libSel);
        this.d_deleteModelObjBtn.setEnabled(modSel);
        this.d_saveToLibBtn.setEnabled(modSel);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            if (!this.checkSaveNewLib()) {
                return;
            }
            PyroPrefs.set(PyroPrefs.PREF_LASTLIBRARY, this.d_currentLib, true);
        }
        super.setVisible(visible);
    }

    private boolean init() {
        String prefLib = PyroPrefs.getString(PyroPrefs.PREF_LASTLIBRARY);
        ArrayList<String> libsToTry = new ArrayList<String>();
        libsToTry.add(prefLib);
        if (!prefLib.equals(PyroPrefs.PREF_LASTLIBRARY.defVal)) {
            libsToTry.add((String)PyroPrefs.PREF_LASTLIBRARY.defVal);
        }
        for (String lib : libsToTry) {
            if (!this.loadLibraryModelFromFile(lib, false)) continue;
            this.setCurrentLibrary(lib);
            return true;
        }
        this.createLibrary();
        this.d_libUnsaved = false;
        return true;
    }

    private void setCurrentLibrary(String lib) {
        this.d_currentLib = lib;
        File f = new File(this.d_currentLib);
        PyroSim.getApp().setLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString(), f);
        String libLabel = String.format(Intl.intl("Library: ...%s"), f.getName());
        String fullLabel = String.format(Intl.intl("Library: %s"), f.getAbsolutePath());
        this.d_libLbl.setText(libLabel);
        this.d_libLbl.setToolTipText(fullLabel);
    }

    public void createLibrary() {
        if (!this.checkSaveNewLib()) {
            return;
        }
        this.d_libModel = new PyroMod();
        this.d_libUnsaved = true;
        this.setCurrentLibrary("untitled.fds");
    }

    private boolean checkSaveNewLib() {
        int selection;
        return !this.d_libUnsaved || !((selection = JOptionPane.showConfirmDialog(this, Intl.intl("The current library has not been saved.  Would you like to do so now?"), Intl.intl("Save New Library") + "?", 1)) == 0 ? !this.saveLibrary() : selection == 2 || selection == -1);
    }

    private boolean loadLibraryModel() {
        if (!this.checkSaveNewLib()) {
            return false;
        }
        File f = new File(this.d_currentLib);
        if (f.isFile()) {
            this.d_libChooser.setSelectedFile(f);
        } else {
            this.d_libChooser.setCurrentDirectory(PyroSim.getApp().getLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString()));
        }
        int selection = this.d_libChooser.showOpenDialog(this);
        if (selection != 0) {
            return false;
        }
        f = this.d_libChooser.getSelectedFile();
        if (!this.loadLibraryModelFromFile(f.getAbsolutePath(), true)) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("The file \"%s\" could not be read."), f.getAbsolutePath()));
            return false;
        }
        this.setCurrentLibrary(f.getAbsolutePath());
        return true;
    }

    public boolean loadLibraryModelFromFile(String filename, boolean showWarnings) {
        PyroSim.getApp().setLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString(), new File(filename));
        try {
            this.d_libModel = new PyroMod();
            FDSParser parser = FDS.newParser(6);
            FDSParseResult result = parser.parseFile(filename, this.d_libModel);
            if (showWarnings) {
                result.warningReport.showWarnings(this, false);
            }
            this.d_libUnsaved = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveLibrary() {
        ArrayList<? extends IPyroObject> toExport = new ArrayList<IPyroObject>();
        for (IMgrRetriever<? extends IPyroObject> retriever : s_retrievers.values()) {
            toExport.addAll(LibraryDlg.getObjects(this.d_libModel, retriever));
        }
        File newLibFile = Actions.exportToFile(this, new File(this.d_currentLib), this.d_libModel, toExport, PyroPrefs.LastFDSDatabaseDirProp.key.toString());
        if (newLibFile == null) {
            return false;
        }
        this.setCurrentLibrary(newLibFile.getAbsolutePath());
        this.d_libUnsaved = false;
        return true;
    }

    private boolean deleteObjs(JList<IPyroObject> jlist, PyroMod domain) {
        List<IPyroObject> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return false;
        }
        Task t = Actions.getDeleteTask(domain, objs);
        if (t == null) {
            return false;
        }
        domain.getTaskManager().exec(t, Intl.intl("Delete Objects"));
        this.loadList(domain, jlist);
        this.preserveSelection(objs, jlist, this.getManager(domain));
        return true;
    }

    private void preserveSelection(Collection<? extends IPyroObject> lastSelectedObjs, JList<IPyroObject> jlist, Composite<? extends IPyroObject> mgr) {
        ArrayList<Integer> selIxes = new ArrayList<Integer>();
        jlist.clearSelection();
        for (IPyroObject iPyroObject : lastSelectedObjs) {
            if (!mgr.containsDeep(iPyroObject)) continue;
            selIxes.add(this.indexOf(jlist, iPyroObject));
        }
        jlist.setSelectedIndices(theUtil.toIntArray(selIxes));
    }

    private int indexOf(JList<IPyroObject> jlist, IPyroObject obj) {
        for (int m = 0; m < jlist.getModel().getSize(); ++m) {
            if (jlist.getModel().getElementAt(m) != obj) continue;
            return m;
        }
        return -1;
    }

    private static <T extends IPyroObject> Collection<T> getObjects(PyroMod domain, IMgrRetriever<T> retriever) {
        Composite<T> mgr = retriever.getManager(domain);
        Predicate<T> filter = retriever.getFilter();
        Collection<T> objs = filter != null ? mgr.flatten(retriever.getType(), filter) : ((APyroObject)mgr).flatten(retriever.getType());
        return Util.sort(objs);
    }

    private void loadList(PyroMod domain, JList<IPyroObject> list) {
        list.setListData((IPyroObject[])theUtil.toArray(LibraryDlg.getObjects(domain, this.d_libCB.getSelectedItem()), IPyroObject.class));
    }

    private Set<? extends IPyroObject> getListContents(JList<IPyroObject> list) {
        LinkedIdentityHashSet objs = new LinkedIdentityHashSet();
        ListModel<IPyroObject> model = list.getModel();
        for (int m = 0; m < model.getSize(); ++m) {
            objs.add(model.getElementAt(m));
        }
        return objs;
    }

    public boolean copyListSelection(JList<IPyroObject> jlistBeingCopied, JList<IPyroObject> jlistCopiedTo, PyroMod containerBeingCopied, PyroMod containerCopiedTo) {
        Set<? extends IPyroObject> oldListVals = this.getListContents(jlistCopiedTo);
        List<IPyroObject> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return true;
        }
        try {
            Actions.doTransfer(containerBeingCopied, containerCopiedTo, objsToCopy);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.loadList(containerCopiedTo, jlistCopiedTo);
        Set<? extends IPyroObject> newListVals = this.getListContents(jlistCopiedTo);
        newListVals.removeAll(oldListVals);
        this.preserveSelection(newListVals, jlistCopiedTo, this.getManager(containerCopiedTo));
        return true;
    }

    static {
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Materials"), Material.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getMaterialMgr();
            }
        });
        Predicate<Surface> surfFilter = new Predicate<Surface>(){

            @Override
            public boolean test(Surface o) {
                return !o.isPredefined();
            }
        };
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Surfaces"), Surface.class, (Predicate)surfFilter){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSurfaceMgr();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Gas-phase Reactions"), Reaction.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getReactions();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Smoke Detector Models"), SmokeLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSmokeLinkModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Heat Detector Models"), HeatLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getHeatLinkModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Sprinkler Link Models"), SprinklerLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSprinklerLinkModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Spray Models"), SprayModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSprayModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Particles"), Particle.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getPartList();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Species"), ExSpec.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getExSpecList();
            }
        });
    }

    private class ManagerRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7049889130747457100L;

        private ManagerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            IPyroObject obj = (IPyroObject)value;
            this.setText(Util.getName(obj));
            return this;
        }
    }

    private class RetrieverRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -4364493595770278351L;

        private RetrieverRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            IMgrRetriever obj = (IMgrRetriever)value;
            this.setText(obj.getDescription());
            return this;
        }
    }

    private class DeleteLibraryObjectsAction
    extends KeyAdapter
    implements ActionListener {
        private DeleteLibraryObjectsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.deleteSurfs();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                this.deleteSurfs();
            } else {
                super.keyReleased(e);
            }
        }

        private void deleteSurfs() {
            if (LibraryDlg.this.deleteObjs(LibraryDlg.this.d_libObjs, LibraryDlg.this.d_libModel)) {
                LibraryDlg.this.d_libUnsaved = true;
            }
        }
    }

    private class DeleteModelObjectsAction
    extends KeyAdapter
    implements ActionListener {
        private DeleteModelObjectsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LibraryDlg.this.deleteObjs(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_mediator);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                LibraryDlg.this.deleteObjs(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_mediator);
            } else {
                super.keyReleased(e);
            }
        }
    }

    private class SaveToLibraryAction
    implements ActionListener {
        private SaveToLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Application.getApp().beginWaitCursor();
            boolean changed = LibraryDlg.this.copyListSelection(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_libObjs, LibraryDlg.this.d_mediator, LibraryDlg.this.d_libModel);
            if (changed) {
                LibraryDlg.this.d_libUnsaved = true;
            }
            Application.getApp().endWaitCursor();
        }
    }

    private class LoadFromLibraryAction
    implements ActionListener {
        private LoadFromLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Application.getApp().beginWaitCursor();
            LibraryDlg.this.copyListSelection(LibraryDlg.this.d_libObjs, LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_libModel, LibraryDlg.this.d_mediator);
            Application.getApp().endWaitCursor();
        }
    }

    private class SaveLibraryAction
    implements ActionListener {
        private SaveLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LibraryDlg.this.saveLibrary();
        }
    }

    private class LoadLibraryAction
    implements ActionListener {
        private LoadLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (LibraryDlg.this.loadLibraryModel()) {
                LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
            }
        }
    }

    private class CreateLibraryAction
    implements ActionListener {
        private CreateLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LibraryDlg.this.createLibrary();
            LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LibraryDlg.this.d_status = 8;
        }
    }

    public static abstract class AMgrRetriever<T extends IPyroObject>
    implements IMgrRetriever<T> {
        private final Class<T> d_type;
        private final String d_desc;
        private final Predicate<T> d_filter;

        public AMgrRetriever(String desc, Class<T> type) {
            this(desc, type, null);
        }

        public AMgrRetriever(String desc, Class<T> type, Predicate<T> filter) {
            this.d_desc = desc;
            this.d_filter = filter;
            this.d_type = type;
        }

        @Override
        public String getDescription() {
            return this.d_desc;
        }

        @Override
        public Class<T> getType() {
            return this.d_type;
        }

        @Override
        public Predicate<T> getFilter() {
            return this.d_filter;
        }
    }

    public static interface IMgrRetriever<T extends IPyroObject> {
        public String getDescription();

        public Composite<T> getManager(PyroMod var1);

        public Class<T> getType();

        public Predicate<T> getFilter();
    }
}

