/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import pyrosim.Intl;
import pyrosim.domain.AWriteablePyroObject;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.BitOptions;

public class CustomFDSPanel
extends guiPanel
implements Modifiable {
    private static final long serialVersionUID = 967771464268406086L;
    public static final int FORCE_WRITE = 1;
    public static final int DISPLAY_TITLE = 2;
    public static final int INSET_BORDER = 4;
    private final String MULTIPLE = Intl.intl("<multiple>");
    private final BitOptions d_options;
    private guiTable d_table;
    private guiCheckBox d_forceWrite;
    private String d_implicitRecordType;
    private Map<Integer, AAdvancedObjPanel> d_advancedProps;
    private Set<String> d_loadedTypes = Collections.emptySet();

    public CustomFDSPanel(int options) {
        this.d_advancedProps = new LinkedHashMap<Integer, AAdvancedObjPanel>();
        this.d_options = new BitOptions(options);
        this.initGui(Collections.EMPTY_SET, this.d_options);
    }

    public void clear() {
        if (this.d_table != null) {
            ((guiDefaultTableModel)this.d_table.getModel()).setRowCount(0);
        }
        this.setModified(false);
    }

    protected void initGui(Set<String> recordTypes, BitOptions options) {
        this.removeAll();
        if (recordTypes.size() > 1) {
            this.d_table = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Record"), Intl.intl("Name"), Intl.intl("Value")}, new Class[]{String.class, String.class, String.class});
            this.d_table.setColumnOptions(0, recordTypes);
            this.d_implicitRecordType = null;
        } else {
            this.d_implicitRecordType = !recordTypes.isEmpty() ? recordTypes.iterator().next() : null;
            this.d_table = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Name"), Intl.intl("Value")}, new Class[]{String.class, String.class});
        }
        guiTableEditor editor = new guiTableEditor(this.d_table, 22);
        this.d_table.getParent().setPreferredSize(new Dimension(150, 1));
        this.d_table.setPreferredScrollableViewportSize(new Dimension(150, editor.getPreferredSize().height));
        GridBagHelper gb = new GridBagHelper(this, options.get(4L));
        if (options.get(2L)) {
            Object recordTypesDesc = "";
            for (String rt : recordTypes) {
                if (!((String)recordTypesDesc).isEmpty()) {
                    recordTypesDesc = (String)recordTypesDesc + ",";
                }
                recordTypesDesc = (String)recordTypesDesc + rt;
            }
            String title = String.format(Intl.intl("Additional Fields (%s)"), recordTypesDesc);
            gb.addFilledRow(new TitleSeparator(title));
            gb.indent();
        }
        this.d_advancedProps.clear();
        this.populateAdvancedObjPanels(options);
        if (options.get(1L)) {
            gb.addRow(this.d_advancedProps.get(1));
        }
        gb.addRow(editor, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.finalizeRows();
    }

    public Set<String> getLoadedTypes() {
        return this.d_loadedTypes;
    }

    public void load(ICustomFDSPropsContainer ... objs) {
        this.load(Arrays.asList(objs));
    }

    public void load(Collection<? extends ICustomFDSPropsContainer> objs) {
        this.load(objs, new AdvPropWrapper[0]);
    }

    public void load(Collection<? extends ICustomFDSPropsContainer> objs, AdvPropWrapper ... advanced) {
        Map<String, Map<String, String>> allProps = this.mergeProps(objs);
        this.d_loadedTypes = new HashSet<String>(allProps.keySet());
        this.initGui(this.d_loadedTypes, new BitOptions(this.d_options.getRaw() | (long)this.getAdvOptions(advanced)));
        allProps.entrySet().stream().forEachOrdered(e -> this.load((String)e.getKey(), (Map)e.getValue()));
        this.loadAdvancedObjPanels(advanced);
    }

    public boolean setTypes(Collection<String> types) {
        HashSet<String> newTypes = new HashSet<String>(types);
        if (newTypes.equals(this.d_loadedTypes)) {
            return false;
        }
        Map<String, Map<String, String>> allProps = this.save();
        boolean modified = allProps.values().stream().anyMatch(m -> !m.isEmpty());
        allProps.keySet().retainAll(newTypes);
        boolean pmodified = this.isModified();
        this.initGui(newTypes, this.d_options);
        allProps.entrySet().stream().forEachOrdered(e -> this.load((String)e.getKey(), (Map)e.getValue()));
        this.d_loadedTypes = newTypes;
        if (pmodified) {
            this.setModified(true);
        }
        return modified;
    }

    private Map<String, Map<String, String>> mergeProps(Collection<? extends ICustomFDSPropsContainer> objs) {
        LinkedHashMap<String, Map<String, String>> allProps = new LinkedHashMap<String, Map<String, String>>();
        String UNDETERMINED = "";
        Function<String, Map> absentMapper = str -> new LinkedHashMap(1);
        for (ICustomFDSPropsContainer iCustomFDSPropsContainer : objs) {
            Collection<String> collection = iCustomFDSPropsContainer.getCustomFDSTypes();
            for (String otype : collection) {
                Map tprops = allProps.computeIfAbsent(otype, absentMapper);
                CustomFDSProps cprops = iCustomFDSPropsContainer.getCustomFDSProps(otype);
                for (Map.Entry<String, String> entry : cprops.getProps().entrySet()) {
                    tprops.put(entry.getKey(), "");
                }
            }
        }
        HashSet openTypes = new HashSet(allProps.keySet());
        for (ICustomFDSPropsContainer iCustomFDSPropsContainer : objs) {
            Collection<String> otypes = iCustomFDSPropsContainer.getCustomFDSTypes();
            Iterator it = openTypes.iterator();
            while (it.hasNext()) {
                String rtype = (String)it.next();
                if (!otypes.contains(rtype)) continue;
                int multipleCount = 0;
                Map mprops = (Map)allProps.get(rtype);
                Map<String, String> oprops = iCustomFDSPropsContainer.getCustomFDSProps(rtype).getProps();
                for (Map.Entry entry : mprops.entrySet()) {
                    String mval = (String)entry.getValue();
                    if (mval == this.MULTIPLE) {
                        ++multipleCount;
                        continue;
                    }
                    String oval = oprops.get(entry.getKey());
                    if (oval != null && mval == "") {
                        entry.setValue(oval);
                        continue;
                    }
                    if (oval != null && oval.equals(mval)) continue;
                    entry.setValue(this.MULTIPLE);
                    ++multipleCount;
                }
                if (multipleCount != mprops.size()) continue;
                it.remove();
            }
            if (!openTypes.isEmpty()) continue;
            return allProps;
        }
        return allProps;
    }

    protected void load(String recordType, Map<String, String> props) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int row = model.getRowCount();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            int col = 0;
            if (this.d_table.getColumnCount() == 3) {
                model.setValueAt(recordType, row, col++);
            }
            model.setValueAt(entry.getKey(), row, col++);
            model.setValueAt(entry.getValue(), row, col++);
            ++row;
        }
        this.setModified(false);
    }

    public void save(ICustomFDSPropsContainer ... objs) {
        this.save(Arrays.asList(objs));
    }

    public void save(Collection<? extends ICustomFDSPropsContainer> objs) {
        if (!this.isModified()) {
            return;
        }
        Map<String, Map<String, String>> allProps = this.save();
        HashSet completeTypes = new HashSet();
        allProps.forEach((rtype, props) -> {
            if (props.values().stream().allMatch(v -> v != this.MULTIPLE)) {
                completeTypes.add(rtype);
            }
        });
        for (ICustomFDSPropsContainer iCustomFDSPropsContainer : objs) {
            Collection<String> otypes = iCustomFDSPropsContainer.getCustomFDSTypes();
            for (String otype : otypes) {
                LinkedHashMap<String, String> rprops;
                LinkedHashMap<String, String> mprops = allProps.get(otype);
                if (completeTypes.contains(otype)) {
                    rprops = mprops;
                } else if (mprops == null) {
                    rprops = Collections.EMPTY_MAP;
                } else {
                    rprops = new LinkedHashMap<String, String>(iCustomFDSPropsContainer.getCustomFDSProps(otype).getProps());
                    for (Map.Entry entry : mprops.entrySet()) {
                        if (entry.getValue() == this.MULTIPLE) continue;
                        rprops.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    rprops.keySet().retainAll(mprops.keySet());
                }
                iCustomFDSPropsContainer.setCustomFDSProps(otype, CustomFDSProps.get((Map<String, String>)rprops));
            }
        }
        this.saveAdvanced(objs);
    }

    protected void saveAdvanced(Collection<? extends ICustomFDSPropsContainer> objs) {
        if (this.d_advancedProps.containsKey(1)) {
            for (ICustomFDSPropsContainer iCustomFDSPropsContainer : objs) {
                if (!(iCustomFDSPropsContainer instanceof AWriteablePyroObject)) continue;
                ((AWriteablePyroObject)((Object)iCustomFDSPropsContainer)).setForceWrite((Boolean)this.getAdvancedObjValue(1));
            }
        }
    }

    protected Map<String, Map<String, String>> save() {
        LinkedHashMap<String, Map<String, String>> allProps = new LinkedHashMap<String, Map<String, String>>();
        Function<String, Map> absentFunc = k -> new LinkedHashMap();
        int numRows = this.d_table.getRowCount();
        for (int row = 0; row < numRows; ++row) {
            String value;
            String key;
            int col = 0;
            String type = this.d_implicitRecordType;
            if (this.d_table.getColumnCount() == 3) {
                type = (String)this.d_table.getValueAt(row, col++);
            }
            if (type == null) continue;
            Map mprops = allProps.computeIfAbsent(type, absentFunc);
            if ((key = (String)this.d_table.getValueAt(row, col++)) == null || key.trim().isEmpty()) continue;
            if ((value = (String)this.d_table.getValueAt(row, col++)) == null || value.trim().isEmpty()) {
                value = this.MULTIPLE;
            }
            mprops.put(key, value);
        }
        return allProps;
    }

    public Object getAdvancedObjValue(int option) {
        if (this.d_advancedProps.get(option) != null) {
            AAdvancedObjPanel pnl = this.d_advancedProps.get(option);
            return pnl.getValue();
        }
        return null;
    }

    private void populateAdvancedObjPanels(BitOptions options) {
        if (options.get(1L)) {
            AdvancedCheckBoxPanel op = new AdvancedCheckBoxPanel(Intl.intl("Always Write FDS Record"));
            this.d_advancedProps.put(1, op);
        }
    }

    private void loadAdvancedObjPanels(AdvPropWrapper ... rappers) {
        for (AdvPropWrapper wrapper : rappers) {
            this.d_advancedProps.get(wrapper.getOption()).load(wrapper.getObj());
        }
    }

    private int getAdvOptions(AdvPropWrapper ... rappers) {
        int opt = 0;
        for (AdvPropWrapper prop : rappers) {
            opt |= prop.getOption();
        }
        return opt;
    }

    public static class AdvPropWrapper<T> {
        private int option;
        private T obj;

        public AdvPropWrapper(T obj, int opt) {
            this.obj = obj;
            this.option = opt;
        }

        public int getOption() {
            return this.option;
        }

        public T getObj() {
            return this.obj;
        }
    }

    private class AdvancedCheckBoxPanel
    extends AAdvancedObjPanel<Boolean> {
        private static final long serialVersionUID = -201726824989459104L;
        private guiCheckBox d_optCB;

        public AdvancedCheckBoxPanel(String lbl) {
            this.setLayout(new GridBagLayout());
            GridBagHelper gbh = new GridBagHelper(this);
            this.d_optCB = new guiCheckBox(lbl);
            gbh.addRow(this.d_optCB);
            gbh.finalizeRows();
        }

        @Override
        public void load(Boolean b) {
            this.d_optCB.setSelected(b);
            this.setModified(false);
        }

        @Override
        public Boolean getValue() {
            return this.d_optCB.isSelected();
        }
    }

    private abstract class AAdvancedObjPanel<T>
    extends guiPanel {
        private static final long serialVersionUID = -6764100768120926352L;

        private AAdvancedObjPanel() {
        }

        public abstract T getValue();

        public abstract void load(T var1);
    }
}

