/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitPoint3D;

public class ScaleTask
extends TransformTask {
    private final Point3d d_base;
    private final Tuple3d d_scale;

    public ScaleTask(PyroMod mediator, Collection<? extends IPyroObject> objects, int n, UnitPoint3D base, Tuple3d scale) {
        super(mediator, objects, n);
        this.d_base = base.getPoint3dValue(Geometry.LU);
        this.d_scale = new Vector3d(scale);
    }

    @Override
    public ITransform getXFormForIteration(int i) {
        double scalex = Math.pow(this.d_scale.x, i);
        double scaley = Math.pow(this.d_scale.y, i);
        double scalez = Math.pow(this.d_scale.z, i);
        ITransform xform = TransformUtil.translate(this.d_base.x, this.d_base.y, this.d_base.z);
        xform = xform.concatenate(TransformUtil.scale(scalex, scaley, scalez));
        xform = xform.concatenate(TransformUtil.translate(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return xform;
    }

    private static class Transform {
        private Tuple3d d_scale;
        private Matrix4d d_matrix;

        private Transform() {
        }
    }
}

