/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.tasks.InsertTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.Tasks;
import thunderheadeng.geometry.objs.node.GeomNodesMerger;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GroupGeomTask
extends CompositeTask<PyroMod> {
    public GroupGeomTask(PyroMod mediator, Collection<? extends IModelObj> objs, ConvertType convertType) {
        super(mediator);
        IModelObj result = convertType == ConvertType.GENERIC ? this.merge(theUtil.filter(objs, GenericGeomSrc.class)) : this.merge(theUtil.filter(objs, FDSObject.class), convertType);
        Pair<ModelComposite, Integer> insert = GroupGeomTask.getInsertInfo(objs);
        SelectTask task = new SelectTask(mediator, result);
        task.addTask(Tasks.delete(objs));
        task.addTask(new InsertTask((IPyroObject)insert.v1, ((Integer)insert.v2).intValue(), new IPyroObject[]{result}));
        this.addTask(task);
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<ModelComposite, Integer> getInsertInfo(Collection<? extends IModelObj> objs) {
        IPyroObject parent = Hierarchy.getCommonParent(objs);
        assert (parent instanceof ModelComposite);
        ModelComposite cparent = (ModelComposite)parent;
        IdentityHashMap<IPyroObject, Integer> ixMap = new IdentityHashMap<IPyroObject, Integer>();
        int ix = 0;
        for (IPyroObject member : cparent.getMembers()) {
            ixMap.put(member, ix++);
        }
        int index = cparent.getMembers().size();
        for (IPyroObject iPyroObject : objs) {
            void var7_8;
            IPyroObject oparent = iPyroObject.getParent();
            while (oparent != null && oparent != cparent) {
                IPyroObject iPyroObject2 = oparent;
                oparent = iPyroObject2.getParent();
            }
            assert (oparent == cparent);
            assert (ixMap.containsKey(var7_8));
            int oix = (Integer)ixMap.get(var7_8);
            if (oix >= index) continue;
            index = oix;
        }
        return new Pair<ModelComposite, Integer>(cparent, index);
    }

    private PyroMod getDomain() {
        return (PyroMod)this.getDomains().iterator().next();
    }

    private GenericGeomSrc merge(Collection<? extends GenericGeomSrc> objs) {
        assert (!objs.isEmpty());
        if (objs.size() == 1) {
            return objs.iterator().next();
        }
        GeomNodesMerger builder = new GeomNodesMerger();
        PropsBuilder props = new PropsBuilder();
        for (GenericGeomSrc genericGeomSrc : objs) {
            IGeomNode geom = genericGeomSrc.getGeom();
            int numPrims = geom.getNumPrims(7);
            props.add(genericGeomSrc.getDisplayProps(), numPrims);
            builder.add(geom, numPrims);
        }
        IGeomNode node = builder.finish();
        return new GenericGeomSrc(objs.iterator().next().getName(), node, props.finalizeProps());
    }

    private FDSObject merge(Collection<? extends FDSObject> objs, ConvertType convertType) {
        Surface inert = this.getDomain().getSurfaceMgr().get(PredefSurf.INERT);
        ArrayList<Surface> surfs = new ArrayList<Surface>(objs.size());
        ArrayList<Color> colors = new ArrayList<Color>(objs.size());
        GeomNodesMerger builder = new GeomNodesMerger();
        for (FDSObject fDSObject : objs) {
            Surface[] subSurfs;
            IGeomNode objGeom = fDSObject.getGeom();
            int numFaces = objGeom.getNumPrims(1);
            Color[] subColors = GroupGeomTask.flatten(Color.class, fDSObject.getColors(), fDSObject.getGeom().getNumPrims(7));
            if (fDSObject instanceof IObstruction) {
                IObstruction obst = (IObstruction)fDSObject;
                subSurfs = GroupGeomTask.flatten(Surface.class, obst.getSurfaces(), numFaces);
            } else {
                subSurfs = new Surface[numFaces];
                for (int m = 0; m < subSurfs.length; ++m) {
                    subSurfs[m] = inert;
                }
            }
            surfs.addAll(Arrays.asList(subSurfs));
            colors.addAll(Arrays.asList(subColors));
            builder.add(objGeom, numFaces);
        }
        Color[] colorsArr = GeomUtil.optimize(colors.toArray(new Color[colors.size()]));
        Surface[] surfaceArray = GeomUtil.optimize(surfs.toArray(new Surface[surfs.size()]));
        IGeomNode newGeom = builder.finish().bakeIfRecommended();
        return convertType == ConvertType.OBSTRUCTION ? GroupGeomTask.convertToObst(objs, newGeom, colorsArr, surfaceArray) : GroupGeomTask.convertToHole(objs, newGeom, colorsArr);
    }

    private static IObstruction convertToObst(Collection<? extends FDSObject> objs, IGeomNode geom, Color[] colors, Surface[] surfs) {
        IObstruction result;
        IFilteredCollection<IObstruction> obsts = theUtil.filter(objs, IObstruction.class);
        if (!obsts.isEmpty()) {
            IObstruction baseObst = (IObstruction)obsts.iterator().next();
            result = (IObstruction)baseObst.clone();
            result.setGeom(geom);
            result.setSurfaces(surfs);
        } else {
            result = new Obstruction(Intl.intl("Obstruction"), geom, surfs);
        }
        result.setColors(colors);
        return result;
    }

    private static IHole convertToHole(Collection<? extends FDSObject> objs, IGeomNode geom, Color[] colors) {
        IHole result;
        IFilteredCollection<IHole> holes = theUtil.filter(objs, IHole.class);
        if (!holes.isEmpty()) {
            IHole baseHole = (IHole)holes.iterator().next();
            result = (IHole)baseHole.clone();
            result.setGeom(geom);
        } else {
            result = new Hole(Intl.intl("Hole"), geom);
        }
        result.setColors(colors);
        return result;
    }

    private static <T> T[] flatten(Class<T> clazz, T[] baseArr, int count) {
        if (baseArr.length == 1 && count != 1) {
            Object[] newArr = (Object[])Array.newInstance(clazz, count);
            for (int m = 0; m < count; ++m) {
                newArr[m] = baseArr[0];
            }
            return newArr;
        }
        assert (baseArr.length == count);
        return baseArr;
    }

    public static enum ConvertType {
        HOLE,
        OBSTRUCTION,
        GENERIC;

    }
}

