/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.Tasks;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.IPropertySet;

public class ExplodeTask
extends CompositeTask<PyroMod> {
    public ExplodeTask(PyroMod mediator, Collection<? extends IModelObj> objs) {
        super(mediator);
        ObstDecorator obstDec = new ObstDecorator();
        EmptyDecorator holeDec = new EmptyDecorator();
        ArrayList<IPyroObject> addObjs = new ArrayList<IPyroObject>();
        ArrayList<IModelObj> delObjs = new ArrayList<IModelObj>();
        for (IModelObj iModelObj : objs) {
            IPyroObject toAdd;
            List<IGeomNode> explodedGeom = ExplodeTask.explodeGeom(iModelObj);
            if (explodedGeom == null) continue;
            List<IModelObj> newObjs = Collections.EMPTY_LIST;
            if (iModelObj instanceof IObstruction) {
                newObjs = ExplodeTask.explodeFDSObject((IObstruction)iModelObj, explodedGeom, obstDec);
            } else if (iModelObj instanceof IHole) {
                newObjs = ExplodeTask.explodeFDSObject((IHole)iModelObj, explodedGeom, holeDec);
            } else if (iModelObj instanceof GenericGeomSrc) {
                newObjs = ExplodeTask.explode((GenericGeomSrc)iModelObj, explodedGeom);
            }
            if (newObjs.size() == 1) {
                toAdd = newObjs.get(0);
            } else {
                ModelComposite group = new ModelComposite(iModelObj.getName());
                group.addAll(newObjs);
                toAdd = group;
            }
            delObjs.add(iModelObj);
            addObjs.add(toAdd);
        }
        if (!addObjs.isEmpty()) {
            SelectTask task = new SelectTask(mediator, addObjs);
            task.addTask(Tasks.replace(delObjs, addObjs, true));
            this.addTask(task);
        }
    }

    private static List<GenericGeomSrc> explode(GenericGeomSrc obj, List<IGeomNode> explodedGeoms) {
        IPropsSrc masterProps = obj.getDisplayProps();
        ArrayList<GenericGeomSrc> result = new ArrayList<GenericGeomSrc>(explodedGeoms.size());
        int primOffset = 0;
        for (IGeomNode geom : explodedGeoms) {
            int numPrims = geom.getNumPrims(7);
            PropsBuilder props = new PropsBuilder();
            props.add(masterProps.subset(primOffset, numPrims), numPrims);
            IPropsSrc newProps = props.finalizeProps();
            GenericGeomSrc newObj = (GenericGeomSrc)obj.clone();
            newObj.setGeom(geom.bakeIfRecommended());
            newObj.setDisplayProps(newProps);
            result.add(newObj);
            primOffset += numPrims;
        }
        return result;
    }

    private static <T extends FDSObject> List<T> explodeFDSObject(T obj, List<IGeomNode> explodedGeoms, Decorator<T> decorator) {
        Color[] colors = obj.getColors();
        int colorIx = 0;
        decorator.begin(obj);
        ArrayList<FDSObject> newObjs = new ArrayList<FDSObject>(explodedGeoms.size());
        for (IGeomNode geomObj : explodedGeoms) {
            int numColors = geomObj.getNumPrims(7);
            Color[] subColors = ExplodeTask.subArray(colors, colorIx, numColors);
            subColors = GeomUtil.optimize(subColors);
            colorIx += numColors;
            FDSObject newObj = (FDSObject)obj.clone();
            newObj.setGeom(geomObj.bakeIfRecommended());
            newObj.setColors(subColors);
            decorator.decorateNext(newObj);
            newObjs.add(newObj);
        }
        return newObjs;
    }

    /*
     * WARNING - void declaration
     */
    private static List<IGeomNode> explodeGeom(IPyroGeomSrc obj) {
        boolean canExplodeGeom;
        IGeomNode node = obj.getGeom();
        boolean bl = canExplodeGeom = node.getLocalGeom() instanceof GeomGroup && node.getLocalGeom().canExplode();
        if (!canExplodeGeom && node.getChildren().isEmpty()) {
            return null;
        }
        ArrayList<IGeomNode> result = new ArrayList<IGeomNode>();
        TransformInfo xform = node.getLocalTransform().getInfo();
        IPropertySet elements = node.getLocalElements();
        if (canExplodeGeom) {
            ArrayList<IGeom> resultGeom = new ArrayList<IGeom>();
            node.getLocalGeom().explode(resultGeom);
            boolean bl2 = false;
            for (IGeom geom : resultGeom) {
                void var7_8;
                int numPrims = geom.getNumPrims(7);
                ElementsBuilder elBuilder = new ElementsBuilder();
                elBuilder.addRange(elements, (int)var7_8, numPrims);
                GeomNodeLeaf rnode = GeomNodeUtil.newNode(xform.xform, geom, elBuilder.finish());
                result.add(rnode);
                var7_8 += numPrims;
            }
        }
        for (IGeomNode iGeomNode : node.getChildren()) {
            result.add(iGeomNode.transform(xform));
        }
        return result;
    }

    private static <T> T[] subArray(T[] baseArray, int offset, int count) {
        if (baseArray.length == 1) {
            return baseArray;
        }
        return Arrays.copyOfRange(baseArray, offset, offset + count);
    }

    private static class EmptyDecorator<T extends FDSObject>
    implements Decorator<T> {
        private EmptyDecorator() {
        }

        @Override
        public void begin(T obj) {
        }

        @Override
        public void decorateNext(T newObj) {
        }
    }

    private static class ObstDecorator
    implements Decorator<IObstruction> {
        private Surface[] d_surfs;
        private int d_surfIx;

        private ObstDecorator() {
        }

        @Override
        public void begin(IObstruction obj) {
            this.d_surfs = obj.getSurfaces();
            this.d_surfIx = 0;
        }

        @Override
        public void decorateNext(IObstruction newObj) {
            int numSurfs = newObj.getGeom().getNumPrims(1);
            Surface[] subSurfs = ExplodeTask.subArray(this.d_surfs, this.d_surfIx, numSurfs);
            subSurfs = GeomUtil.optimize(subSurfs);
            this.d_surfIx += numSurfs;
            newObj.setSurfaces(subSurfs);
        }
    }

    private static interface Decorator<T extends FDSObject> {
        public void begin(T var1);

        public void decorateNext(T var1);
    }
}

