/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.reaction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefaultProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Reaction
extends NamedPyroObject
implements Serializable,
ICustomFDSPropsContainer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final VariantProfile AUTO_IGNIT_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 1, new UnitDouble(-273.0, SI.CELSIUS)));
    public static final VariantProfile HEAT_OF_COMB_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 48, null));
    public static final VariantProfile HRRPUA_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 22, null));
    public static final VariantProfile HRRPUV_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 25, null));
    public static final VariantProfile RADIATIVE_FRAC_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 28, SIUS.newud(0.35, 28)));
    private String d_fyi;
    private boolean d_active;
    private ReacType d_type;
    private ExSpec d_fuel;
    @Deprecated
    private double d_H;
    @Deprecated
    private double d_C;
    @Deprecated
    private double d_O;
    @Deprecated
    private double d_N;
    private UnitDouble d_ambMassFracO2;
    private UnitDouble d_ambMassFracCO2;
    private boolean d_suppression;
    private Variant d_autoIgnitionTemp;
    private UnitDouble d_critFlameTemp;
    @Deprecated
    private UnitDouble d_hrrpuaSheet;
    @Deprecated
    private UnitDouble d_hrrpuvAvg;
    private double d_coYield;
    private double d_sootYield;
    private EnergyRelease d_energyType;
    private UnitDouble d_epumo2;
    private Variant d_heatOfCombustion;
    private boolean d_ideal;
    private Variant d_radiativeFraction;
    private double d_hcnYield;
    @Deprecated
    private double d_sootHFraction;
    private Map<ExSpec, Double> d_stoichiometryMap;
    private CustomFDSProps d_customFDSProps;
    private boolean d_isPredefined;

    public Reaction(String name, ReacType type) {
        this(name, false, type);
    }

    public Reaction(String name, boolean predefined, ReacType type) {
        super(name);
        this.d_type = type;
        this.d_isPredefined = predefined;
        this.setFuel(null);
        this.setFuelComp(0.0, 0.0, 0.0, 0.0);
        this.setSuppression(true);
        this.setCritFlameTemp(new UnitDouble(1427.0, SI.CELSIUS));
        this.d_autoIgnitionTemp = AUTO_IGNIT_PROF.getDefault();
        this.setHrrpuaSheet(new UnitDouble(200.0, SI.KILO(SI.WATT).divide(SI.METER.pow(2))));
        this.setHrrpuvAvg(new UnitDouble(2500.0, SI.KILO(SI.WATT).divide(SI.METER.pow(3))));
        this.setCOYield(0.0);
        this.setSootYield(0.0);
        this.setHCNYield(0.0);
        this.setEpumo2(new UnitDouble(13100.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM)));
        this.d_heatOfCombustion = HEAT_OF_COMB_PROF.getDefault();
        this.setEnergyType(EnergyRelease.EPUMO2);
        this.setIdeal(false);
        this.setSootHFraction(0.1);
        this.d_radiativeFraction = RADIATIVE_FRAC_PROF.getDefault();
        this.d_customFDSProps = CustomFDSProps.EMPTY;
        this.d_stoichiometryMap = new LinkedHashMap<ExSpec, Double>();
    }

    public boolean isFirst(ReactionList reactions) {
        return reactions.flatten().isEmpty() || reactions.flatten().size() == 1 && reactions.flatten().iterator().next() == this;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("REAC");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Reaction)) {
            return false;
        }
        Reaction r = (Reaction)obj;
        return super.equals(obj) && this.d_customFDSProps.equals(r.d_customFDSProps);
    }

    public void imprint(Reaction reac) {
        this.setFYI(reac.getFYI());
        this.setReacType(reac.getReacType());
        this.setCOYield(reac.getCOYield());
        this.setSootYield(reac.getSootYield());
        this.setHCNYield(reac.getHCNYield());
        this.setFuelComp(reac.getH(), reac.getC(), reac.getO(), reac.getN());
        if (reac.getAutoIgnitionTemp().isConstant()) {
            this.setAutoIgnitionTemp((UnitDouble)reac.getAutoIgnitionTemp().val);
        }
        this.setCritFlameTemp(reac.getCritFlameTemp());
        this.setEpumo2(reac.getEpumo2());
        this.setEnergyType(reac.getEnergyType());
        this.setFuel(reac.getFuel());
        if (reac.getHeatOfCombustion().isConstant()) {
            this.setHeatOfCombustion((UnitDouble)reac.getHeatOfCombustion().val);
        }
        this.setHrrpuaSheet(reac.getHrrpuaSheet());
        this.setHrrpuvAvg(reac.getHrrpuvAvg());
        this.setIdeal(reac.isIdeal());
        if (reac.getRadiativeFraction().isConstant()) {
            this.setRadiativeFraction((UnitDouble)reac.getRadiativeFraction().val);
        }
        this.setSootHFraction(reac.getSootHFraction());
        this.setSuppression(reac.allowSuppression());
        this.setComplexStoichiometry(reac.getComplexStoichiometry());
        this.setCustomFDSProps(reac.getCustomFDSProps());
        this.changedEvt(new Object[0]);
    }

    public boolean isActive() {
        return this.d_active;
    }

    public void setActive(boolean active) {
        this.d_active = active;
        this.changedEvt(new Object[0]);
    }

    public boolean isPredefined() {
        return this.d_isPredefined;
    }

    public ExSpec getFuel() {
        return this.d_fuel;
    }

    public String getGenericFuelName() {
        return this.getName() + Intl.intl("_fuel");
    }

    public void setFuel(ExSpec spec) {
        this.d_fuel = spec;
    }

    public void setFuelComp(double H, double C, double O, double N) {
        this.setH(H);
        this.setC(C);
        this.setO(O);
        this.setN(N);
    }

    public double getH() {
        return this.d_H;
    }

    public void setH(double h) {
        this.d_H = h;
    }

    public double getC() {
        return this.d_C;
    }

    public void setC(double c) {
        this.d_C = c;
    }

    public double getO() {
        return this.d_O;
    }

    public void setO(double o) {
        this.d_O = o;
    }

    public double getN() {
        return this.d_N;
    }

    public void setN(double n) {
        this.d_N = n;
    }

    public boolean allowSuppression() {
        return this.d_suppression;
    }

    public void setSuppression(boolean suppression) {
        this.d_suppression = suppression;
    }

    public Variant getAutoIgnitionTemp() {
        return this.d_autoIgnitionTemp;
    }

    public void setAutoIgnitionTemp(UnitDouble autoIgnitionTemp) {
        this.d_autoIgnitionTemp = Variant.constant(autoIgnitionTemp);
    }

    public UnitDouble getCritFlameTemp() {
        return this.d_critFlameTemp;
    }

    public void setCritFlameTemp(UnitDouble critFlameTemp) {
        this.d_critFlameTemp = critFlameTemp;
    }

    public UnitDouble getHrrpuaSheet() {
        return this.d_hrrpuaSheet;
    }

    public void setHrrpuaSheet(UnitDouble hrrpuaSheet) {
        this.d_hrrpuaSheet = hrrpuaSheet;
    }

    public UnitDouble getHrrpuvAvg() {
        return this.d_hrrpuvAvg;
    }

    public void setHrrpuvAvg(UnitDouble hrrpuaAvg) {
        this.d_hrrpuvAvg = hrrpuaAvg;
    }

    public Variant getRadiativeFraction() {
        return this.d_radiativeFraction;
    }

    public void setRadiativeFraction(UnitDouble radFrac) {
        this.d_radiativeFraction = radFrac == null ? RADIATIVE_FRAC_PROF.getDefault() : Variant.constant(radFrac);
    }

    public double getCOYield() {
        return this.d_coYield;
    }

    public void setCOYield(double coYield) {
        this.d_coYield = coYield;
    }

    public double getSootYield() {
        return this.d_sootYield;
    }

    public void setSootYield(double sootYield) {
        this.d_sootYield = sootYield;
    }

    public double getHCNYield() {
        return this.d_hcnYield;
    }

    public void setHCNYield(double hcnYield) {
        this.d_hcnYield = hcnYield;
    }

    @Deprecated
    public double getSootHFraction() {
        return this.d_sootHFraction;
    }

    @Deprecated
    public void setSootHFraction(double sootHFraction) {
        this.d_sootHFraction = sootHFraction;
    }

    public EnergyRelease getEnergyType() {
        return this.d_energyType;
    }

    public void setEnergyType(EnergyRelease type) {
        this.d_energyType = type;
    }

    public UnitDouble getEpumo2() {
        return this.d_epumo2;
    }

    public void setEpumo2(UnitDouble epumo2) {
        this.d_epumo2 = epumo2;
    }

    public Variant getHeatOfCombustion() {
        return this.d_heatOfCombustion;
    }

    public void setHeatOfCombustion(UnitDouble heatOfCombustion) {
        if (heatOfCombustion == null) {
            this.d_heatOfCombustion = Variant.DEFAULT;
            this.d_energyType = EnergyRelease.EPUMO2;
            this.setEpumo2(new UnitDouble(13100.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM)));
        } else {
            this.d_heatOfCombustion = Variant.constant(heatOfCombustion);
        }
    }

    public boolean isIdeal() {
        return this.d_ideal;
    }

    public void setIdeal(boolean ideal) {
        this.d_ideal = ideal;
    }

    public ReacType getReacType() {
        return this.d_type;
    }

    public void setReacType(ReacType type) {
        this.d_type = type;
    }

    public boolean isSimpleChemReaction() {
        return this.d_type.equals((Object)ReacType.SIMPLE);
    }

    public boolean isComplexChemReaction() {
        return this.d_type.equals((Object)ReacType.COMPLEX);
    }

    public Map<ExSpec, Double> getComplexStoichiometry() {
        return this.d_stoichiometryMap;
    }

    public void setComplexStoichiometry(Map<ExSpec, Double> chem) {
        this.d_stoichiometryMap = chem;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        if (this.getReacType().equals((Object)ReacType.SIMPLE)) {
            deps.add(DLink.REQUIRED, (IPyroObject)this.d_fuel);
        } else if (this.getReacType().equals((Object)ReacType.COMPLEX)) {
            for (ExSpec spec : this.d_stoichiometryMap.keySet()) {
                deps.add(DLink.WEAK, (IPyroObject)spec);
            }
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof ExSpec) {
            if (this.getReacType().equals((Object)ReacType.SIMPLE)) {
                Util.keepIfNullOr(objs, ExSpec.class);
            } else if (this.getReacType().equals((Object)ReacType.COMPLEX)) {
                Util.keepIf(objs, o -> o instanceof ExSpec && !this.d_stoichiometryMap.containsKey(o));
            }
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (old instanceof ExSpec) {
            return new AReplaceRefTask<ExSpec>((Object)old, (Object)replacement){
                private boolean isFuel;
                private boolean isChem;
                {
                    super(old2, repl);
                    this.isFuel = theUtil.equal(Reaction.this.getFuel(), old);
                    this.isChem = Reaction.this.getComplexStoichiometry().containsKey(old);
                }

                @Override
                protected void set(ExSpec obj) {
                    ExSpec setSpec;
                    ExSpec exSpec = setSpec = obj == null ? ExSpecList.getDefaultFuel(true) : obj;
                    if (this.isFuel) {
                        Reaction.this.setFuel(setSpec);
                    }
                    if (this.isChem) {
                        ExSpec replaceKey = theUtil.equal(old, obj) ? (ExSpec)replacement : (ExSpec)old;
                        Double value = Reaction.this.getComplexStoichiometry().get(replaceKey);
                        if (value == null) {
                            return;
                        }
                        Reaction.this.getComplexStoichiometry().remove(replaceKey);
                        Reaction.this.getComplexStoichiometry().put(obj, value);
                    }
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public String toString() {
        String fuel = this.d_fuel != null ? this.d_fuel.getName() : "null";
        return String.format("%s[name=%s,active=%s,predefined=%s,fuel=%s]", this.getClass().getSimpleName(), this.getName(), this.isActive(), this.isPredefined(), fuel);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_type == null) {
            this.d_type = ReacType.SIMPLE;
        }
        if (this.d_stoichiometryMap == null) {
            this.d_stoichiometryMap = new LinkedHashMap<ExSpec, Double>();
        }
    }

    public static enum ReacType {
        SIMPLE(Intl.intl("Simple Chemistry")),
        COMPLEX(Intl.intl("Complex Stoichiometry"));

        public final String id;

        private ReacType(String id) {
            this.id = id;
        }
    }

    public static enum EnergyRelease {
        EPUMO2,
        HEAT_OF_COMBUSTION;

    }
}

