/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.QuantityCategory;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.Predicates;

public final class Quantity
extends Enum<Quantity> {
    public static final /* enum */ Quantity ABSORPTION_COEFFICIENT = new Quantity(Intl.intl("Absorption Coefficient"), 13, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity ADIABATIC_SURFACE_TEMPERATURE_GAS = new Quantity(Intl.intl("Adiabatic Surface Temperature Gas"), 1, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity ASPIRATION = new Quantity(Intl.intl("Aspiration"), 57, QuantityType.GAS, 0L, true);
    @FDSDeprecated(vFDS="6.6.0", vPyro=121)
    public static final /* enum */ Quantity AVERAGE_SPECIFIC_HEAT = new Quantity(Intl.intl("Average Specific Heat"), 11, QuantityType.GAS, 572234297438568673L);
    @FDSDeprecated(vFDS="6.0.1", vPyro=83)
    public static final /* enum */ Quantity CABLE_TEMPERATURE = new Quantity(Intl.intl("Cable Temperature"), 1, QuantityType.GAS, 0L);
    public static final /* enum */ Quantity CONDUCTIVITY = new Quantity(Intl.intl("Conductivity"), 19, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity DENSITY = new Quantity(Intl.intl("Density"), 4, QuantityType.GAS, 572234297507774945L);
    public static final /* enum */ Quantity DIVERGENCE = new Quantity(Intl.intl("Divergence"), 35, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity ENTHALPY = new Quantity(Intl.intl("Enthalpy"), 62, QuantityType.GAS, 572234297507774689L);
    public static final /* enum */ Quantity SENSIBLE_ENTHALPY = new Quantity(Intl.intl("Sensible Enthalpy"), 62, QuantityType.GAS, 572234297507774689L);
    public static final /* enum */ Quantity EXTINCTION = new Quantity(Intl.intl("Extinction"), 28, QuantityType.GAS, 129L);
    public static final /* enum */ Quantity EXTINCTION_COEFFICIENT = new Quantity(Intl.intl("Extinction Coefficient"), 51, QuantityType.GAS, 572234297438568673L, true);
    public static final /* enum */ Quantity FED = new Quantity(Intl.intl("Fractional Effective Dose (FED)"), 28, QuantityType.GAS, 0x10000E1L, true);
    public static final /* enum */ Quantity FIC = new Quantity(Intl.intl("Fractional Irritant Concentration (FIC)"), 28, QuantityType.GAS, 0x1000001L, true);
    public static final /* enum */ Quantity H = new Quantity(Intl.intl("H"), 36, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity HRRPUL = new Quantity(Intl.intl("Heat Release Rate per Unit Length"), 88, QuantityType.GAS, 572234297438568449L);
    public static final /* enum */ Quantity HRRPUV = new Quantity(Intl.intl("Heat Release Rate per Unit Volume"), 25, QuantityType.GAS, 572234297507774689L);
    public static final /* enum */ Quantity MIXTURE_FRACTION = new Quantity(Intl.intl("Mixture Fraction"), 26, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity OPTICAL_DENSITY = new Quantity(Intl.intl("Optical Density"), 63, QuantityType.GAS, 572234297438568673L, true);
    public static final /* enum */ Quantity PRESSURE = new Quantity(Intl.intl("Pressure"), 39, QuantityType.GAS, 572234297442762977L);
    public static final /* enum */ Quantity BACKGROUND_PRESSURE = new Quantity(Intl.intl("Background Pressure"), 39, QuantityType.GAS, 572234297442762977L);
    public static final /* enum */ Quantity RADIATIVE_HEAT_FLUX_GAS = new Quantity(Intl.intl("Radiative Heat Flux Gas"), 33, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity GAUGE_HEAT_FLUX_GAS = new Quantity(Intl.intl("Gauge Heat Flux Gas"), 33, QuantityType.GAS, 572234297438568465L);
    public static final /* enum */ Quantity RELATIVE_HUMIDITY = new Quantity(Intl.intl("Relative Humidity"), 64, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity SPECIFIC_ENTHALPY = new Quantity(Intl.intl("Specific Enthalpy"), 65, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity SPECIFIC_SENSIBLE_ENTHALPY = new Quantity(Intl.intl("Specific Sensible Enthalpy"), 65, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity SPECIFIC_HEAT = new Quantity(Intl.intl("Specific Heat"), 11, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity TEMPERATURE = new Quantity(Intl.intl("Temperature"), 1, QuantityType.GAS, 572234297438568929L);
    public static final /* enum */ Quantity THERMOCOUPLE = new Quantity(Intl.intl("Thermocouple"), 1, QuantityType.GAS, 572234297438568449L);
    public static final /* enum */ Quantity U_VELOCITY = new Quantity(Intl.intl("U-Velocity"), 8, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity V_VELOCITY = new Quantity(Intl.intl("V-Velocity"), 8, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity W_VELOCITY = new Quantity(Intl.intl("W-Velocity"), 8, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity VELOCITY = new Quantity(Intl.intl("Velocity"), 8, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity VISCOSITY = new Quantity(Intl.intl("Viscosity"), 41, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity VISIBILITY = new Quantity(Intl.intl("Visibility"), 16, QuantityType.GAS, 572234297438568673L, true);
    public static final /* enum */ Quantity ADIABATIC_SURFACE_TEMPERATURE = new Quantity(Intl.intl("Adiabatic Surface Temperature"), 1, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity BACK_WALL_TEMPERATURE = new Quantity(Intl.intl("Back Wall Temperature"), 1, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity BURNING_RATE = new Quantity(Intl.intl("Burning Rate"), 20, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity CONVECTIVE_FLUX = new Quantity(Intl.intl("Convective Heat Flux"), 33, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity FRICTION_VELOCITY = new Quantity(Intl.intl("Friction Velocity"), 28, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity GAS_TEMPERATURE = new Quantity(Intl.intl("Gas Temperature"), 1, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity GAUGE_HEAT_FLUX = new Quantity(Intl.intl("Gauge Heat Flux"), 33, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity HEAT_FLUX = new Quantity(Intl.intl("Net Heat Flux"), 33, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity HEAT_TRANSFER_COEFFICIENT = new Quantity(Intl.intl("Heat Transfer Coefficient"), 22, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity HRRPUA = new Quantity(Intl.intl("Heat Release Rate per Unit Area"), 22, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity INCIDENT_HEAT_FLUX = new Quantity(Intl.intl("Incident Heat Flux"), 33, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity INSIDE_WALL_TEMPERATURE = new Quantity(Intl.intl("Inside Wall Temperature"), 1, QuantityType.SOLID, 540709100045402113L);
    public static final /* enum */ Quantity NORMAL_VELOCITY = new Quantity(Intl.intl("Normal Velocity"), 8, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity PRESSURE_COEFFICIENT = new Quantity(Intl.intl("Pressure Coefficient"), 28, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity RADIATIVE_FLUX = new Quantity(Intl.intl("Radiative Heat Flux"), 33, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity RADIOMETER = new Quantity(Intl.intl("Radiometer"), 33, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity SOLID_CONDUCTIVITY = new Quantity(Intl.intl("Solid Conductivity"), 19, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity SOLID_SPECIFIC_HEAT = new Quantity(Intl.intl("Solid Specific Heat"), 11, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity SURFACE_DENSITY = new Quantity(Intl.intl("Surface Density"), 23, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity WALL_TEMPERATURE = new Quantity(Intl.intl("Wall Temperature"), 1, QuantityType.SOLID, 540709100045402129L);
    public static final /* enum */ Quantity WALL_THICKNESS = new Quantity(Intl.intl("Wall Thickness"), 0, QuantityType.SOLID, 540709100045402113L);
    public static final /* enum */ Quantity NORMALIZED_HEATING_RATE = new Quantity(Intl.intl("Normalized Heating Rate"), 89, QuantityType.SOLID, 1L);
    public static final /* enum */ Quantity NORMALIZED_HEAT_RELEASE_RATE = new Quantity(Intl.intl("Normalized Heat Release Rate"), 89, QuantityType.SOLID, 1L);
    @FDSDeprecated(vFDS="6.0.1", vPyro=52)
    public static final /* enum */ Quantity MASS_LOSS = new Quantity(Intl.intl("Mass Loss"), 23, QuantityType.SOLID, 541834999960633361L);
    public static final /* enum */ Quantity HRR = new Quantity(Intl.intl("Heat Release Rate"), 37, QuantityType.GAS, 4L);
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity HEAT_FLOW = new Quantity(Intl.intl("Heat Flow"), 37, QuantityType.GAS, 2L);
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity HEAT_FLOW_WALL = new Quantity(Intl.intl("Heat Flow Wall"), 37, QuantityType.SOLID, 2L);
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity MASS_FLOW = new Quantity(Intl.intl("Mass Flow"), 38, QuantityType.GAS, 2L);
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity MASS_FLOW_WALL = new Quantity(Intl.intl("Mass Flow Wall"), 38, QuantityType.SOLID, 2L);
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity VOLUME_FLOW = new Quantity(Intl.intl("Volume Flow"), 24, QuantityType.GAS, 2L);
    @FDSDeprecated(vFDS="6.7.8", vPyro=150)
    public static final /* enum */ Quantity VOLUME_FLOW_WALL = new Quantity(Intl.intl("Volume Flow Wall"), 24, QuantityType.SOLID, 2L);
    public static final /* enum */ Quantity VOLUME_FLOW_X = new Quantity(Intl.intl("Volume Flow in X Direction"), 24, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity VOLUME_FLOW_Y = new Quantity(Intl.intl("Volume Flow in Y Direction"), 24, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity VOLUME_FLOW_Z = new Quantity(Intl.intl("Volume Flow in Z Direction"), 24, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity VOLUME_FLOW_BOUNDARY = new Quantity(Intl.intl("Volume Flow in X Direction"), 24, QuantityType.SOLID, 2L);
    public static final /* enum */ Quantity ENTHALPY_FLOW_X = new Quantity(Intl.intl("Enthalpy Flow in X Direction"), 94, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity ENTHALPY_FLOW_Y = new Quantity(Intl.intl("Enthalpy Flow in Y Direction"), 94, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity ENTHALPY_FLOW_Z = new Quantity(Intl.intl("Enthalpy Flow in Z Direction"), 94, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity ENTHALPY_FLOW_WALL = new Quantity(Intl.intl("Enthalpy Wall"), 94, QuantityType.SOLID, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW = new Quantity(Intl.intl("Mass Flow"), 38, QuantityType.SOLID, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_WALL = new Quantity(Intl.intl("Mass Flow Wall"), 38, QuantityType.SOLID, 2L);
    public static final /* enum */ Quantity NOSPEC_TOTAL_MASS_FLOW_WALL = new Quantity(Intl.intl("Total Mass Flow Wall"), 38, QuantityType.SOLID, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X = new Quantity(Intl.intl("Mass Flow in X Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y = new Quantity(Intl.intl("Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z = new Quantity(Intl.intl("Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X_TOTAL = new Quantity(Intl.intl("Total Mass Flow in X Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in X Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_X_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in X Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Y_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity NOSPEC_MASS_FLOW_Z_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L);
    public static final /* enum */ Quantity LAYER_HEIGHT = new Quantity(Intl.intl("Layer Height"), 0, QuantityType.GAS, 8L);
    public static final /* enum */ Quantity LOWER_TEMPERATURE = new Quantity(Intl.intl("Lower Temperature"), 1, QuantityType.GAS, 8L);
    public static final /* enum */ Quantity PATH_OBSCURATION = new Quantity(Intl.intl("Path Obscuration"), 80, QuantityType.GAS, 8L, true);
    public static final /* enum */ Quantity TRANSMISSION = new Quantity(Intl.intl("Transmission"), 31, QuantityType.GAS, 8L);
    public static final /* enum */ Quantity UPPER_TEMPERATURE = new Quantity(Intl.intl("Upper Temperature"), 1, QuantityType.GAS, 8L);
    public static final /* enum */ Quantity CHAMBER_OBSCURATION = new Quantity(Intl.intl("Chamber Obscuration"), 31, QuantityType.GAS, 0L);
    public static final /* enum */ Quantity LINK_TEMPERATURE = new Quantity(Intl.intl("Link Temperature"), 1, QuantityType.GAS, 0L);
    public static final /* enum */ Quantity SPRINKLER_LINK_TEMPERATURE = new Quantity(Intl.intl("Sprinkler Link Temperature"), 1, QuantityType.GAS, 0L);
    public static final /* enum */ Quantity CONTROL_VALUE = new Quantity(Intl.intl("Control Value"), 28, QuantityType.GAS, 0L);
    public static final /* enum */ Quantity ACTUATED_SPRINKLERS = new Quantity(Intl.intl("Actuated Sprinklers"), 28, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity CPU_TIME = new Quantity(Intl.intl("CPU Time"), 2, QuantityType.GAS, 1L);
    @FDSDeprecated(vFDS="6.7.6", vPyro=139)
    public static final /* enum */ Quantity CPU_TIME_PER_STEP = new Quantity(Intl.intl("CPU Time per Step"), 2, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity DEPOSITION_VELOCITY = new Quantity(Intl.intl("Deposition Velocity"), 8, QuantityType.GAS, 540709100045402129L);
    public static final /* enum */ Quantity ITERATION = new Quantity(Intl.intl("Iteration"), 28, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity NUMBER_OF_PARTICLES = new Quantity(Intl.intl("Number of Particles"), 28, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity OPEN_NOZZLES = new Quantity(Intl.intl("Open Nozzles"), 28, QuantityType.GAS, 572234297438568449L);
    public static final /* enum */ Quantity PRESSURE_ZONE = new Quantity(Intl.intl("Pressure Zone"), 28, QuantityType.GAS, 129L);
    public static final /* enum */ Quantity TIME = new Quantity(Intl.intl("Time"), 2, QuantityType.GAS, 572234297438568673L);
    public static final /* enum */ Quantity TIME_STEP = new Quantity(Intl.intl("Time Step"), 2, QuantityType.GAS, 1L);
    @FDSDeprecated(vFDS="6.3", vPyro=85)
    public static final /* enum */ Quantity TURBULENCE_RESOLUTION = new Quantity(Intl.intl("Turbulence Resolution"), 28, QuantityType.GAS, 129L);
    public static final /* enum */ Quantity WALL_CLOCK_TIME = new Quantity(Intl.intl("Wall Clock Time"), 2, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity WALL_CLOCK_TIME_ITERATIONS = new Quantity(Intl.intl("Wall Clock Time Iterations"), 2, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity AERO_VOLUME_FRACTION = new Quantity(Intl.intl("Aerosol Volume Fraction"), 32, QuantityType.GAS, 572234297438568673L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction"), 18, QuantityType.GAS, 572234297507774689L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction"), 32, QuantityType.GAS, 572234297438568673L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_X = new Quantity(Intl.intl("Mass Flux in X Direction"), 45, QuantityType.GAS, 572234297442762977L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Y = new Quantity(Intl.intl("Mass Flux in Y Direction"), 45, QuantityType.GAS, 572234297442762977L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX_Z = new Quantity(Intl.intl("Mass Flux in Z Direction"), 45, QuantityType.GAS, 572234297442762977L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLUX = new Quantity(Intl.intl("Mass Flux"), 45, QuantityType.SOLID, 540709100045402129L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_DENSITY = new Quantity(Intl.intl("Density"), 4, QuantityType.GAS, 572234297507774689L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_VISIBILITY = new Quantity(Intl.intl("Visibility"), 16, QuantityType.GAS, 572234297438568673L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_OPTICAL_DENSITY = new Quantity(Intl.intl("Optical Density"), 63, QuantityType.GAS, 572234297438568673L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_SURFACE_DEPOSITION = new Quantity(Intl.intl("Surface Deposition"), 83, QuantityType.SOLID, 573360197423005713L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_AMPUA = new Quantity(Intl.intl("Accumulated Mass Per Unit Area"), 23, QuantityType.SOLID, 541834999960633361L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_CPUA = new Quantity(Intl.intl("Cooling Per Unit Area"), 33, QuantityType.SOLID, 541834999960633361L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MPUA = new Quantity(Intl.intl("Mass Per Unit Area"), 23, QuantityType.SOLID, 541834999960633361L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MPUV = new Quantity(Intl.intl("Mass Per Unit Volume"), 4, QuantityType.GAS, 572234297507774657L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW = new Quantity(Intl.intl("Mass Flow"), 38, QuantityType.SOLID, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_WALL = new Quantity(Intl.intl("Mass Flow Wall"), 38, QuantityType.SOLID, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_TOTAL_MASS_FLOW_WALL = new Quantity(Intl.intl("Total Mass Flow Wall"), 38, QuantityType.SOLID, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X = new Quantity(Intl.intl("Mass Flow in X Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y = new Quantity(Intl.intl("Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z = new Quantity(Intl.intl("Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X_TOTAL = new Quantity(Intl.intl("Total Mass Flow in X Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z_TOTAL = new Quantity(Intl.intl("Total Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in X Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z_ADVECTIVE = new Quantity(Intl.intl("Advective Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_X_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in X Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Y_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Y Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity SPEC_MASS_FLOW_Z_DIFFUSIVE = new Quantity(Intl.intl("Diffusive Mass Flow in Z Direction"), 38, QuantityType.GAS, 2L, QuantityCategory.SPECIES, ExSpec.class);
    public static final /* enum */ Quantity MATL_DENSITY = new Quantity(Intl.intl("Density"), 4, QuantityType.GAS, 572234297507774720L, QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity MATL_SOLID_DENSITY = new Quantity(Intl.intl("Solid Density"), 4, QuantityType.SOLID, 540709100045402113L, QuantityCategory.MATERIAL, Material.class);
    public static final /* enum */ Quantity PART_ACMPUA = new Quantity(Intl.intl("Accumulated Mass Per Unit Area"), 23, QuantityType.SOLID, 541834999960633361L, QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_CPUA = new Quantity(Intl.intl("Cooling Per Unit Area"), 33, QuantityType.SOLID, 541834999960633361L, QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MASS_FLUX_X = new Quantity(Intl.intl("Mass Flux of Particles in X Direction"), 45, QuantityType.GAS, 572234297442762944L, QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MASS_FLUX_Y = new Quantity(Intl.intl("Mass Flux of Particles in Y Direction"), 45, QuantityType.GAS, 572234297442762944L, QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MASS_FLUX_Z = new Quantity(Intl.intl("Mass Flux of Particles in Z Direction"), 45, QuantityType.GAS, 572234297442762944L, QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MPUA = new Quantity(Intl.intl("Mass Per Unit Area"), 23, QuantityType.SOLID, 541834999960633361L, QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity PART_MPUV = new Quantity(Intl.intl("Mass Per Unit Volume"), 4, QuantityType.GAS, 572234297507774657L, QuantityCategory.PARTICLE, Particle.class, new MasslessPartFilter());
    public static final /* enum */ Quantity HVAC_AIRCOIL_HEAT_EXCHANGE = new Quantity(Intl.intl("Heat Exchange Rate for an Aircoil"), 37, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_DENSITY = new Quantity(Intl.intl("Density of the Flow in a Duct"), 4, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_MASS_FLOW = new Quantity(Intl.intl("Mass Flow in a Duct"), 38, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction of a Species in a Duct"), 18, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_DUCT_TEMPERATURE = new Quantity(Intl.intl("Temperature of the Flow in a Duct"), 1, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_VELOCITY = new Quantity(Intl.intl("Velocity of a Duct"), 8, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_VOLUME_FLOW = new Quantity(Intl.intl("Volumetric Flow in a Duct"), 24, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_DUCT_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction of a Species in a Duct"), 32, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_DUCT_ENERGY_FLOW = new Quantity(Intl.intl("Energy Flow in a Duct"), 37, QuantityType.HVAC_DUCT, 0L, QuantityCategory.HVAC, HvacDuct.class);
    public static final /* enum */ Quantity HVAC_FILTER_LOADING = new Quantity(Intl.intl("Loading of a Species in a Filter"), 77, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_FILTER_LOSS = new Quantity(Intl.intl("Flow Loss through a Filter"), 28, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_DENSITY = new Quantity(Intl.intl("Density of the Flow through a Node"), 4, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_MASS_FRACTION = new Quantity(Intl.intl("Mass Fraction of a Species in a Node"), 18, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_NODE_PRESSURE = new Quantity(Intl.intl("Pressure of a Node"), 39, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_TEMPERATURE = new Quantity(Intl.intl("Temperature of the Flow through a Node"), 1, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_VOLUME_FRACTION = new Quantity(Intl.intl("Volume Fraction of a Species in a Node"), 32, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class, ExSpec.class);
    public static final /* enum */ Quantity HVAC_NODE_PRESSURE_DIFFERENCE = new Quantity(Intl.intl("Pressure Difference between Two Nodes"), 39, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class, HvacNode.class);
    public static final /* enum */ Quantity HVAC_NODE_ENTHALPY = new Quantity(Intl.intl("Enthalpy of the Flow through a Node"), 62, QuantityType.HVAC_NODE, 0L, QuantityCategory.HVAC, HvacNode.class);
    public static final /* enum */ Quantity CELL_U = new Quantity(Intl.intl("Cell U"), 8, QuantityType.GAS, 161L);
    public static final /* enum */ Quantity CELL_V = new Quantity(Intl.intl("Cell V"), 8, QuantityType.GAS, 161L);
    public static final /* enum */ Quantity CELL_W = new Quantity(Intl.intl("Cell W"), 8, QuantityType.GAS, 161L);
    public static final /* enum */ Quantity YPLUS = new Quantity(Intl.intl("Viscous Wall Units"), 28, QuantityType.SOLID, 17L);
    public static final /* enum */ Quantity PDPA = new Quantity(Intl.intl("Particle Diagnostics"), 28, QuantityType.GAS, 1L);
    public static final /* enum */ Quantity INTEGRATED_INTENSITY = new Quantity(Intl.intl("Integrated Intensity"), 22, QuantityType.GAS, 572234297442762977L);
    public static final /* enum */ Quantity RADIATION_LOSS = new Quantity(Intl.intl("Radiation Loss"), 25, QuantityType.GAS, 572234297507774689L);
    public static final /* enum */ Quantity CHEMISTRY_ITER = new Quantity(Intl.intl("Chemical Subiterations"), 28, QuantityType.GAS, 128L);
    public final String name;
    public final int unitType;
    public final QuantityType quantityType;
    public final long outputTypes;
    public final boolean mixFracOnly;
    public final String category;
    public final Class<? extends IPyroObject>[] requiredTypes;
    public final Predicate[] typeFilters;
    private static final /* synthetic */ Quantity[] $VALUES;

    public static Quantity[] values() {
        return (Quantity[])$VALUES.clone();
    }

    public static Quantity valueOf(String name) {
        return Enum.valueOf(Quantity.class, name);
    }

    private Quantity(String name, int unitType, QuantityType quantityType, long outputTypes) {
        this(name, unitType, quantityType, outputTypes, false);
    }

    private Quantity(String name, int unitType, QuantityType quantityType, long outputTypes, QuantityCategory category, Object ... args) {
        this(name, unitType, quantityType, outputTypes, false, category, args);
    }

    private Quantity(String name, int unitType, QuantityType quantityType, long outputTypes, boolean mixFracOnly) {
        this(name, unitType, quantityType, outputTypes, mixFracOnly, null, new Object[0]);
    }

    private Quantity(String name, int unitType, QuantityType quantityType, long outputTypes, boolean mixFracOnly, QuantityCategory category, Object ... args) {
        this.name = name;
        this.unitType = unitType;
        this.quantityType = quantityType;
        this.outputTypes = outputTypes;
        this.mixFracOnly = mixFracOnly;
        this.category = category == null ? null : category.category;
        ArrayList<Class> types = new ArrayList<Class>();
        ArrayList<Predicate> filters = new ArrayList<Predicate>();
        int m = 0;
        while (m < args.length) {
            Class type = (Class)args[m];
            Predicate filter = Predicates.alwaysTrue();
            if (++m < args.length && args[m] instanceof Predicate) {
                filter = (Predicate)args[m];
                ++m;
            }
            types.add(type);
            filters.add(filter);
        }
        this.requiredTypes = types.toArray(new Class[types.size()]);
        this.typeFilters = filters.toArray(new Predicate[filters.size()]);
    }

    public boolean isDeprecated() {
        try {
            return Quantity.class.getField(this.name()).isAnnotationPresent(FDSDeprecated.class);
        }
        catch (NoSuchFieldException e) {
            assert (false);
            return false;
        }
    }

    public StaticQuantity create() {
        assert (this.requiredTypes.length == 0);
        return new StaticQuantity(this);
    }

    public ObjectQuantity create(IPyroObject ... args) {
        assert (args.length > 0 && this.isValidArgs(args));
        return new ObjectQuantity(this, args);
    }

    public IQuantity create(Collection<? extends IPyroObject> args) {
        IPyroObject[] vargs = args.toArray(new IPyroObject[args.size()]);
        assert (this.isValidArgs(vargs));
        if (this.requiredTypes.length > 0) {
            return new ObjectQuantity(this, vargs);
        }
        return new StaticQuantity(this);
    }

    public boolean isValidArgs(IPyroObject ... args) {
        try {
            this.checkArgs(args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void checkArgs(IPyroObject ... args) throws Exception {
        if (args.length != this.requiredTypes.length) {
            String msg = String.format(Intl.intl("%d objects must be specified."), this.requiredTypes.length);
            throw new Exception(msg);
        }
        for (int m = 0; m < args.length; ++m) {
            Class<? extends IPyroObject> type = this.requiredTypes[m];
            if (!type.isInstance(args[m])) {
                String msg = String.format(Intl.intl("Object %1$d must be a %2$s."), m, TVEntryPoints.ep(type).getCategoryName());
                throw new Exception(msg);
            }
            if (this.typeFilters[m].test(type.cast(args[m]))) continue;
            String msg = this.typeFilters[m].toString();
            throw new Exception(msg);
        }
    }

    public int getNumArgs() {
        return this.requiredTypes.length;
    }

    static {
        $VALUES = new Quantity[]{ABSORPTION_COEFFICIENT, ADIABATIC_SURFACE_TEMPERATURE_GAS, ASPIRATION, AVERAGE_SPECIFIC_HEAT, CABLE_TEMPERATURE, CONDUCTIVITY, DENSITY, DIVERGENCE, ENTHALPY, SENSIBLE_ENTHALPY, EXTINCTION, EXTINCTION_COEFFICIENT, FED, FIC, H, HRRPUL, HRRPUV, MIXTURE_FRACTION, OPTICAL_DENSITY, PRESSURE, BACKGROUND_PRESSURE, RADIATIVE_HEAT_FLUX_GAS, GAUGE_HEAT_FLUX_GAS, RELATIVE_HUMIDITY, SPECIFIC_ENTHALPY, SPECIFIC_SENSIBLE_ENTHALPY, SPECIFIC_HEAT, TEMPERATURE, THERMOCOUPLE, U_VELOCITY, V_VELOCITY, W_VELOCITY, VELOCITY, VISCOSITY, VISIBILITY, ADIABATIC_SURFACE_TEMPERATURE, BACK_WALL_TEMPERATURE, BURNING_RATE, CONVECTIVE_FLUX, FRICTION_VELOCITY, GAS_TEMPERATURE, GAUGE_HEAT_FLUX, HEAT_FLUX, HEAT_TRANSFER_COEFFICIENT, HRRPUA, INCIDENT_HEAT_FLUX, INSIDE_WALL_TEMPERATURE, NORMAL_VELOCITY, PRESSURE_COEFFICIENT, RADIATIVE_FLUX, RADIOMETER, SOLID_CONDUCTIVITY, SOLID_SPECIFIC_HEAT, SURFACE_DENSITY, WALL_TEMPERATURE, WALL_THICKNESS, NORMALIZED_HEATING_RATE, NORMALIZED_HEAT_RELEASE_RATE, MASS_LOSS, HRR, HEAT_FLOW, HEAT_FLOW_WALL, MASS_FLOW, MASS_FLOW_WALL, VOLUME_FLOW, VOLUME_FLOW_WALL, VOLUME_FLOW_X, VOLUME_FLOW_Y, VOLUME_FLOW_Z, VOLUME_FLOW_BOUNDARY, ENTHALPY_FLOW_X, ENTHALPY_FLOW_Y, ENTHALPY_FLOW_Z, ENTHALPY_FLOW_WALL, NOSPEC_MASS_FLOW, NOSPEC_MASS_FLOW_WALL, NOSPEC_TOTAL_MASS_FLOW_WALL, NOSPEC_MASS_FLOW_X, NOSPEC_MASS_FLOW_Y, NOSPEC_MASS_FLOW_Z, NOSPEC_MASS_FLOW_X_TOTAL, NOSPEC_MASS_FLOW_Y_TOTAL, NOSPEC_MASS_FLOW_Z_TOTAL, NOSPEC_MASS_FLOW_X_ADVECTIVE, NOSPEC_MASS_FLOW_Y_ADVECTIVE, NOSPEC_MASS_FLOW_Z_ADVECTIVE, NOSPEC_MASS_FLOW_X_DIFFUSIVE, NOSPEC_MASS_FLOW_Y_DIFFUSIVE, NOSPEC_MASS_FLOW_Z_DIFFUSIVE, LAYER_HEIGHT, LOWER_TEMPERATURE, PATH_OBSCURATION, TRANSMISSION, UPPER_TEMPERATURE, CHAMBER_OBSCURATION, LINK_TEMPERATURE, SPRINKLER_LINK_TEMPERATURE, CONTROL_VALUE, ACTUATED_SPRINKLERS, CPU_TIME, CPU_TIME_PER_STEP, DEPOSITION_VELOCITY, ITERATION, NUMBER_OF_PARTICLES, OPEN_NOZZLES, PRESSURE_ZONE, TIME, TIME_STEP, TURBULENCE_RESOLUTION, WALL_CLOCK_TIME, WALL_CLOCK_TIME_ITERATIONS, AERO_VOLUME_FRACTION, SPEC_MASS_FRACTION, SPEC_VOLUME_FRACTION, SPEC_MASS_FLUX_X, SPEC_MASS_FLUX_Y, SPEC_MASS_FLUX_Z, SPEC_MASS_FLUX, SPEC_DENSITY, SPEC_VISIBILITY, SPEC_OPTICAL_DENSITY, SPEC_SURFACE_DEPOSITION, SPEC_AMPUA, SPEC_CPUA, SPEC_MPUA, SPEC_MPUV, SPEC_MASS_FLOW, SPEC_MASS_FLOW_WALL, SPEC_TOTAL_MASS_FLOW_WALL, SPEC_MASS_FLOW_X, SPEC_MASS_FLOW_Y, SPEC_MASS_FLOW_Z, SPEC_MASS_FLOW_X_TOTAL, SPEC_MASS_FLOW_Y_TOTAL, SPEC_MASS_FLOW_Z_TOTAL, SPEC_MASS_FLOW_X_ADVECTIVE, SPEC_MASS_FLOW_Y_ADVECTIVE, SPEC_MASS_FLOW_Z_ADVECTIVE, SPEC_MASS_FLOW_X_DIFFUSIVE, SPEC_MASS_FLOW_Y_DIFFUSIVE, SPEC_MASS_FLOW_Z_DIFFUSIVE, MATL_DENSITY, MATL_SOLID_DENSITY, PART_ACMPUA, PART_CPUA, PART_MASS_FLUX_X, PART_MASS_FLUX_Y, PART_MASS_FLUX_Z, PART_MPUA, PART_MPUV, HVAC_AIRCOIL_HEAT_EXCHANGE, HVAC_DUCT_DENSITY, HVAC_DUCT_MASS_FLOW, HVAC_DUCT_MASS_FRACTION, HVAC_DUCT_TEMPERATURE, HVAC_DUCT_VELOCITY, HVAC_DUCT_VOLUME_FLOW, HVAC_DUCT_VOLUME_FRACTION, HVAC_DUCT_ENERGY_FLOW, HVAC_FILTER_LOADING, HVAC_FILTER_LOSS, HVAC_NODE_DENSITY, HVAC_NODE_MASS_FRACTION, HVAC_NODE_PRESSURE, HVAC_NODE_TEMPERATURE, HVAC_NODE_VOLUME_FRACTION, HVAC_NODE_PRESSURE_DIFFERENCE, HVAC_NODE_ENTHALPY, CELL_U, CELL_V, CELL_W, YPLUS, PDPA, INTEGRATED_INTENSITY, RADIATION_LOSS, CHEMISTRY_ITER};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FDSDeprecated {
        public String vFDS();

        public int vPyro();
    }

    private static class MasslessPartFilter
    implements Predicate<Particle> {
        private MasslessPartFilter() {
        }

        @Override
        public boolean test(Particle o) {
            return !o.isType(Particle.Type.TRACER);
        }

        public String toString() {
            return Intl.intl("Particle must have mass.");
        }
    }
}

