/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.particle;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.Variant;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Particle
extends NamedPyroObject
implements ISignalSink,
ICustomFDSPropsContainer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private Type d_type;
    private String d_fyi;
    private Output d_output;
    private IColoring d_coloring;
    private CustomFDSProps d_customFDSProps;
    private OneLogicInPin d_inPin;
    private Surface d_surf;
    private ExSpec d_species;
    private boolean d_isStatic;
    private Distribution d_distribution;
    private Variant d_medDiam;
    private UnitDouble d_minDiam;
    private UnitDouble d_maxDiam;
    private Double d_sigmaD;
    private double d_gammaD;
    private Drag d_dragType;
    private UnitPoint3D d_dragCoef3D;
    private UnitPoint3D d_perm;
    private UnitPoint3D d_orientation;
    private double d_porousVolumeFrac;
    private double d_denseVolumeFrac;
    private double d_freeAreaFraction;
    @Deprecated
    private double d_dragCoef;

    public Particle(String name, Type type, Output output, IColoring coloring) {
        super(name);
        this.d_type = type;
        this.d_distribution = Distribution.CONST;
        this.d_output = output;
        this.d_coloring = coloring;
        this.d_customFDSProps = CustomFDSProps.EMPTY;
        this.d_inPin = new OneLogicInPin(this);
        this.d_surf = null;
        this.d_species = null;
        this.d_isStatic = false;
        if (type == Type.LIQUID) {
            this.setDiameter(new UnitDouble(500.0, SI.MICRO(SI.METER)));
        } else {
            this.d_medDiam = Variant.DEFAULT;
        }
        this.d_minDiam = new UnitDouble(20.0, SI.MICRO(SI.METER));
        this.d_maxDiam = new UnitDouble(Double.POSITIVE_INFINITY, SI.MICRO(SI.METER));
        this.d_gammaD = 2.4;
        this.d_sigmaD = null;
        this.d_dragType = Drag.SPHERE;
        this.d_denseVolumeFrac = 1.0E-5;
        this.d_dragCoef3D = new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE);
        this.d_perm = new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE);
        this.d_orientation = new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 66) {
            this.d_dragType = Drag.SPHERE;
        }
        if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 148) {
            if (this.d_dragType == Drag.COEF) {
                this.d_dragType = Drag.CUSTOM;
                this.d_dragCoef3D = new UnitPoint3D(this.d_dragCoef, 0.0, 0.0, Unit.ONE);
            } else {
                this.d_dragCoef3D = new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE);
            }
            this.d_perm = new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE);
            this.d_orientation = new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE);
        }
    }

    public void setType(Type type) {
        this.d_type = type;
    }

    public Type getType() {
        return this.d_type;
    }

    public boolean isType(Type type) {
        return this.d_type == type;
    }

    public Distribution getDistribution() {
        return this.d_distribution;
    }

    public void setDistribution(Distribution dist) {
        this.d_distribution = dist;
    }

    public boolean isDistributionType(Distribution dist) {
        return this.d_distribution == dist;
    }

    public Variant getDiameter() {
        return this.d_medDiam;
    }

    public void setDiameter(UnitDouble diameter) {
        this.d_medDiam = diameter != null ? Variant.constant(diameter) : Variant.DEFAULT;
    }

    public UnitDouble getMinDiameter() {
        return this.d_minDiam;
    }

    public void setMinDiameter(UnitDouble diameter) {
        this.d_minDiam = diameter;
    }

    public UnitDouble getMaxDiameter() {
        return this.d_maxDiam;
    }

    public void setMaxDiameter(UnitDouble diameter) {
        this.d_maxDiam = diameter;
    }

    public Double getSigmaD() {
        return this.d_sigmaD;
    }

    public void setSigmaD(double sigmaD) {
        this.d_sigmaD = sigmaD;
    }

    public double getGammaD() {
        return this.d_gammaD;
    }

    public void setGammaD(double gammaD) {
        this.d_gammaD = gammaD;
    }

    public void setConstDistribution(UnitDouble diameter) {
        this.setDiameter(diameter);
        this.setDistribution(Distribution.CONST);
    }

    public void setRosinRammler(UnitDouble diameter, UnitDouble minDiam, UnitDouble maxDiam, double gammaD) {
        this.setDiameter(diameter);
        this.setMinDiameter(minDiam);
        this.setMaxDiameter(maxDiam);
        this.setGammaD(gammaD);
        this.setDistribution(Distribution.ROSIN);
    }

    public void setLognormal(UnitDouble diameter, UnitDouble minDiam, UnitDouble maxDiam, double sigmaD) {
        this.setDiameter(diameter);
        this.setMinDiameter(minDiam);
        this.setMaxDiameter(maxDiam);
        this.setSigmaD(sigmaD);
        this.setDistribution(Distribution.LOGNORMAL);
    }

    public void setRosinRammlerLognormal(UnitDouble diameter, UnitDouble minDiam, UnitDouble maxDiam, double gammaD) {
        this.setDiameter(diameter);
        this.setMinDiameter(minDiam);
        this.setMaxDiameter(maxDiam);
        this.setGammaD(gammaD);
        this.setDistribution(Distribution.ROSINLOGNORMAL);
    }

    public Drag getDragType() {
        return this.d_dragType;
    }

    public void setDrag(Drag drag) {
        this.d_dragType = drag;
    }

    public UnitPoint3D getDragCoef3D() {
        return this.d_dragCoef3D;
    }

    public void setDragCoef3D(UnitPoint3D coeff) {
        this.d_dragCoef3D = coeff;
    }

    public void setPermeability(UnitPoint3D perm) {
        this.d_perm = perm;
    }

    public UnitPoint3D getPermeability() {
        return this.d_perm;
    }

    public void setOrientation(UnitPoint3D ori) {
        this.d_orientation = ori;
    }

    public UnitPoint3D getOrientation() {
        return this.d_orientation;
    }

    public double getPorousVolumeFraction() {
        return this.d_porousVolumeFrac;
    }

    public void setPorousVolumeFraction(double pvf) {
        this.d_porousVolumeFrac = pvf;
    }

    public double getDenseVolumeFraction() {
        return this.d_denseVolumeFrac;
    }

    public void setDenseVolumeFraction(double dvf) {
        this.d_denseVolumeFrac = dvf;
    }

    public double getFreeAreaFraction() {
        return this.d_freeAreaFraction;
    }

    public void setFreeAreaFraction(double faf) {
        this.d_freeAreaFraction = faf;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("PART");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        Particle clone = (Particle)super.clone();
        clone.d_inPin = (OneLogicInPin)this.d_inPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof Particle && super.equals(obj) && ((Particle)obj).d_inPin.equals(this.d_inPin) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        return obj == this || obj instanceof Particle && ((Particle)obj).d_isStatic == this.d_isStatic && ((Particle)obj).d_output.equals(this.d_output) && theUtil.equal(((Particle)obj).d_coloring, this.d_coloring) && ((Particle)obj).d_customFDSProps.equals(this.d_customFDSProps);
    }

    public int propHash() {
        return this.d_output.hashCode() + theUtil.hashCode(this.d_isStatic) + (this.d_coloring != null ? this.d_coloring.hashCode() : 0) + this.d_customFDSProps.hashCode();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    private void fireEventIfChanged(Object before, Object after) {
        if (!theUtil.equal(before, after)) {
            this.changedEvt(new Object[0]);
        }
    }

    public Output getOutput() {
        return this.d_output;
    }

    public void setOutput(Output output) {
        Output old = this.d_output;
        this.d_output = output;
        this.fireEventIfChanged(old, this.d_output);
    }

    public IColoring getColoring() {
        return this.d_coloring;
    }

    public void setColoring(IColoring coloring) {
        IColoring old = this.d_coloring;
        this.d_coloring = coloring;
        this.fireEventIfChanged(old, this.d_coloring);
    }

    public Color getDefaultColor() {
        switch (this.d_type) {
            case SOLID: {
                return Color.ORANGE;
            }
            case TRACER: {
                return Color.BLACK;
            }
            case LIQUID: {
                return Color.BLUE;
            }
        }
        throw new RuntimeException("Invalid particle type.");
    }

    public void setDefaultColor() {
        this.setColoring(new ConstColoring(this.getDefaultColor()));
    }

    public Surface getSurface() {
        return this.d_surf;
    }

    public void setSurface(Surface surf) {
        Surface old = this.d_surf;
        this.d_surf = surf;
        this.fireEventIfChanged(old, this.d_surf);
    }

    public ExSpec getSpecies() {
        return this.d_species;
    }

    public void setSpecies(ExSpec species) {
        ExSpec old = this.d_species;
        this.d_species = species;
        this.fireEventIfChanged(old, this.d_species);
    }

    public boolean isStatic() {
        return this.d_isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.d_isStatic = isStatic;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_surf);
        deps.add(DLink.WEAK, (IPyroObject)this.d_species);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof ExSpec) {
            Util.keepIfNullOr(objs, ExSpec.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof ExSpec) {
            return new AReplaceRefTask<ExSpec>((Object)old, (Object)replacement){

                @Override
                protected void set(ExSpec obj) {
                    Particle.this.setSpecies(obj);
                }
            };
        }
        if (old instanceof Surface) {
            return new AReplaceRefTask<Surface>((Object)old, (Object)replacement){

                @Override
                protected void set(Surface obj) {
                    Particle.this.setSurface(obj);
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    public static enum Drag {
        SPHERE(Intl.intl("Sphere")),
        CYLINDER(Intl.intl("Cylinder")),
        DISK(Intl.intl("Disk")),
        POROUS_MEDIA(Intl.intl("Porous Media")),
        SCREEN(Intl.intl("Screen")),
        CUSTOM(Intl.intl("Custom")),
        COEF(Intl.intl("Coefficient"));

        private final String name;

        private Drag(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Distribution {
        CONST,
        ROSIN,
        LOGNORMAL,
        ROSINLOGNORMAL;

    }

    public static enum Type {
        TRACER,
        LIQUID,
        SOLID;

    }
}

