/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PyroDisplayGeom;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.ObstFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.LWArray;
import pyrosim.util.Util;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.nmt.BooleanOp;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Task;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class Obstruction
extends AFDSObject
implements IObstruction {
    static final long serialVersionUID = 1L;
    private Object d_geom;
    private Object d_surfaces;
    private final BIMType d_bimType;
    @Deprecated
    private Object d_texMapper;
    @SkipDep
    private TexOrigin d_texOrigin;
    @SkipDep
    private UnitDouble d_bulkDensity;
    private transient Integer d_cachedNumFaces = null;
    private static final Predicate<Surface> s_surfFilter = new Predicate<Surface>(){

        @Override
        public boolean test(Surface surf) {
            return !surf.isPredefined(PredefSurf.OPEN) && !surf.isPredefined(PredefSurf.MIRROR) && !surf.isPredefined(PredefSurf.HVAC) && !surf.isPredefined(PredefSurf.PERIODIC) && !surf.isPredefined(PredefSurf.PERIODIC_FLOW_ONLY);
        }
    };

    public Obstruction(String name, IGeomNode geom, Surface[] surfs) {
        this(name, geom, surfs, BIMType.UNKNOWN);
    }

    public Obstruction(String name, IGeomNode geom, Surface[] surfs, BIMType bimType) {
        super(name);
        this.d_geom = geom;
        this.d_surfaces = LWArray.newArray(surfs);
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.d_bimType = bimType;
        this.d_bulkDensity = null;
        this.setOptions(92, true);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = PyroSimObjectInputStream.getVersion(in);
        if (version < 87) {
            IElemSource uvSrc = (IElemSource)this.d_texMapper;
            this.d_texMapper = null;
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            if (uvSrc != Elements.NO_UV) {
                IElemSource uv = uvSrc;
                this.d_geom = ((IGeomNode)this.d_geom).applyUVElements("uvset", (pix, oldUV) -> uv.getPrimSource((int)pix));
            }
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
        if (version < 130) {
            try {
                theUtil.assignFinalField(this, Obstruction.class, "d_bimType", (Object)BIMType.UNKNOWN);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public Object clone() {
        Obstruction clone = (Obstruction)super.clone();
        Surface[] surfs = this.getSurfaces();
        clone.d_surfaces = LWArray.newArray(surfs);
        return clone;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("OBST");
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    @Override
    public UnitDouble getBulkDensity() {
        return this.d_bulkDensity;
    }

    @Override
    public void setBulkDensity(UnitDouble dens) {
        if (theUtil.equal(dens, this.d_bulkDensity)) {
            return;
        }
        this.d_bulkDensity = dens;
        this.changedEvt(new Object[0]);
    }

    @Override
    public BIMType getBIMType() {
        return this.d_bimType;
    }

    private static int filterOptions(int options) {
        return options & 0xFD;
    }

    @Override
    public void setOptions(int options, boolean set) {
        this.setFlags(Obstruction.filterOptions(options), set, new Object[0]);
    }

    @Override
    public boolean getOptions(int options) {
        return this.testFlags(Obstruction.filterOptions(options));
    }

    @Override
    public int getSetOptions() {
        return Obstruction.filterOptions(super.getSetFlags());
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin origin) {
        if (this.d_texOrigin.equals(origin)) {
            return;
        }
        this.d_texOrigin = origin;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getNumFaces() {
        if (this.d_cachedNumFaces == null) {
            this.d_cachedNumFaces = this.getGeom().getNumPrims(1);
        }
        return this.d_cachedNumFaces;
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public List<Pair<IObstruction, IHole>> intersectHoles(Supplier<Collection<? extends IHole>> getNearHoles, Predicate<IHole> getHoleGeom, Surface fillSurf) {
        ArrayList<Pair<IObstruction, IHole>> result = new ArrayList<Pair<IObstruction, IHole>>();
        BiConsumer<IHole, DisplayGeom> addHole = (hole, display) -> {
            int numFaces = display.node.getNumPrims(1);
            if (numFaces == 0) {
                return;
            }
            Obstruction clone = (Obstruction)this.clone();
            clone.setGeom(display.node);
            Pair<Surface[], Color[]> surfsAndColors = GeomUtil.getSurfsAndColors(numFaces, display.props);
            clone.setSurfaces((Surface[])surfsAndColors.v1);
            clone.setColors((Color[])surfsAndColors.v2);
            result.add(new Pair<Obstruction, IHole>(clone, (IHole)hole));
        };
        DisplayGeom posGeom = this.constructIsectDisplay(getNearHoles, getHoleGeom, addHole, () -> this.getDisplayProps(true), oprops -> this.getInnerProps(fillSurf, (IPropsSrc)oprops, true));
        if (posGeom == null) {
            return Collections.EMPTY_LIST;
        }
        addHole.accept(null, posGeom);
        return result;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IPyroDisplayProps pyroProps = drawProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)drawProps : null;
        Surface fillSurf = pyroProps != null ? pyroProps.getFillSurface(this) : null;
        DisplayGeom disp = FDSUtil.getRastDisplay(pyroProps, this, this.getTextureOrigin());
        if (disp == null) {
            Predicate holeFilter = pyroProps != null ? pyroProps.getHoleFilter(this) : Filters.alwaysTrue();
            Supplier<Collection<IHole>> getHoles = pyroProps != null && !Filters.alwaysFalse(holeFilter) ? () -> theUtil.filter(pyroProps.getGeomProximity(this).getNearObjs(this), IHole.class, Predicates.and(h -> h.isEnabled(), holeFilter)) : () -> Collections.emptyList();
            IPropsSrc obstProps = this.getDisplayProps();
            disp = this.constructIsectDisplay(getHoles, Predicates.alwaysFalse(), null, () -> obstProps, oprops -> this.getInnerProps(fillSurf, (IPropsSrc)oprops, false));
            if (disp == null) {
                IGeomNode node = FDSUtil.finalizeUVElements(this.getGeom(), this.d_texOrigin);
                disp = new DisplayGeom(node, obstProps);
            }
        }
        IPrimProps innerProps = this.getInnerProps(fillSurf, disp.props, false);
        int options = 0;
        if (this.getOptions(32)) {
            options |= 1;
        }
        disp = new PyroDisplayGeom(disp, innerProps, options);
        return disp;
    }

    protected IPrimProps getInnerProps(Surface fillSurf, IPropsSrc obstProps, boolean surfsAsMats) {
        if (obstProps instanceof UniformProps) {
            return obstProps.get(0);
        }
        if (fillSurf != null) {
            Color color = surfsAsMats ? null : fillSurf.getColor();
            return new IPrimProps.Face(color, fillSurf, 0);
        }
        return new IPrimProps.Face(Color.BLACK, null, 0);
    }

    private DisplayGeom constructIsectDisplay(Supplier<Collection<? extends IHole>> getNearHoles, Predicate<IHole> getHoleGeom, BiConsumer<IHole, DisplayGeom> holeGeometry, Supplier<IPropsSrc> getObstProps, Function<IPropsSrc, IPrimProps> getInnerProps) {
        if (this.getOptions(4)) {
            try {
                Collection<? extends IHole> nearHoles = getNearHoles.get();
                if (!nearHoles.isEmpty()) {
                    IPropsSrc obstProps = getObstProps.get();
                    IPrimProps holeProps = getInnerProps.apply(obstProps);
                    ArrayList<HoleInfo> holeGeoms = new ArrayList<HoleInfo>(nearHoles.size());
                    for (IHole iHole : nearHoles) {
                        holeGeoms.add(new HoleInfo(iHole, GeomUtil.flatten(iHole.getGeom())));
                    }
                    IGeomNode node = this.getGeom();
                    DisplayGeom displayGeom = Obstruction.subtractHoles(this.getSetFlags(), node, obstProps, 0, holeGeoms, holeProps, getHoleGeom, holeGeometry);
                    if (displayGeom != null) {
                        return new DisplayGeom(FDSUtil.finalizeUVElements(displayGeom.node, this.d_texOrigin), displayGeom.props);
                    }
                }
            }
            catch (Throwable t) {
                System.err.printf("Error subtracting holes: obst=%s%n", this.getName());
                t.printStackTrace();
            }
        }
        return null;
    }

    public static Model toModel(TransformInfo xform, IGeom geom, Map<IPrimProps, Integer> propIdMap, IPropsSrc props, int propOffset, IPropertySet elements, int elemOffset) {
        Function<IPrimProps, Integer> newPropFunc = prop -> propIdMap.size();
        BiFunction<Integer, IPrimProps, Integer> getFaceId = (ix, fprops) -> (Integer)propIdMap.computeIfAbsent((IPrimProps)fprops, newPropFunc);
        return GeomUtil.toModel(xform, geom, getFaceId, props, propOffset, elements, elemOffset);
    }

    /*
     * WARNING - void declaration
     */
    private static DisplayGeom subtractHoles(int obstOptions, IGeomNode obstGeom, IPropsSrc obstProps, int obstPropOffset, List<HoleInfo> holeGeoms, IPrimProps holeProps, Predicate<IHole> getHoleGeom, BiConsumer<IHole, DisplayGeom> holeGeometry) {
        void var15_22;
        IPropertySet newElems;
        void var15_19;
        int oPropOffset = obstPropOffset;
        DisplayBuilder builder = new DisplayBuilder(obstGeom, obstProps, oPropOffset);
        TransformInfo ti = obstGeom.getLocalTransform().getInfo();
        int obstElemOffset = 0;
        for (IGeom geom : builder.oldGeoms) {
            Obstruction.subtractHoles(obstOptions, ti, geom, obstProps, obstPropOffset, builder.oldElems, obstElemOffset, holeGeoms, holeProps, builder, getHoleGeom, holeGeometry);
            int nprims = geom.getNumPrims(1);
            obstPropOffset += nprims;
            obstElemOffset += nprims;
        }
        int numGeomPrims = obstPropOffset - oPropOffset;
        ArrayList<IGeomNode> tchildren = new ArrayList<IGeomNode>(obstGeom.getChildren().size());
        for (IGeomNode iGeomNode : obstGeom.getChildren()) {
            tchildren.add(iGeomNode.quickTransform(ti));
        }
        ArrayList<ModifiedChild> modChildren = null;
        boolean bl = false;
        while (var15_19 < tchildren.size()) {
            IGeomNode child = (IGeomNode)tchildren.get((int)var15_19);
            DisplayGeom mchild = Obstruction.subtractHoles(obstOptions, child, obstProps, obstPropOffset, holeGeoms, holeProps, getHoleGeom, holeGeometry);
            int ncprims = child.getNumPrims(7);
            if (mchild != null) {
                if (modChildren == null) {
                    modChildren = new ArrayList<ModifiedChild>();
                }
                modChildren.add(new ModifiedChild(mchild.node, mchild.props, (int)var15_19, obstPropOffset, ncprims));
            }
            obstPropOffset += ncprims;
            ++var15_19;
        }
        if (!builder.isModified() && modChildren == null) {
            return null;
        }
        PropsBuilder newProps = new PropsBuilder();
        if (builder.isModified()) {
            ElementsBuilder elemsBuilder = new ElementsBuilder();
            for (int m = 0; m < builder.geoms.size(); ++m) {
                IGeom g = builder.geoms.get(m);
                int pcount = g.getNumPrims(7);
                IPropsSrc p = builder.props.get(m);
                newProps.add(p, pcount);
                for (Map.Entry<Elements.ElemProp<?>, IElemSource<?>> entry : builder.elems.get(m).entrySet()) {
                    elemsBuilder.add(entry.getKey(), entry.getValue(), pcount);
                }
                for (Map.Entry<Object, IElemSource<Object>> entry : builder.uvElems.get(m).entrySet()) {
                    elemsBuilder.addUV((String)entry.getKey(), entry.getValue(), pcount);
                }
                elemsBuilder.next(pcount);
            }
            newElems = elemsBuilder.finish();
            IGeom iGeom = thunderheadeng.geometry.objs.GeomUtil.group(builder.geoms);
        } else {
            IGeom iGeom = obstGeom.getLocalGeom().transform(ti, 0);
            newElems = Elements.transform(obstGeom.getLocalElements(), ti);
            newProps.add(obstProps.subset(oPropOffset, numGeomPrims), numGeomPrims);
        }
        if (modChildren != null) {
            ArrayList newChildren = new ArrayList(tchildren.size());
            int poffset = oPropOffset + numGeomPrims;
            int coffset = 0;
            for (ModifiedChild mchild : modChildren) {
                newChildren.addAll(tchildren.subList(coffset, mchild.childIx));
                int nuprops = mchild.propBegin - poffset;
                newProps.add(obstProps.subset(poffset, nuprops), nuprops);
                poffset += nuprops;
                newChildren.add(mchild.node);
                newProps.add(mchild.props, mchild.node.getNumPrims(7));
                coffset = mchild.childIx + 1;
                poffset += mchild.nSkippedProps;
            }
            newChildren.addAll(tchildren.subList(coffset, tchildren.size()));
            newProps.add(obstProps.subset(poffset, obstPropOffset - poffset), obstPropOffset - poffset);
            tchildren = newChildren;
        } else {
            int numChildPrims = obstPropOffset - numGeomPrims - oPropOffset;
            newProps.add(obstProps.subset(oPropOffset + numGeomPrims, numChildPrims), numChildPrims);
        }
        IGeomNode newNode = GeomNodeUtil.newNode(TransformUtil.IDENTITY, (IGeom)var15_22, newElems, tchildren);
        return new DisplayGeom(newNode, newProps.finalizeProps());
    }

    private static void subtractHoles(int obstOptions, TransformInfo obstXform, IGeom obstGeom, IPropsSrc obstProps, int obstPropsOffset, IPropertySet obstElems, int obstElemsOffset, List<HoleInfo> holeGeoms, IPrimProps holeProps, DisplayBuilder result, Predicate<IHole> getHoleGeom, BiConsumer<IHole, DisplayGeom> holeGeometry) {
        LinkedHashMap<IPrimProps, Integer> propIdMap = new LinkedHashMap<IPrimProps, Integer>();
        boolean modified = false;
        Model obstModel = null;
        AABox obstbb = obstXform.getBounds(obstGeom, new AABox());
        boolean obstSolid = !obstGeom.isShell();
        for (HoleInfo holeInfo : holeGeoms) {
            DisplayGeomBuilder holeGeomBuilder = getHoleGeom.test(holeInfo.hole) && holeGeometry != null ? new DisplayGeomBuilder() : null;
            for (GeomNodeUtil.QuickFlatten holeGeom : holeInfo.geom) {
                Model newModel;
                boolean holeSolid;
                Containment contains = obstbb.test(holeGeom.ti.getBounds(holeGeom.geom, new AABox()));
                if (contains == Containment.OUTSIDE) continue;
                if (obstModel == null) {
                    obstModel = Obstruction.toModel(obstXform, obstGeom, propIdMap, obstProps, obstPropsOffset, obstElems, obstElemsOffset);
                }
                obstSolid = obstSolid && obstModel.getFaces().size() >= 4;
                Model holeModel = Obstruction.toModel(holeGeom.ti, holeGeom.geom, propIdMap, new UniformProps(holeProps), 0, holeGeom.elements, 0);
                boolean bl = holeSolid = !holeGeom.geom.isShell() && holeModel.getFaces().size() >= 4;
                if (holeGeomBuilder == null) {
                    newModel = BooleanOp.subtract(obstModel, obstSolid, holeModel, holeSolid);
                } else {
                    Pair<Model, Model> iresult = BooleanOp.subtractAndIntersect(obstModel, obstSolid, holeModel, holeSolid);
                    newModel = (Model)iresult.v1;
                    if (iresult.v2 != null) {
                        Obstruction.addDisplay((Model)iresult.v2, obstOptions, holeSolid, propIdMap, (g, elems, props) -> holeGeomBuilder.add((IGeom)g, (IPropsSrc)props, (IPropertySet)elems));
                    }
                }
                if (newModel == obstModel || newModel == null) continue;
                obstModel = newModel;
                obstbb = obstModel.getBoundingBox();
                modified = true;
            }
            if (holeGeomBuilder == null) continue;
            holeGeometry.accept(holeInfo.hole, holeGeomBuilder.finish().toDisplay());
        }
        if (modified) {
            assert (obstModel != null);
            Obstruction.addDisplay(obstModel, obstOptions, obstSolid, propIdMap, result::add);
        } else {
            result.skip();
        }
    }

    private static void addDisplay(Model srcModel, int obstOptions, boolean isSolid, Map<IPrimProps, Integer> propIdMap, TriConsumer<IGeom, IPropertySet, IPropsSrc> result) {
        IPrimProps[] props = new IPrimProps[propIdMap.size()];
        for (Map.Entry<IPrimProps, Integer> entry : propIdMap.entrySet()) {
            Object prop = entry.getKey();
            if (prop.testOptions(2)) {
                prop = prop.setOptions(prop.getOptions() & 0xFFFFFFFD);
            }
            props[entry.getValue().intValue()] = prop;
        }
        IPrimProps[] resultProps = new IPrimProps[srcModel.getFaces().size()];
        int ix = 0;
        for (Face face : srcModel.getFaces()) {
            int groupid = face.groups[0];
            IPrimProps prop = props[groupid];
            resultProps[ix++] = prop;
        }
        FlattenedProps fprops = new FlattenedProps(resultProps);
        GeomNodeLeaf node = GeomUtil.toGeomNode(srcModel, fprops, isSolid, (obstOptions & 0x80) != 0);
        result.accept(node.getLocalGeom(), node.getLocalElements(), fprops);
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dprops, Runnable validateProgress) {
        IGeomNode pickable = this.getGeom().getPickable(validateProgress, dprops.isWireframe(this));
        return new DisplayGeom(pickable, IPickable.DEF_PROPS);
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (this.d_geom == geom) {
            return;
        }
        assert (geom.getNumPrims(6) == 0) : "Geometry assigned to an obstruction should contain only faces.";
        this.d_geom = geom;
        this.d_cachedNumFaces = null;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setSurfaces(Surface[] surfs) {
        assert (surfs.length == 1 || surfs.length == this.getGeom().getNumPrims(1));
        this.d_surfaces = LWArray.newArray(surfs);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Surface[] getSurfaces() {
        PyroMod domain = (PyroMod)this.getDomain();
        if (Objects.equals(this.d_surfaces, null) && domain != null) {
            return LWArray.toArray(domain.getDefaultSurface(), Surface.class);
        }
        return LWArray.toArray(this.d_surfaces, Surface.class);
    }

    @Override
    public Predicate<Surface> getSurfFilter() {
        return s_surfFilter;
    }

    public static Predicate<Surface> getSurfaceFilter() {
        return s_surfFilter;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        IPyroObject[] surfs = this.getSurfaces();
        deps.add(DLink.REQUIRED, surfs);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Surface) {
            Util.keepIfNullOr(objs, o -> o instanceof Surface && s_surfFilter.test((Surface)o));
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (!(dep instanceof Surface) && Util.containsAny(changes, Surface.EVT_APPEARANCE, Surface.EVT_COLOR, EventChannel.EVT_GENERAL)) {
            return super.taskUpdateDep(dep, changes);
        }
        return GeomUtil.taskChanged(this);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (!(old instanceof Surface)) {
            return super.taskReplaceDep(old, replacement);
        }
        return new AUndoableTask(){
            private IGeomNode d_oldNode = null;
            private int[] d_ixes = null;

            @Override
            public void undo() {
                this.setData((Surface)old, this.d_oldNode);
                this.d_ixes = null;
                this.d_oldNode = null;
            }

            @Override
            public void run() {
                ArrayList<Integer> ixes = new ArrayList<Integer>();
                BitSet bits = new BitSet();
                Surface[] surfs = Obstruction.this.getSurfaces();
                for (int m = 0; m < surfs.length; ++m) {
                    if (surfs[m] != old) continue;
                    ixes.add(m);
                    bits.set(m);
                }
                this.d_ixes = theUtil.toIntArray(ixes);
                IGeomNode newNode = this.d_oldNode = Obstruction.this.getGeom();
                this.setData((Surface)replacement, newNode);
            }

            private void setData(Surface surf, IGeomNode node) {
                Surface[] surfs = Obstruction.this.getSurfaces();
                Surface[] newSurfs = (Surface[])surfs.clone();
                for (int m = 0; m < this.d_ixes.length; ++m) {
                    newSurfs[this.d_ixes[m]] = surf;
                }
                Obstruction.this.pauseUpdates();
                Obstruction.this.setSurfaces(newSurfs);
                Obstruction.this.setGeom(node);
                Obstruction.this.resumeUpdates();
            }
        };
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Surface.class);
    }

    private static class DisplayBuilder {
        public final ITransform oldXform;
        public final List<IGeom> oldGeoms;
        public final IPropertySet oldElems;
        public final IPropsSrc oldProps;
        private int geomIx = 0;
        public List<IGeom> geoms = null;
        public List<Map<Elements.ElemProp<?>, IElemSource<?>>> elems = null;
        public List<Map<String, IElemSource<Point2d>>> uvElems = null;
        public List<IPropsSrc> props = null;

        public DisplayBuilder(IGeomNode node, IPropsSrc oldProps, int propOffset) {
            this.oldXform = node.getLocalTransform();
            this.oldGeoms = thunderheadeng.geometry.objs.GeomUtil.flatten(node.getLocalGeom());
            this.oldElems = node.getLocalElements();
            this.oldProps = oldProps.subset(propOffset, node.getLocalGeom().getNumPrims(7));
        }

        public void add(IGeom geom, IPropertySet elems, IPropsSrc props) {
            if (this.geoms == null) {
                this.geoms = new ArrayList<IGeom>(this.oldGeoms.size());
                assert (this.elems == null && this.props == null && this.uvElems == null);
                this.elems = new ArrayList(this.oldGeoms.size());
                this.uvElems = new ArrayList<Map<String, IElemSource<Point2d>>>(this.oldGeoms.size());
                this.props = new ArrayList<IPropsSrc>(this.oldGeoms.size());
                int poffset = 0;
                TransformInfo ti = this.oldXform.getInfo();
                IPropertySet telems = Elements.transform(this.oldElems, ti);
                for (int m = 0; m < this.oldGeoms.size(); ++m) {
                    IGeom g = this.oldGeoms.get(m).transform(ti, 0);
                    this.geoms.add(g);
                    int numPrims = g.getNumPrims(7);
                    this.props.add(this.oldProps.subset(poffset, numPrims));
                    this.elems.add(DisplayBuilder.toMap(telems, poffset, numPrims));
                    this.uvElems.add(DisplayBuilder.toUVMap(telems, poffset, numPrims));
                    poffset += numPrims;
                }
            }
            this.geoms.set(this.geomIx, geom);
            this.props.set(this.geomIx, props);
            int numPrims = geom.getNumPrims(7);
            this.elems.set(this.geomIx, DisplayBuilder.toMap(elems, 0, numPrims));
            this.uvElems.set(this.geomIx, DisplayBuilder.toUVMap(elems, 0, numPrims));
            ++this.geomIx;
        }

        private static Map<Elements.ElemProp<?>, IElemSource<?>> toMap(IPropertySet telems, int poffset, int numPrims) {
            HashMap elemMap = new HashMap();
            for (Elements.ElemProp<?> prop : Elements.getAllElemProps()) {
                elemMap.put(prop, ((IElemSource)telems.get(prop)).subset(poffset, numPrims));
            }
            return elemMap;
        }

        private static Map<String, IElemSource<Point2d>> toUVMap(IPropertySet telems, int poffset, int numPrims) {
            HashMap<String, IElemSource<Point2d>> elemMap = new HashMap<String, IElemSource<Point2d>>();
            for (Map.Entry<String, IElemSource<Point2d>> entry : telems.get(Elements.UV).entrySet()) {
                elemMap.put(entry.getKey(), entry.getValue().subset(poffset, numPrims));
            }
            return elemMap;
        }

        public void skip() {
            ++this.geomIx;
        }

        public boolean isModified() {
            return this.geoms != null;
        }
    }

    private static class ModifiedChild {
        public final IGeomNode node;
        public final IPropsSrc props;
        public final int childIx;
        public final int propBegin;
        public final int nSkippedProps;

        public ModifiedChild(IGeomNode node, IPropsSrc props, int childIx, int propBegin, int nSkippedProps) {
            this.node = node;
            this.props = props;
            this.childIx = childIx;
            this.propBegin = propBegin;
            this.nSkippedProps = nSkippedProps;
        }
    }

    private static class HoleInfo {
        public IHole hole;
        public final List<GeomNodeUtil.QuickFlatten> geom;

        public HoleInfo(IHole hole, List<GeomNodeUtil.QuickFlatten> geom) {
            this.hole = hole;
            this.geom = geom;
        }
    }

    private class FragGen
    implements IFDSObjProps {
        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rastOptions) {
            return new ObstFragGenerator(Obstruction.this, rastOptions);
        }

        @Override
        public FaceProps getFace(int ix) {
            Surface[] surfs = Obstruction.this.getSurfaces();
            Surface surf = surfs.length > 1 ? surfs[ix] : surfs[0];
            Color[] colors = Obstruction.this.getColors();
            Color color = colors.length == 1 ? colors[0] : colors[ix];
            return new FaceProps(surf, color);
        }

        @Override
        public boolean thickenEnabled() {
            return Obstruction.this.getOptions(1);
        }
    }
}

