/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import pyrosim.domain.devices.IBeamDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitLineSeg3D;

public abstract class ABeamMeasurer
extends AMeasuringDevc
implements IBeamDevice {
    static final long serialVersionUID = 1L;
    private UnitLineSeg3D d_beam;
    private static final IPrimProps s_primProps = new IPrimProps.Edge(new Color(0.7f, 0.7f, 0.0f), 1.0, IPrimProps.DEF_STIPPLE, 0);

    public ABeamMeasurer(String name, IQuantity measurment, UnitLineSeg3D beam) {
        super(name, measurment);
        this.d_beam = beam;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ABeamMeasurer && super.equals(obj) && this.d_beam.equals(((ABeamMeasurer)obj).d_beam);
    }

    public void setBeam(UnitLineSeg3D beam) {
        this.d_beam = beam;
        this.changedEvt(new Object[0]);
    }

    @Override
    public UnitLineSeg3D getBeam() {
        return this.d_beam;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBeamGeom());
    }

    public IGeom getBeamGeom() {
        return new LineSeg(this.d_beam.getP1(Geometry.LU), this.d_beam.getP2(Geometry.LU));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof LineSeg) {
            LineSeg ls = (LineSeg)geom;
            this.setBeam(new UnitLineSeg3D(ls.p1, ls.p2, Geometry.LU));
        }
    }
}

