/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.MathOps.SumOp;
import pyrosim.domain.controls.Util;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.AInPin;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.util.ListSet;
import thunderheadeng.util.theUtil;

public class ControlBridge
extends AControl
implements INamed,
ILatchable {
    static final long serialVersionUID = 1L;
    private IInPin d_inPin = new ControlBridgeAdapterInPin(this);
    private IOutPin d_outPin = new LogicOutPin(this);
    private IDoubleOutPin d_doubleOutPin = new DoubleOutPin(this, Intl.intl("FLOAT"), 28);

    public ControlBridge(String name) {
        super(name);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("bridge");
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return Util.inputLatches(this.d_inPin);
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin, this.d_doubleOutPin);
    }

    public IDoubleOutPin getDoubleOutPin() {
        return this.d_doubleOutPin;
    }

    public ILogicOutPin getLogicOutPin() {
        return (ILogicOutPin)this.d_outPin;
    }

    public ControlBridgeAdapterInPin getAdapterInPin() {
        return (ControlBridgeAdapterInPin)this.d_inPin;
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        ControlBridge clone = (ControlBridge)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_outPin = (IOutPin)this.d_outPin.clone(clone);
        clone.d_doubleOutPin = (IDoubleOutPin)this.d_doubleOutPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ControlBridge)) {
            return false;
        }
        ControlBridge op = (ControlBridge)obj;
        return super.equals(obj) && this.d_inPin.equals(op.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 153696506 + this.d_inPin.hashCode();
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this.equals(obj);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public void setName(String name) {
        ISignalSource src;
        this.pauseUpdates();
        super.setName(name);
        ISignalSource iSignalSource = src = !this.d_inPin.getConnections().isEmpty() ? this.d_inPin.getConnectedSources().iterator().next() : null;
        if (src instanceof IControl && !(src instanceof ControlBridge)) {
            ((IControl)src).setName(name);
        }
        this.resumeUpdates();
    }

    public boolean isMathControl() {
        return ((ControlBridgeAdapterInPin)this.d_inPin).isDoubleInput();
    }

    public boolean isLogicWire() {
        return ((ControlBridgeAdapterInPin)this.d_inPin).isLogicInput();
    }

    public boolean isActivation() {
        return this.isLogicWire() && !this.isMathControl();
    }

    public boolean isDetector() {
        return this.isMathControl() && this.isLogicWire();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_doubleOutPin == null) {
            this.d_doubleOutPin = new DoubleOutPin((ISignalSource)this, 28);
        }
        if (this.d_inPin instanceof OneLogicInPin) {
            ControlBridgeAdapterInPin newInPin = new ControlBridgeAdapterInPin(this);
            for (IOutPin iOutPin : this.d_inPin.getConnections()) {
                this.d_inPin.disconnect(iOutPin);
                newInPin.connect(iOutPin);
            }
            this.d_inPin = newInPin;
        }
    }

    public static void disconnectLogicOutPins(ControlBridge cb, PyroMod pyMod) {
        Set<Dependency> bridgeDeps = pyMod.getDependencies(cb).getDependents(cb);
        for (Dependency dep : bridgeDeps) {
            if (!(dep.source instanceof ILogicInPin)) continue;
            IInPin inPin = (IInPin)dep.source;
            inPin.disconnect(cb.getLogicOutPin());
        }
    }

    public static ControlBridge initNewCustomCtrl(String name) {
        CustomCtrl custom = new CustomCtrl();
        IOutPin clockOutPin = Clock.INSTANCE.getOutputPins().iterator().next();
        custom.getInputPin().connect(clockOutPin);
        ControlBridge bridge = new ControlBridge(name);
        bridge.getInputPin().connect(custom.getOutputPins().get(0));
        return bridge;
    }

    public static ControlBridge initNewMathCtrl(String name) {
        ControlBridge bridge = new ControlBridge(name);
        SumOp math = new SumOp();
        for (IOutPin iOutPin : math.getOutputPins()) {
            bridge.getInputPin().connect(iOutPin);
        }
        return bridge;
    }

    public static class ControlBridgeAdapterInPin
    extends AInPin
    implements ILogicInPin,
    IDoubleInPin {
        static final long serialVersionUID = 1L;
        private IDoubleOutPin d_doubleSignal;
        private ILogicOutPin d_logicSignal;

        public ControlBridgeAdapterInPin(ISignalSink sink) {
            super(sink);
        }

        @Override
        public Object clone() {
            ControlBridgeAdapterInPin clone = (ControlBridgeAdapterInPin)super.clone();
            clone.d_doubleSignal = this.d_doubleSignal;
            clone.d_logicSignal = this.d_logicSignal;
            return clone;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ControlBridgeAdapterInPin)) {
                return false;
            }
            ControlBridgeAdapterInPin pin = (ControlBridgeAdapterInPin)obj;
            return super.equals(obj) && theUtil.equal(this.d_logicSignal, pin.d_logicSignal) && theUtil.equal(this.d_doubleSignal, pin.d_doubleSignal);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + -79136327;
        }

        @Override
        public boolean canConnect(IOutPin signalPin) {
            if (!super.canConnect(signalPin)) {
                return false;
            }
            if (this.d_logicSignal == null && this.d_doubleSignal == null) {
                return true;
            }
            if (this.d_logicSignal != null && this.d_doubleSignal == null) {
                if (signalPin instanceof ILogicOutPin) {
                    return false;
                }
                return signalPin.getAttachedSource().equals(this.d_logicSignal.getAttachedSource());
            }
            if (this.d_logicSignal == null && this.d_doubleSignal != null) {
                if (signalPin instanceof IDoubleOutPin) {
                    return false;
                }
                return signalPin.getAttachedSource().equals(this.d_doubleSignal.getAttachedSource());
            }
            return false;
        }

        @Override
        public void connect(IOutPin signalPin) {
            assert (this.canConnect(signalPin));
            if (signalPin instanceof ILogicOutPin) {
                this.d_logicSignal = (ILogicOutPin)signalPin;
            }
            if (signalPin instanceof IDoubleOutPin) {
                this.d_doubleSignal = (IDoubleOutPin)signalPin;
            }
        }

        @Override
        public boolean disconnect(IOutPin pin2) {
            if (pin2 != null && pin2.equals(this.d_doubleSignal)) {
                this.d_doubleSignal = null;
                return true;
            }
            if (pin2 != null && pin2.equals(this.d_logicSignal)) {
                this.d_logicSignal = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean disconnectAll() {
            this.d_logicSignal = null;
            this.d_doubleSignal = null;
            return true;
        }

        @Override
        public Set<? extends IOutPin> getConnections() {
            HashSet<IOutPin> pins = new HashSet<IOutPin>();
            if (this.d_logicSignal != null) {
                pins.add(this.d_logicSignal);
            }
            if (this.d_doubleSignal != null) {
                pins.add(this.d_doubleSignal);
            }
            return Collections.unmodifiableSet(new ListSet(pins));
        }

        @Override
        public boolean isCompatible(IOutPin pin2) {
            return true;
        }

        public boolean isDoubleInput() {
            return this.d_doubleSignal != null;
        }

        public boolean isLogicInput() {
            return this.d_logicSignal != null;
        }

        @Override
        public void changeInputUnits(UnitSystem us) {
        }

        @Override
        public void updateInputUnit(Unit newUnit) {
        }
    }
}

