/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatUtil;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Surface
extends NamedPyroObject
implements IMaterial,
IDirectDependent,
ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    public static final Object EVT_APPEARANCE = new Object();
    public static final Object EVT_COLOR = new Object();
    public static final Object EVT_FYI = new Object();
    private MatAttrs d_defAttrs = new MatAttrs();
    private Material d_appearance;
    @SkipDep
    private transient Icon[] d_icons = null;
    private ISurfDesc d_surfDesc = null;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public static ISurfDesc newBasicDesc() {
        return new SurfDescStatic.Inert();
    }

    public static boolean isBasicDesc(ISurfDesc desc) {
        return desc instanceof SurfDescStatic.Inert;
    }

    public boolean isValidDefault() {
        return !this.isPredefined() || this.equals(((PyroMod)this.getDomain()).getSurfaceMgr().get(PredefSurf.INERT.name())) || this.equals(((PyroMod)this.getDomain()).getSurfaceMgr().get(PredefSurf.ADIABATIC.name()));
    }

    public Surface(String name) {
        this(name, new Color(255, 204, 102), null);
    }

    public Surface(String name, Color color, Material texInfo) {
        this(name, color, texInfo, Surface.newBasicDesc());
    }

    public Surface(String name, Color color, Material texInfo, ISurfDesc desc) {
        super(name);
        this.d_appearance = texInfo;
        this.d_surfDesc = desc;
        this.d_fyi = "";
        this.d_customFDSProps = CustomFDSProps.EMPTY;
        this.setColor(color);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public Surface clone() {
        Surface clone = (Surface)super.clone();
        return clone;
    }

    public void restoreFrom(Surface surf) {
        this.d_defAttrs = new MatAttrs();
        this.d_appearance = surf.getAppearance();
        this.d_surfDesc = surf.getSurfDesc();
        this.d_fyi = surf.getFYI();
        this.d_customFDSProps = surf.getCustomFDSProps("");
        this.setColor(surf.getColor());
    }

    @Override
    public IMatAttrs getAttributes() {
        if (this.d_appearance != null) {
            return this.d_appearance.getAttributes();
        }
        return this.d_defAttrs;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Surface)) {
            return false;
        }
        Surface s = (Surface)obj;
        return super.equals(obj) && this.d_defAttrs != null && s.d_defAttrs != null && MatUtil.makeImagesHashable(this.d_defAttrs).equals(s.d_defAttrs) && Surface.equal(this.d_appearance, s.d_appearance) && this.d_surfDesc.equals(s.d_surfDesc) && this.d_customFDSProps.equals(s.d_customFDSProps);
    }

    private static boolean equal(Material app1, Material app2) {
        return app1 == null ? app2 == null : app1.pseudoEquals(app2);
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("SURF");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    public void setSurfDesc(ISurfDesc desc) {
        this.d_surfDesc = desc;
        this.changedEvt(new Object[0]);
    }

    public ISurfDesc getSurfDesc() {
        return this.d_surfDesc;
    }

    public Color getColor() {
        return this.d_defAttrs.getDiffuseColorWithOpacity();
    }

    public void setColor(Color col) {
        this.d_defAttrs = this.d_defAttrs.applyColorToDiffuseAndOpacity(col);
        this.changedEvt(EVT_COLOR);
    }

    public Material getAppearance() {
        return this.d_appearance;
    }

    public void setAppearance(Material mat) {
        if (this.d_appearance == mat) {
            return;
        }
        this.d_appearance = mat;
        this.changedEvt(EVT_APPEARANCE);
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(EVT_FYI);
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        if (changes.length == 0 || theUtil.contains(EVT_COLOR, changes) || theUtil.contains(EVT_APPEARANCE, changes)) {
            this.invalidateIcon();
        }
        return super.changedEvt(changes);
    }

    private synchronized void invalidateIcon() {
        this.d_icons = null;
    }

    public synchronized Icon[] getIcons(int width, int height, Consumer<Icon[]> whenDone) {
        if (this.d_icons == null) {
            Material ti = this.getAppearance();
            int colorOptions = 3;
            if (ti != null) {
                this.d_icons = PyroGuiUtil.getIconsAsync(finishedIcons -> {
                    this.invalidateIcon();
                    whenDone.accept((Icon[])finishedIcons);
                }, ti, width, height, colorOptions, guiUtil.ImageFilter.NORMAL, guiUtil.ImageFilter.DISABLED);
            } else {
                ColorIcon icon = new ColorIcon(this.getColor(), width, height, colorOptions);
                this.d_icons = new Icon[]{icon, icon};
            }
        }
        return this.d_icons;
    }

    public boolean isPredefined() {
        for (PredefSurf psurf : PredefSurf.values()) {
            if (!this.isPredefined(psurf)) continue;
            return true;
        }
        return false;
    }

    public boolean isPredefined(PredefSurf psurf) {
        return theUtil.equal(this.getName(), psurf.name);
    }

    @Override
    public String toString() {
        return this.toString(this.getName());
    }

    public String toString(String name) {
        return "Surface: " + name + " (" + this.d_fyi + ")";
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_appearance);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Material) {
            Util.keepIfNullOr(objs, Material.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.d_appearance) {
            return new AReplaceRefTask<Material>((Object)old, (Object)replacement){

                @Override
                protected void set(Material obj) {
                    Surface.this.setAppearance(obj);
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (dep == this.d_appearance) {
            return GeomUtil.taskChanged(this);
        }
        return EmptyTask.INSTANCE;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Material.class);
    }
}

