/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.util.Collection;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class DefaultSurface
extends Surface {
    static final long serialVersionUID = 1L;
    private Surface d_dependentSurface;

    public DefaultSurface(SurfDescStatic desc) {
        super("<Default>");
        this.setSurfDesc(desc);
    }

    public String getDefaultSurfaceName() {
        return this.d_dependentSurface == null ? "" : this.d_dependentSurface.getName();
    }

    @Override
    public void setDomain(PyroMod domain, IPyroObject parent) {
        super.setDomain(domain, parent);
        if (domain != null) {
            Surface defaultSurface = domain.getSimParams().getMisc().getSurfDefault();
            this.restoreFrom(defaultSurface);
            this.d_dependentSurface = defaultSurface;
            domain.getNames(this).registerName(this.getName());
        }
    }

    @Override
    public void restoreFrom(Surface surf) {
        super.restoreFrom(surf);
        this.d_dependentSurface = surf;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DefaultSurface;
    }

    @Override
    public boolean isPredefined() {
        for (PredefSurf psurf : PredefSurf.values()) {
            if (!this.isPredefined(psurf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPredefined(PredefSurf psurf) {
        return this.d_dependentSurface != null && theUtil.equal(this.d_dependentSurface.getName(), psurf.name);
    }

    @Override
    public String toString() {
        return this.d_dependentSurface == null ? "" : this.d_dependentSurface.toString();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_dependentSurface);
        super.takeDepSnapshot(deps);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (dep instanceof SimParams.Misc) {
            Surface defaultSurface = ((SimParams.Misc)dep).getSurfDefault();
            this.restoreFrom(defaultSurface);
            this.d_dependentSurface = defaultSurface;
            return GeomUtil.taskChanged(this);
        }
        if (dep instanceof Surface) {
            this.restoreFrom((Surface)dep);
            return GeomUtil.taskChanged(this);
        }
        return super.taskUpdateDep(dep, changes);
    }
}

