/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.domain.TimeFunction;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public abstract class Backing
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final Backing EXPOSED = new Exposed();
    public static final Backing INSULATED = new Insulated();

    public static Backing newDefault() {
        return new AirGap();
    }

    public static class Insulated
    extends Backing {
        static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            return obj instanceof Insulated;
        }
    }

    public static class Exposed
    extends Backing {
        static final long serialVersionUID = 1L;

        public boolean equals(Object obj) {
            return obj instanceof Exposed;
        }
    }

    public static class AirGap
    extends Backing {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_airTemp;
        public final TimeFunction<?> d_airTempRamp;

        public AirGap() {
            this(new UnitDouble(20.0, SI.CELSIUS), TimeFunction.newDefault());
        }

        public AirGap(UnitDouble airTemp, TimeFunction<?> func) {
            this.d_airTemp = airTemp;
            this.d_airTempRamp = func;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_airTemp);
            hash = 31 * hash + theUtil.hashCode(this.d_airTempRamp);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AirGap)) {
                return false;
            }
            AirGap a = (AirGap)obj;
            return theUtil.equal(this.d_airTemp, a.d_airTemp) && this.d_airTempRamp.equals(a.d_airTempRamp);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.d_airTempRamp == null) {
                try {
                    Util.assignFinalField(this, "d_airTempRamp", TimeFunction.newDefault());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (this.d_airTemp == null) {
                try {
                    Util.assignFinalField(this, "d_airTemp", new UnitDouble(20.0, SI.CELSIUS));
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

