/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.output.StatGeom;
import pyrosim.geom.Geometry;
import pyrosim.geom.IGeomSource;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.ITriInterpolator3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.IAttribInterpolator;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtSolidUtil;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.ManifoldSolid;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.MappedIterator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.QuadFunction;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class GeomUtil
extends thunderheadeng.geometry.objs.GeomUtil {
    public static final int CREASEID = 0x7FFFFFFD;
    public static final int NOCREASEID = 0x7FFFFFFC;
    private static final Logger LOGGER = Logger.getLogger(GeomUtil.class.getSimpleName());
    public static final int OPT_QUICK_TEST_MANIFOLD = 1;
    public static final int OPT_INTERSECT = 2;
    public static final int OPT_REMOVE_INTERNAL_FACES = 4;
    public static final int OPT_UNION_PIECES = 8;
    public static final int OPT_KEEP_ISECT_RESULT_IF_NONMANIFOLD = 16;
    public static final int OPT_REMOVE_VESTIGIAL_FACES = 32;
    public static final int OPT_SPLIT_INTO_SOLIDS = 64;
    private static final Point2d s_invalidUV = new Point2d();
    private static final Vector3d s_invalidNormal = new Vector3d();
    public static final ModelAttrib INVALID_ATTRIB = new ModelAttrib(s_invalidNormal, s_invalidUV);

    public static AABox getBounds(IGeom geomObj) {
        AABox bounds = new AABox();
        geomObj.getBoundingBox(bounds);
        return bounds;
    }

    public static AABox getBounds(IGeomSource geomObj) {
        return geomObj.getBounds();
    }

    public static AABox getBounds(Collection<? extends IGeomSource> geomObjs) {
        AABox bounds = new AABox();
        for (IGeomSource iGeomSource : geomObjs) {
            bounds.add(iGeomSource.getBounds());
        }
        return bounds;
    }

    public static UnitAABox getUnitBounds(IGeomSource geomObj) {
        return new UnitAABox(GeomUtil.getBounds(geomObj), Geometry.LU);
    }

    public static UnitAABox getUnitBounds(IGeom geomObj) {
        return new UnitAABox(GeomUtil.getBounds(geomObj), Geometry.LU);
    }

    public static <T> boolean isUniform(T[] vals, boolean identityEquals) {
        if (vals.length == 0) {
            return false;
        }
        T base = vals[0];
        if (identityEquals) {
            for (int m = 1; m < vals.length; ++m) {
                if (vals[m] == base) continue;
                return false;
            }
        } else {
            for (int m = 1; m < vals.length; ++m) {
                if (theUtil.equal(base, vals[m])) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> T[] optimizeArray(T[] vals, Class<T> clazz, boolean identityEquals) {
        if (!GeomUtil.isUniform(vals, identityEquals) || vals.length <= 1) {
            return vals;
        }
        Object[] newVals = (Object[])Array.newInstance(clazz, 1);
        newVals[0] = vals[0];
        return newVals;
    }

    public static boolean isUniform(Surface[] surfs) {
        return GeomUtil.isUniform(surfs, true);
    }

    public static Surface[] optimize(Surface[] surfs) {
        return GeomUtil.optimizeArray(surfs, Surface.class, true);
    }

    public static boolean isUniform(Color[] colors) {
        return GeomUtil.isUniform(colors, false);
    }

    public static Color[] optimize(Color[] colors) {
        return GeomUtil.optimizeArray(colors, Color.class, false);
    }

    public static Pair<Surface[], Color[]> getSurfsAndColors(int numFaces, IPropsSrc props) {
        Color[] colors;
        Surface[] surfs;
        int nUniform = props.getUniformCount(0, numFaces);
        if (nUniform == numFaces) {
            IPrimProps first = props.iterator().next();
            surfs = new Surface[]{(Surface)first.getMaterial()};
            colors = new Color[]{first.getColor()};
        } else {
            surfs = new Surface[numFaces];
            colors = new Color[numFaces];
            int ix = 0;
            for (IPrimProps pprops : props) {
                surfs[ix] = (Surface)pprops.getMaterial();
                colors[ix] = pprops.getColor();
                ++ix;
            }
            surfs = GeomUtil.optimize(surfs);
            colors = GeomUtil.optimize(colors);
        }
        return new Pair<Surface[], Color[]>(surfs, colors);
    }

    public static DisplayGeom convertToOutline(DisplayGeom dispGeom) {
        IGeomNode fnode = dispGeom.node.flatten();
        List<IPrimitive> prims = thunderheadeng.geometry.objs.GeomUtil.explodeToTypes(fnode.getLocalGeom(), 7);
        IElemSource<Boolean> creaseElem = fnode.getElements(Elements.CREASE);
        IElemSource<Elements.Orient> orientElem = fnode.getElements(Elements.ORIENT);
        ArrayList resultGeom = new ArrayList();
        PropsBuilder resultProps = new PropsBuilder();
        Elements.processPolys(prims, (ufaces, m, allPolys) -> {
            if (!allPolys.booleanValue()) {
                return;
            }
            int pcount = ufaces.size();
            List<Boolean> creases = creaseElem.subset((int)m, pcount).generate(Boolean.class, (List<IPolygon>)ufaces, orientElem.subset((int)m, pcount), dispGeom.props.subset((int)m, pcount));
            Iterator<Boolean> creaseit = creases.iterator();
            Iterator<IPrimProps> propit = dispGeom.props.subset((int)m, pcount).iterator();
            for (IPrimitive prim : ufaces) {
                IPolygon poly = (IPolygon)prim;
                IPrimProps props = propit.next();
                int nloops = poly.getNumLoops();
                for (int n = 0; n < nloops; ++n) {
                    int nverts = poly.getNumPoints(n);
                    for (int o = 0; o < nverts; ++o) {
                        Boolean creased = creaseit.next();
                        if (!creased.booleanValue()) continue;
                        resultGeom.add(poly.getPoint(n, o));
                        resultGeom.add(poly.getPoint(n, (o + 1) % nverts));
                        resultProps.add(props);
                    }
                }
            }
        });
        Mesh mesh = new Mesh(theUtil.toArray(resultGeom, Point3d.class), theUtil.sequentialList(0, resultGeom.size()), 1);
        IPropsSrc props = resultProps.finalizeProps();
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(mesh), props);
    }

    public static boolean isCullGeom(IGeomNode node) {
        if (GeomUtil.isCullGeom(node.getLocalGeom())) {
            return true;
        }
        for (IGeomNode iGeomNode : node.getChildren()) {
            if (!GeomUtil.isCullGeom(iGeomNode)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCullGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            return true;
        }
        if (geom instanceof IProxyGeom) {
            return GeomUtil.isCullGeom(((IProxyGeom)geom).getBase());
        }
        if (geom instanceof GeomGroup) {
            for (IGeom child : ((GeomGroup)geom).children) {
                if (GeomUtil.isCullGeom(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<IPolygon> toPolys(IFace face, double errorTol, boolean triangulateIfHoles) {
        ArrayList<IPolygon> polys = new ArrayList<IPolygon>();
        GeomUtil.toPolys(face, errorTol, triangulateIfHoles, polys);
        return polys;
    }

    public static void toPolys(IFace face, double errorTol, boolean triangulateIfHoles, List<IPolygon> polys) {
        if (face instanceof IPolygon) {
            IPolygon poly = (IPolygon)face;
            if (!triangulateIfHoles || poly.getNumLoops() <= 1) {
                polys.add(poly);
                return;
            }
        }
        polys.addAll(thunderheadeng.geometry.objs.GeomUtil.getTriangles(errorTol, face));
    }

    public static <T> T[] matchPrimCount(IGeomNode geom, int primTypes, T[] vals, Class<T> type) {
        return GeomUtil.matchPrimCount(geom, primTypes, vals, type, false);
    }

    public static <T> T[] matchPrimCount(IGeomNode geom, int primTypes, T[] vals, Class<T> type, boolean newArray) {
        return GeomUtil.matchPrimCount(vals, type, newArray, geom.getNumPrims(primTypes));
    }

    public static <T> T[] matchPrimCount(T[] vals, Class<T> type, boolean newArray, int primCount) {
        if (vals.length == primCount) {
            return newArray ? (Object[])vals.clone() : vals;
        }
        assert (vals.length == 1);
        Object[] newVals = (Object[])Array.newInstance(type, primCount);
        for (int m = 0; m < primCount; ++m) {
            newVals[m] = vals[0];
        }
        return newVals;
    }

    public static Task taskChanged(IPyroObject obj) {
        return new ChangedTask(obj);
    }

    public static IPolygon toPoly(Model model, Face face) {
        return GeomUtil.toPoly(model, face, i -> {}, o -> {});
    }

    public static <T> IPolygon toPoly(Model model, Face face, Consumer<int[]> edgeids, Consumer<T> vertAttrs) {
        Object defAttrs = model.getAttributeInterpolator() != null ? model.getAttributeInterpolator().getDefault() : null;
        ArrayList<Point3d[]> verts = new ArrayList<Point3d[]>();
        for (int m = 0; m < face.edgeLoops.size(); ++m) {
            FaceLoop loop = face.edgeLoops.get(m);
            if (loop.edges.size() < 3) continue;
            Point3d[] loopVerts = new Point3d[loop.edges.size()];
            for (int n = 0; n < loop.edges.size(); ++n) {
                EdgeUse eu = loop.edges.get(n);
                Vertex v = eu.v1();
                loopVerts[n] = v.loc;
                Object attrs = v.getFaceAttrib(face);
                edgeids.accept(eu.edge.groups);
                vertAttrs.accept(attrs != null ? attrs : defAttrs);
            }
            verts.add(loopVerts);
        }
        return PolyUtil.newPoly(theUtil.toArray(verts, Point3d[].class));
    }

    public static DisplayGeom generateClipCaps(IPyroDisplayProps drawProps, DisplayGeom uncappedGeom, ConvexHull region, IPropsSrc psrc, boolean autoOpacity, IElemSource<Point2d> capUV) {
        if (drawProps == null) {
            return DisplayGeom.EMPTY;
        }
        try {
            if (uncappedGeom.node.getNumPrims(1) == 0) {
                return DisplayGeom.EMPTY;
            }
            IFilteredCollection<GeomNodeUtil.QuickFlatten> solidGeom = theUtil.filter(uncappedGeom.node.quickFlatten(5), pair -> !pair.geom.isShell());
            if (solidGeom.isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            AABox bounds = uncappedGeom.node.getBoundingBox(new AABox());
            if (region.test(bounds) != Containment.INTERSECTS) {
                return DisplayGeom.EMPTY;
            }
            int geomid = Integer.MAX_VALUE;
            Model model = null;
            Matrix4d wl = null;
            Matrix4d lw = null;
            Point3d tp = null;
            AABox lbounds = null;
            Plane3d[] planes = region.getPlanes();
            for (int n = 0; n < planes.length; ++n) {
                Point3d[] fverts;
                Plane3d plane = planes[n];
                double side = Inter3D.testPlaneAABox(plane, bounds, 1.0E-6);
                if (side != 0.0) continue;
                if (model == null) {
                    model = new Model();
                    wl = new Matrix4d();
                    lw = new Matrix4d();
                    tp = new Point3d();
                    lbounds = new AABox();
                } else {
                    lbounds.reset();
                }
                Util.getPlaneTransforms(plane, wl, lw);
                for (int m = 0; m < 8; ++m) {
                    bounds.getCorner(m, tp);
                    wl.transform(tp);
                    lbounds.add(tp);
                }
                lbounds = lbounds.scale(1.5);
                for (Point3d p : fverts = new Point3d[]{new Point3d(lbounds.getMinX(), lbounds.getMinY(), 0.0), new Point3d(lbounds.getMaxX(), lbounds.getMinY(), 0.0), new Point3d(lbounds.getMaxX(), lbounds.getMaxY(), 0.0), new Point3d(lbounds.getMinX(), lbounds.getMaxY(), 0.0)}) {
                    lw.transform(p);
                }
                model.addPolygonFace(n, plane, fverts);
            }
            if (model == null || model.getFaces().isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            ArrayList<IGeom> xformedSolidGeoms = new ArrayList<IGeom>(theUtil.map(solidGeom, qxform -> qxform.geom.transform(qxform.ti, 0)));
            List<IFace> solidFaces = thunderheadeng.geometry.objs.GeomUtil.explode(xformedSolidGeoms, IFace.class);
            ArrayList<Face> delFaces = new ArrayList<Face>();
            for (IFace face : solidFaces) {
                IPolygon poly;
                boolean triangulate = true;
                if (face instanceof IPolygon && (poly = (IPolygon)face).getNumLoops() == 1) {
                    model.addPolygonFace(Integer.MAX_VALUE, poly.getPlane(true), PolyUtil.getAllVerts(poly, false));
                    triangulate = false;
                }
                if (triangulate) {
                    Mesh fmesh = face.triangulate(drawProps.getFaceError());
                    int m = 0;
                    while (m < fmesh.indices.length) {
                        Point3d p1 = fmesh.vertices[fmesh.indices[m++]];
                        Point3d p2 = fmesh.vertices[fmesh.indices[m++]];
                        Point3d p3 = fmesh.vertices[fmesh.indices[m++]];
                        model.addPolygonFace(Integer.MAX_VALUE, new Plane3d(true, p1, p2, p3), p1, p2, p3);
                    }
                }
                delFaces.clear();
                delFaces.addAll(model.getFaces(Integer.MAX_VALUE));
                for (Face delFace : delFaces) {
                    if (delFace.groups.length > 1) continue;
                    model.deleteFace(delFace, true, true);
                }
            }
            int alpha = -1;
            if (psrc == null || autoOpacity) {
                int nuniform;
                IPropsSrc cprops = null;
                int numPrims = uncappedGeom.node.getNumPrims(7);
                for (int m = 0; m < numPrims; m += nuniform) {
                    nuniform = uncappedGeom.props.getUniformCount(m, numPrims - m);
                    IPrimProps pprops = uncappedGeom.props.get(m);
                    if (!(pprops instanceof IPrimProps.Face)) continue;
                    cprops = new UniformProps(pprops);
                    break;
                }
                if (cprops == null) {
                    return DisplayGeom.EMPTY;
                }
                if (psrc == null) {
                    psrc = cprops;
                } else {
                    IPrimProps props0 = cprops.get(0);
                    if (props0.getMaterial() == null) {
                        alpha = props0.getColor().getAlpha();
                    } else {
                        IMatAttrs attrs = props0.getMaterial().getAttributes();
                        alpha = attrs.getAlphaFromDiffuseAndOpacity();
                    }
                }
            }
            ArrayList<ManifoldSolid> solidInfos = null;
            ArrayList<IPolygon> geomResult = new ArrayList<IPolygon>();
            PropsBuilder pbuilder = new PropsBuilder();
            for (Face face : model.getFaces()) {
                tp = model.findPointInFace(face);
                if (tp == null || !region.contains(tp, 1.0E-6)) continue;
                if (face.groups.length == 1) {
                    if (solidInfos == null) {
                        solidInfos = new ArrayList<ManifoldSolid>();
                        for (IGeom solid : xformedSolidGeoms) {
                            solidInfos.add(new ManifoldSolid(solid, false));
                        }
                    }
                    boolean inSolid = false;
                    Iterator solid = solidInfos.iterator();
                    while (solid.hasNext()) {
                        Object si = (ManifoldSolid)solid.next();
                        if (((ManifoldSolid)si).classify(tp, 1.0E-6) == ManifoldSolid.PointClassify.OUTSIDE) continue;
                        inSolid = true;
                        break;
                    }
                    if (!inSolid) continue;
                }
                IPolygon poly = GeomUtil.toPoly(model, face);
                geomResult.add(poly);
                Object pid = -1;
                for (int id : face.groups) {
                    if (id == Integer.MAX_VALUE) continue;
                    pid = id;
                    break;
                }
                assert (pid != -1);
                IPrimProps fprops = psrc.get((int)pid);
                if (alpha != -1 && alpha != fprops.getColor().getAlpha()) {
                    Color c = fprops.getColor();
                    fprops = fprops.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                }
                pbuilder.add(fprops);
            }
            if (geomResult.isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            IPropertySet elements = Elements.newElements("teciuv0x193fa", capUV);
            GeomNodeLeaf node = GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(geomResult), elements);
            return new DisplayGeom((IGeomNode)node, pbuilder.finalizeProps());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return DisplayGeom.EMPTY;
        }
    }

    public static List<GeomNodeUtil.QuickFlatten> flatten(IGeomNode node) {
        return node.quickFlatten(1);
    }

    private static Point3d[] calcPointArray(Point3d p1, Point3d p2, int numPoints) {
        Point3d[] r = new Point3d[numPoints];
        double dx = (p2.x - p1.x) / (double)(numPoints - 1);
        double dy = (p2.y - p1.y) / (double)(numPoints - 1);
        double dz = (p2.z - p1.z) / (double)(numPoints - 1);
        r[0] = p1;
        r[numPoints - 1] = p2;
        for (int i = 1; i < numPoints - 1; ++i) {
            r[i] = new Point3d(p1.x + dx * (double)i, p1.y + dy * (double)i, p1.z + dz * (double)i);
        }
        return r;
    }

    public static DisplayGeom generateLinearArrayDisplayGeom(StatGeom.LinearPointArrayGeom geom, IPrimProps pointProp) {
        Point3d[] r;
        assert (geom instanceof LineSeg);
        ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
        PropsBuilder gprops = new PropsBuilder();
        geoms.add(geom);
        gprops.add(new IPrimProps.Edge(pointProp.getColor(), 3.0, IPrimProps.DEF_STIPPLE, 0));
        for (Point3d p : r = GeomUtil.calcPointArray(geom.p1, geom.p2, geom.d_numPoints)) {
            geoms.add(new Point(p));
            gprops.add(pointProp);
        }
        IGeom geometry = thunderheadeng.geometry.objs.GeomUtil.group(geoms);
        GeomNodeLeaf node = GeomNodeUtil.newNode(geometry);
        return new DisplayGeom((IGeomNode)node, gprops.finalizeProps());
    }

    public static DisplayGeom generateLinearVolumeArrayDisplayGeom(StatGeom.LinearVolumeArrayGeom geom, IPrimProps props) {
        assert (geom instanceof LineSeg);
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        PropsBuilder gprops = new PropsBuilder();
        geoms.add(geom);
        gprops.add(new IPrimProps.Edge(props.getColor(), 3.0, IPrimProps.DEF_STIPPLE, 0));
        Point3d[] r = GeomUtil.calcPointArray(geom.p1, geom.p2, geom.d_numPoints);
        Point3d delta = geom.getDelta();
        for (Point3d p : r) {
            geoms.add(new AABoxGeom(new AABox(p.x - delta.x, p.y - delta.y, p.z - delta.z, p.x + delta.x, p.y + delta.y, p.z + delta.z)));
            gprops.add(props, 6);
        }
        IGeom geometry = thunderheadeng.geometry.objs.GeomUtil.group(geoms);
        GeomNodeLeaf node = GeomNodeUtil.newNode(geometry);
        return new DisplayGeom((IGeomNode)node, gprops.finalizeProps());
    }

    public static Pair<IGeomNode, IntUnaryOperator> validateGEOM(GEOMValidateParams params, IObstruction obst) {
        Pair<IGeom, IntUnaryOperator> manifoldResult;
        IGeomNode gnode = obst.getGeom();
        assert (!params.test(64));
        IGeomNode fnode = gnode.flatten();
        if (params.test(1) && fnode.getLocalGeom().canBeMadeManifold() && (manifoldResult = fnode.getLocalGeom().makeManifold()) != null) {
            if (manifoldResult.v1 == fnode.getLocalGeom()) {
                gnode = GeomNodeUtil.solidify(gnode);
                return new Pair<IGeomNode, IntUnaryOperator>(gnode, i -> i);
            }
            assert (((IGeom)manifoldResult.v1).getNumPrims(6) == 0);
            int numOriginalFaces = fnode.getLocalGeom().getNumPrims(1);
            int numFaces = ((IGeom)manifoldResult.v1).getNumPrims(1);
            BitSet originalFaces = new BitSet(numOriginalFaces);
            boolean faceOrderSame = true;
            for (int m = 0; m < numFaces; ++m) {
                int origIx = ((IntUnaryOperator)manifoldResult.v2).applyAsInt(m);
                faceOrderSame &= origIx == m;
                originalFaces.set(origIx);
            }
            IPropertySet elems = fnode.getLocalElements();
            if (!faceOrderSame || originalFaces.cardinality() != numOriginalFaces) {
                int count;
                ElementsBuilder newElemsBuilder = new ElementsBuilder();
                for (int m = 0; m < numFaces; m += count) {
                    int nextMappedIx;
                    int mappedIx = ((IntUnaryOperator)manifoldResult.v2).applyAsInt(m);
                    count = 1;
                    for (int n = m + 1; n < numFaces && (nextMappedIx = ((IntUnaryOperator)manifoldResult.v2).applyAsInt(n)) == mappedIx + n; ++n) {
                        ++count;
                    }
                    newElemsBuilder.addRange(elems, mappedIx, count);
                }
                elems = newElemsBuilder.finish();
            }
            SolidGeom solidGeom = thunderheadeng.geometry.objs.GeomUtil.solidify((IGeom)manifoldResult.v1);
            GeomNodeLeaf newNode = GeomNodeUtil.newNode(solidGeom, elems);
            return new Pair<IGeomNode, IntUnaryOperator>(newNode, (IntUnaryOperator)manifoldResult.v2);
        }
        if (params.test(2)) {
            try {
                List<Pair<IGeomNode, IntUnaryOperator>> result = GeomUtil.makeManifold(params, fnode, obst.getDisplayProps());
                assert (result.size() == 1);
                return result.get(0);
            }
            catch (NmtSolidUtil.ManifoldException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Pair<IGeomNode, IntUnaryOperator>> makeManifold(GEOMValidateParams params, IGeomNode geom, IPropsSrc dprops) throws NmtSolidUtil.ManifoldException {
        IGeomNode fgeom = geom.flatten();
        try {
            void var8_20;
            Model model = GeomUtil.toModel(TransformUtil.IDENTITY_INFO, fgeom.getLocalGeom(), (ix, props) -> ix, dprops, 0, fgeom.getLocalElements(), 0);
            if (model.getFaces().isEmpty()) {
                throw new NmtSolidUtil.ManifoldException(Intl.intl("Geometry is empty."));
            }
            ArrayList<Edge> remEdges = new ArrayList<Edge>();
            for (Edge edge : model.getEdges()) {
                if (edge.faces.size() != 1 || !edge.faces.get(0).isInternalEdge(edge)) continue;
                remEdges.add(edge);
            }
            ArrayList<Vertex> potRemVerts = new ArrayList<Vertex>();
            for (Edge edge : remEdges) {
                potRemVerts.add(edge.v1);
                potRemVerts.add(edge.v2);
                model.removeEdgeFromFace(edge);
            }
            for (Vertex vertex : potRemVerts) {
                if (!vertex.edges.isEmpty() || vertex.face == null) continue;
                model.removeVertexFromFace(vertex);
            }
            boolean bl = params.test(32);
            if (params.test(4)) {
                LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
                Predicate<Face> testRemove = face -> {
                    if (face.groups.length == 1) {
                        return false;
                    }
                    boolean anyEdgesNonManifold = face.edgeLoops.stream().flatMap(loop -> loop.edges.stream()).anyMatch(eu -> eu.edge.faces.size() > 2);
                    return anyEdgesNonManifold;
                };
                for (Face face2 : model.getFaces()) {
                    if (!testRemove.test(face2)) continue;
                    linkedIdentityHashSet.add(face2);
                }
                LinkedIdentityHashSet<Face> adjFaces = new LinkedIdentityHashSet<Face>();
                for (Face remFace : linkedIdentityHashSet) {
                    if (!bl) {
                        for (FaceLoop loop : remFace.edgeLoops) {
                            for (EdgeUse eu : loop.edges) {
                                for (Face adjFace : eu.edge.faces) {
                                    if (linkedIdentityHashSet.contains(adjFace)) continue;
                                    adjFaces.add(adjFace);
                                }
                            }
                        }
                    }
                    model.deleteFace(remFace, true, true);
                }
                GeomUtil.removeVestigialNonManifoldFaces(model, adjFaces);
            }
            if (bl) {
                GeomUtil.removeVestigialNonManifoldFaces(model, model.getFaces());
            }
            if (model.isEmpty()) {
                throw new NmtSolidUtil.ManifoldException(Intl.intl("Geometry was empty after removing non-manifold faces."));
            }
            Object var8_18 = null;
            if (!params.test(16)) {
                NmtSolidUtil.validateClosedManifold(model, false, Geometry.LU, UnitSystem.getSource(0));
                Boolean bl2 = true;
            }
            ArrayList<Pair<IGeomNode, IntUnaryOperator>> result = new ArrayList<Pair<IGeomNode, IntUnaryOperator>>();
            BiConsumer<Model, Collection> addModel = (mod, faces) -> {
                int numOrigFaces = fgeom.getNumPrims(1);
                int[] faceIds = new int[faces.size()];
                IPrimProps[] resultProps = new IPrimProps[faces.size()];
                int fix = 0;
                for (Face face : faces) {
                    int id;
                    assert (face.groups.length != 0);
                    assert (IntStream.of(face.groups).allMatch(i -> i >= 0 && i < numOrigFaces));
                    faceIds[fix] = id = face.groups[0];
                    resultProps[fix] = dprops.get(id);
                    ++fix;
                }
                IntUnaryOperator mapFaceIxes = i -> faceIds[i];
                GeomNodeLeaf finalGeom = GeomUtil.toGeomNode(mod, faces, new FlattenedProps(resultProps), true, true);
                result.add(new Pair<GeomNodeLeaf, IntUnaryOperator>(finalGeom, mapFaceIxes));
            };
            if (params.test(64) && (var8_20 != null && var8_20.booleanValue() || var8_20 == null && NmtSolidUtil.isClosedManifold(model, false))) {
                List<NmtSolidUtil.Solid> list = NmtSolidUtil.separateSolids(model);
                for (NmtSolidUtil.Solid solid : list) {
                    addModel.accept(model, theUtil.flatMap(solid.shells, shell -> shell.faces));
                }
            } else {
                addModel.accept(model, model.getFaces());
            }
            return result;
        }
        catch (NmtSolidUtil.ManifoldException e) {
            throw e;
        }
        catch (Throwable t) {
            TeciLogging.log(LOGGER, t);
            throw new NmtSolidUtil.ManifoldException(t);
        }
    }

    private static void removeVestigialNonManifoldFaces(Model model, Collection<Face> seedFaces) {
        if (seedFaces.isEmpty()) {
            return;
        }
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        for (Face face : seedFaces) {
            if (!face.edgeLoops.stream().flatMap(loop -> loop.edges.stream()).anyMatch(eu -> eu.edge.faces.size() == 1)) continue;
            open.addLast(face);
        }
        ArrayList<Face> toRemove = new ArrayList<Face>();
        IdentityHashSet closed = new IdentityHashSet();
        closed.addAll(open);
        while (!open.isEmpty()) {
            Face face = (Face)open.removeFirst();
            toRemove.add(face);
            for (FaceLoop loop2 : face.edgeLoops) {
                for (EdgeUse eu2 : loop2.edges) {
                    if (eu2.edge.faces.size() != 2) continue;
                    for (Face adjFace : eu2.edge.faces) {
                        if (adjFace == face || !closed.add(adjFace)) continue;
                        open.addLast(adjFace);
                    }
                }
            }
        }
        if (toRemove.size() == model.getFaces().size()) {
            model.clear();
            return;
        }
        for (Face face : toRemove) {
            model.deleteFace(face, true, true);
        }
    }

    public static Model toModel(TransformInfo xform, IGeom geom, BiFunction<Integer, IPrimProps, Integer> getFaceId, IPropsSrc props, int propOffset, IPropertySet elements, int elemOffset) {
        Model model = new Model(new ModelAttribInterpolator());
        List faces = GeomUtil.explode(geom.transform(xform, 0), IFace.class);
        int nprims = faces.size();
        IPropertySet subElems = Elements.subset(elements, elemOffset, nprims);
        Elements.transformEq(subElems, xform);
        IElemSource creases = (IElemSource)((Object)subElems.get(Elements.CREASE));
        IElemSource orients = (IElemSource)((Object)subElems.get(Elements.ORIENT));
        Map<String, IElemSource<Point2d>> texuv = subElems.get(Elements.UV);
        IElemSource normals = (IElemSource)((Object)subElems.get(Elements.NORMAL));
        IPropsSrc sprops = props.subset(propOffset, nprims);
        Iterator<IPrimProps> propit = sprops.iterator();
        int[] creaseid = new int[]{0x7FFFFFFD};
        int[] nocreaseid = new int[]{0x7FFFFFFC};
        ArrayList edgeids = new ArrayList();
        ArrayList attribs = new ArrayList();
        Point3d[][] tpoints = new Point3d[1][3];
        Elements.processPolys(faces, (ufaces, m, allPoly) -> {
            int ucount = ufaces.size();
            if (allPoly.booleanValue()) {
                IElemSource<Elements.Orient> uorients = orients.subset((int)m, ucount);
                IPropsSrc uprops = sprops.subset((int)m, ucount);
                List<Boolean> ucreases = creases.subset((int)m, ucount).generate(Boolean.class, (List<IPolygon>)ufaces, uorients, uprops);
                Iterator<Boolean> creaseit = ucreases.iterator();
                Iterator<Vector3d> ccwNormIt = normals != Elements.NO_NORMAL ? normals.subset((int)m, ucount).generate(Vector3d.class, (List<IPolygon>)ufaces, uorients, uprops).iterator() : null;
                MappedIterator<Vector3d, Vector3d> cwNormIt = ccwNormIt != null ? new MappedIterator<Vector3d, Vector3d>(ccwNormIt, n -> Util3D.negate(n)) : null;
                LinkedHashMap<String, Iterator<Point2d>> texuvIts = new LinkedHashMap<String, Iterator<Point2d>>();
                for (Map.Entry entry : texuv.entrySet()) {
                    texuvIts.put((String)entry.getKey(), ((IElemSource)entry.getValue()).subset((int)m, ucount).generate(Point2d.class, (List<IPolygon>)ufaces, uorients, uprops).iterator());
                }
                Iterator<Elements.Orient> orientIt = uorients.getPerPrimIterator();
                int fix = m;
                for (IFace face : ufaces) {
                    IPrimProps prop = (IPrimProps)propit.next();
                    Integer id = (Integer)getFaceId.apply(fix, prop);
                    IPolygon poly = (IPolygon)face;
                    Point3d[][] loops = PolyUtil.getLoops(poly, false);
                    int nverts = PolyUtil.getNumVerts(poly);
                    Elements.Orient orient = orientIt.next();
                    Iterator<Vector3d> fnormIt = orient.isCCW() ? ccwNormIt : cwNormIt;
                    Iterator ftexuvIt = (Iterator)Elements.chooseUVItem(texuvIts, prop.getMaterial());
                    edgeids.clear();
                    attribs.clear();
                    Runnable addNextAttrib = GeomUtil.getFaceAttribAdder(attribs, fnormIt, ftexuvIt);
                    for (int n2 = 0; n2 < nverts; ++n2) {
                        boolean crease = creaseit.next();
                        edgeids.add(crease ? creaseid : nocreaseid);
                        addNextAttrib.run();
                    }
                    for (Iterator texuvIt : texuvIts.values()) {
                        if (texuvIt == ftexuvIt) continue;
                        for (int n3 = 0; n3 < nverts; ++n3) {
                            texuvIt.next();
                        }
                    }
                    model.addPolygonFace(poly.getPlane(true), loops, new int[]{id}, edgeids, attribs);
                    ++fix;
                }
            } else {
                int fix = m;
                for (IFace face : ufaces) {
                    IPrimProps prop = (IPrimProps)propit.next();
                    Integer id = (Integer)getFaceId.apply(fix, prop);
                    Mesh mesh = face.triangulate(0.1);
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)orients.getPrimElement(fix)));
                    ElementMesh<Boolean> fcreases = creases.getPrimSource(fix).generate(Boolean.class, face, orient, mesh, prop);
                    Iterator<Boolean> fcreaseit = fcreases.iterator();
                    Iterator<Vector3d> fnormIt = normals != Elements.NO_NORMAL ? normals.getPrimSource(fix).generate(Vector3d.class, face, orient, mesh, prop).iterator() : null;
                    IElemSource fuvs = (IElemSource)Elements.chooseUVItem(texuv, prop.getMaterial());
                    Iterator<Point2d> fuvsIt = fuvs != null ? fuvs.getPrimSource(fix).generate(Point2d.class, face, orient, mesh, prop).iterator() : null;
                    Runnable addNextAttrib = GeomUtil.getFaceAttribAdder(attribs, fnormIt, fuvsIt);
                    for (int n4 = 0; n4 < mesh.indices.length; n4 += 3) {
                        edgeids.clear();
                        attribs.clear();
                        for (int o = 0; o < 3; ++o) {
                            tpoints[0][o] = mesh.vertices[mesh.indices[n4 + o]];
                            edgeids.add(fcreaseit.next() != false ? creaseid : nocreaseid);
                            addNextAttrib.run();
                        }
                        model.addPolygonFace(new Plane3d(true, tpoints[0]), tpoints, new int[]{id}, edgeids, attribs);
                    }
                    ++fix;
                }
            }
        });
        return model;
    }

    private static Runnable getFaceAttribAdder(List<ModelAttrib> attribs, Iterator<Vector3d> normIt, Iterator<Point2d> ftexuvIt) {
        if (ftexuvIt == null && normIt == null) {
            return () -> {};
        }
        return () -> {
            Vector3d normal = normIt != null ? (Vector3d)normIt.next() : s_invalidNormal;
            Point2d uv = ftexuvIt != null ? (Point2d)ftexuvIt.next() : s_invalidUV;
            attribs.add(new ModelAttrib(normal, uv));
        };
    }

    public static GeomNodeLeaf toGeomNode(Model srcModel, IPropsSrc faceProps, boolean isSolid, boolean orientSolidFaces) {
        return GeomUtil.toGeomNode(srcModel, srcModel.getFaces(), faceProps, isSolid, orientSolidFaces);
    }

    public static GeomNodeLeaf toGeomNode(Model srcModel, Collection<Face> faces, IPropsSrc faceProps, boolean isSolid, boolean orientSolidFaces) {
        ArrayList<IPolygon> geoms = new ArrayList<IPolygon>(faces.size());
        ElementsBuilder elements = new ElementsBuilder();
        ArrayList creaseList = new ArrayList();
        ArrayList normalList = new ArrayList();
        ArrayList uvList = new ArrayList();
        Iterator<IPrimProps> propsIt = faceProps.iterator();
        if (orientSolidFaces && faces.size() != srcModel.getFaces().size()) {
            srcModel = new Model(srcModel.getAttributeInterpolator());
            srcModel.add(faces, Collections.emptyList(), Collections.emptyList());
            faces = srcModel.getFaces();
        }
        Model fSrcModel = srcModel;
        Supplier<Predicate> getPosFaces = () -> {
            Predicate<Face> posFaces;
            if (orientSolidFaces && (posFaces = NmtSolidUtil.getSolidFaceOrients(fSrcModel)) != null) {
                return posFaces;
            }
            return Predicates.alwaysTrue();
        };
        Predicate posFaces = getPosFaces.get();
        for (Face face : faces) {
            String uvSet;
            IElemSource<Vector3d> normals;
            IPrimProps props = propsIt.next();
            creaseList.clear();
            normalList.clear();
            uvList.clear();
            boolean[] normalsValid = new boolean[]{true};
            boolean[] uvsValid = new boolean[]{true};
            Consumer<ModelAttrib> attrsResult = attrs -> {
                if (attrs == INVALID_ATTRIB || attrs == null) {
                    normalsValid[0] = false;
                    uvsValid[0] = false;
                } else {
                    if (attrs.normal != s_invalidNormal) {
                        normalList.add(attrs.normal);
                    } else {
                        normalsValid[0] = false;
                    }
                    if (attrs.texuv != s_invalidUV) {
                        uvList.add(attrs.texuv);
                    } else {
                        uvsValid[0] = false;
                    }
                }
            };
            IPolygon poly = GeomUtil.toPoly(srcModel, face, eids -> {
                boolean crease = NmtUtil.findGroup(eids, 0x7FFFFFFD) || !NmtUtil.findGroup(eids, 0x7FFFFFFC);
                creaseList.add(crease);
            }, attrsResult);
            boolean isOrientPos = posFaces.test(face);
            IElemSource<Elements.Orient> orient = isOrientPos ? Elements.CCW : Elements.CW;
            elements.add(Elements.ORIENT, orient, 1);
            geoms.add(poly);
            elements.add(Elements.CREASE, new ElementPoly<Boolean>(theUtil.toArray(creaseList, Boolean.class)), 1);
            if (!normalsValid[0]) {
                normals = Elements.NO_NORMAL;
            } else {
                ArrayList finalNormals = isOrientPos ? normalList : theUtil.map(normalList, v -> Util3D.negate(v));
                normals = new ElementPoly<Vector3d>(theUtil.toArray(finalNormals, Vector3d.class));
            }
            elements.add(Elements.NORMAL, normals, 1);
            String string = uvSet = props.getMaterial() != null ? props.getMaterial().getAttributes().getUVSet() : null;
            if (uvsValid[0] && uvSet != null) {
                elements.addUV(uvSet, new ElementPoly<Point2d>(theUtil.toArray(uvList, Point2d.class)), 1);
            }
            elements.next(1);
        }
        IGeom geom = thunderheadeng.geometry.objs.GeomUtil.group(geoms);
        if (isSolid) {
            geom = new SolidGeom(geom);
        }
        IPropertySet elems = elements.finish();
        if (PyroSim.FDS7_DEBUG) {
            elems = Elements.copyOf(elems);
            elems.set(Elements.CREASE, Elements.ALL_CREASE);
            elems = Elements.finalizeElements(elems);
        }
        return GeomNodeUtil.newNode(geom, elems);
    }

    public static class ModelAttribInterpolator
    implements IAttribInterpolator<ModelAttrib> {
        @Override
        public ModelAttrib getDefault() {
            return INVALID_ATTRIB;
        }

        private static <T> T interpolate(double[] params, T v1, T v2, T v3, T invalid, QuadFunction<double[], T, T, T, T> interpolate) {
            return v1 == invalid || v2 == invalid || v3 == invalid ? invalid : interpolate.apply(params, v1, v2, v3);
        }

        @Override
        public ModelAttrib interpolate(ITriInterpolator3d interpolator, double[] params, ModelAttrib a1, ModelAttrib a2, ModelAttrib a3) {
            if (a1 == INVALID_ATTRIB || a2 == INVALID_ATTRIB || a3 == INVALID_ATTRIB) {
                return INVALID_ATTRIB;
            }
            return new ModelAttrib(ModelAttribInterpolator.interpolate(params, a1.normal, a2.normal, a3.normal, s_invalidNormal, interpolator::interpolateNorm), ModelAttribInterpolator.interpolate(params, a1.texuv, a2.texuv, a3.texuv, s_invalidUV, interpolator::interpolate));
        }

        @Override
        public ModelAttrib transform(ModelAttrib attrib, ITransform.ITransformer transform) {
            if (attrib == INVALID_ATTRIB) {
                return attrib;
            }
            if (attrib.normal == s_invalidNormal) {
                return attrib;
            }
            return new ModelAttrib(transform.transformNew(attrib.normal), attrib.texuv);
        }
    }

    public static class ModelAttrib {
        public final Vector3d normal;
        public final Point2d texuv;

        public ModelAttrib(Vector3d normal, Point2d texuv) {
            this.normal = normal;
            this.texuv = texuv;
        }

        public String toString() {
            return String.format("normal=%s, texuv=%s", this.normal == s_invalidNormal ? "INVALID" : this.normal, this.texuv == s_invalidUV ? "INVALID" : this.texuv);
        }
    }

    public static final class GEOMValidateParams {
        public final int options;

        public GEOMValidateParams(int options) {
            this.options = options;
        }

        public boolean test(int options) {
            return (this.options & options) == options;
        }
    }

    private static class ChangedTask
    extends AUndoableTask {
        private final IPyroObject d_obj;

        public ChangedTask(IPyroObject obj) {
            this.d_obj = obj;
        }

        @Override
        public void run() {
            this.d_obj.changedEvt(new Object[0]);
        }

        @Override
        public void undo() {
            this.d_obj.changedEvt(new Object[0]);
        }
    }
}

