/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Comparator;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.domain.ModelImage;
import pyrosim.domain.NamedPyroObject;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class Floor
extends NamedPyroObject {
    static final long serialVersionUID = 1L;
    public static final Color DEFAULT_COLOR = Color.BLUE;
    public static final double DEFAULT_THICKNESS = 0.2;
    public static final double DEFAULT_HEIGHT = 2.75;
    private UnitDouble d_elevation;
    private UnitDouble d_slabThickness;
    private UnitDouble d_wallHeight;
    private ModelImage d_bgImage;
    private Color d_clipColor;

    public Floor(String name) {
        this(name, new UnitDouble(0.0, SI.METER), new UnitDouble(0.2, SI.METER), new UnitDouble(2.75, SI.METER), null, DEFAULT_COLOR);
    }

    public Floor(String name, UnitDouble elevation, UnitDouble slabThickness, UnitDouble wallHeight, ModelImage bgImage, Color clipColor) {
        super(name);
        this.d_elevation = elevation;
        this.d_slabThickness = slabThickness;
        this.d_wallHeight = wallHeight;
        this.d_clipColor = clipColor;
        this.setBgImage(bgImage);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_clipColor == null) {
            this.d_clipColor = DEFAULT_COLOR;
        }
    }

    public void setClipColor(Color color) {
        if (this.d_clipColor.equals(color)) {
            return;
        }
        this.d_clipColor = color;
        this.changedEvt(new Object[0]);
    }

    public Color getClipColor() {
        return this.d_clipColor;
    }

    public void setElevation(UnitDouble elevation) {
        if (this.d_elevation.equals(elevation)) {
            return;
        }
        this.d_elevation = elevation;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getElevation() {
        return this.d_elevation;
    }

    public void setSlabThickness(UnitDouble thickness) {
        if (this.d_slabThickness.equals(thickness)) {
            return;
        }
        this.d_slabThickness = thickness;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getSlabThickness() {
        return this.d_slabThickness;
    }

    public void setWallHeight(UnitDouble height) {
        if (this.d_wallHeight.equals(height)) {
            return;
        }
        this.d_wallHeight = height;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getWallHeight() {
        return this.d_wallHeight;
    }

    public UnitDouble getCeilingLoc() {
        return this.d_elevation.add(this.d_wallHeight);
    }

    public UnitDouble getSlabBottom() {
        return this.d_elevation.sub(this.d_slabThickness);
    }

    public void setBgImage(ModelImage bgImage) {
        this.d_bgImage = bgImage;
        if (this.d_bgImage != null) {
            BGImageXform xform = this.d_bgImage.getLWTransform();
            xform = new BGImageXform(xform.anchorImage, new Point3d(xform.anchorModel.x, xform.anchorModel.y, this.d_elevation.getValue(SI.METER)), xform.aImage, xform.bImage, xform.distABModel, xform.abAngle);
            this.d_bgImage.setLWTransform(xform);
        }
        this.changedEvt(new Object[0]);
    }

    public ModelImage getBgImage() {
        return this.d_bgImage;
    }

    @Override
    public boolean equals(Object f2) {
        return f2 == this || f2 instanceof Floor && super.equals(f2) && ((Floor)f2).d_elevation.equals(this.d_elevation) && ((Floor)f2).d_slabThickness.equals(this.d_slabThickness) && ((Floor)f2).d_wallHeight.equals(this.d_wallHeight) && ((Floor)f2).d_clipColor.equals(this.d_clipColor) && theUtil.equal(((Floor)f2).d_bgImage, this.d_bgImage);
    }

    @Override
    public Floor clone() {
        Floor clone = (Floor)super.clone();
        if (this.d_bgImage != null) {
            clone.d_bgImage = this.d_bgImage.clone();
        }
        return clone;
    }

    public boolean intersects(Floor f2) {
        double b1 = this.getSlabBottom().getValue(Geometry.LU);
        double t1 = this.getCeilingLoc().getValue(Geometry.LU);
        double b2 = f2.getSlabBottom().getValue(Geometry.LU);
        double t2 = f2.getCeilingLoc().getValue(Geometry.LU);
        return theUtil.lt(b2, t1, 1.0E-9) && theUtil.gt(t2, b1, 1.0E-9);
    }

    public static class CompareLevel
    implements Comparator<Floor> {
        @Override
        public int compare(Floor o1, Floor o2) {
            return o1.d_elevation.compareTo(o2.d_elevation);
        }
    }
}

