/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.gui.SurfaceHover;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.FaceCache;
import pyrosim.mv.tools.PyroToolHooks;
import pyrosim.mv.tools.SurfaceUtil;
import pyrosim.mv.tools.ToolUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.elem.ElementFlattened;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.AdvancedTool;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.scene3d.tools.IToggleListener;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SurfacePainterTool
extends APyroTool {
    private static final int PAINT_WHOLE_OBJ_KEY = 16;
    private final PyroMod d_domain;
    private final DisplayManager d_mgr;
    private final GenericGeomSrc d_displayObj;
    private final FaceCache d_faceCache;
    private Selection d_selection;
    private final Map<ISurfObj, IGeomNode> d_surfPaintedObjs;
    private final Map<ISurfObj, ISurfObj> d_objClones;
    private final Set<FacePainter> d_facePainters;
    private SurfaceHover d_hover;

    public SurfacePainterTool(PyroMod domain, ModelView mv, DisplayManager dispMgr, DrawProps drawProps) {
        super((IToolController)mv, drawProps, new ToolFunc());
        this.d_domain = domain;
        this.d_mgr = dispMgr;
        this.d_faceCache = new FaceCache(domain);
        this.d_displayObj = new GenericGeomSrc("", GeomNodeUtil.EMPTY_NODE, DisplayGeom.EMPTY.props);
        this.d_surfPaintedObjs = new IdentityHashMap<ISurfObj, IGeomNode>();
        this.d_facePainters = new LinkedHashSet<FacePainter>();
        this.d_objClones = new LinkedIdentityHashMap<ISurfObj, ISurfObj>();
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IAdvancedTool tool) {
                SurfaceUtil.chooseNextSurfaceSpecs(SurfacePainterTool.this.getProps());
                SurfacePainterTool.this.updatePickFace();
            }
        });
        this.setMenuBuilder(PyroToolHooks.Menu.TOOL_ACTIONS.key, (IAdvancedTool tool, MenuBuilder builder) -> {
            builder.addMutuallyExclusive(new PickPropAction(true, false), new PickPropAction(false, true), new PickPropAction(true, true));
            builder.addSeparator();
            if (this.getProps().get(DrawProps.SPECIFY_SURFACE).booleanValue()) {
                ToolUtil.addSurfSubmenu(this.d_domain, this.getProps(), SurfacePainterTool.getSurfFilter(), builder);
            }
            if (this.getProps().get(DrawProps.SPECIFY_COLOR).booleanValue()) {
                ToolUtil.addColorSubmenu(this.d_domain, this.getProps(), builder);
            }
        });
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
    }

    protected SurfaceHover getHoverWindow() {
        if (this.d_hover == null) {
            this.d_hover = new SurfaceHover(this.getAttachedComponent());
        }
        return this.d_hover;
    }

    @Override
    public void activate() {
        this.pauseRepaint();
        super.activate();
        this.d_mgr.add(this.d_displayObj);
        this.resumeRepaint(true);
        this.getHoverWindow().attach();
    }

    @Override
    public void deactivate() {
        this.getHoverWindow().detach();
        this.pauseRepaint();
        this.d_mgr.remove(this.d_displayObj);
        super.deactivate();
        this.resumeRepaint(true);
    }

    public static Predicate<Surface> getSurfFilter() {
        Predicate<Surface> surfFilter = Obstruction.getSurfaceFilter().or(Vent.getSurfaceFilter());
        Predicate<Surface> enabledFilter = new Predicate<Surface>(){

            @Override
            public boolean test(Surface o) {
                return o.isEnabled();
            }
        };
        return surfFilter.and(enabledFilter);
    }

    @Override
    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(ISurfObj.class, GeomType.FACE));
    }

    @Override
    public ISnapConstraint getSnapConstraint() {
        return null;
    }

    private boolean getPickPropState(boolean surface, boolean color) {
        return this.getProps().get(DrawProps.SPECIFY_SURFACE) == surface && this.getProps().get(DrawProps.SPECIFY_COLOR) == color;
    }

    private static String getPickPropDesc(boolean surface, boolean color) {
        if (surface && color) {
            return Intl.intl("Paint Surface + Color");
        }
        if (surface) {
            return Intl.intl("Paint Surface only");
        }
        return Intl.intl("Paint Color only");
    }

    protected void setSurface(Surface surf) {
        this.getProps().set(DrawProps.SURFACE, surf);
        this.updatePickFace();
    }

    protected void setColor(Color color) {
        this.getProps().set(DrawProps.COLOR, color);
        if (color != null) {
            ColorHistory.add(color);
        }
        this.updatePickFace();
    }

    protected boolean getWholeObjMode() {
        return this.getPressedKeys().contains(16);
    }

    @Override
    protected String getStatusMessage() {
        return this.getWholeObjMode() ? "" : Intl.intl("Hold SHIFT to paint whole object");
    }

    protected void updatePickFace() {
        Selection newSel = null;
        boolean wholeObj = this.getWholeObjMode();
        DrawProps props = this.getProps();
        boolean specColor = props.get(DrawProps.SPECIFY_COLOR);
        Color color = props.get(DrawProps.COLOR);
        boolean specSurf = props.get(DrawProps.SPECIFY_SURFACE);
        Surface surf = props.get(DrawProps.SURFACE);
        Collection<IsectInfo> ii = this.getP1().snaps;
        if ((specColor || specSurf) && !ii.isEmpty()) {
            IsectInfo info = ii.iterator().next();
            assert (info.obj instanceof ISurfObj);
            ISurfObj obst = (ISurfObj)info.obj;
            if (!specSurf || obst.getSurfFilter().test(surf)) {
                FaceCache.Faces cfaces = this.d_faceCache.getFaces(obst);
                for (int m = 0; m < cfaces.faces.length; ++m) {
                    IFace iface = cfaces.faces[m];
                    Point3d projp = iface.project(info.isectPoint);
                    if (!projp.epsilonEquals(info.isectPoint, 1.0E-6) || !iface.classify((Point3d)projp, (double)1.0E-6).positive) continue;
                    newSel = new Selection(obst, m, wholeObj);
                    break;
                }
            }
        }
        if (!theUtil.equal(this.d_selection, newSel)) {
            this.d_selection = newSel;
            if (newSel != null) {
                IGeomNode geom;
                IGeomNode wholeObjGeom = this.d_selection.obj.getGeom();
                IElemSource<Point2d> texMapper = FDSUtil.getUsableTexMapperPrim(wholeObjGeom, newSel.obj.getTextureOrigin());
                if (newSel.wholeObj) {
                    geom = wholeObjGeom.initUVElements(texMapper);
                } else {
                    FaceCache.Faces faces = this.d_faceCache.getFaces(this.d_selection.obj);
                    IFace face = faces.faces[this.d_selection.faceIx];
                    IPropertySet felems = Elements.getPrimElements(faces.elems, this.d_selection.faceIx);
                    geom = GeomNodeUtil.newNode(face, felems).initUVElements(texMapper);
                }
                this.d_displayObj.setGeom(geom);
                Color fcolor = specColor ? color : null;
                Surface fsurf = specSurf ? surf : this.getSurface(newSel.obj, newSel.faceIx);
                IPrimProps.Face fprops = FDSUtil.newObstFaceProps(fcolor, fsurf, 0);
                this.d_displayObj.setDisplayProps(new UniformProps(fprops));
            } else {
                this.clearDisplay();
            }
            Collection<IDisplayable> displays = this.d_mgr.getDisplayObjs(this.d_displayObj);
            if (!displays.isEmpty()) {
                this.d_mgr.updateDisplays(this.d_displayObj);
                for (GeomDisplay disp : theUtil.filter(displays, GeomDisplay.class)) {
                    disp.setSelected(true);
                }
            }
            this.repaintSurface();
        }
        String title = wholeObj ? Intl.intl("Paint Whole Object") : Intl.intl("Paint Face");
        this.getHoverWindow().update(title, specSurf, surf, specColor, color);
    }

    protected Color getColor(ISurfObj obj, int face) {
        Color[] colors = obj.getColors();
        return colors.length == 1 ? colors[0] : colors[face];
    }

    protected Surface getSurface(ISurfObj obj, int face) {
        Surface[] surfs = obj.getSurfaces();
        return surfs.length == 1 ? surfs[0] : surfs[face];
    }

    protected void paintCurrentFace() {
        int[] nArray;
        if (this.d_selection == null) {
            return;
        }
        DrawProps props = this.getProps();
        boolean paintSurf = props.get(DrawProps.SPECIFY_SURFACE);
        Surface surf = props.get(DrawProps.SURFACE);
        boolean removeTexUV = props.get(DrawProps.REMOVE_TEX_UV);
        boolean paintColor = props.get(DrawProps.SPECIFY_COLOR);
        Color color = props.get(DrawProps.COLOR);
        if (!this.d_selection.wholeObj) {
            int[] nArray2 = new int[2];
            nArray2[0] = this.d_selection.faceIx;
            nArray = nArray2;
            nArray2[1] = this.d_selection.faceIx + 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = this.d_selection.obj.getNumFaces();
        }
        int[] range = nArray;
        ISurfObj clone = this.d_objClones.computeIfAbsent(this.d_selection.obj, o -> {
            ISurfObj cobj = (ISurfObj)o.clone();
            this.d_mgr.remove(o);
            this.d_mgr.add(cobj);
            return cobj;
        });
        if (paintSurf) {
            this.d_surfPaintedObjs.computeIfAbsent(this.d_selection.obj, o -> FacePainter.decompressSurf(o, clone, this.d_faceCache));
        }
        if (paintColor) {
            FacePainter.decompressColor(clone);
        }
        boolean repaint = false;
        for (int m = range[0]; m < range[1]; ++m) {
            FacePainter painter = new FacePainter(this.d_selection.obj, clone, m, paintSurf, surf, removeTexUV, paintColor, color);
            if (painter.isNull() || this.d_facePainters.contains(painter)) continue;
            painter.apply();
            this.d_facePainters.add(painter);
            repaint = true;
        }
        if (repaint) {
            this.d_mgr.updateDisplays(clone);
            this.repaintSurface();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pauseRepaint();
        super.keyPressed(e);
        if (e.getKeyCode() == 16) {
            this.updatePickFace();
        }
        this.resumeRepaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.pauseRepaint();
        super.keyReleased(e);
        if (e.getKeyCode() == 16) {
            this.updatePickFace();
        }
        this.resumeRepaint();
    }

    private Collection<PaintRecord> compressPaintedObjs() {
        LinkedIdentityHashMap<ISurfObj, ObjPainted> affectedObjs = new LinkedIdentityHashMap<ISurfObj, ObjPainted>();
        for (FacePainter facePaint : this.d_facePainters) {
            ObjPainted painted = affectedObjs.computeIfAbsent(facePaint.obst, o -> new ObjPainted());
            painted.surf |= facePaint.paintSurf;
            painted.color |= facePaint.paintColor;
            painted.mfaces.add(facePaint.ix);
        }
        ArrayList<PaintRecord> records = new ArrayList<PaintRecord>(affectedObjs.size());
        for (Map.Entry entry : affectedObjs.entrySet()) {
            ISurfObj obst = (ISurfObj)entry.getKey();
            ObjPainted painted = (ObjPainted)entry.getValue();
            if (!painted.surf && !painted.color) continue;
            ISurfObj clone = this.d_objClones.get(obst);
            assert (clone != null);
            PaintRecord record = new PaintRecord(obst);
            records.add(record);
            if (painted.surf) {
                FacePainter.compressSurf(clone, this.d_surfPaintedObjs.get(obst), painted.mfaces);
                record.geom = clone.getGeom();
                record.surfs = clone.getSurfaces();
            }
            if (!painted.color) continue;
            FacePainter.compressColor(clone);
            record.colors = clone.getColors();
        }
        return records;
    }

    @Override
    public void finish() {
        this.pauseRepaint();
        if (!this.d_facePainters.isEmpty()) {
            Collection<PaintRecord> records = this.compressPaintedObjs();
            PaintTask task = new PaintTask(records);
            this.d_domain.getTaskManager().exec((Task)task, Intl.intl("Paint Faces"), 1);
        }
        this.reset();
        super.finish();
        this.resumeRepaint();
    }

    @Override
    public boolean cancel() {
        this.pauseRepaint();
        this.reset();
        boolean canceled = super.cancel();
        this.resumeRepaint();
        return canceled;
    }

    @Override
    public void reset() {
        this.clearDisplay();
        this.d_mgr.updateDisplays(this.d_displayObj);
        this.d_mgr.removeDisplays((Collection<? extends Object>)this.d_objClones.values());
        this.d_mgr.addDisplays((Collection<? extends Object>)this.d_objClones.keySet());
        this.repaintSurface();
        this.d_objClones.clear();
        this.d_faceCache.clear();
        this.d_facePainters.clear();
        this.d_surfPaintedObjs.clear();
        this.d_selection = null;
    }

    protected void clearDisplay() {
        this.d_displayObj.setGeom(GeomNodeUtil.EMPTY_NODE);
        this.d_displayObj.setDisplayProps(DisplayGeom.EMPTY.props);
    }

    protected static class ToolFunc
    extends AdvancedTool.ToolFunc<SurfacePainterTool> {
        protected ToolFunc() {
        }

        @Override
        public void mouseMoved(SurfacePainterTool tool, MouseEvent e) {
            super.mouseMoved(tool, e);
            tool.updatePickFace();
        }

        @Override
        public void mousePressed(SurfacePainterTool tool, MouseEvent e) {
            super.mousePressed(tool, e);
            tool.updatePickFace();
            if (tool.isDragging(1)) {
                tool.paintCurrentFace();
            }
        }

        @Override
        public void mouseDragged(SurfacePainterTool tool, MouseEvent e) {
            super.mouseDragged(tool, e);
            tool.updatePickFace();
            if (tool.isDragging(1)) {
                tool.paintCurrentFace();
            }
        }

        @Override
        public void mouseReleased(SurfacePainterTool tool, MouseEvent e) {
            super.mouseReleased(tool, e);
            tool.updatePickFace();
            if (e.getButton() == 1) {
                tool.paintCurrentFace();
                if (tool.d_facePainters.size() > 0) {
                    tool.finish();
                }
            }
        }
    }

    private static class Selection {
        public final ISurfObj obj;
        public final int faceIx;
        public final boolean wholeObj;

        public Selection(ISurfObj obj, int fix, boolean wholeObj) {
            this.obj = obj;
            this.faceIx = fix;
            this.wholeObj = wholeObj;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Selection && ((Selection)obj).obj == obj && ((Selection)obj).faceIx == this.faceIx && ((Selection)obj).wholeObj == this.wholeObj;
        }
    }

    private static class ObjPainted {
        public boolean surf = false;
        public boolean color = false;
        public Set<Integer> mfaces = new HashSet<Integer>();

        private ObjPainted() {
        }
    }

    public static class PaintTask
    extends AUndoableTask {
        private final PaintRecord[] records;

        public PaintTask(Collection<PaintRecord> records) {
            this.records = theUtil.toArray(records, PaintRecord.class);
        }

        protected PyroMod getDomain() {
            if (this.records.length == 0) {
                return null;
            }
            return (PyroMod)this.records[0].obj.getDomain();
        }

        @Override
        public void run() {
            PyroMod domain = this.getDomain();
            if (domain != null) {
                domain.pauseUpdates();
            }
            for (int m = 0; m < this.records.length; ++m) {
                PaintRecord rec = this.records[m];
                PaintRecord newRec = new PaintRecord(rec.obj, rec.colors != null ? rec.obj.getColors() : null, rec.surfs != null ? rec.obj.getSurfaces() : null, rec.geom != null ? rec.obj.getGeom() : null);
                if (rec.colors != null) {
                    rec.obj.setColors(rec.colors);
                }
                if (rec.surfs != null) {
                    rec.obj.setSurfaces(rec.surfs);
                }
                if (rec.geom != null) {
                    rec.obj.setGeom(rec.geom);
                }
                this.records[m] = newRec;
            }
            if (domain != null) {
                domain.resumeUpdates();
            }
        }

        @Override
        public void undo() {
            this.run();
        }
    }

    private static class PaintRecord {
        public final ISurfObj obj;
        public Color[] colors;
        public Surface[] surfs;
        public IGeomNode geom;

        public PaintRecord(ISurfObj obj) {
            this(obj, null, null, null);
        }

        public PaintRecord(ISurfObj obj, Color[] colors, Surface[] surfs, IGeomNode geom) {
            this.obj = obj;
            this.colors = colors;
            this.surfs = surfs;
            this.geom = geom;
        }
    }

    public static class FacePainter {
        public final ISurfObj obst;
        public final ISurfObj clone;
        public final int ix;
        public final boolean paintSurf;
        public final Surface newSurf;
        public final boolean removeTexUV;
        public final boolean paintColor;
        public final Color newColor;

        public FacePainter(ISurfObj obst, ISurfObj clone, int ix, boolean paintSurf, Surface newSurf, boolean removeTexUV, boolean paintColor, Color color) {
            this.obst = obst;
            this.clone = clone;
            this.ix = ix;
            this.paintSurf = paintSurf;
            this.newSurf = newSurf;
            this.removeTexUV = removeTexUV;
            this.paintColor = paintColor;
            this.newColor = color;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof FacePainter && ((FacePainter)obj).obst == this.obst && ((FacePainter)obj).ix == this.ix;
        }

        public int hashCode() {
            return -1842044929 + this.ix + System.identityHashCode(this.obst);
        }

        public void apply() {
            if (this.paintSurf) {
                int numFaces = this.clone.getNumFaces();
                IGeomNode geom = this.clone.getGeom();
                Surface[] surfs = this.clone.getSurfaces();
                Surface oldSurf = surfs[this.ix];
                boolean modified = false;
                modified |= oldSurf != this.newSurf;
                surfs[this.ix] = this.newSurf;
                assert (this.clone.getGeom().getChildren().isEmpty());
                if (this.removeTexUV) {
                    IElemSource<Point2d> newMapper = FDSUtil.getDefaultTexMapper();
                    Map<String, IElemSource<Point2d>> uvsets = geom.getLocalElements().get(Elements.UV);
                    for (Map.Entry<String, IElemSource<Point2d>> uvset : uvsets.entrySet()) {
                        IElemSource<Point2d>[] uvPrims = Elements.decompress(uvset.getValue(), 0, numFaces, false).getArray();
                        modified |= uvPrims[this.ix] != newMapper;
                        uvPrims[this.ix] = newMapper;
                    }
                }
                if (modified) {
                    this.clone.setSurfaces(surfs);
                }
            }
            if (this.paintColor) {
                Color[] colors = this.clone.getColors();
                colors[this.ix] = this.newColor;
                this.clone.setColors(colors);
            }
        }

        public boolean isNull() {
            if (this.paintSurf) {
                Surface surf;
                Surface[] surfs = this.clone.getSurfaces();
                Surface surface = surf = surfs.length == 1 ? surfs[0] : surfs[this.ix];
                if (surf != this.newSurf) {
                    return false;
                }
                if (this.removeTexUV) {
                    int numFaces = this.clone.getNumFaces();
                    IGeomNode geom = this.clone.getGeom();
                    Map<String, IElemSource<Point2d>> uvsets = geom.getLocalElements().get(Elements.UV);
                    return !uvsets.values().stream().anyMatch(uvset -> {
                        IElemSource<T>[] uvPrims = Elements.decompress(uvset, 0, numFaces, false).getArray();
                        return uvPrims[this.ix] != FDSUtil.getDefaultTexMapper();
                    });
                }
                return true;
            }
            if (this.paintColor) {
                Color color;
                Color[] colors = this.clone.getColors();
                Color color2 = color = colors.length == 1 ? colors[0] : colors[this.ix];
                if (!theUtil.equal(color, this.newColor)) {
                    return false;
                }
            }
            return true;
        }

        public static IGeomNode decompressSurf(ISurfObj obj, ISurfObj clone, FaceCache faceCache) {
            IGeomNode node;
            int numFaces = clone.getNumFaces();
            Surface[] surfs = clone.getSurfaces();
            surfs = GeomUtil.matchPrimCount(surfs, Surface.class, true, numFaces);
            clone.setSurfaces(surfs);
            IGeomNode onode = clone.getGeom();
            if (faceCache != null) {
                FaceCache.Faces faces = faceCache.getFaces(obj);
                node = GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(faces.faces), faces.elems);
            } else {
                node = onode.flatten();
            }
            IPropertySet elems = Elements.copyOf(node.getLocalElements());
            Map<String, IElemSource<Point2d>> uvsets = elems.get(Elements.UV);
            ListMap<String, IElemSource<Point2d>> newUVSets = new ListMap<String, IElemSource<Point2d>>(uvsets);
            int numPrims = node.getLocalGeom().getNumPrims(7);
            for (Map.Entry<String, IElemSource<Point2d>> entry : uvsets.entrySet()) {
                newUVSets.put(entry.getKey(), Elements.decompress(entry.getValue(), 0, numPrims, true));
            }
            elems.set(Elements.UV, newUVSets);
            node = node.applyLocalElements(elems);
            clone.setGeom(node);
            return onode;
        }

        public static void compressSurf(ISurfObj clone, IGeomNode origGeom, Set<Integer> modifiedFaces) {
            clone.setSurfaces(GeomUtil.optimize(clone.getSurfaces()));
            IGeomNode newNode = origGeom;
            assert (clone.getGeom().getChildren().isEmpty());
            Map<String, IElemSource<Point2d>> uvsets = clone.getGeom().getLocalElements().get(Elements.UV);
            for (Map.Entry<String, IElemSource<Point2d>> uvset : uvsets.entrySet()) {
                ElementFlattened fuv = (ElementFlattened)uvset.getValue();
                newNode = newNode.applyUVElements(uvset.getKey(), (i, oe) -> modifiedFaces.contains(i) ? fuv.getArray()[i] : oe);
            }
            clone.setGeom(newNode);
        }

        public static void decompressColor(ISurfObj clone) {
            Color[] colors = GeomUtil.matchPrimCount(clone.getColors(), Color.class, true, clone.getNumFaces());
            clone.setColors(colors);
        }

        public static void compressColor(ISurfObj clone) {
            clone.setColors(GeomUtil.optimize(clone.getColors()));
        }
    }

    protected class PickPropAction
    extends BooleanAction {
        private static final long serialVersionUID = 4257523322539688474L;
        private final boolean d_surface;
        private final boolean d_color;

        public PickPropAction(boolean surface, boolean color) {
            super(SurfacePainterTool.getPickPropDesc(surface, color), SurfacePainterTool.this.getPickPropState(surface, color));
            this.d_surface = surface;
            this.d_color = color;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                SurfacePainterTool.this.getProps().set(DrawProps.SPECIFY_SURFACE, this.d_surface);
                SurfacePainterTool.this.getProps().set(DrawProps.SPECIFY_COLOR, this.d_color);
                SurfacePainterTool.this.updatePickFace();
            }
        }
    }
}

