/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;

public class SmokeViewNavigationFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Drag", "DRAG.gif", 15, 15);
    private Point d_lastMouseLocation;
    private double d_rotX = 0.0;
    private double d_rotZ = 0.0;

    @Override
    public boolean isDrawable(CursorTool tool) {
        return false;
    }

    @Override
    public Cursor getCursor(CursorTool tool) {
        return tool.isDragging() ? CURSOR : null;
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
        this.d_lastMouseLocation = e.getPoint();
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
        boolean shouldTranslateForward;
        int dx = e.getX() - this.d_lastMouseLocation.x;
        int dy = e.getY() - this.d_lastMouseLocation.y;
        int translateModHorizontal = 1152;
        int translateModVertical = 1536;
        int orbitMod = 1024;
        boolean shouldTranslateVert = (e.getModifiersEx() & translateModVertical) == translateModVertical;
        boolean shouldTranslateRight = shouldTranslateForward = (e.getModifiersEx() & translateModHorizontal) == translateModHorizontal;
        boolean shouldTranslate = shouldTranslateVert || shouldTranslateForward || shouldTranslateRight;
        boolean shouldOrbit = !shouldTranslate && (e.getModifiersEx() & orbitMod) == orbitMod;
        Camera c = tool.getView().getCamera();
        if (shouldTranslate) {
            double paramX = (double)dx * 0.1;
            double paramY = (double)dy * -0.1;
            if (shouldTranslateVert) {
                c.translateEye(0.0, paramY, 0.0, true);
            }
            if (shouldTranslateForward) {
                c.translateEye(0.0, 0.0, -paramY, true);
            }
            if (shouldTranslateRight) {
                c.translateEye(paramX, 0.0, 0.0, true);
            }
        }
        if (shouldOrbit) {
            double rotZ = dx;
            double rotCamRight = -dy;
            Vector3d camRight = c.getRightVector();
            camRight.normalize();
            Matrix3d camMat = c.getLocalTransformRHR();
            Vector3d z = new Vector3d(0.0, 0.0, -1.0);
            camMat.transform(z);
            c.orbit(rotZ, z.x, z.y, z.z);
            c.orbit(rotCamRight, 1.0, 0.0, 0.0);
        }
        tool.repaintSurface();
        this.d_lastMouseLocation = e.getPoint();
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
    }
}

