/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.jscience.physics.units.Unit;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.PyroActionMap;
import pyrosim.mv.ModelView;
import pyrosim.mv.tools.DrawProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.scene3d.tools.AdvancedTool;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.util.IPropertySet;

public class PyroToolHooks
implements AdvancedTool.IAppHook {
    public static final IPropertySet.Prop<DrawProps> DRAW_PROPS = new IPropertySet.Prop<Object>("PyroToolHooks.DRAW_PROPS", null);
    public static final PyroToolHooks INSTANCE = new PyroToolHooks();

    private PyroToolHooks() {
    }

    @Override
    public void init(AdvancedTool tool) {
        tool.setMenuBuilder(Menu.TOOL_PROPS.key, (t, builder) -> {
            Action toolProps = ((ModelView)t.getToolController()).getToolPropsAction();
            if (toolProps.isEnabled()) {
                builder.add(toolProps);
            }
        });
        tool.setMenuSorter((key1, key2) -> {
            Menu m1 = Menu.getMenu(key1);
            Menu m2 = Menu.getMenu(key2);
            if (m1 != null && m2 != null) {
                return m1.compareTo(m2);
            }
            if (m1 != null) {
                return -1;
            }
            if (m2 != null) {
                return 1;
            }
            return key1.compareTo((String)key2);
        });
    }

    @Override
    public boolean isToolUndoEvent(AdvancedTool tool, KeyEvent evt, MouseHistory mouseHistory) {
        PyroActionMap.PyroShortcutUIHelper actionKeyFinder = new PyroActionMap.PyroShortcutUIHelper();
        KeyStroke ksUndo = actionKeyFinder.getKeyStrokeForID("undo");
        KeyStroke ksRecv = KeyStroke.getKeyStrokeForEvent(evt);
        return ksUndo != null && ksUndo.equals(ksRecv) && mouseHistory.isUndoAvailable();
    }

    @Override
    public boolean isToolRedoEvent(AdvancedTool tool, KeyEvent evt, MouseHistory mouseHistory) {
        PyroActionMap.PyroShortcutUIHelper actionKeyFinder = new PyroActionMap.PyroShortcutUIHelper();
        KeyStroke ksRedo = actionKeyFinder.getKeyStrokeForID("redo");
        KeyStroke ksRecv = KeyStroke.getKeyStrokeForEvent(evt);
        return ksRedo != null && ksRedo.equals(ksRecv) && mouseHistory.isRedoAvailable();
    }

    @Override
    public double getWorkingZLocation(AdvancedTool tool) {
        DrawProps props = tool.getProp(DRAW_PROPS);
        assert (props != null);
        if (props == null) {
            return 0.0;
        }
        return props.get(DrawProps.LOCATION).getValue(Geometry.LU);
    }

    @Override
    public Unit getNativeLengthUnit() {
        return Geometry.LU;
    }

    @Override
    public IUnitSrc getLengthUnitSrc() {
        return UnitSystem.getSource(0);
    }

    @Override
    public Unit getNativeAngleUnit() {
        return Geometry.AU;
    }

    public static enum Menu {
        TOOL_ACTIONS("Menu.ToolActions"),
        APPEARANCE("Menu.Appearance"),
        CONSTRAINT("Menu.Constraint"),
        CANCEL("Menu.Cancel"),
        TOOL_PROPS("Menu.ToolProps");

        public final String key;

        private Menu(String key) {
            this.key = key;
        }

        public static Menu getMenu(String key) {
            for (Menu m : Menu.values()) {
                if (!m.key.equals(key)) continue;
                return m;
            }
            return null;
        }
    }
}

