/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Vent;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.GridVis;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.GridDisplay;
import pyrosim.mv.displays.GridRenderer;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.NativeMaterial;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IdentityHashSet;

public class GridDisplayManager
extends APyroDisplayMgr<Grid, GridDisplay>
implements ColorChangedListener {
    private Map<Grid, GridMergeUtil.BoundaryInfo> d_gridFaces;
    private final GridRenderer d_renderer;

    public GridDisplayManager(PyroMod mod, ModelScene scene, ModelView mv, DisplayFilter df) {
        super(mod, mv, GridDisplayManager.newSceneMap(scene), Grid.class, df);
        mv.getColors().addColorChangedListener(this);
        this.d_gridFaces = null;
        this.d_renderer = new GridRenderer();
        scene.addRenderableObjects(Arrays.asList(this.d_renderer));
    }

    public void setActiveFloor(Floor floor) {
        for (GridDisplay display : this.getDisplayMap().values()) {
            display.setActiveFloor(floor);
        }
        this.repaint();
    }

    public Floor getActiveFloor() {
        return this.getMV().getCurrentFloor();
    }

    @Override
    protected Collection<? extends Class<?>> getFilterTypes() {
        return Arrays.asList(GridVis.Boundary.class, GridVis.Outline.class, GridVis.Divisions.class);
    }

    @Override
    protected void filterChanged(DisplayFilter filter, Class type) {
        this.updateAll();
    }

    @Override
    public void colorChanged(ColorChangedEvent e) {
        this.updateDisplays(this.getMediator().getGridManager().flatten());
    }

    private Surface getSurface() {
        return this.getMediator().getSimParams().getMisc().getSurfDefault();
    }

    private NativeMaterial getBoundarySurf() {
        Surface surf = this.getSurface();
        return this.getMV().getDrawProps().getNativeMat(surf);
    }

    @Override
    protected boolean isVisible(Grid obj) {
        return obj.isVisible();
    }

    @Override
    protected boolean isSelected(Grid obj) {
        return super.isSelected(obj) || GridDisplayManager.allFalse(this.getVisibility(obj)) && this.getMV() != null && this.getMV().isInteractive(obj);
    }

    private static boolean allFalse(boolean[] values) {
        if (values.length == 0) {
            return false;
        }
        for (boolean v : values) {
            if (!v) continue;
            return false;
        }
        return true;
    }

    @Override
    protected GridDisplay createDisplay(Grid obj, boolean visible, boolean selected) {
        GridDisplay gd = new GridDisplay(obj, this.getBoundarySurf(), this.getSurface());
        this.updateDisplay(obj, gd);
        return gd;
    }

    @Override
    protected void addDisplays(Function<RenderTarget, Optional<ModelScene>> scenes, Collection<? extends Grid> objs, Collection<GridDisplay> disps) {
        for (IDisplayable iDisplayable : disps) {
            this.d_renderer.addDisplay((GridDisplay)iDisplayable);
        }
    }

    @Override
    protected void removeDisplays(Function<RenderTarget, Optional<ModelScene>> scenes, Collection<GridDisplay> disps) {
        for (IDisplayable iDisplayable : disps) {
            this.d_renderer.removeDisplay((GridDisplay)iDisplayable);
        }
    }

    @Override
    public void addAll() {
        this.d_gridFaces = null;
        this.addDisplays(this.getMediator().getGridManager().flatten());
    }

    @Override
    public void processEvents(Events events, EventResult result) {
        GridDisplay gd;
        IdentityHashSet toAdd = new IdentityHashSet();
        IdentityHashSet toRemove = new IdentityHashSet();
        IdentityHashSet generalChanges = new IdentityHashSet();
        IdentityHashSet visSelChanges = new IdentityHashSet();
        boolean updateGridBoundaries = false;
        boolean updateBoundarySurface = false;
        for (EventChannel<Grid> eventChannel : events.getAffectedChannels(Grid.class, new Class[0])) {
            this.repaint();
            Set<Grid> added = eventChannel.getAddedObjs();
            Set<Grid> removed = eventChannel.getRemovedObjs();
            Set<Grid> genChanges = eventChannel.getChangedObjs(EventChannel.EVT_GENERAL);
            Set<Grid> set = eventChannel.getChangedObjs(PyroMod.EVT_SEL);
            Set<Grid> visChanges = eventChannel.getChangedObjs(PyroMod.EVT_VISIBILITY_CHANGED);
            Set<Grid> enChanges = eventChannel.getChangedObjs(PyroMod.EVT_ENABLED_CHANGED);
            toAdd.addAll(added);
            toRemove.addAll(removed);
            generalChanges.addAll(genChanges);
            visSelChanges.addAll(set);
            visSelChanges.addAll(visChanges);
            visSelChanges.addAll(enChanges);
            updateGridBoundaries |= !genChanges.isEmpty() || !added.isEmpty() || !removed.isEmpty() || !enChanges.isEmpty();
        }
        updateBoundarySurface |= !events.getAffectedChannels(SimParams.Misc.class, new Class[0]).isEmpty();
        block1: for (EventChannel<NamedPyroObject> eventChannel : events.getAffectedChannels(Surface.class, new Class[0])) {
            Surface defSurf = this.getMediator().getSimParams().getMisc().getSurfDefault();
            Set<NamedPyroObject> changedSurfs = eventChannel.getChangedObjs(Surface.EVT_APPEARANCE, Events.EVT_GENERAL);
            for (Surface surface : changedSurfs) {
                if (surface != defSurf) continue;
                updateBoundarySurface = true;
                continue block1;
            }
        }
        for (EventChannel<NamedPyroObject> eventChannel : events.getAffectedChannels(Vent.class, new Class[0])) {
            if (!eventChannel.hasAddedObjs() && !eventChannel.hasRemovedObjs() && (!eventChannel.hasChangedObjs() || eventChannel.areChangesExclusiveTo(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED))) continue;
            updateGridBoundaries = true;
            break;
        }
        if (updateGridBoundaries) {
            this.d_gridFaces = null;
        }
        if (updateGridBoundaries || updateBoundarySurface) {
            generalChanges.addAll(this.getMediator().getGridManager().flatten());
            generalChanges.removeAll(toAdd);
        }
        visSelChanges.removeAll(generalChanges);
        boolean repaint = !toAdd.isEmpty() || !toRemove.isEmpty() || !generalChanges.isEmpty();
        this.addDisplays(toAdd);
        this.removeDisplays(toRemove);
        for (Grid grid : generalChanges) {
            gd = (GridDisplay)this.getDisplay(grid);
            if (gd == null) continue;
            this.updateDisplay(grid, gd);
        }
        for (Grid grid : visSelChanges) {
            gd = (GridDisplay)this.getDisplay(grid);
            if (gd == null) continue;
            repaint = true;
            gd.setSelected(this.isSelected(grid));
            boolean[] vis = this.getVisibility(grid);
            gd.setVisible(vis[0], vis[1], vis[2]);
        }
        if (repaint) {
            this.getMV().getRenderComp().repaint();
        }
    }

    @Override
    public void updateDisplay(Grid obj, GridDisplay gd) {
        this.updateBoundaries();
        gd.pauseUpdates();
        gd.setActiveFloor(this.getActiveFloor());
        boolean forceVis = false;
        GridMergeUtil.BoundaryInfo gcr = this.d_gridFaces.get(obj);
        if (gcr == null) {
            gcr = GridMergeUtil.mergeGrids(Arrays.asList(new Grid[]{obj}), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces.get(obj);
            assert (gcr != null);
            forceVis = true;
        }
        gd.updateBoundarySurface(this.getBoundarySurf(), this.getSurface());
        gd.setData(gcr.faces, gcr.boundaryEdges);
        gd.updateColors();
        gd.updateSelected(this.isSelected(obj));
        boolean[] vis = this.getVisibility(obj, forceVis);
        gd.updateOutlineVisible(vis[0]);
        gd.updateBoundaryVisible(vis[1]);
        gd.updateMeshVisible(vis[2]);
        gd.resumeUpdates();
    }

    private boolean[] getVisibility(Grid obj) {
        return this.getVisibility(obj, false);
    }

    private boolean[] getVisibility(Grid obj, boolean forceVis) {
        boolean meshVisible;
        boolean gridVisible;
        Camera mainCam = this.getScenes().apply(RenderTarget.NORMAL).get().getCamera();
        boolean isOrtho = mainCam instanceof OrthoCamera;
        boolean bl = gridVisible = obj.isVisible() && obj.isEnabled();
        if (isOrtho) {
            gridVisible &= forceVis || this.getMV().getCurrentSnapper() == 2;
            meshVisible = true;
        } else {
            meshVisible = !this.getFilter().isFilteringAllOf(GridVis.Divisions.class);
        }
        return new boolean[]{gridVisible && !this.getFilter().isFilteringAllOf(GridVis.Outline.class), gridVisible && !isOrtho && !this.getFilter().isFilteringAllOf(GridVis.Boundary.class), gridVisible && meshVisible};
    }

    private void updateBoundaries() {
        if (this.d_gridFaces != null) {
            return;
        }
        GridList gm = this.getMediator().getGridManager();
        Collection<Vent> vents = ((APyroObject)this.getMediator().getObstructions()).flatten(Vent.class);
        Collection grids = gm.flatten(new EnabledFilter());
        this.d_gridFaces = GridMergeUtil.mergeGrids(grids, vents).faces;
        assert (grids.size() == this.d_gridFaces.size());
    }
}

