/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.Serializable;
import pyrosim.legacy_2012_1.thunderheadeng.util.DurationMismatchException;

public abstract class DiscreteSignal
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4339998604821941944L;

    public abstract DiscreteSignal newSignal(double var1, int var3);

    public void set(double time, double value) {
        this.setSample(this.timeToSample(time), value);
    }

    public abstract void setSample(int var1, double var2);

    public void setRange(double a, double b, double value) {
        this.setRangeOfSamples(this.timeToSample(a), this.timeToSample(b), value);
    }

    public void setRangeOfSamples(int a, int b, double value) {
        int max = this.getNumSamples();
        for (int x = a; x < b && x < max; ++x) {
            this.setSample(x, value);
        }
    }

    public double evaluate(double time) {
        return this.evaluateSample(this.timeToSample(time));
    }

    public double[] toArray() {
        int numSamples = this.getNumSamples();
        double[] values = new double[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            values[i] = this.evaluateSample(i);
        }
        return values;
    }

    public abstract double evaluateSample(int var1);

    public abstract int getNumSamples();

    public abstract double getSampleInterval();

    public double getDuration() {
        return (double)this.getNumSamples() * this.getSampleInterval();
    }

    public DiscreteSignal extractRange(double beg, double end) {
        int thisIndex;
        int begSample = this.timeToSample(beg);
        int endSample = this.timeToSample(end);
        DiscreteSignal newSig = this.newSignal(this.getSampleInterval(), endSample - begSample);
        int newIndex = 0;
        int min = Math.min(endSample, 0);
        for (thisIndex = begSample; thisIndex < min; ++thisIndex) {
            newSig.setSample(newIndex++, 0.0);
        }
        min = Math.min(endSample, this.getNumSamples());
        while (thisIndex < min) {
            newSig.setSample(newIndex++, this.evaluateSample(thisIndex++));
        }
        while (thisIndex < endSample) {
            newSig.setSample(newIndex++, 0.0);
            ++thisIndex;
        }
        return newSig;
    }

    public double sampleToTime(int sample) {
        return (double)sample * this.getSampleInterval();
    }

    public int timeToSample(double time) {
        return (int)Math.floor(time / this.getSampleInterval());
    }

    public double integrate() {
        return this.integrate(0, this.getNumSamples());
    }

    public double integrate(int a, int b) {
        double sum = 0.0;
        for (int t = a; t < b; ++t) {
            sum += this.evaluateSample(t);
        }
        return sum * this.getSampleInterval();
    }

    public DiscreteSignal invert() {
        int max = this.getNumSamples();
        for (int t = 0; t < max; ++t) {
            this.setSample(t, -this.evaluateSample(t));
        }
        return this;
    }

    public DiscreteSignal multiply(DiscreteSignal s) {
        if (this.getDuration() != s.getDuration()) {
            throw new DurationMismatchException();
        }
        if (this.getSampleInterval() != s.getSampleInterval()) {
            try {
                s = (DiscreteSignal)s.clone();
                s.resample(this.getSampleInterval());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.getNumSamples(); ++i) {
            this.setSample(i, this.evaluateSample(i) * s.evaluateSample(i));
        }
        return this;
    }

    public DiscreteSignal add(DiscreteSignal s) {
        if (this.getDuration() != s.getDuration()) {
            throw new DurationMismatchException();
        }
        if (this.getSampleInterval() != s.getSampleInterval()) {
            try {
                s = (DiscreteSignal)s.clone();
                s.resample(this.getSampleInterval());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        int max = this.getNumSamples();
        for (int i = 0; i < max; ++i) {
            this.setSample(i, this.evaluateSample(i) + s.evaluateSample(i));
        }
        return this;
    }

    public DiscreteSignal add(double constant) {
        int max = this.getNumSamples();
        for (int i = 0; i < max; ++i) {
            this.setSample(i, this.evaluateSample(i) + constant);
        }
        return this;
    }

    public DiscreteSignal multiply(double constant) {
        int max = this.getNumSamples();
        for (int i = 0; i < max; ++i) {
            this.setSample(i, this.evaluateSample(i) * constant);
        }
        return this;
    }

    public abstract void resample(double var1);
}

