/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.vecmath.Point3i;
import pyrosim.legacy_2012_1.thunderheadeng.util.MergedCell;

public class AdjacencyMerger {
    public static <T> Collection<MergedCell<T>> mergeCells(T[] cells, IMergeQuery<T> mergeQuery) {
        ArrayList<MergedCell<T>> mergeCells = new ArrayList<MergedCell<T>>();
        for (int m = 0; m < cells.length; ++m) {
            T entry = cells[m];
            mergeCells.add(new MergedCell<T>(entry, m, m, 0, 0, 0, 0));
        }
        return AdjacencyMerger.mergeCells(mergeCells, mergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells(T[][] cells, IMergeQuery<T> mergeQuery) {
        ArrayList<MergedCell<T>> mergeCells = new ArrayList<MergedCell<T>>();
        for (int m = 0; m < cells.length; ++m) {
            T[] c1 = cells[m];
            for (int n = 0; n < c1.length; ++n) {
                T entry = c1[n];
                mergeCells.add(new MergedCell<T>(entry, n, n, m, m, 0, 0));
            }
        }
        return AdjacencyMerger.mergeCells(mergeCells, mergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells(T[][][] cells, IMergeQuery<T> mergeQuery) {
        ArrayList<MergedCell<T>> mergeCells = new ArrayList<MergedCell<T>>();
        for (int m = 0; m < cells.length; ++m) {
            T[][] c1 = cells[m];
            for (int n = 0; n < c1.length; ++n) {
                T[] c2 = c1[n];
                for (int o = 0; o < c2.length; ++o) {
                    T entry = c2[o];
                    mergeCells.add(new MergedCell<T>(entry, o, o, n, n, m, m));
                }
            }
        }
        return AdjacencyMerger.mergeCells(mergeCells, mergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells2(Map<Point3i, T> cells, IMergeQuery<T> mergeQuery) {
        ArrayList<MergedCell<T>> mergeCells = new ArrayList<MergedCell<T>>();
        for (Map.Entry<Point3i, T> entry : cells.entrySet()) {
            Point3i cellIx = entry.getKey();
            mergeCells.add(new MergedCell<T>(entry.getValue(), cellIx.x, cellIx.x, cellIx.y, cellIx.y, cellIx.z, cellIx.z));
        }
        return AdjacencyMerger.mergeCells(mergeCells, mergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells3(Map<T, Collection<Point3i>> cells, IMergeQuery<T> mergeQuery) {
        ArrayList<MergedCell<T>> mergeCells = new ArrayList<MergedCell<T>>();
        for (Map.Entry<T, Collection<Point3i>> entry : cells.entrySet()) {
            for (Point3i cellIx : entry.getValue()) {
                mergeCells.add(new MergedCell<T>(entry.getKey(), cellIx.x, cellIx.x, cellIx.y, cellIx.y, cellIx.z, cellIx.z));
            }
        }
        return AdjacencyMerger.mergeCells(mergeCells, mergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells(Collection<MergedCell<T>> cells, IMergeQuery<T> mergeQuery) {
        Collection<MergedCell<T>> zMergedCells = AdjacencyMerger.mergeCells(cells, new PointComp(), new ZRunComp(), new ZRunMerger(), mergeQuery, Dir.Z);
        cells = null;
        Collection<MergedCell<T>> xzMergedCells = AdjacencyMerger.mergeCells(zMergedCells, null, new XZRunComp(), new XZRunMerger(), mergeQuery, Dir.X);
        zMergedCells = null;
        Collection<MergedCell<T>> xyzMergedCells = AdjacencyMerger.mergeCells(xzMergedCells, null, null, new XYZRunMerger(), mergeQuery, Dir.Y);
        xzMergedCells = null;
        return xyzMergedCells;
    }

    private static <T> Collection<MergedCell<T>> mergeCells(Collection<MergedCell<T>> preMerges, Comparator<MergedCell<T>> optPreSorter, Comparator<MergedCell<T>> optPostSorter, Merger<T> merger, IMergeQuery<T> mergeQuery, Dir dir) {
        Collection<MergedCell<MergedCell>> preSorted;
        if (optPreSorter != null) {
            preSorted = new TreeSet<MergedCell<T>>(optPreSorter);
            preSorted.addAll(preMerges);
        } else {
            preSorted = preMerges;
        }
        MergedCell[] entries = preSorted.toArray(new MergedCell[preSorted.size()]);
        AbstractCollection result = optPostSorter != null ? new TreeSet<MergedCell<T>>(optPostSorter) : new ArrayList();
        int m = 0;
        while (m < entries.length) {
            T mergedVal;
            MergedCell prm2;
            int n;
            MergedCell prm1 = entries[m];
            MergedCell<T> merged = merger.init(prm1);
            for (n = m + 1; n < entries.length && merger.areCellsAdjacent(merged, prm2 = entries[n]) && (mergedVal = mergeQuery.merge(merged.val, prm2.val, dir)) != null; ++n) {
                merged = merger.merge(merged, prm2);
                merged.val = mergedVal;
            }
            result.add(merged);
            m = n;
        }
        return result;
    }

    private static class XYZRunMerger<T>
    implements Merger<T> {
        private XYZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell<T> cell1, MergedCell<T> cell2) {
            return cell1.x1 == cell2.x1 && cell1.x2 == cell2.x2 && cell1.z1 == cell2.z1 && cell1.z2 == cell2.z2 && cell1.y2 == cell2.y1 - 1;
        }

        @Override
        public MergedCell<T> init(MergedCell<T> cell) {
            return new MergedCell(cell.val, cell.x1, cell.x2, cell.y1, cell.y1, cell.z1, cell.z2);
        }

        @Override
        public MergedCell<T> merge(MergedCell<T> cell1, MergedCell<T> cell2) {
            cell1.y2 = cell2.y1;
            return cell1;
        }
    }

    private static class XZRunMerger<T>
    implements Merger<T> {
        private XZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell<T> cell1, MergedCell<T> cell2) {
            return cell1.y1 == cell2.y1 && cell1.z1 == cell2.z1 && cell1.z2 == cell2.z2 && cell1.x2 == cell2.x1 - 1;
        }

        @Override
        public MergedCell<T> init(MergedCell<T> cell) {
            return new MergedCell(cell.val, cell.x1, cell.x1, cell.y1, cell.y1, cell.z1, cell.z2);
        }

        @Override
        public MergedCell<T> merge(MergedCell<T> cell1, MergedCell<T> cell2) {
            cell1.x2 = cell2.x1;
            return cell1;
        }
    }

    private static class ZRunMerger<T>
    implements Merger<T> {
        private ZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell<T> cell1, MergedCell<T> cell2) {
            return cell1.x1 == cell2.x1 && cell1.y1 == cell2.y1 && cell1.z2 == cell2.z1 - 1;
        }

        @Override
        public MergedCell<T> init(MergedCell<T> cell) {
            return new MergedCell(cell.val, cell.x1, cell.x1, cell.y1, cell.y1, cell.z1, cell.z1);
        }

        @Override
        public MergedCell<T> merge(MergedCell<T> cell1, MergedCell<T> cell2) {
            cell1.z2 = cell2.z1;
            return cell1;
        }
    }

    private static class XZRunComp<T>
    implements Comparator<MergedCell<T>> {
        private XZRunComp() {
        }

        @Override
        public int compare(MergedCell<T> r1, MergedCell<T> r2) {
            int x1diff = r1.x1 - r2.x1;
            if (x1diff != 0) {
                return x1diff;
            }
            int rxlen1 = r1.x2 - r1.x1 + 1;
            int rxlen2 = r2.x2 - r2.x1 + 1;
            int rxdiff = rxlen1 - rxlen2;
            if (rxdiff != 0) {
                return rxdiff;
            }
            int z1diff = r1.z1 - r2.z1;
            if (z1diff != 0) {
                return z1diff;
            }
            int rzlen1 = r1.z2 - r1.z1 + 1;
            int rzlen2 = r2.z2 - r2.z1 + 1;
            int rzdiff = rzlen1 - rzlen2;
            if (rzdiff != 0) {
                return rzdiff;
            }
            return r1.y1 - r2.y1;
        }
    }

    private static class ZRunComp<T>
    implements Comparator<MergedCell<T>> {
        private ZRunComp() {
        }

        @Override
        public int compare(MergedCell<T> r1, MergedCell<T> r2) {
            int ydiff = r1.y1 - r2.y1;
            if (ydiff != 0) {
                return ydiff;
            }
            int z1diff = r1.z1 - r2.z1;
            if (z1diff != 0) {
                return z1diff;
            }
            int rzlen1 = r1.z2 - r1.z1 + 1;
            int rzlen2 = r2.z2 - r2.z1 + 1;
            int rzdiff = rzlen1 - rzlen2;
            if (rzdiff != 0) {
                return rzdiff;
            }
            return r1.x1 - r2.x1;
        }
    }

    private static class PointComp<T>
    implements Comparator<MergedCell<T>> {
        private PointComp() {
        }

        @Override
        public int compare(MergedCell<T> p1, MergedCell<T> p2) {
            int ydiff = p1.y1 - p2.y1;
            if (ydiff != 0) {
                return ydiff;
            }
            int xdiff = p1.x1 - p2.x1;
            if (xdiff != 0) {
                return xdiff;
            }
            return p1.z1 - p2.z1;
        }
    }

    private static interface Merger<T> {
        public MergedCell<T> init(MergedCell<T> var1);

        public boolean areCellsAdjacent(MergedCell<T> var1, MergedCell<T> var2);

        public MergedCell<T> merge(MergedCell<T> var1, MergedCell<T> var2);
    }

    public static interface IMergeQuery<T> {
        public T merge(T var1, T var2, Dir var3);
    }

    public static enum Dir {
        X,
        Y,
        Z;

    }
}

