/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AbstractValueRange;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public class UnitDoubleVR
extends AbstractValueRange<UnitDouble>
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final UnitDoubleVR UNBOUNDED = new UnitDoubleVR(null, null, false, false, false, false);

    protected UnitDoubleVR(UnitDouble min, UnitDouble max, boolean checkMin, boolean checkMax, boolean minInclusive, boolean maxInclusive) {
        super(min, max, checkMin, checkMax, minInclusive, maxInclusive);
    }

    public static UnitDoubleVR unbounded() {
        return UNBOUNDED;
    }

    public static UnitDoubleVR above(UnitDouble min, boolean inclusive) {
        return new UnitDoubleVR(min, null, true, false, inclusive, false);
    }

    public static UnitDoubleVR below(UnitDouble max, boolean inclusive) {
        return new UnitDoubleVR(null, max, false, true, false, inclusive);
    }

    public static UnitDoubleVR between(UnitDouble min, UnitDouble max, boolean minInclusive, boolean maxInclusive) {
        return new UnitDoubleVR(min, max, true, true, minInclusive, maxInclusive);
    }

    public static UnitDoubleVR above(double min, Unit u, boolean inclusive) {
        return new UnitDoubleVR(new UnitDouble(min, u), null, true, false, inclusive, false);
    }

    public static UnitDoubleVR below(double max, Unit u, boolean inclusive) {
        return new UnitDoubleVR(null, new UnitDouble(max, u), false, true, false, inclusive);
    }

    public static UnitDoubleVR between(double min, double max, Unit u, boolean minInclusive, boolean maxInclusive) {
        return new UnitDoubleVR(new UnitDouble(min, u), new UnitDouble(max, u), true, true, minInclusive, maxInclusive);
    }

    public static UnitDoubleVR from(DoubleVR range, Unit u) {
        if (!range.checksMin() && !range.checksMax()) {
            return UnitDoubleVR.unbounded();
        }
        if (!range.checksMin() && range.checksMax()) {
            return UnitDoubleVR.below(new UnitDouble((Double)range.getMaxValue(), u), range.isMaxInclusive());
        }
        if (range.checksMin() && !range.checksMax()) {
            return UnitDoubleVR.above(new UnitDouble((Double)range.getMinValue(), u), range.isMinInclusive());
        }
        return UnitDoubleVR.between(new UnitDouble((Double)range.getMinValue(), u), new UnitDouble((Double)range.getMaxValue(), u), range.isMinInclusive(), range.isMaxInclusive());
    }

    @Override
    public String format(Object value) {
        return Global.format((UnitDouble)value);
    }

    public DoubleVR getDoubleRange(Unit u) {
        if (!this.checksMin() && !this.checksMax()) {
            return DoubleVR.unbounded();
        }
        if (!this.checksMin() && this.checksMax()) {
            return DoubleVR.below(((UnitDouble)this.getMaxValue()).getValue(u), this.isMaxInclusive());
        }
        if (this.checksMin() && !this.checksMax()) {
            return DoubleVR.above(((UnitDouble)this.getMinValue()).getValue(u), this.isMinInclusive());
        }
        return DoubleVR.between(((UnitDouble)this.getMinValue()).getValue(u), ((UnitDouble)this.getMaxValue()).getValue(u), this.isMinInclusive(), this.isMaxInclusive());
    }

    @Override
    protected UnitDouble clampMaxUnincl(UnitDouble val) {
        if (this.checksMin() && this.checksMax() && ((UnitDouble)this.getMinValue()).equals(this.getMaxValue())) {
            return val;
        }
        return ((UnitDouble)this.getMaxValue()).diff(this.getClampOffset());
    }

    @Override
    protected UnitDouble clampMinUnincl(UnitDouble val) {
        if (this.checksMin() && this.checksMax() && ((UnitDouble)this.getMinValue()).equals(this.getMaxValue())) {
            return val;
        }
        return ((UnitDouble)this.getMinValue()).add(this.getClampOffset());
    }

    private UnitDouble getClampOffset() {
        if (this.checksMin() && this.checksMax()) {
            Unit u = ((UnitDouble)this.getMaxValue()).getUnit();
            double diff = ((UnitDouble)this.getMaxValue()).getValue(u) - ((UnitDouble)this.getMinValue()).getValue(u);
            return new UnitDouble(diff * 1.0E-6, u);
        }
        Unit u = this.checksMin() ? ((UnitDouble)this.getMinValue()).getUnit() : ((UnitDouble)this.getMaxValue()).getUnit();
        return new UnitDouble(0.01, u);
    }
}

