/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.NativeImage;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class Material
extends ANativelyMirrored {
    private static final long serialVersionUID = -5509726297599843462L;
    private Color d_diffuseColor;
    private Color d_specularColor;
    private NativeImage d_diffuseTex;
    private NativeImage d_specularTex;
    private NativeImage d_normalTex;

    public Material() {
        this.d_diffuseColor = this.d_specularColor = Color.BLACK;
        this.d_normalTex = null;
        this.d_specularTex = null;
        this.d_diffuseTex = null;
        this.nativeConstructed(Material.class);
    }

    @Override
    public Class resolveNativeClass() {
        return Material.class;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Material)) {
            return false;
        }
        Material mat = (Material)obj;
        return this.d_diffuseColor.equals(mat.d_diffuseColor) && this.d_specularColor.equals(mat.d_specularColor) && this.d_diffuseTex == mat.d_diffuseTex && this.d_specularTex == mat.d_specularTex && this.d_normalTex == mat.d_normalTex;
    }

    public int hashCode() {
        return 54497274 + this.d_diffuseColor.hashCode() + this.d_specularColor.hashCode() + System.identityHashCode(this.d_diffuseTex) + System.identityHashCode(this.d_specularTex) + System.identityHashCode(this.d_normalTex);
    }

    public void setDiffuse(Color c, NativeImage tex) {
        this.d_diffuseColor = c;
        this.d_diffuseTex = tex;
        this.markNativeDirty();
    }

    public Pair<Color, NativeImage> getDiffuse() {
        return new Pair<Color, NativeImage>(this.d_diffuseColor, this.d_diffuseTex);
    }

    public void setSpecular(Color c, NativeImage tex) {
        this.d_specularColor = c;
        this.d_specularTex = tex;
        this.markNativeDirty();
    }

    public Pair<Color, NativeImage> getSpecular() {
        return new Pair<Color, NativeImage>(this.d_specularColor, this.d_specularTex);
    }

    public void setNormal(NativeImage img) {
        this.d_normalTex = img;
        this.markNativeDirty();
    }

    public NativeImage getNormal() {
        return this.d_normalTex;
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        Material.write(writer, this.d_diffuseColor);
        writer.write((Keyable)this.d_diffuseTex);
        Material.write(writer, this.d_specularColor);
        writer.write((Keyable)this.d_specularTex);
        writer.write((Keyable)this.d_normalTex);
    }

    private static void write(INativeStream stream, Color c) {
        stream.writeBytes((byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue(), (byte)c.getAlpha());
    }
}

