/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import pyrosim.legacy_2012_1.thunderheadeng.gui.SelectableAction;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class guiUtil {
    private static final HashMap<ImageKey, WeakReference<Image>> s_images = new HashMap();

    public static Image loadImage(String filename) {
        return guiUtil.loadImage(filename, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage(String filename, int maxDimension) {
        HashMap<ImageKey, WeakReference<Image>> hashMap = s_images;
        synchronized (hashMap) {
            Image img;
            ImageKey key = new ImageKey(filename, maxDimension);
            WeakReference<Image> imageRef = s_images.get(key);
            Image image = img = imageRef != null ? (Image)imageRef.get() : null;
            if (img == null) {
                img = guiUtil.forceImageLoad(filename, maxDimension);
                s_images.put(key, new WeakReference<Image>(img));
            }
            return img;
        }
    }

    private static Image forceImageLoad(String filename, int maxDimension) {
        try {
            BufferedImage image;
            if (!filename.startsWith("/")) {
                filename = "/" + filename;
            }
            URL url = guiUtil.class.getResource(filename);
            Image resultImage = image = ImageIO.read(url);
            int width = image.getWidth();
            int height = image.getHeight();
            if (width > maxDimension || height > maxDimension) {
                float aspect = (float)width / (float)height;
                if (width > height) {
                    width = maxDimension;
                    height = (int)((float)width / aspect);
                } else {
                    height = maxDimension;
                    width = (int)((float)height * aspect);
                }
                resultImage = image.getScaledInstance(width, height, 1);
            }
            return resultImage;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ImageIcon loadTeciIcon(String name) {
        return guiUtil.loadTeciIcon(name, Integer.MAX_VALUE);
    }

    public static ImageIcon loadTeciIcon(String name, int maxDimension) {
        return guiUtil.loadIcon("pyrosim.legacy_2012_1.thunderheadeng/gui/graphics/" + name, maxDimension);
    }

    public static ImageIcon loadIcon(String filename) {
        return guiUtil.loadIcon(filename, Integer.MAX_VALUE);
    }

    public static ImageIcon loadIcon(String filename, int maxDimension) {
        Image image = guiUtil.loadImage(filename, maxDimension);
        return image == null ? null : new ImageIcon(image);
    }

    public static Cursor createTeciCursor(String key, String filename, int hotspotx, int hotspoty) {
        return guiUtil.createCursor(key, "pyrosim.legacy_2012_1.thunderheadeng/gui/graphics/" + filename, hotspotx, hotspoty);
    }

    public static Cursor createCursor(String key, String filename, int hotspotx, int hotspoty) {
        Image image = guiUtil.loadImage(filename);
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(hotspotx, hotspoty), key);
        }
        catch (Exception e) {
            return Cursor.getDefaultCursor();
        }
    }

    public static void addSelectableMenuItem(JMenu menu, SelectableAction action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.addItemListener(action);
        menu.add(item);
    }

    public static JToggleButton createToolbarToggleButton(SelectableAction action) {
        JToggleButton button = new JToggleButton(action);
        guiUtil.initToolbarBtn(action, button);
        button.addItemListener(action);
        return button;
    }

    public static JButton createToolbarButton(Action action) {
        JButton btn = new JButton(action);
        guiUtil.initToolbarBtn(action, btn);
        return btn;
    }

    private static void initToolbarBtn(Action action, AbstractButton btn) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            btn.setText("");
            String ttt = (String)action.getValue("ShortDescription");
            if (ttt == null || ttt.trim().equals("")) {
                btn.setToolTipText((String)action.getValue("Name"));
            }
        }
    }

    public static void addMEMenuItems(JMenu menu, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            SelectableAction action = actions[m];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.addItemListener(action);
            menu.add(item);
            group.add(item);
        }
    }

    public static void addMEToolbarItems(JToolBar tb, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            JToggleButton item = guiUtil.createToolbarToggleButton(actions[m]);
            tb.add(item);
            group.add(item);
        }
    }

    public static Icon createDisabledIcon(Icon i) {
        if (i == null) {
            return null;
        }
        if (i instanceof ImageIcon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)i).getImage()));
        }
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        i.paintIcon(null, g, 0, 0);
        g.dispose();
        return new ImageIcon(GrayFilter.createDisabledImage(bi));
    }

    public static Pair<JTabbedPane, Component> findTab(Component c) {
        if (c == null) {
            return null;
        }
        Container parent = c.getParent();
        while (parent != null && !(parent instanceof JTabbedPane)) {
            c = parent;
            parent = c.getParent();
        }
        return parent instanceof JTabbedPane ? new Pair<JTabbedPane, Component>((JTabbedPane)parent, c) : null;
    }

    private static class ImageKey {
        public final String resourceName;
        public final int maxDimension;

        public ImageKey(String resourceName, int maxDimension) {
            this.resourceName = resourceName;
            this.maxDimension = maxDimension;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ImageKey && ((ImageKey)obj).resourceName.equals(this.resourceName) && ((ImageKey)obj).maxDimension == this.maxDimension;
        }

        public int hashCode() {
            return 0xFAA344D ^ this.resourceName.hashCode() ^ this.maxDimension;
        }
    }
}

