/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.format;

import java.text.ParseException;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.gui.format.AFormat;
import pyrosim.legacy_2012_1.thunderheadeng.units.IUnitType;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObservable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObserver;
import pyrosim.legacy_2012_1.thunderheadeng.util.ObservableProxy;

public class UnitDoubleFormat
extends AFormat<UnitDouble>
implements IObserver,
IObservable {
    private static final long serialVersionUID = -4714104436022336354L;
    private final IUnitType d_unit;
    private final boolean d_formatWithUnit;
    private final ObservableProxy d_observableHelper;

    public UnitDoubleFormat(IUnitType unit) {
        this(unit, true);
    }

    public UnitDoubleFormat(IUnitType compabilityUnit, boolean displayOnlyCompabilityUnit) {
        this.d_unit = compabilityUnit;
        this.d_unit.addObserver(this, true);
        this.d_formatWithUnit = displayOnlyCompabilityUnit;
        this.d_observableHelper = new ObservableProxy(this);
    }

    @Override
    protected UnitDouble parse(String text) throws ParseException {
        Unit unit = this.d_unit.getUnit();
        return Global.parseUnitDouble(text, unit);
    }

    @Override
    protected String toString(UnitDouble val) {
        Unit displayUnit = this.d_formatWithUnit && this.d_unit != null ? this.d_unit.getUnit() : val.getUnit();
        return Global.format(val.getValue(displayUnit), displayUnit);
    }

    @Override
    public void update(IObservable o, Object arg) {
        this.d_observableHelper.setChanged(true);
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_observableHelper.addObserver(observer, weakRef);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_observableHelper.deleteObserver(observer);
    }
}

