/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;

public class Triangle
extends AFace
implements IPolygon,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;
    public final Point3d p3;

    public Triangle(Point3d p1, Point3d p2, Point3d p3) {
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.Triangle(this.p1, this.p2, this.p3);
    }

    @Override
    public Triangle optimize(IPointOptimizer pool) {
        Point3d np1 = pool.getExisting(this.p1);
        Point3d np2 = pool.getExisting(this.p2);
        Point3d np3 = pool.getExisting(this.p3);
        return np1 != this.p1 || np2 != this.p2 || np3 != this.p3 ? new Triangle(np1, np2, np3) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.p1);
        aabb.add(this.p2);
        aabb.add(this.p3);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public Triangle transform(Matrix4d xform) {
        return new Triangle(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.p2), Util3D.xform(xform, this.p3));
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int loop) {
        return 3;
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        switch (ix) {
            case 0: {
                return this.p1;
            }
            case 1: {
                return this.p2;
            }
            case 2: {
                return this.p3;
            }
        }
        return null;
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
        PolyUtil.getBoundary(boundary, this);
    }

    @Override
    public Vector3d getNormal() {
        Vector3d normal = Util3D.simplePolygonNormal(Arrays.asList(this.p1, this.p2, this.p3), 1.0E-6);
        return normal == null ? GeomConstants.VEC3D_ZERO : normal;
    }

    @Override
    public Mesh triangulate(double errorTol) {
        Point3d[] verts = new Point3d[]{this.p1, this.p2, this.p3};
        int[] ixes = new int[]{0, 1, 2};
        return new Mesh(verts, ixes, 2);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        return PolyUtil.intersectsBox(source, this, filter, region);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        PolyUtil.pickPoints(this, isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    public Point3d project(Point3d p) {
        return PolyUtil.getPlane(this).projectOntoPlane(p);
    }

    @Override
    public IFace.PointClassify classify(Point3d p, double tol) {
        return PolyUtil.classify(this, p, tol);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return PolyUtil.generateManipHandles(this);
    }
}

